/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinateSystem;
import chemaxon.marvin.modelling.mm.mmff94.BondParameters;
import chemaxon.marvin.modelling.mm.mmff94.Charges;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.VanDerWaals;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraBondParameters;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import java.util.Collections;
import java.util.Vector;

public class MMFFMolecule {
    private Molecule mol;
    private int[] atomTypes;
    private double[] formalCharges;
    private double[] partAtomCharges;
    private Charges q;
    private VanDerWaals vdw;
    private InternalCoordinateSystem ics;
    private Vector<MMFFComponent> allComponents;
    Vector<MMFFComponent> usedComponents = new Vector();
    protected double E;
    protected double[] grad;
    private boolean crdChanged;
    private boolean dummy = false;

    public Molecule getMolecule() {
        return this.mol;
    }

    public int[] getAtomTypes() {
        return this.atomTypes;
    }

    public void setAtomTypes(int[] atomTypes) {
        this.atomTypes = atomTypes;
    }

    public double getFormalCharge(int idx) {
        return this.formalCharges[idx];
    }

    public void setFormalCharges(double[] formalCharges) {
        this.formalCharges = formalCharges;
    }

    public double[] getPartialAtomCharges() {
        return this.partAtomCharges;
    }

    public InternalCoordinateSystem getIntCoordSystem() {
        return this.ics;
    }

    public double[] getCoordinates() {
        return this.ics.getCartesianCoordinates();
    }

    public void setAllComponents(Vector<MMFFComponent> allComponents) {
        this.allComponents = allComponents;
    }

    public void setUsedComponents() {
        this.usedComponents.clear();
        if (MMFF94.getEnabledComponent().cardinality() == 7) {
            this.usedComponents.setSize(this.allComponents.size());
            Collections.copy(this.usedComponents, this.allComponents);
        } else {
            for (int i = 0; i < this.allComponents.size(); ++i) {
                MMFFComponent c = this.allComponents.get(i);
                if (!MMFF94.isEnabled(c.getType())) continue;
                this.usedComponents.add(c);
            }
        }
    }

    public Vector<MMFFComponent> getUsedComponents() {
        return this.usedComponents;
    }

    public MMFFMolecule(Molecule mol) throws MMFF94Exception {
        this.init(mol);
        this.ics = new InternalCoordinateSystem();
        this.ics.setCosAngleEnabled(true);
        this.ics.setM(mol);
        this.ics.setLinearBondAngleLimit(Math.PI);
    }

    private void init(Molecule mol) throws MMFF94Exception {
        if (mol == null) {
            this.grad = new double[1];
            this.fillNaN();
            this.setCrdChanged(false);
            throw new MMFF94Exception("Molecule is null!");
        }
        this.mol = mol.cloneMolecule();
        if (mol.isEmpty()) {
            this.grad = new double[3 * mol.getAtomCount()];
            this.fillNaN();
            this.E = Double.NEGATIVE_INFINITY;
            this.setCrdChanged(false);
            return;
        }
        this.grad = new double[3 * mol.getAtomCount()];
        this.setCrdChanged(true);
        boolean allTypeisValid = Parameters.getMMFFParameters().getFFAtomTypeArray().setMoleculeProp(this);
        if (!allTypeisValid) {
            this.fillNaN();
            this.setCrdChanged(false);
            throw new MMFF94Exception("Missing atomtype!");
        }
        this.q = new Charges();
        this.q.init(this);
        this.partAtomCharges = this.q.getPartialAtomCharges();
        this.vdw = new VanDerWaals();
        this.vdw.init(this);
    }

    private void fillNaN() {
        this.E = Double.NaN;
        for (int i = 0; i < this.grad.length; ++i) {
            this.grad[i] = Double.NaN;
        }
    }

    protected boolean isCrdChanged() {
        return this.crdChanged;
    }

    protected void setCrdChanged(boolean crdChanged) {
        this.crdChanged = crdChanged;
    }

    protected void calc() {
        if (this.isCrdChanged()) {
            int i;
            this.E = 0.0;
            for (i = 0; i < this.grad.length; ++i) {
                this.grad[i] = 0.0;
            }
            for (i = 0; i < this.usedComponents.size(); ++i) {
                MMFFComponent comp = this.usedComponents.get(i);
                this.E += comp.getEnergy();
                comp.addGradient(this.grad);
            }
            if (!U.isDoubleOK(this.E) || !U.isDoubleOK(this.grad)) {
                this.E = Double.NaN;
                for (i = 0; i < this.grad.length; ++i) {
                    this.grad[i] = Double.NaN;
                }
            }
            this.setCrdChanged(false);
        }
    }

    public Vector<MMFFComponent> getMMFFComponents(int type) {
        Vector<MMFFComponent> cs = new Vector<MMFFComponent>();
        for (int i = 0; i < this.allComponents.size(); ++i) {
            MMFFComponent c = this.allComponents.get(i);
            if (c.getType() != type) continue;
            cs.add(c);
        }
        return cs;
    }

    public String getLabelOfAtom(int idx) {
        return Parameters.getMMFFParameters().getAtomTypeProp().getLabel(this.atomTypes[idx]);
    }

    public double getEqBondLength(int atomIdx1, int atomIdx2) {
        int[] atomIndeces = new int[]{atomIdx1, atomIdx2};
        FFComponentProvider bpx = Parameters.getMMFFParameters().getBondHashMap().getParams(atomIndeces, this);
        if (bpx instanceof ExtraBondParameters) {
            return ((ExtraBondParameters)bpx).getR0();
        }
        BondParameters bp = (BondParameters)Parameters.getMMFFParameters().getBondHashMap().getParams(atomIndeces, this);
        if (!bp.isMultipleFFComponentProvider()) {
            return bp.getR0();
        }
        return bp.getOptimalValues()[0];
    }

    public Charges getCharges() {
        return this.q;
    }

    public VanDerWaals getVanDerWaals() {
        return this.vdw;
    }

    public double getElectr_E(int a1, int a2) {
        return this.q.getE(a1, a2);
    }

    public double getElectr_dE(int a1, int a2) {
        return this.q.getdE(a1, a2);
    }

    public double getVDW_E(int a1, int a2) {
        return this.vdw.getE(a1, a2);
    }

    public double getVDW_dE(int a1, int a2) {
        return this.vdw.getdE(a1, a2);
    }

    public void setDummy() {
        this.dummy = true;
    }

    public boolean isDummy() {
        return this.dummy;
    }
}

