/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;

public class OutOfPlaneComponent
extends MMFFComponent {
    private double koop;
    private InternalCoordinate[] chi = new InternalCoordinate[2];
    private double E;
    private double[] dE = new double[2];
    private double[] crds;
    private int[] idx;
    private double angle;
    private double scale;
    private double linAngLimit = 2.96705972839036;

    public double getKoop() {
        return this.koop;
    }

    public void setKoop(double koop) {
        this.koop = koop;
    }

    @Override
    public InternalCoordinate[] getInternalCoordinates() {
        return this.chi;
    }

    public void setInternalCoordinates(InternalCoordinate[] chi) {
        this.chi = chi;
    }

    private void calc() {
        this.crds = this.chi[0].getCartesianCoordinates();
        this.idx = this.chi[0].getAtomIndeces();
        this.chi[1] = new Internals.InternalBondAngle(this.crds, new int[]{this.idx[0], this.idx[1], this.idx[2]});
        this.angle = this.chi[1].getValue();
        this.scale = this.function.scale(this.angle - this.linAngLimit, Math.PI - this.linAngLimit);
        this.E = this.function.corrOutOfPlaneBending(this.koop, this.chi[0].getValue());
        this.dE[0] = this.function.corrOutOfPlaneBendingDer(this.koop, this.chi[0].getValue()) * this.scale;
        this.dE[1] = this.E * this.function.scaleGrad(this.angle - this.linAngLimit, Math.PI - this.linAngLimit);
        this.E *= this.scale;
    }

    @Override
    public double getEnergy() {
        this.calc();
        return this.E;
    }

    @Override
    public double[] getDerivative() {
        return this.dE;
    }

    @Override
    public int getType() {
        return 3;
    }
}

