/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.AngleHashMap;
import chemaxon.marvin.modelling.mm.mmff94.BondHashMap;
import chemaxon.marvin.modelling.mm.mmff94.Charges;
import chemaxon.marvin.modelling.mm.mmff94.FFAtomTypeArray;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.marvin.modelling.mm.mmff94.OutOfPlaneHashMap;
import chemaxon.marvin.modelling.mm.mmff94.StretchBendHashMap;
import chemaxon.marvin.modelling.mm.mmff94.TorsionHashMap;
import chemaxon.marvin.modelling.mm.mmff94.VanDerWaals;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.AtomTypeProperties;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraAngleHashMap;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraBondHashMap;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraStretchBendHashMap;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraTorsionHashMap;
import java.io.InputStream;

public class Parameters {
    private FFAtomTypeArray ata;
    private AngleHashMap ahm;
    private BondHashMap bhm;
    private StretchBendHashMap sbhm;
    private TorsionHashMap thm;
    private OutOfPlaneHashMap oophm;
    private VanDerWaals vdw;
    private Charges q;
    private AtomTypeProperties atp;
    private ExtraStretchBendHashMap extrasbhm;
    private ExtraBondHashMap extrabhm;
    private ExtraAngleHashMap extraahm;
    private ExtraTorsionHashMap extrathm;
    private static final Parameters MMFF94_PARAMETERS = new Parameters();

    public static Parameters getMMFFParameters() {
        return MMFF94_PARAMETERS;
    }

    private Parameters() {
        try {
            InputStream in = this.getClass().getResourceAsStream("MMFF94_parameters.xml");
            XMLParser xml = new XMLParser(in);
            this.ata = new FFAtomTypeArray(xml);
            this.ahm = new AngleHashMap();
            this.ahm.xmlImport(xml);
            this.bhm = new BondHashMap();
            this.bhm.xmlImport(xml);
            this.sbhm = new StretchBendHashMap();
            this.sbhm.xmlImport(xml);
            this.thm = new TorsionHashMap();
            this.thm.xmlImport(xml);
            this.oophm = new OutOfPlaneHashMap();
            this.oophm.xmlImport(xml);
            this.atp = new AtomTypeProperties(xml);
            this.extrasbhm = new ExtraStretchBendHashMap();
            this.extrasbhm.xmlImport(xml);
            this.sbhm.setExtraComponentProviderHM(this.extrasbhm);
            this.extrabhm = new ExtraBondHashMap();
            this.extrabhm.xmlImport(xml);
            this.bhm.setExtraComponentProviderHM(this.extrabhm);
            this.extraahm = new ExtraAngleHashMap();
            this.extraahm.xmlImport(xml);
            this.ahm.setExtraComponentProviderHM(this.extraahm);
            this.extrathm = new ExtraTorsionHashMap(this.atp);
            this.thm.setExtraComponentProviderHM(this.extrathm);
            VanDerWaals.readParameters(xml);
            Charges.readParameters(xml);
        }
        catch (MMFF94Exception e) {
            e.printStackTrace();
        }
    }

    public FFAtomTypeArray getFFAtomTypeArray() {
        return this.ata;
    }

    public AngleHashMap getAngleHashMap() {
        return this.ahm;
    }

    public BondHashMap getBondHashMap() {
        return this.bhm;
    }

    public StretchBendHashMap getStretchBendHashMap() {
        return this.sbhm;
    }

    public TorsionHashMap getTorsionHashMap() {
        return this.thm;
    }

    public OutOfPlaneHashMap getOutOfPlanHashMap() {
        return this.oophm;
    }

    public AtomTypeProperties getAtomTypeProp() {
        return this.atp;
    }

    public ExtraAngleHashMap getExtraAngleHashMap() {
        return this.extraahm;
    }

    public ExtraBondHashMap getExtraBondHashMap() {
        return this.extrabhm;
    }

    public ExtraStretchBendHashMap getExtraStretchBendHashMap() {
        return this.extrasbhm;
    }

    public ExtraTorsionHashMap getExtraTorsionHashMap() {
        return this.extrathm;
    }
}

