/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinateSystem;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.MultipleFFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.StretchBendComponent;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraAngleParameters;

public class StretchBendParameters
extends MultipleFFComponentProvider
implements FFComponentProvider {
    protected int sbt;
    private int i;
    private int j;
    private int k;
    private double kbaIJK;
    private double kbaKJI;
    private String source;
    private StretchBendComponent sbc;

    public int getSbt() {
        return this.sbt;
    }

    public void setSbt(int sbt) {
        this.sbt = sbt;
    }

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getKbaIJK() {
        return this.kbaIJK;
    }

    public void setKbaIJK(double kbaIJK) {
        this.kbaIJK = kbaIJK;
    }

    public double getKbaKJI() {
        return this.kbaKJI;
    }

    public void setKbaKJI(double kbaKJI) {
        this.kbaKJI = kbaKJI;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public MMFFComponent getComponent(InternalCoordinate q, MMFFMolecule mol) {
        this.sbc = new StretchBendComponent();
        int[] atomIndeces = q.getAtomIndeces();
        int[] aiIJ = new int[]{atomIndeces[0], atomIndeces[1]};
        int[] aiKJ = new int[]{atomIndeces[1], atomIndeces[2]};
        InternalCoordinate[] intcoord = new InternalCoordinate[]{(InternalCoordinate)mol.getIntCoordSystem().getInternalCoordinateHashMap().get(InternalCoordinateSystem.getKeyForInternalCoordinate(new Internals.InternalBondLength(q.getCartesianCoordinates(), aiIJ))), (InternalCoordinate)mol.getIntCoordSystem().getInternalCoordinateHashMap().get(InternalCoordinateSystem.getKeyForInternalCoordinate(new Internals.InternalBondLength(q.getCartesianCoordinates(), aiKJ))), q};
        this.sbc.setInternalCoordinates(intcoord);
        this.sbc.setRij0(Parameters.getMMFFParameters().getBondHashMap().getOptimalValues(aiIJ, mol));
        this.sbc.setRkj0(Parameters.getMMFFParameters().getBondHashMap().getOptimalValues(aiKJ, mol));
        FFComponentProvider ap = Parameters.getMMFFParameters().getAngleHashMap().getParams(Tools.getAngleType(atomIndeces, mol), atomIndeces, mol);
        if (ap instanceof ExtraAngleParameters) {
            this.sbc.setTheta0(((ExtraAngleParameters)ap).getTheta(atomIndeces, mol));
        } else {
            this.sbc.setTheta0(ap.getOptimalValues()[0]);
        }
        this.sbc.setKbaIJK(this.getKbaIJK());
        this.sbc.setKbaKJI(this.getKbaKJI());
        return this.sbc;
    }

    @Override
    public double[] getOptimalValues() {
        double[] optVal = new double[]{this.sbc.getRij0(), this.sbc.getRkj0(), this.sbc.getTheta0()};
        return optVal;
    }
}

