/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;

public class TorsionComponent
extends MMFFComponent {
    private double V1;
    private double V2;
    private double V3;
    private InternalCoordinate[] phi = new InternalCoordinate[3];
    private double E;
    private double[] dE = new double[3];
    private double angle1;
    private double angle2;
    private double scale1;
    private double scale2;
    private double linAngLimit = 2.96705972839036;

    public double getV1() {
        return this.V1;
    }

    public void setV1(double v1) {
        this.V1 = v1;
    }

    public double getV2() {
        return this.V2;
    }

    public void setV2(double v2) {
        this.V2 = v2;
    }

    public double getV3() {
        return this.V3;
    }

    public void setV3(double v3) {
        this.V3 = v3;
    }

    @Override
    public InternalCoordinate[] getInternalCoordinates() {
        return this.phi;
    }

    public void setInternalCoordinates(InternalCoordinate[] phi) {
        this.phi = phi;
    }

    private void calc() {
        this.angle1 = this.phi[1].getValue();
        this.angle2 = this.phi[2].getValue();
        this.scale1 = this.function.scale(this.angle1 - this.linAngLimit, Math.PI - this.linAngLimit);
        this.scale2 = this.function.scale(this.angle2 - this.linAngLimit, Math.PI - this.linAngLimit);
        this.E = this.function.torsion(this.V1, this.V2, this.V3, this.phi[0].getValue());
        this.dE[0] = this.function.torsionDer(this.V1, this.V2, this.V3, this.phi[0].getValue()) * this.scale1 * this.scale2;
        this.dE[1] = 0.0;
        this.dE[2] = 0.0;
        if (this.scale1 < 1.0 || this.scale2 < 1.0) {
            if (this.scale1 < 1.0) {
                this.dE[1] = this.E * this.function.scaleGrad(this.angle1 - this.linAngLimit, Math.PI - this.linAngLimit) * this.scale2;
            }
            if (this.scale2 < 1.0) {
                this.dE[2] = this.E * this.function.scaleGrad(this.angle2 - this.linAngLimit, Math.PI - this.linAngLimit) * this.scale1;
            }
            this.E *= this.scale1 * this.scale2;
        }
    }

    @Override
    public double getEnergy() {
        this.calc();
        return this.E;
    }

    @Override
    public double[] getDerivative() {
        return this.dE;
    }

    @Override
    public int getType() {
        return 4;
    }
}

