/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.MultipleFFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.TorsionComponent;

public class TorsionParameters
extends MultipleFFComponentProvider
implements FFComponentProvider {
    protected int tt;
    private int i;
    private int j;
    private int k;
    private int l;
    private double V1;
    private double V2;
    private double V3;
    private String source;

    public int getTt() {
        return this.tt;
    }

    public void setTt(int tt) {
        this.tt = tt;
    }

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getL() {
        return this.l;
    }

    public void setL(int l) {
        this.l = l;
    }

    public double getV1() {
        return this.V1;
    }

    public void setV1(double v1) {
        this.V1 = v1;
    }

    public double getV2() {
        return this.V2;
    }

    public void setV2(double v2) {
        this.V2 = v2;
    }

    public double getV3() {
        return this.V3;
    }

    public void setV3(double v3) {
        this.V3 = v3;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public MMFFComponent getComponent(InternalCoordinate q, MMFFMolecule mol) {
        TorsionComponent tc = new TorsionComponent();
        tc.setV1(this.V1);
        tc.setV2(this.V2);
        tc.setV3(this.V3);
        double[] crds = q.getCartesianCoordinates();
        int[] idx = q.getAtomIndeces();
        InternalCoordinate[] ic = new InternalCoordinate[]{q, new Internals.InternalBondAngle(crds, new int[]{idx[0], idx[1], idx[2]}), new Internals.InternalBondAngle(crds, new int[]{idx[1], idx[2], idx[3]})};
        tc.setInternalCoordinates(ic);
        return tc;
    }

    @Override
    public double[] getOptimalValues() {
        return null;
    }
}

