/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AtomTypeProperties {
    private String[] label;
    private int[] aspec;
    private int[] crd;
    private int[] val;
    private int[] pilp;
    private int[] mltb;
    private int[] arom;
    private int[] lin;
    private int[] sbmb;
    private static final double[] EMP_RULE_TORSION = new double[]{2.0, 2.12, 2.0, 1.5, 2.0, 0.2, 1.25, 1.22, 1.25, 2.4, 1.25, 0.49};
    private static final double[] MMFF_COVALENT_RADIUS = new double[]{0.33, -1.0, 1.34, 0.9, 0.81, 0.77, 0.73, 0.72, 0.74, -1.0, 1.54, 1.3, 1.22, 1.15, 1.09, 1.03, 1.01, -1.0, 1.96, 1.74, 1.44, 1.36, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.38, 1.31, 1.19, 1.2, 1.2, 1.16, 1.15, -1.0, 2.11, 1.92, 1.62, 1.48, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.53, 1.48, 1.46, 1.4, 1.41, 1.35, 1.33, -1.0};

    public String getLabel(int atomType) {
        return this.label[atomType];
    }

    public int getAspec(int atomType) {
        return this.aspec[atomType];
    }

    public int getCrd(int atomType) {
        return this.crd[atomType];
    }

    public int getVal(int atomType) {
        return this.val[atomType];
    }

    public int getPilp(int atomType) {
        return this.pilp[atomType];
    }

    public int getMltb(int atomType) {
        return this.mltb[atomType];
    }

    public int getArom(int atomType) {
        return this.arom[atomType];
    }

    public int getLin(int atomType) {
        return this.lin[atomType];
    }

    public int getSbmb(int atomType) {
        return this.sbmb[atomType];
    }

    public static double getCovalentRadius(int z) {
        return MMFF_COVALENT_RADIUS[z - 1];
    }

    public static double[] getEmpTorsPar(int z) {
        switch (z) {
            case 6: {
                return new double[]{EMP_RULE_TORSION[0], EMP_RULE_TORSION[1]};
            }
            case 7: {
                return new double[]{EMP_RULE_TORSION[2], EMP_RULE_TORSION[3]};
            }
            case 8: {
                return new double[]{EMP_RULE_TORSION[4], EMP_RULE_TORSION[5]};
            }
            case 14: {
                return new double[]{EMP_RULE_TORSION[6], EMP_RULE_TORSION[7]};
            }
            case 15: {
                return new double[]{EMP_RULE_TORSION[8], EMP_RULE_TORSION[9]};
            }
            case 16: {
                return new double[]{EMP_RULE_TORSION[10], EMP_RULE_TORSION[11]};
            }
        }
        return null;
    }

    public AtomTypeProperties(XMLParser xml) {
        NodeList nl = xml.readParameters("MMFF-atom-type-properties");
        this.label = new String[100];
        this.aspec = new int[100];
        this.crd = new int[100];
        this.val = new int[100];
        this.pilp = new int[100];
        this.mltb = new int[100];
        this.arom = new int[100];
        this.lin = new int[100];
        this.sbmb = new int[100];
        for (int i = 0; i < nl.getLength(); ++i) {
            int type = Integer.parseInt(((Element)nl.item(i)).getAttribute("type"));
            this.label[type] = ((Element)nl.item(i)).getAttribute("label");
            this.aspec[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("aspec"));
            this.crd[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("crd"));
            this.val[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("val"));
            this.pilp[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("pilp"));
            this.mltb[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("mltb"));
            this.arom[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("arom"));
            this.lin[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("lin"));
            this.sbmb[type] = Integer.parseInt(((Element)nl.item(i)).getAttribute("sbmb"));
        }
    }
}

