/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraBondParameters;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExtraBondHashMap
extends FFProviderHM {
    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("bond-extension");
        for (int i = 0; i < nl.getLength(); ++i) {
            ExtraBondParameters extrabp = new ExtraBondParameters();
            extrabp.setI(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            extrabp.setJ(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            extrabp.setR0(Double.parseDouble(((Element)nl.item(i)).getAttribute("r0")));
            extrabp.setKb(Double.parseDouble(((Element)nl.item(i)).getAttribute("kb")));
            String key = extrabp.getI() + " " + extrabp.getJ();
            this.addParams(key, extrabp);
        }
    }

    @Override
    public FFComponentProvider getParams(int[] atomindeces, MMFFMolecule mol) {
        int[] atomspecies = new int[2];
        for (int i = 0; i < atomindeces.length; ++i) {
            atomspecies[i] = mol.getMolecule().getAtom(atomindeces[i]).getAtno();
        }
        FFComponentProvider parameter = this.getParams(this.getKeyForTypes(atomspecies));
        if (parameter != null) {
            return this.getParams(this.getKeyForTypes(atomspecies));
        }
        mol.setDummy();
        ExtraBondParameters dummy = new ExtraBondParameters();
        dummy.setI(atomspecies[0]);
        dummy.setJ(atomspecies[1]);
        dummy.setKb(3.5);
        dummy.setR0(2.0);
        return dummy;
    }
}

