/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.mm.mmff94.BondComponent;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.extra.AtomTypeProperties;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class ExtraBondParameters
implements FFComponentProvider {
    private int i;
    private int j;
    private double r0;
    private double kb;

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public double getR0() {
        return this.r0;
    }

    public void setR0(double r0) {
        this.r0 = r0;
    }

    public double getKb() {
        return this.kb;
    }

    public void setKb(double kb) {
        this.kb = kb;
    }

    public MMFFComponent getComponent(int[] atomIndeces, double[] coordinates) throws IOException {
        return null;
    }

    @Override
    public MMFFComponent getComponent(InternalCoordinate q, MMFFMolecule mol) {
        int[] ai = q.getAtomIndeces();
        double[] cr = new double[ai.length];
        double[] en = new double[ai.length];
        double c = 0.085;
        for (int i = 0; i < ai.length; ++i) {
            int z = mol.getMolecule().getAtom(ai[i]).getAtno();
            cr[i] = AtomTypeProperties.getCovalentRadius(z);
            en[i] = (double)MolAtom.electronegOf(z) / 10.0;
            if (z != 1) continue;
            c = 0.05;
        }
        switch (this.getBondOrder(ai, mol)) {
            case 5: {
                cr[0] = cr[0] - 0.04;
                cr[1] = cr[1] - 0.04;
                break;
            }
            case 4: {
                cr[0] = cr[0] - 0.075;
                cr[1] = cr[1] - 0.075;
                break;
            }
            case 3: {
                cr[0] = cr[0] - 0.17;
                cr[1] = cr[1] - 0.17;
                break;
            }
            case 2: {
                cr[0] = cr[0] - 0.1;
                cr[1] = cr[1] - 0.1;
                break;
            }
            case 1: {
                if (this.getHybrState(ai[0], mol) == 1) {
                    cr[0] = cr[0] - 0.08;
                }
                if (this.getHybrState(ai[0], mol) == 2) {
                    cr[0] = cr[0] - 0.03;
                }
                if (this.getHybrState(ai[1], mol) == 1) {
                    cr[1] = cr[1] - 0.08;
                }
                if (this.getHybrState(ai[1], mol) != 2) break;
                cr[1] = cr[1] - 0.03;
            }
        }
        double r = cr[0] + cr[1] - c * Math.pow(Math.abs(en[0] - en[1]), 1.4) - 0.008;
        double k = this.kb * Math.pow(this.r0 / r, 6.0);
        BondComponent bc = new BondComponent();
        bc.setR0(r);
        bc.setKb(k);
        bc.setInternalCoordinate(q);
        return bc;
    }

    @Override
    public double[] getOptimalValues() {
        double[] optVal = new double[]{this.r0};
        return optVal;
    }

    private int getHybrState(int atomIdx, MMFFMolecule mol) {
        int type = Tools.getAtomType(atomIdx, mol);
        int mltb = Parameters.getMMFFParameters().getAtomTypeProp().getMltb(type);
        if (mltb == 1 || mltb == 2) {
            return 2;
        }
        if (mltb == 3) {
            return 1;
        }
        return 3;
    }

    private int getBondOrder(int[] atomIdx, MMFFMolecule mol) {
        int typeI = Tools.getAtomType(atomIdx[0], mol);
        int typeJ = Tools.getAtomType(atomIdx[1], mol);
        int mltbI = Parameters.getMMFFParameters().getAtomTypeProp().getMltb(typeI);
        int mltbJ = Parameters.getMMFFParameters().getAtomTypeProp().getMltb(typeJ);
        int pilpI = Parameters.getMMFFParameters().getAtomTypeProp().getPilp(typeI);
        int pilpJ = Parameters.getMMFFParameters().getAtomTypeProp().getPilp(typeJ);
        if (mltbI == 1 && mltbJ == 1) {
            return 4;
        }
        if (mltbI == 1 && mltbJ == 2) {
            return 5;
        }
        if (mltbI == 2 && mltbJ == 1) {
            return 5;
        }
        if (Parameters.getMMFFParameters().getAtomTypeProp().getArom(typeI) == 1 && Parameters.getMMFFParameters().getAtomTypeProp().getArom(typeJ) == 1) {
            System.err.println("Not supported! (Aromatic rings)");
            return 0;
        }
        switch (this.getBondType(atomIdx, mol)) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    private int getBondType(int[] atomIdx, MMFFMolecule mol) {
        Molecule m = mol.getMolecule();
        MolBond bond = m.getAtom(atomIdx[0]).getBondTo(m.getAtom(atomIdx[1]));
        return bond.getType();
    }
}

