/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinateSystem;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.StretchBendComponent;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraAngleParameters;
import java.io.IOException;

public class ExtraStretchBendParameters
implements FFComponentProvider {
    private int i;
    private int j;
    private int k;
    private double kbaIJK;
    private double kbaKJI;
    private StretchBendComponent sbc;

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getKbaIJK() {
        return this.kbaIJK;
    }

    public void setKbaIJK(double kbaIJK) {
        this.kbaIJK = kbaIJK;
    }

    public double getKbaKJI() {
        return this.kbaKJI;
    }

    public void setKbaKJI(double kbaKJI) {
        this.kbaKJI = kbaKJI;
    }

    @Override
    public MMFFComponent getComponent(InternalCoordinate q, MMFFMolecule mol) {
        this.sbc = new StretchBendComponent();
        int[] atomIndeces = q.getAtomIndeces();
        int[] aiIJ = new int[]{atomIndeces[0], atomIndeces[1]};
        int[] aiKJ = new int[]{atomIndeces[1], atomIndeces[2]};
        InternalCoordinate[] intcoord = new InternalCoordinate[]{(InternalCoordinate)mol.getIntCoordSystem().getInternalCoordinateHashMap().get(InternalCoordinateSystem.getKeyForInternalCoordinate(new Internals.InternalBondLength(q.getCartesianCoordinates(), aiIJ))), (InternalCoordinate)mol.getIntCoordSystem().getInternalCoordinateHashMap().get(InternalCoordinateSystem.getKeyForInternalCoordinate(new Internals.InternalBondLength(q.getCartesianCoordinates(), aiKJ))), q};
        int[] ij = new int[]{atomIndeces[0], atomIndeces[1]};
        int[] kj = new int[]{atomIndeces[1], atomIndeces[2]};
        this.sbc.setInternalCoordinates(intcoord);
        this.sbc.setRij0(Parameters.getMMFFParameters().getBondHashMap().getOptimalValues(ij, mol));
        this.sbc.setRkj0(Parameters.getMMFFParameters().getBondHashMap().getOptimalValues(kj, mol));
        FFComponentProvider ap = Parameters.getMMFFParameters().getAngleHashMap().getParams(Tools.getAngleType(atomIndeces, mol), atomIndeces, mol);
        if (ap instanceof ExtraAngleParameters) {
            this.sbc.setTheta0(((ExtraAngleParameters)ap).getTheta(atomIndeces, mol));
        } else {
            this.sbc.setTheta0(ap.getOptimalValues()[0]);
        }
        this.sbc.setKbaIJK(this.kbaIJK);
        this.sbc.setKbaKJI(this.kbaKJI);
        return this.sbc;
    }

    public MMFFComponent getComponent(int[] atomIndeces, double[] coordinates) throws IOException {
        return null;
    }

    @Override
    public double[] getOptimalValues() {
        return null;
    }
}

