/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.modelling.newmd.Debug;
import chemaxon.marvin.modelling.newmd.MDException;
import chemaxon.marvin.modelling.newmd.MDSettings;
import chemaxon.marvin.modelling.newmd.ProjectedVelocityVerlet;
import chemaxon.marvin.modelling.newmd.boundary.Monitor;
import chemaxon.marvin.modelling.newmd.boundary.MonitorI;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class MolecularDynamics {
    private MDSettings settings = null;
    private Molecule mol;
    private int stepno = 1000;
    private int elapsedstep = 0;
    private double elapsedtime = 0.0;
    private double[] c = null;
    private Monitor stepMonitor = null;
    private MonitorI numericMonitor = null;
    private Monitor analyticMonitor = null;
    private ForceField ff = null;
    private ProjectedVelocityVerlet integrator = null;
    private double lastenergy = 0.0;
    private double lastpotenergy = 0.0;
    private double lastkinenergy = 0.0;
    public static final int TRAJ_NONE = 0;
    public static final int TRAJ_XTC = 1;
    public static final int TRAJ_MOL = 2;
    public static final int TRAJ_SDF = 2;
    private int trajectorytype = 0;
    private String trajectoryfile = "-";
    OutputStream trajectorystream = null;
    MolExporter trajectorymolexporter;

    public MolecularDynamics() {
        this.settings = new MDSettings();
    }

    public MolecularDynamics(MDSettings settings) {
        this.setDebugLevel(255, "-");
        this.settings = settings;
    }

    public MolecularDynamics(MDSettings settings, Molecule inputmol) throws MDException {
        this.settings = settings;
        this.setInputMolecule(inputmol);
    }

    public MolecularDynamics(MDSettings settings, Molecule inputmol, int steps) throws MDException {
        this.setInputMolecule(inputmol);
        this.setStepNo(steps);
        this.settings = settings;
    }

    public void setStepNo(int stepnumber) {
        this.stepno = stepnumber > 0 ? stepnumber : 1;
    }

    public double getTimeStep() {
        return this.settings.getStepSize();
    }

    public void setTimeStep(String steptimestr) {
        if (steptimestr != null && steptimestr.length() > 0) {
            this.settings.setStepSize(Double.valueOf(steptimestr));
        } else {
            this.settings.setStepSize(0.1);
        }
    }

    public void setTemperature(double temperatureK) {
        if (temperatureK >= 0.0) {
            this.settings.setTemperature(temperatureK);
        } else {
            this.settings.setTemperature(300.0);
        }
    }

    public void setCenterMolecule(boolean centerMolecule) {
        this.settings.setCoolInternals(true);
    }

    public void setTrajectory(String trajtype, String trajfile) {
        this.trajectoryfile = trajfile;
        if (this.trajectoryfile != null && this.trajectoryfile.length() > 0 && !this.trajectoryfile.equals("-")) {
            try {
                this.trajectorystream = new FileOutputStream(this.trajectoryfile);
            }
            catch (IOException e) {
                this.trajectoryfile = "-";
                this.trajectorystream = System.out;
            }
        } else {
            this.trajectoryfile = "-";
            this.trajectorystream = System.out;
        }
        this.trajectorytype = 0;
        if (trajtype != null && trajtype.length() > 0) {
            if (trajtype.equalsIgnoreCase("mol")) {
                this.trajectorytype = 2;
                try {
                    this.trajectorymolexporter = new MolExporter(this.trajectorystream, "mol");
                }
                catch (MolFormatException e) {
                    this.trajectorytype = 0;
                }
                catch (IllegalArgumentException e) {
                    this.trajectorytype = 0;
                }
                catch (IOException e) {
                    this.trajectorytype = 0;
                }
            }
            if (trajtype.equalsIgnoreCase("sdf")) {
                this.trajectorytype = 2;
                try {
                    this.trajectorymolexporter = new MolExporter(this.trajectorystream, "sdf");
                }
                catch (MolFormatException e) {
                    this.trajectorytype = 0;
                }
                catch (IllegalArgumentException e) {
                    this.trajectorytype = 0;
                }
                catch (IOException e) {
                    this.trajectorytype = 0;
                }
            }
        }
    }

    public void setDebugLevel(int level, String debugoutputstr) {
        Debug.debuglevel = level;
        if (Debug.debuglevel > 0) {
            if (debugoutputstr != null && debugoutputstr.length() > 0 && !debugoutputstr.equals("-")) {
                try {
                    FileOutputStream debugfile = new FileOutputStream(debugoutputstr);
                    Debug.debugstream = new PrintStream(debugfile);
                }
                catch (IOException e) {
                    Debug.debugstream = System.err;
                }
            } else {
                Debug.debugstream = System.err;
            }
            if ((Debug.debuglevel & 8) > 0) {
                Debug.debugstream.println("Calculation parameters:");
                Debug.debugstream.println("TrRot projection: " + this.settings.isCoolTranslationRotation());
                Debug.debugstream.println("Forcefield: " + this.settings.getForceFieldNames()[this.settings.getForceFieldType()]);
                Debug.debugstream.println("Integrator code: " + this.settings.getIntegratorNames()[this.settings.getIntegratorType()]);
                Debug.debugstream.println("Steptime: " + this.settings.getStepSize() + " fs");
                Debug.debugstream.println("Stepno: " + this.stepno);
                Debug.debugstream.println("Debug level: " + Debug.debuglevel);
                Debug.debugstream.println("Debug output: " + debugoutputstr + "\n\n");
            }
        } else {
            Debug.debuglevel = 0;
            Debug.debugstream = System.err;
        }
    }

    public void setInputMolecule(Molecule inputmol) throws MDException {
        this.mol = inputmol;
        if (this.mol == null || this.mol.isEmpty()) {
            throw new MDException("Molecule is empty");
        }
        if ((Debug.debuglevel & 8) > 0) {
            int atoms = this.mol.getAtomCount();
            Debug.debugstream.println("Atom number: " + this.mol.getName());
            Debug.debugstream.println("No.\tRendszam\tTomeg\tX\tY\tZ\n");
            for (int i = 0; i < atoms; ++i) {
                MolAtom a = this.mol.getAtom(i);
                Debug.debugstream.println(i + "\t" + a.getAtno() + "\t" + a.getMass() + "\t" + a.getX() + "\t" + a.getY() + "\t" + a.getZ());
            }
            Debug.debugstream.println();
        }
        this.InitMD();
    }

    public double getLastTemperature() {
        return this.integrator.getRealTemperature();
    }

    public int getStepNo() {
        return this.stepno;
    }

    public double getCurrentStepNo() {
        return this.elapsedstep;
    }

    public double getElapsedTime() {
        return this.elapsedtime;
    }

    public double getLastTotalEnergy() {
        return this.lastenergy;
    }

    public double getLastPotentialEnergy() {
        return this.lastpotenergy;
    }

    public double getLastKineticEnergy() {
        return this.lastkinenergy;
    }

    public double[] getVelocities() {
        return this.integrator.getVelocities();
    }

    public void setVelocities(double[] newvelocities) throws MDException {
        this.integrator.setVelocities(newvelocities);
    }

    public void InitMD() throws MDException {
        this.setDebugLevel(0, null);
        this.settings.setThermostat(1);
        switch (this.settings.getForceFieldType()) {
            case 2: {
                this.ff = new MMFF94();
                this.ff.init(this.mol);
                System.err.println("MMFF94 selected");
                break;
            }
            case 0: {
                Dreiding dd = new Dreiding();
                dd.init(this.mol);
                this.ff = dd;
                if ((Debug.debuglevel & 1) > 0) {
                    Debug.debugstream.println("MMFF Force field selected");
                }
                System.err.println("Dreiding selected");
                break;
            }
            default: {
                Dreiding dd = new Dreiding();
                dd.init(this.mol);
                this.ff = dd;
                if ((Debug.debuglevel & 1) > 0) {
                    Debug.debugstream.println("Dreiding Force field selected");
                }
                System.err.println("Default Dreiding selected");
            }
        }
        switch (this.settings.getIntegratorType()) {
            default: 
        }
        this.integrator = new ProjectedVelocityVerlet(this.settings, this.mol, this.ff);
        this.integrator.setStepMonitor(this.stepMonitor);
        this.integrator.setAnalyticMonitor(this.analyticMonitor);
        this.integrator.setNumericMonitor(this.numericMonitor);
        this.integrator.setInitialVelocities();
        this.elapsedstep = 0;
        this.elapsedtime = 0.0;
    }

    public void setForceField(String ffstr) {
        if (ffstr != null) {
            if (ffstr.equalsIgnoreCase("mmff")) {
                this.settings.setForceFieldType(2);
            }
            if (ffstr.equalsIgnoreCase("newdreiding")) {
                this.settings.setForceFieldType(0);
            }
            if (ffstr.equalsIgnoreCase("dreiding")) {
                this.settings.setForceFieldType(0);
            }
        } else {
            this.settings.setForceFieldType(2);
        }
    }

    public void setIntegrator(String intstr) {
        if (intstr != null) {
            if (intstr.equalsIgnoreCase("positionverlet")) {
                this.settings.setIntegratorType(0);
            }
            if (intstr.equalsIgnoreCase("leapfrog")) {
                this.settings.setIntegratorType(2);
            }
            if (intstr.equalsIgnoreCase("stabilizedvelocityverlet")) {
                this.settings.setIntegratorType(1);
            }
        } else {
            this.settings.setIntegratorType(1);
        }
    }

    public Molecule RunMD() throws MDException {
        double sum;
        double kin;
        double pot;
        double[] c = new double[this.mol.getAtomCount() * 3];
        this.InitMD();
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Step time: " + this.settings.getStepSize() + " fs");
            Debug.debugstream.println("Step number: " + this.stepno);
        }
        for (int s = 0; s < this.stepno; ++s) {
            double steptime = this.settings.getStepSize();
            MDException e = (MDException)this.integrator.Update().next();
            if (e != null) {
                throw e;
            }
            ++this.elapsedstep;
            this.elapsedtime += steptime;
            c = this.integrator.getCoordinates();
            if ((Debug.debuglevel & 4) <= 0 && this.trajectorytype != 2 && this.trajectorytype != 1) continue;
            c = this.integrator.getCoordinates();
            if ((Debug.debuglevel & 4) > 0) {
                pot = this.integrator.getPotentialEnergy();
                kin = this.integrator.getKineticEnergy();
                sum = kin + pot;
                Debug.debugstream.println("Stepno: " + this.elapsedstep);
                Debug.debugstream.println("Steptime: " + steptime);
                Debug.debugstream.println("Time: " + this.elapsedtime);
                Debug.debugstream.println("Pot. energy: " + pot + " kcal/mol");
                Debug.debugstream.println("Kin. energy: " + kin + " kcal/mol");
                Debug.debugstream.println("Sum. energy: " + sum + " kcal/mol");
                Debug.debugstream.println("Temperature: " + this.integrator.getTemperature() + " K");
                Debug.debugstream.println("\t\tx\ty\tz");
                for (int i = 0; i < this.mol.getAtomCount(); ++i) {
                    Debug.debugstream.println(i + ".\t" + c[i * 3] + "\t" + c[i * 3 + 1] + "\t" + c[i * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            this.integrator.storeCoordinates(this.mol, c);
            this.saveTrajectory(this.mol);
        }
        this.integrator.storeCoordinates(this.mol, c);
        pot = this.integrator.getPotentialEnergy();
        kin = this.integrator.getKineticEnergy();
        this.lastenergy = sum = kin + pot;
        this.lastkinenergy = kin;
        this.lastpotenergy = pot;
        this.integrator.storeCoordinates(this.mol, this.integrator.getCoordinates());
        this.mol.setComment("Time " + Double.toString(this.elapsedtime) + " fs");
        this.mol.setProperty("Energy", Double.toString(sum));
        return this.mol;
    }

    public Molecule NextStep() throws MDException {
        double sum;
        MDException e;
        if (this.stepMonitor != null) {
            this.stepMonitor.start();
        }
        double steptime = this.settings.getStepSize();
        ++this.stepno;
        ++this.elapsedstep;
        this.elapsedtime += steptime;
        if (this.c == null || this.c.length != this.mol.getAtomCount() * 3) {
            this.c = new double[this.mol.getAtomCount() * 3];
        }
        if ((e = (MDException)this.integrator.Update().next()) != null) {
            throw e;
        }
        double pot = this.integrator.getPotentialEnergy();
        double kin = this.integrator.getKineticEnergy();
        this.lastenergy = sum = kin + pot;
        this.lastkinenergy = kin;
        this.lastpotenergy = pot;
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Stepno: " + this.elapsedstep);
            Debug.debugstream.println("Steptime: " + steptime);
            Debug.debugstream.println("Time: " + this.elapsedtime);
            Debug.debugstream.println("Pot. energy: " + pot + " kcal/mol");
            Debug.debugstream.println("Kin. energy: " + kin + " kcal/mol");
            Debug.debugstream.println("Sum. energy: " + sum + " kcal/mol");
            Debug.debugstream.println("Temperature: " + this.integrator.getTemperature() + " K");
            this.c = this.integrator.getCoordinates();
            for (int i = 0; i < this.c.length; i += 3) {
                Debug.debugstream.println("\t\tx\ty\tz");
                Debug.debugstream.println(i + ".\t" + this.c[i] + "\t" + this.c[i + 1] + "\t" + this.c[i + 2]);
            }
        }
        this.c = this.integrator.getCoordinates();
        this.integrator.storeCoordinates(this.mol, this.c);
        this.saveTrajectory(this.mol);
        this.mol.setComment("MD Step " + Double.toString(this.elapsedstep));
        this.mol.setProperty("Energy", Double.toString(sum));
        if (this.stepMonitor != null) {
            this.stepMonitor.stop();
        }
        return this.mol;
    }

    private void saveTrajectory(Molecule mol) {
        if (this.trajectorytype == 2 || this.trajectorytype == 2) {
            try {
                this.trajectorymolexporter.write(mol);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public long getProjectionTime() {
        long projectionTime = 0L;
        if (this.integrator != null) {
            projectionTime = this.integrator.getProjectionTime();
        }
        return projectionTime;
    }

    public long getBMatrixTime() {
        long bMatrixTime = 0L;
        if (this.integrator != null) {
            bMatrixTime = this.integrator.getBMatrixTime();
        }
        return bMatrixTime;
    }

    public long getMdTime() {
        long mdTime = 0L;
        if (this.integrator != null) {
            mdTime = this.integrator.getMdTime();
        }
        return mdTime;
    }

    public Monitor getStepMonitor() {
        return this.stepMonitor;
    }

    public void setStepMonitor(Monitor stepMonitor) {
        this.stepMonitor = stepMonitor;
    }

    public MonitorI getNumericMonitor() {
        return this.numericMonitor;
    }

    public void setNumericMonitor(MonitorI numericMonitor) {
        this.numericMonitor = numericMonitor;
    }

    public Monitor getAnalyticMonitor() {
        return this.analyticMonitor;
    }

    public void setAnalyticMonitor(Monitor analyticMonitor) {
        this.analyticMonitor = analyticMonitor;
    }
}

