/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.alignment.AlignRigidEasy;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.gui.StructureStream;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.modelling.struc.ConformerEquivalenceUtils;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Vector;

public class ConformationMatch
implements Runnable {
    public static final double DEFAULT_MATCH_LIMIT = 0.5;
    private double matchLimit = 0.5;
    private Molecule mol = null;
    private int[] frozenmatch = null;
    private StructureStream strSource = null;
    private Substructure3DSearch sss = new Substructure3DSearch();
    private Vector<Molecule> conformations = new Vector();
    private int[] grinv = null;
    private boolean automatic = false;
    private ForceField ff = null;
    private String energyPropertyKey = null;
    private int countLimit = 1000;
    private double energyWindow = 5.0;
    private int count = 0;
    private double lowestEnergy = 0.0;
    private int[][] matchlist = null;
    private JQuatFit qfit = null;
    private int takenConformations = 0;
    private boolean setCount = true;
    private int ccounter = 0;
    private boolean opt = false;
    private boolean raw = false;
    private boolean hasConformations = false;
    private SimpleCanceller canceller = null;
    private boolean debugTrajectory = true;
    private String trajectoryName = "debugTrajectory";
    private boolean rawTrajectory = false;
    private MolExporter trajExporter = null;
    private ForceField off = null;
    private GradientOptimization o = null;
    private int maxNumberOfConformations = Integer.MAX_VALUE;
    private AlignRigidEasy align = null;
    private int speedLevel = 0;

    public ConformationMatch(StructureStream strSource, Molecule mol) {
        this.strSource = strSource;
        if (mol != null) {
            this.setMolecule(mol);
            this.setHasConformations(true);
        }
    }

    private void init() {
        int[] atoms;
        int i;
        if (!this.hasConformations && (this.mol == null || this.mol.isEmpty())) {
            throw new UnsupportedOperationException("ConformationMatch cannot run with null or empty molecule.");
        }
        if (this.mol != null && this.mol.getFragCount(0) > 1 && !this.isRaw()) {
            throw new UnsupportedOperationException("ConformationMatch is not yet implemented for molecules containing more than one fragment. Sorry.");
        }
        if (this.isRaw()) {
            return;
        }
        this.grinv = new int[this.mol.getAtomCount()];
        this.mol.getGrinv(this.grinv, 2);
        int[] tmpatoms = null;
        HashMap<Integer, int[]> multi = new HashMap<Integer, int[]>();
        BitSet multiAtoms = new BitSet();
        for (i = 0; i < this.grinv.length; ++i) {
            atoms = (int[])multi.get(this.grinv[i]);
            if (atoms == null) {
                tmpatoms = new int[]{i};
                multi.put(this.grinv[i], tmpatoms);
                continue;
            }
            tmpatoms = new int[atoms.length + 1];
            tmpatoms[atoms.length] = i;
            for (int j = 0; j < tmpatoms.length - 1; ++j) {
                tmpatoms[j] = atoms[j];
            }
            multi.put(this.grinv[i], tmpatoms);
        }
        for (i = 0; i < this.grinv.length; ++i) {
            atoms = (int[])multi.get(this.grinv[i]);
            if (atoms == null || atoms.length <= 1) continue;
            multiAtoms.set(i);
        }
        this.frozenmatch = new int[this.mol.getAtomCount()];
        boolean k = false;
        for (int i2 = 0; i2 < this.mol.getAtomCount(); ++i2) {
            this.frozenmatch[i2] = multiAtoms.get(i2) ? -1 : i2;
        }
        if (!this.isRaw()) {
            this.sss.setTarget(this.mol);
            ErrPrint.errPrint("Frozen match:", this.frozenmatch);
            ErrPrint.errPrint("GrInv", this.grinv);
            this.sss.setFrozenMatch(this.frozenmatch);
            this.sss.setIgnoreGeometryMatching(false, this.getMatchLimit());
            this.sss.setIgnoreExactMatching(false);
        }
        this.ccounter = 0;
        if (!this.automatic && this.countLimit == 0) {
            this.setCountLimit(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.err.println("ConformationMatch.run() called with ForceField " + this.ff.getClass().getName());
        this.strSource.setMolecule(this.mol);
        this.ff.init(this.mol);
        this.strSource.setVisible(true);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (this.strSource.isVisible()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (this.strSource.hasNext()) {
            if (this.getCanceller() != null && this.getCanceller().isCancelled()) {
                System.err.println("Cancel.");
                this.strSource.exit();
                return;
            }
            File stopFile = new File("STOP");
            if (stopFile.exists()) {
                System.err.println("File STOP was found, exit.");
                this.strSource.exit();
                return;
            }
            if (this.count > this.countLimit) {
                if (this.automatic && this.setCount && this.ccounter > 0) {
                    this.setCountLimit(this.count * 3);
                    this.ccounter = 0;
                } else {
                    if (this.automatic) {
                        System.err.println("Automatic count limit " + this.countLimit + " reached.");
                    } else {
                        System.err.println("Count limit " + this.countLimit + " reached.");
                    }
                    this.strSource.exit();
                    return;
                }
            }
            Molecule qmol = (Molecule)this.strSource.next();
            if (this.isRaw() || this.debugTrajectory && !this.hasConformations()) {
                if (this.trajExporter == null) {
                    try {
                        this.trajExporter = this.isRaw() ? new MolExporter(this.getTrajectoryName(), "sdf") : new MolExporter("debugTrajctory.sdf", "sdf");
                    }
                    catch (MolExportException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.trajExporter.write(qmol);
                }
                catch (MolExportException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.mol != null && qmol.getAtomCount() == this.mol.getAtomCount()) {
                int[] qgrinv = new int[qmol.getAtomCount()];
                qmol.getGrinv(qgrinv, 2);
                int shft = 0;
                for (int i = 0; i < qgrinv.length; ++i) {
                    if (qgrinv[i] == this.grinv[i] + shft) continue;
                    if (i == 0) {
                        shft = qgrinv[i] - this.grinv[i];
                        continue;
                    }
                    throw new UnsupportedOperationException("ConformationMatch can only be applied to conformations of the SAME molecule.");
                }
            } else if (this.mol != null) {
                throw new UnsupportedOperationException("ConformationMatch can only be applied to conformations of the SAME molecule.");
            }
            if (this.add(qmol)) {
                this.qfit = new JQuatFit(ConformerEquivalenceUtils.getMolCoordinates(qmol));
                ++this.ccounter;
            }
            Vector<Molecule> vector = this.conformations;
            synchronized (vector) {
                if (this.conformations.size() > this.maxNumberOfConformations) {
                    this.strSource.exit();
                    return;
                }
            }
            ++this.count;
        }
        this.strSource.exit();
    }

    public double getEnergy(Molecule m) {
        double energy = 0.0;
        if (this.getEnergyPropertyKey() != null) {
            energy = Double.parseDouble((String)m.getPropertyObject(this.getEnergyPropertyKey()));
            System.err.println("Energy from property is " + energy);
        } else if (this.getFf() != null) {
            if (!this.getFf().isInit()) {
                this.getFf().init(m);
            }
            this.ff.setCrd(this.getCoords(m));
            energy = this.ff.getEnergy();
            System.err.println("Calculated energy is " + energy);
            m.setProperty("Conformation_Energy", Double.toString(energy));
        } else {
            throw new UnsupportedOperationException("No way to get the energy of the conformation in ConformationMatch, set the proper property key or forcefield.");
        }
        return energy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Molecule qmol) {
        if (this.align == null) {
            this.align = new AlignRigidEasy();
            this.align.setReference(qmol);
        }
        int size = 0;
        Vector<Molecule> vector = this.conformations;
        synchronized (vector) {
            size = this.conformations.size();
            if (this.conformations == null) {
                this.conformations = new Vector();
            }
        }
        boolean clone = true;
        if (size > 0) {
            if (this.matchlist == null) {
                this.matchlist = new int[2][qmol.getAtomCount()];
                for (int i = 0; i < this.matchlist.length; ++i) {
                    this.matchlist[0][i] = i;
                    this.matchlist[1][i] = i;
                }
            }
            this.align.setRotatable(qmol);
            this.align.align();
            double dev = this.align.rmsd();
            if (Double.isNaN(dev)) {
                System.err.println("Alignement failed due to NaN.");
            }
            if (dev < this.getMatchLimit()) {
                return false;
            }
            this.align.setReference(qmol);
        }
        this.off = null;
        double[] saveVariables = null;
        if (this.isOpt()) {
            this.off = this.getFf();
            if (this.off == null) {
                this.off = new MMFF94();
                this.off.init(qmol);
                this.off.setCrd(ConformationMatch.getMolCoordinates(qmol));
            } else {
                if (!this.off.isInit()) {
                    this.off.init(qmol);
                }
                saveVariables = JLinAlg.VectCopy(this.off.getVariables());
                this.off.setCrd(ConformationMatch.getMolCoordinates(qmol));
            }
            if (this.o == null) {
                this.o = new GradientOptimization(this.off);
            }
            try {
                this.o.setVerboseLevel(1);
                this.o.setGradientRMSLimit(1.0E-5);
                System.err.print("+");
                if (!this.o.run()) {
                    return false;
                }
            }
            catch (GradientOptimization.GradientOptimizationException e) {
                e.printStackTrace();
            }
            qmol = this.off.getMoleculeWithLastUsedCoordinates();
            if (this.getEnergyPropertyKey() == null) {
                this.setEnergyPropertyKey("MMFF94_Energy");
            }
            qmol.setProperty(this.getEnergyPropertyKey(), Double.toString(this.off.getEnergy()));
            if (saveVariables != null) {
                this.off.setCrd(saveVariables);
            }
            clone = true;
        }
        boolean found = false;
        if (size > 0 && (this.isOpt() || this.getSpeedLevel() < 1)) {
            if (qmol == this.mol || clone) {
                clone = true;
                this.sss.setQuery(qmol.cloneMolecule());
            } else {
                this.sss.setQuery(qmol);
            }
            this.sss.setQueryCoordinates(ConformerEquivalenceUtils.getMolCoordinates(qmol));
            int nConf = this.conformations.size();
            found = false;
            double[][] mtcoords = null;
            for (int i = nConf - 1; i >= 0; --i) {
                this.sss.setTarget(this.conformations.elementAt(i));
                double[][] tcoords = ConformerEquivalenceUtils.getMolCoordinates(this.conformations.elementAt(i));
                this.sss.setTargetCoordinates(ConformerEquivalenceUtils.getMolCoordinates(this.conformations.elementAt(i)));
                this.sss.setIgnoreGeometryMatching(false, this.getMatchLimit());
                this.sss.setIgnoreExactMatching(false);
                this.sss.setFrozenMatch(this.frozenmatch);
                boolean bl = found = found || this.sss.findFirst();
                if (found) {
                    int[] res = this.sss.getResult();
                    int[] orig = new int[qmol.getAtomCount()];
                    for (int j = 0; j < orig.length; ++j) {
                        orig[j] = j;
                    }
                    int[][] matches = new int[2][];
                    matches[1] = orig;
                    matches[0] = res;
                    mtcoords = tcoords;
                    JQuatFit q = new JQuatFit(mtcoords);
                    double d = q.quatfit(ConformerEquivalenceUtils.getMolCoordinates(qmol), matches);
                }
                if (found) break;
            }
        }
        if (found) {
            return !found;
        }
        double energy = 0.0;
        if (this.getFf() != null && this.getFf().isInit()) {
            this.getFf().setCrd(ConformationMatch.getMolCoordinates(qmol));
            energy = this.getFf().getEnergy();
        } else if (!this.hasConformations()) {
            energy = this.getEnergy(qmol);
        }
        if (this.count == 0) {
            this.setLowestEnergy(energy);
        }
        if (!found && (Double.isInfinite(this.energyWindow) || energy < this.lowestEnergy + this.energyWindow)) {
            System.err.println("Energy of the new conformation is: " + energy);
            Vector<Molecule> vector2 = this.conformations;
            synchronized (vector2) {
                if (clone) {
                    this.conformations.addElement(qmol.cloneMolecule());
                } else {
                    this.conformations.addElement(qmol);
                }
                System.err.println("Storage size is " + this.conformations.size() + " at " + this.count);
            }
            if (this.automatic && this.count * 3 > this.countLimit) {
                this.setCountLimit(this.count * 3);
                this.setCount = true;
                this.ccounter = 0;
            }
            if (this.conformations.size() > this.maxNumberOfConformations) {
                return false;
            }
        }
        return !found;
    }

    private double[] getCoords(Molecule mol) {
        double[][] coord = ConformerEquivalenceUtils.getMolCoordinates(mol);
        double[] crd = new double[coord.length * 3];
        for (int i = 0; i < coord.length; ++i) {
            crd[i * 3] = coord[i][0];
            crd[i * 3 + 1] = coord[i][1];
            crd[i * 3 + 2] = coord[i][2];
        }
        return crd;
    }

    public Molecule[] getConformations() {
        Molecule[] confs = new Molecule[this.getConformationCount()];
        return this.conformations.toArray(confs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Molecule[] getRemainingConformations() {
        Molecule[] confs = null;
        Vector<Molecule> vector = this.conformations;
        synchronized (vector) {
            confs = new Molecule[this.conformations.size() - this.takenConformations];
            for (int i = 0; i < confs.length; ++i) {
                confs[i] = this.conformations.elementAt(i + this.takenConformations);
            }
            this.takenConformations = this.conformations.size();
        }
        return confs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConformationCount() {
        Vector<Molecule> vector = this.conformations;
        synchronized (vector) {
            return this.conformations.size();
        }
    }

    public void setMatchLimit(double matchLimit) {
        this.matchLimit = matchLimit;
        this.sss.setIgnoreGeometryMatching(false, matchLimit);
    }

    public double getMatchLimit() {
        return this.matchLimit;
    }

    public void setMolecule(Molecule mol) {
        this.mol = mol;
        this.init();
    }

    public Molecule getMol() {
        return this.mol;
    }

    public void setStrSource(StructureStream strSource) {
        this.strSource = strSource;
        this.init();
    }

    public StructureStream getStrSource() {
        return this.strSource;
    }

    public void setAutomatic(boolean automata) {
        this.automatic = automata;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public ForceField getFf() {
        return this.ff;
    }

    public void setFf(ForceField ff) {
        System.err.println("Set CM FF to " + ff.getClass().getName());
        this.ff = ff;
    }

    public String getEnergyPropertyKey() {
        return this.energyPropertyKey;
    }

    public void setEnergyPropertyKey(String eneergyPropertyKey) {
        this.energyPropertyKey = eneergyPropertyKey;
    }

    public int getCountLimit() {
        return this.countLimit;
    }

    public void setCountLimit(int countLimit) {
        System.err.println("Set count limit to " + countLimit);
        this.countLimit = countLimit;
    }

    public void setCountLimit(long countLimit) {
        System.err.println("Set count limit to " + countLimit);
        this.countLimit = Math.round(countLimit);
    }

    public double getEnergyWindow() {
        return this.energyWindow;
    }

    public void setEnergyWindow(double energyWindow) {
        this.energyWindow = energyWindow;
    }

    public void setConformations(Vector<Molecule> conformations) {
        this.conformations = conformations;
    }

    public void setLowestEnergy(double lowestEnergy) {
        this.lowestEnergy = lowestEnergy;
    }

    public double getLowestEnergy() {
        return this.lowestEnergy;
    }

    public void setOpt(boolean opt) {
        this.opt = opt;
    }

    public boolean isOpt() {
        return this.opt;
    }

    public void setHasConformations(boolean hasConformations) {
        this.hasConformations = hasConformations;
    }

    public boolean hasConformations() {
        return this.hasConformations;
    }

    public void setCanceller(SimpleCanceller canceller) {
        this.canceller = canceller;
    }

    public SimpleCanceller getCanceller() {
        return this.canceller;
    }

    public static double[] getMolCoordinates(Molecule m) {
        double[] coord = new double[3 * m.getAtomCount()];
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            int ij = 3 * i;
            coord[ij] = a.getX();
            coord[++ij] = a.getY();
            coord[++ij] = a.getZ();
        }
        return coord;
    }

    public static void setMolCoordinates(double[] coord, Molecule m) {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            int ij = 3 * i;
            a.setX(coord[ij]);
            a.setY(coord[++ij]);
            a.setZ(coord[++ij]);
        }
    }

    public void setMaxNumberOfConformations(int maxNumberOfConformations) {
        this.maxNumberOfConformations = maxNumberOfConformations;
    }

    public int getMaxNumberOfConformations() {
        return this.maxNumberOfConformations;
    }

    public void setSpeedLevel(int speedLevel) {
        this.speedLevel = speedLevel;
    }

    public int getSpeedLevel() {
        return this.speedLevel;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public String getTrajectoryName() {
        return this.trajectoryName;
    }

    public void setTrajectoryName(String trajectoryName) {
        this.trajectoryName = trajectoryName;
    }
}

