/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.calculations.clean.Opt3D;
import chemaxon.calculations.clean.Optimization;
import chemaxon.common.util.IntVector;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.debug.ForceFieldChecker;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.diag.Instrumentation;
import chemaxon.marvin.modelling.linalg.FunctionAdapter;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.MolecularDynamics;
import chemaxon.marvin.modelling.mm.DefaultForceField;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.marvin.modelling.struc.ConformerEquivalenceUtils;
import chemaxon.marvin.modelling.struc.ConformersDescriptor;
import chemaxon.marvin.modelling.struc.StereoCriteriaItem;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.Pinger;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.io.FileOutputStream;
import java.util.BitSet;

public class Fragment {
    private myMolecule basemol = null;
    private int[] atomlist = null;
    private int[] anchors = null;
    private CleanSettings cleanSettings = null;
    myMolecule fragMol = null;
    private Opt3D.Dreiding dreiding = null;
    private ForceField ff = null;
    boolean useHBondsInDreiding = false;
    Optimization opt = null;
    GradientOptimization gopt = null;
    BitSet[] atom13position = null;
    BitSet[] atom13positionInRing4 = null;
    BitSet[] atom13positionInRing5 = null;
    Substructure3DSearch gSSS = null;
    Substructure3DSearch subs = null;
    StereoCriteriaList stereo = null;
    public static final int STEREO_FLAG_OK = 1;
    public static final int STEREO_FLAG_CTERROR = 2;
    public static final int STEREO_FLAG_PERROR = 4;
    public static final int STEREO_FLAG_PERMUTATED = 8;
    public static final int STEREO_FLAG_ERROR = 6;
    public static final int STERIC_FLAG_PROXIMITY_SOFT = 1;
    public static final int STERIC_FLAG_PROXIMITY_HARD = 2;
    public static final int STERIC_FLAG_BONDLENGTH_SOFT = 4;
    public static final int STERIC_FLAG_BONDLENGTH_HARD = 8;
    public static final int STERIC_FLAG_RINGCRITICAL = 16;
    public static final int STERIC_FLAG_FLAWED = 32;
    public static final int STERIC_FLAG_SOFTERROR = 21;
    public static final int STERIC_FLAG_HARDERROR = 10;
    public static final int STERIC_FLAG_DEFORMEDSP3 = 64;

    public CleanSettings getCleanSettings() {
        return this.cleanSettings;
    }

    public BitSet[] getAtom13position() {
        if (this.atom13position == null) {
            int i;
            myMolecule m = this.getFragMol();
            this.atom13position = new BitSet[m.a];
            this.atom13positionInRing4 = new BitSet[m.a];
            this.atom13positionInRing5 = new BitSet[m.a];
            for (i = 0; i < m.a; ++i) {
                this.atom13position[i] = new BitSet(m.a);
                this.atom13positionInRing4[i] = new BitSet(m.a);
                this.atom13positionInRing5[i] = new BitSet(m.a);
            }
            for (i = 0; i < m.a; ++i) {
                for (int k = 0; k < m.ctab[i].length; ++k) {
                    for (int l = 0; l < m.ctab[i].length; ++l) {
                        int neighk = m.ctab[i][k];
                        int neighl = m.ctab[i][l];
                        if (this.atom13position[neighk].get(neighl)) {
                            this.atom13positionInRing4[neighk].set(neighl);
                        }
                        this.atom13position[neighk].set(neighl);
                    }
                }
            }
            if (m.SSSR != null) {
                for (i = 0; i < m.SSSR.length; ++i) {
                    if (m.SSSR[i].length != 5) continue;
                    for (int j = 0; j < m.SSSR[i].length; ++j) {
                        int a1 = m.SSSR[i][j];
                        int a2 = m.SSSR[i][(j + 2) % m.SSSR[i].length];
                        this.atom13positionInRing5[a1].set(a2);
                        this.atom13positionInRing5[a2].set(a1);
                    }
                }
            }
        }
        return this.atom13position;
    }

    public BitSet[] getAtom13positionInRing4() {
        if (this.atom13positionInRing4 == null) {
            this.getAtom13position();
        }
        return this.atom13positionInRing4;
    }

    public BitSet[] getAtom13positionInRing5() {
        if (this.atom13positionInRing5 == null) {
            this.getAtom13position();
        }
        return this.atom13positionInRing5;
    }

    public Fragment(Molecule mol, CleanSettings settings) {
        this.fragMol = this.basemol = new myMolecule(mol, settings);
        this.atomlist = U.gen(this.basemol.a);
        this.anchors = null;
        this.stereo = null;
        this.cleanSettings = settings;
    }

    public Fragment(myMolecule basemol, int[] atomlist, int[] anchors, StereoCriteriaList stereo, CleanSettings settings) {
        this.basemol = basemol;
        this.atomlist = atomlist;
        this.anchors = anchors;
        this.stereo = stereo;
        this.cleanSettings = settings;
    }

    public Fragment(myMolecule basemol, CleanSettings settings) {
        this.basemol = basemol;
        this.atomlist = U.gen(basemol.a);
        this.anchors = null;
        this.fragMol = basemol;
        this.cleanSettings = settings;
    }

    public void setStereo(StereoCriteriaList stereo) {
        this.stereo = stereo;
    }

    public StereoCriteriaList getStereo() {
        return this.stereo;
    }

    public int[] getAtomList() {
        return this.atomlist;
    }

    public int getAtomCount() {
        return this.atomlist.length;
    }

    public int[] getAnchors() {
        return this.anchors;
    }

    public myMolecule getBaseMol() {
        return this.basemol;
    }

    private Opt3D.Dreiding getDreiding() {
        return this.getDreiding(false, false);
    }

    public ForceField getForceField() {
        if (this.ff == null) {
            switch (DefaultForceField.getDefaultForceFieldType()) {
                case 0: {
                    this.ff = this.getFragMol().getForceField(this.cleanSettings);
                    break;
                }
                case 1: {
                    try {
                        this.ff = this.getFragMol().getMMFF();
                        break;
                    }
                    catch (MMFF94Exception e) {
                        this.ff = this.getFragMol().getForceField(this.cleanSettings);
                    }
                }
            }
        }
        return this.ff;
    }

    private Opt3D.Dreiding getDreiding(boolean createNewDreiding, boolean createNewFragMol) {
        if (createNewDreiding) {
            this.dreiding = null;
        }
        if (this.dreiding == null) {
            throw new UnsupportedOperationException();
        }
        return this.dreiding;
    }

    public static myMolecule retrieveMolceuleFromDreiding(Opt3D.Dreiding d) {
        return (myMolecule)d.getMol();
    }

    public double calcDreiding(double[][] c) {
        return this.calcDreiding(c, this.useHBondsInDreiding);
    }

    private double calcDreiding_Opt3D_Dreiding(double[][] c, boolean useHBonds) {
        Opt3D.Dreiding ffield = this.getDreiding();
        ffield.clearCorrupted();
        ffield.setDisableHBond(!useHBonds);
        myMolecule fm = Fragment.retrieveMolceuleFromDreiding(ffield);
        if (c == null) {
            System.err.println("c==null");
        }
        if (fm == null) {
            System.err.println("fm==null");
        }
        if (c.length != fm.a) {
            System.err.println("Consystency error in calcDreiding().");
        }
        for (int i = 0; i < fm.a; ++i) {
            for (int j = 0; j < 3; ++j) {
                fm.coord[i][j] = c[i][j];
            }
        }
        int tracerid = -1;
        if (CleanArgs.cltracer != null) {
            tracerid = CleanArgs.cltracer.getNodeID();
            CleanArgs.cltracer.incDetail(11);
        }
        debugPrintout debug = CleanArgs.getDebug();
        boolean Opt3D_dodebug = Opt3D.dodebug;
        boolean bl = Opt3D.dodebug = debug != null;
        if (debug != null) {
            debug.incLevel("Invoke Dreiding energy");
        }
        double e = ffield.getEnergy();
        if (debug != null) {
            debug.decLevel();
        }
        if (debug != null) {
            debug.println("Energy: " + e);
        }
        Opt3D.dodebug = Opt3D_dodebug;
        if (CleanArgs.cltracer != null) {
            CleanArgs.cltracer.decDetail(tracerid);
        }
        return e;
    }

    public double[][] calcDreidingGrad_Opt3D_Dreiding(double[][] c, boolean useHBonds) {
        Opt3D.Dreiding ffield = this.getDreiding();
        ffield.clearCorrupted();
        ffield.setDisableHBond(!useHBonds);
        myMolecule fm = Fragment.retrieveMolceuleFromDreiding(ffield);
        if (c == null) {
            System.err.println("c==null");
        }
        if (fm == null) {
            System.err.println("fm==null");
        }
        if (c.length != fm.a) {
            System.err.println("Consystency error in calcDreiding().");
        }
        for (int i = 0; i < fm.a; ++i) {
            for (int j = 0; j < 3; ++j) {
                fm.coord[i][j] = c[i][j];
            }
        }
        int tracerid = -1;
        if (CleanArgs.cltracer != null) {
            tracerid = CleanArgs.cltracer.getNodeID();
            CleanArgs.cltracer.incDetail(11);
        }
        debugPrintout debug = CleanArgs.getDebug();
        boolean Opt3D_dodebug = Opt3D.dodebug;
        boolean bl = Opt3D.dodebug = debug != null;
        if (debug != null) {
            debug.incLevel("Invoke Dreiding energy");
        }
        double e = ffield.getEnergy(true);
        double[][] grad = ffield.getDeriv();
        if (debug != null) {
            debug.decLevel();
        }
        if (debug != null) {
            debug.println("Energy: " + e);
        }
        Opt3D.dodebug = Opt3D_dodebug;
        if (CleanArgs.cltracer != null) {
            CleanArgs.cltracer.decDetail(tracerid);
        }
        return grad;
    }

    private double calcDreiding_MM(double[][] c, boolean useHBonds) {
        ForceField ffield = this.getForceField();
        double[] fv = ffield.getVariables();
        int k = 0;
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                fv[k++] = c[i][j];
            }
        }
        ffield.setCrd(fv);
        return ffield.getEnergy();
    }

    public double getEquilibriumBondLength(int a1, int a2) {
        ForceField f = this.getForceField();
        return f.getEqulibriumBondLength(a1, a2);
    }

    public double calcDreiding(double[][] c, boolean useHBonds) {
        return this.calcDreiding_MM(c, useHBonds);
    }

    public double[] calcDreidingGradient(double[][] c, boolean useHBonds) {
        ForceField ffield = this.getForceField();
        double[] fv = ffield.getVariables();
        int k = 0;
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                fv[k++] = c[i][j];
            }
        }
        ffield.setCrd(fv);
        return ffield.getFunctionGradient();
    }

    public double[] calcDreidingNumericGradient(double[][] c, double eps, boolean useHBonds) {
        ForceField ffield = this.getForceField();
        double[] fv = ffield.getVariables();
        int k = 0;
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                fv[k++] = c[i][j];
            }
        }
        ffield.setCrd(fv);
        return ForceFieldChecker.getNumericGradient(ffield, eps);
    }

    public double[] calcDreiding(double[][][] c) {
        return this.calcDreiding(c, this.useHBondsInDreiding);
    }

    public double[] calcDreiding(double[][][] c, boolean useHBonds) {
        double[] ret = new double[c.length];
        for (int i = 0; i < c.length; ++i) {
            ret[i] = this.calcDreiding(c[i], useHBonds);
        }
        return ret;
    }

    private Optimization getOpt() {
        return this.getOpt(false, false, false);
    }

    private GradientOptimization getGOpt() {
        return this.getGOpt(false, false, false);
    }

    private GradientOptimization getGOpt(boolean createNewOpt, boolean createNewDreiding, boolean createNewFragMol) {
        if (createNewOpt) {
            this.gopt = null;
        }
        if (this.gopt == null) {
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.incLevel("Construct optimization");
            }
            if (debug != null) {
                debug.println("Aquire ForceField");
            }
            ForceField f = this.getForceField();
            f.setCanceller(this.cleanSettings.getCanceller());
            if (debug != null) {
                debug.printBC("Construct GradientOptimization");
            }
            if (this.cleanSettings.isOptionCheckGradientsGiven()) {
                Molecule fmol = null;
                boolean pall = false;
                switch (this.cleanSettings.getCheckGradientBehavior()) {
                    case 3: {
                        fmol = this.getFragMol().getOriginalMolCopy();
                        pall = true;
                        break;
                    }
                    case 2: {
                        fmol = this.getFragMol().getOriginalMolCopy();
                    }
                }
                this.gopt = new GradientOptimization(new ForceFieldChecker(f, fmol, pall, this.cleanSettings.isCheckGradientSkipNum()));
            } else {
                this.gopt = new GradientOptimization(f);
            }
            if (debug != null) {
                debug.decLevel();
            }
        }
        return this.gopt;
    }

    private Optimization getOpt(boolean createNewOpt, boolean createNewDreiding, boolean createNewFragMol) {
        Optimization optB = this.opt;
        if (createNewOpt) {
            this.opt = null;
        }
        if (this.opt == null) {
            System.err.println("Warning! Using isopt with old dreiding!");
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.incLevel("Construct optimization");
            }
            if (debug != null) {
                debug.printBC("Aquire Dreiding object");
            }
            Opt3D.Dreiding d = this.getDreiding(createNewDreiding, createNewFragMol);
            if (debug != null) {
                debug.printBC("Aquire fragMol");
            }
            myMolecule mol = Fragment.retrieveMolceuleFromDreiding(d);
            if (debug != null) {
                debug.printBC("Invoke MMOptimization constructor");
            }
            if (debug == null) {
                Opt3D.dodebug = false;
            }
            Opt3D.MMOptimization ff_mmopt = new Opt3D.MMOptimization(d, debug);
            if (debug != null) {
                debug.printBC("Invoke Optimization constructor");
            }
            this.opt = new Optimization(ff_mmopt, this.cleanSettings.getCanceller());
            if (debug != null) {
                debug.decLevel();
            }
        }
        if (optB != null && createNewOpt) {
            Opt3D.MMOptimization MMold = (Opt3D.MMOptimization)optB.getFunct();
            Opt3D.MMOptimization MMnew = (Opt3D.MMOptimization)this.opt.getFunct();
            Opt3D.Dreiding dold = MMold.MM;
            Opt3D.Dreiding dnew = MMnew.MM;
            if (!U.equals(dold.getAnum(), dnew.getAnum())) {
                throw new UnsupportedOperationException();
            }
            if (!U.equals(dold.getBAtom1(), dnew.getBAtom1())) {
                throw new UnsupportedOperationException();
            }
            if (!U.equals(dold.getBAtom2(), dnew.getBAtom2())) {
                throw new UnsupportedOperationException();
            }
            if (!U.equals(dold.getBList(), dnew.getBList())) {
                throw new UnsupportedOperationException();
            }
            if (!U.equals(dold.getBOList(), dnew.getBOList())) {
                throw new UnsupportedOperationException();
            }
            if (!U.equals(dold.getBondOrders(), dnew.getBondOrders())) {
                throw new UnsupportedOperationException();
            }
            if (!U.equals(dold.getCTab(), dnew.getCTab())) {
                throw new UnsupportedOperationException();
            }
            this.opt = optB;
        }
        return this.opt;
    }

    public boolean optimizeDreiding(double[][] c) {
        return this.optimizeDreiding(c, 0.001);
    }

    private boolean invokeNewOptim(double[][] c, double ftol, debugPrintout debug) {
        VerbosePrinter vp = null;
        if (debug != null) {
            vp = this.cleanSettings.getVerbosePrinter("Invoke new optim");
        }
        if (vp != null) {
            vp.print("invokeNewOptim()");
            vp.print("call getGOpt()");
        }
        GradientOptimization o = this.getGOpt(true, false, false);
        if (vp != null) {
            vp.print("call o.getFunction");
        }
        GradientOptimization.FunctionToMinimize func = o.getFunction();
        FunctionAdapter fad = null;
        ForceField ffi = null;
        if (func instanceof ForceFieldChecker) {
            func = ((ForceFieldChecker)func).getBase();
        }
        if (func instanceof FunctionAdapter) {
            if (vp != null) {
                vp.print("Fill FunctionAdapter coordinates");
            }
            fad = (FunctionAdapter)func;
            myMolecule mol = fad.getMyMol();
            fad.invalidate();
            for (int i = 0; i < c.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    mol.coord[i][j] = c[i][j];
                }
            }
        } else if (func instanceof ForceField) {
            double[] ffvar;
            if (vp != null) {
                vp.print("Fill ForceField coordinates");
            }
            if (c.length * 3 != (ffvar = (ffi = (ForceField)func).getVariables()).length) {
                throw new UnsupportedOperationException();
            }
            int k = 0;
            for (int i = 0; i < c.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ffvar[k++] = c[i][j];
                }
            }
            ffi.setCrd(ffvar);
        } else {
            throw new UnsupportedOperationException();
        }
        double e = 0.0;
        boolean converged = false;
        boolean exception = false;
        try {
            int ovl = CleanArgs.getVerboseLevel();
            if (debug != null) {
                ovl = 4;
            }
            if (vp != null) {
                vp.print("Set verbose level to: " + ovl);
            }
            o.setVerboseLevel(ovl);
            o.setGradientRMSLimit(ftol);
            o.setFinishGradientRMSLimit(ftol);
            if (fad != null) {
                fad.clearDreidingCorrupted();
            }
            if (ffi != null) {
                ffi.clearForceFieldCorrupted();
            }
            if (debug != null && vp != null) {
                GradientOptimization.VerbosePrinterAdapter vpa = new GradientOptimization.VerbosePrinterAdapter(vp.incDetail("Run optimization"));
                o.setVerbosePrinter(vpa);
            } else {
                if (o.getVerboseLevel() != 0 && !o.isVerbosePrinterNotNull()) {
                    o.setVerbosePrinter(new GradientOptimization.VerbosePrinterImplementation());
                }
                if (vp != null) {
                    vp.print("Run optimization");
                }
            }
            converged = o.run();
            if (vp != null) {
                vp.print("Optimization returned. Converged=" + converged);
            }
            if (!converged) {
                CleanArgs.reportError("Optimizer not converged");
                if (this.cleanSettings.getInst() != null) {
                    this.cleanSettings.getInst().addFlag(new Instrumentation.OptimizerNotConvergedFlag());
                    System.err.println("Stack trace:");
                    Thread.dumpStack();
                }
                if (debug != null) {
                    debug.reportError("Optimizer not converged");
                }
            } else if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Optimizer returned; converged");
            }
        }
        catch (Exception ex) {
            exception = true;
            CleanArgs.reportException("Optimizer exception", ex);
            if (this.cleanSettings.getInst() != null) {
                this.cleanSettings.getInst().addFlag(new Instrumentation.OptimizerExceptionFlag());
                this.cleanSettings.getInst().addFlag(new Instrumentation.ExceptionReported(ex));
            }
            ex.printStackTrace();
        }
        if (fad != null) {
            myMolecule mol = fad.getMyMol();
            for (int i = 0; i < c.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    c[i][j] = mol.coord[i][j];
                }
            }
        } else if (ffi != null) {
            double[] var = ffi.getVariables();
            int k = 0;
            for (int i = 0; i < c.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    c[i][j] = var[k++];
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return converged;
    }

    private boolean invokeOldOptim(double[][] c, double ftol, debugPrintout debug) {
        boolean converged = false;
        if (debug != null) {
            debug.printBC("Aquire Optimization object");
        }
        Optimization o = this.getOpt();
        if (debug != null) {
            debug.printBC("Aquire myMolecule object");
        }
        Opt3D.MMOptimization mm = (Opt3D.MMOptimization)o.getFunct();
        myMolecule mol = (myMolecule)mm.MM.getMol();
        mm.MM.setDisableHBond(!this.useHBondsInDreiding);
        if (debug != null) {
            debug.printBC("update coordinates");
        }
        if (c.length != mol.a) {
            throw new IndexOutOfBoundsException("Coordinates size mismatch.");
        }
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                mol.coord[i][j] = c[i][j];
            }
        }
        mm.initVar();
        if (debug != null) {
            mol.place3DApplet("Before optimization", c);
            Printouts.place3DApplet("Molecule from Dreiding", mm.MM.getTopologyMol(false));
            Printouts.place3DApplet("Molecule from Dreiding Top", mm.MM.getTopologyMol(true));
        }
        ((Opt3D.MMOptimization)o.getFunct()).debug = debug;
        if (debug == null) {
            Opt3D.dodebug = false;
        }
        if (debug != null) {
            debug.println("Invoke optimization");
            final Opt3D.Dreiding fd = mm.MM;
            Pinger p = new Pinger(){

                @Override
                public void ping() {
                    Printouts.place3DApplet("After step", fd.getTopologyMol(true));
                }
            };
            Pinger q = new Pinger(){

                @Override
                public void ping() {
                    Printouts.place3DApplet("Funct eval", fd.getTopologyMol(true));
                }
            };
            mm.setMolUpdatePing(p);
            mm.setFunctEvalPing(q);
        }
        double e = 0.0;
        double ret = o.GradOpt(48, ftol);
        converged = U.isDoubleOK(ret);
        mm.setMolUpdatePing(null);
        if (debug != null) {
            debug.println("Returned. Energy: " + e);
        }
        if (debug != null) {
            mol.place3DApplet("After optimization", mol.coord);
            Printouts.place3DApplet("Molecule from Dreiding", mm.MM.getTopologyMol(false));
            Printouts.place3DApplet("Molecule from Dreiding Top", mm.MM.getTopologyMol(true));
        }
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                c[i][j] = mol.coord[i][j];
            }
        }
        return converged;
    }

    public boolean optimizeDreiding(double[][] c, double ftol) {
        boolean flawedAfter;
        if (this.cleanSettings != null && this.cleanSettings.OPT_stopper_Optimization != null) {
            this.cleanSettings.OPT_stopper_Optimization.start();
        }
        boolean converged = false;
        debugPrintout debug = CleanArgs.getDebug();
        if (!U.isDoubleOK(c)) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Optimization invoked on flawed structure");
            }
            if (debug != null && debug.getWillPrint()) {
                debug.println("Flawed structure before optimization: ");
                U.toString(c);
            }
            throw new UnsupportedOperationException("Optimization invoked on flawed structure");
        }
        double e = 0.0;
        double[][] cbefore = null;
        cbefore = U.clone(c);
        long tbefore = 0L;
        double ebefore = 0.0;
        boolean stericStateBefore = false;
        int tracerid = -1;
        if (CleanArgs.cltracer != null) {
            tracerid = CleanArgs.cltracer.getNodeID();
            CleanArgs.cltracer.incDetail(9);
        }
        debugPrintout optd = CleanArgs.getDebug();
        converged = CleanArgs.OPT_OPTIMIZERTOUSE == 1 ? this.invokeOldOptim(c, ftol, optd) : this.invokeNewOptim(c, ftol, optd);
        if (CleanArgs.cltracer != null) {
            CleanArgs.cltracer.decDetail(tracerid);
        }
        boolean flawedAfterE = !U.isDoubleOK(e = this.calcDreiding(c));
        boolean flawedAfterC = !U.isDoubleOK(c);
        boolean bl = flawedAfter = flawedAfterC || flawedAfterE;
        if (flawedAfter) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Flawed after optimization");
            }
            if (this.cleanSettings != null && this.cleanSettings.getInst() != null) {
                this.cleanSettings.getInst().addFlag(new Instrumentation.OptimizationFlawedFlag());
            }
            U.copyTo(cbefore, c);
        }
        long tafter = 0L;
        if (tbefore != 0L) {
            tafter = System.currentTimeMillis();
        }
        if (!converged) {
            // empty if block
        }
        int stericStateAfter = 0;
        boolean stericStateAfterCalculated = false;
        if (this.cleanSettings != null && this.cleanSettings.getInst() != null) {
            if (!stericStateAfterCalculated) {
                stericStateAfter = this.checkSteric(c, true, debug);
                stericStateAfterCalculated = true;
            }
            if ((stericStateAfter & 0x10) != 0) {
                this.cleanSettings.getInst().addFlag(new Instrumentation.OptimizedToRC());
            }
            if ((stericStateAfter & 0x40) != 0) {
                this.cleanSettings.getInst().addFlag(new Instrumentation.OptimizedToDefSP3());
            }
        }
        if (this.cleanSettings != null && this.cleanSettings.OPT_stopper_Optimization != null) {
            this.cleanSettings.OPT_stopper_Optimization.stop();
        }
        return converged;
    }

    public void appendToFileBeforeAfters(double[][] cBefore, double[][] cAfter, String filename1, String filename2, boolean tripletsIn1, boolean beforeIn2, String format2, String[] commonProps, String idPropKey, String tstampPropKey, String origsmiPropKey, String addVerb, CleanSettings settings) {
        try {
            boolean append2;
            boolean append1 = cBefore != null && filename1 != null;
            boolean bl = append2 = cAfter != null && filename2 != null;
            if (!append1 && !append2) {
                return;
            }
            System.err.print("Appending molecule to ");
            if (append1) {
                System.err.print("\"" + filename1 + "\"");
            }
            if (append2) {
                if (append1) {
                    System.err.print("/");
                }
                System.err.print("\"" + filename2 + "\"");
            }
            if (addVerb != null) {
                System.err.print(" " + addVerb);
            }
            System.err.println();
            FileOutputStream fo1 = null;
            FileOutputStream fo2 = null;
            MolExporter me1 = null;
            MolExporter me2 = null;
            if (append1) {
                fo1 = new FileOutputStream(filename1, true);
                me1 = new MolExporter(fo1, format2);
            }
            if (append2) {
                fo2 = new FileOutputStream(filename2, true);
                me2 = new MolExporter(fo2, format2);
            }
            Molecule m = this.getFragMol().getOriginalMolCopy().cloneMolecule();
            if (commonProps != null) {
                for (int i = 0; i < commonProps.length; ++i) {
                    m.setProperty(commonProps[i], commonProps[i + 1]);
                    ++i;
                }
            }
            String origsmi = null;
            if (settings != null && origsmiPropKey != null) {
                origsmi = settings.getSourceSmiles();
            }
            if (origsmi != null) {
                m.setProperty(origsmiPropKey, origsmi);
            }
            String tstamp = null;
            if (tstampPropKey != null) {
                tstamp = "" + System.currentTimeMillis();
            }
            if (tstampPropKey != null) {
                m.setProperty(tstampPropKey, tstamp);
            }
            if (append1 && tripletsIn1) {
                int i;
                Molecule mBA = m.cloneMolecule();
                if (idPropKey != null) {
                    mBA.setProperty(idPropKey, "StructureBefore");
                }
                ConformersDescriptor.writeCoords(mBA, cBefore);
                me1.write(mBA);
                if (idPropKey != null) {
                    mBA.setProperty(idPropKey, "StructureAfter");
                }
                ConformersDescriptor.writeCoords(mBA, cAfter);
                me1.write(mBA);
                ConformersDescriptor.writeCoords(mBA, cBefore);
                if (idPropKey != null) {
                    mBA.setProperty(idPropKey, "StructureBeforeAfterOverlap");
                }
                double[][] afterclone = U.clone(cAfter);
                JQuatFit qf = new JQuatFit(cBefore);
                qf.quatfit(afterclone, new int[][]{U.gen(cBefore.length), U.gen(cBefore.length)});
                Molecule mBA2 = mBA.cloneMolecule();
                ConformersDescriptor.writeCoords(mBA2, afterclone);
                for (i = 0; i < mBA2.getAtomCount(); ++i) {
                    mBA.add(mBA2.getAtom(i));
                }
                for (i = 0; i < mBA2.getBondCount(); ++i) {
                    mBA.add(mBA2.getBond(i));
                }
                me1.write(mBA);
            } else if (append1 && !tripletsIn1) {
                ConformersDescriptor.writeCoords(m, cBefore);
                me1.write(m);
            }
            if (append2) {
                if (beforeIn2) {
                    ConformersDescriptor.writeCoords(m, cBefore);
                } else {
                    ConformersDescriptor.writeCoords(m, cAfter);
                }
                me2.write(m);
            }
            if (fo1 != null) {
                me1.close();
                fo1.flush();
                fo1.close();
            }
            if (fo2 != null) {
                me2.close();
                fo2.flush();
                fo2.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void runControlledMD(double[][] c, CleanSettings settings) {
        this.runControlledMD(c, 300, 350, settings);
    }

    public void runControlledMD(double[][] c, int nStep, int startingTemperature, CleanSettings settings) {
        debugPrintout debug;
        if (settings.OPT_stopper_MD != null) {
            settings.OPT_stopper_MD.start();
        }
        if ((debug = CleanArgs.getDebug()) != null) {
            debug.incLevel("Invoke molecular dynamics");
        }
        if (debug != null) {
            debug.printBC("Aquire fragMol()");
        }
        myMolecule myMol = this.getFragMol();
        Molecule mol = myMol.getOriginalMolCopy();
        ConformerEquivalenceUtils.setMolCoordinates(mol, c);
        if (debug != null) {
            debug.printBC("Aquire MolecularDynamics object");
        }
        try {
            MolecularDynamics md = new MolecularDynamics(mol);
            md.setTimeStep("1");
            md.setStepNo(nStep);
            md.setDebugLevel(0, "-");
            md.setTemperature(startingTemperature);
            md.setIntegrator("stabilizedvelocityverlet");
            md.InitMD();
            mol = md.RunMD();
        }
        catch (MDException e) {
            System.err.println("FATAL MD ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        if (debug != null) {
            debug.printBC("Retreive coordinates");
        }
        c = ConformerEquivalenceUtils.getMolCoordinates(mol, c);
        if (debug != null) {
            debug.decLevel();
        }
        if (settings.OPT_stopper_MD != null) {
            settings.OPT_stopper_MD.stop();
        }
    }

    public void placeApplet(String btnlabel) {
        this.getFragMol().placeApplet(btnlabel);
    }

    public void placeApplet(String btnlabel, String sel) {
        this.getFragMol().placeApplet(btnlabel, sel);
    }

    public myMolecule getFragMol() {
        return this.getFragMol(false);
    }

    public myMolecule getFragMol(boolean constructNew) {
        myMolecule fragMolBackup = this.fragMol;
        if (constructNew) {
            this.fragMol = null;
        }
        if (this.fragMol == null) {
            int i;
            debugPrintout debug = null;
            if (debug != null) {
                debug.printBC("Constructing fragment molecule");
            }
            Molecule cm = new Molecule();
            int[] selAtoms = this.getAtomList();
            myMolecule origmol = this.getBaseMol();
            int[] atomToSel = U.genInverse(selAtoms, origmol.a);
            BitSet atomIsAnchor = U.createSets(this.getAnchors(), origmol.a);
            for (i = 0; i < selAtoms.length; ++i) {
                int aid = selAtoms[i];
                int anum = atomIsAnchor.get(aid) ? 1 : origmol.anum[aid];
                MolAtom a = new MolAtom(anum);
                cm.add(a);
            }
            for (i = 0; i < origmol.bat[0].length; ++i) {
                int oa1 = origmol.bat[0][i];
                int oa2 = origmol.bat[1][i];
                int fa1 = atomToSel[oa1];
                int fa2 = atomToSel[oa2];
                if (fa1 == -1 || fa2 == -1 || atomIsAnchor.get(oa1) && atomIsAnchor.get(oa2)) continue;
                MolAtom a1 = cm.getAtom(fa1);
                MolAtom a2 = cm.getAtom(fa2);
                int f = 1;
                switch (origmol.getBondOrder(i)) {
                    case 4: {
                        f = 2;
                        break;
                    }
                    case 6: {
                        f = 3;
                        break;
                    }
                    case 3: {
                        f = 4;
                    }
                }
                if (f != 1) {
                    boolean mlig2;
                    boolean anch1 = atomIsAnchor.get(oa1);
                    boolean anch2 = atomIsAnchor.get(oa2);
                    boolean mlig1 = origmol.ctab[oa1].length > 4;
                    boolean bl = mlig2 = origmol.ctab[oa2].length > 4;
                    if (anch1 && !anch2 && mlig2 || !anch1 && anch2 && mlig1) {
                        f = 1;
                        if (CleanArgs.doVerbose()) {
                            CleanArgs.verbose("Anchor bond changed");
                        }
                    }
                }
                MolBond b = new MolBond(a1, a2, f);
                cm.add(b);
            }
            SelectionMolecule sm = new SelectionMolecule();
            cm.clonecopy(sm);
            this.fragMol = new myMolecule(sm, debug, this.cleanSettings);
            if (debug != null) {
                debug.incLevel("Molecule fragment constructed");
                this.fragMol.printout(debug);
                debug.decLevel();
                this.fragMol.placeApplet("Constructed molecule (anchors)", U.sel(this.getAnchors()));
            }
        }
        if (fragMolBackup != null && constructNew) {
            if (!U.equals(this.fragMol.anum, fragMolBackup.anum)) {
                System.err.println("anum");
                ErrPrint.errPrint("Old anum", fragMolBackup.anum);
                ErrPrint.errPrint("New anum", this.fragMol.anum);
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.bat, fragMolBackup.bat)) {
                System.err.println("bat");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.bdesc, fragMolBackup.bdesc)) {
                System.err.println("bdesc");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.atomFlag, fragMolBackup.atomFlag)) {
                System.err.println("atomFlag");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.ctab, fragMolBackup.ctab)) {
                System.err.println("ctab");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.getBAtom1(), fragMolBackup.getBAtom1())) {
                System.err.println("getBatom1");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.getBAtom2(), fragMolBackup.getBAtom2())) {
                System.err.println("getBatom2");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.getAtomNumbers(), fragMolBackup.getAtomNumbers())) {
                System.err.println("getAtomNumbers");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.getBList(), fragMolBackup.getBList())) {
                System.err.println("getBlist");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.getBOlist(), fragMolBackup.getBOlist())) {
                System.err.println("getBOlist");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.getBondOrders(), fragMolBackup.getBondOrders())) {
                System.err.println("getBOlist");
                throw new UnsupportedOperationException();
            }
            if (!U.equals(this.fragMol.getCtab(), fragMolBackup.getCtab())) {
                System.err.println("getCtab");
                throw new UnsupportedOperationException();
            }
        }
        return this.fragMol;
    }

    public void setUseHBondsInDreiding(boolean useHBondsInDreiding) {
        this.useHBondsInDreiding = useHBondsInDreiding;
    }

    public boolean isEquivalent(double[][] c1, double[][] c2) {
        return this.isEquivalent(c1, c2, 0.1);
    }

    public boolean isEquivalent(double[][] c1, double[][] c2, double tolerance) {
        if (this.subs == null) {
            this.subs = new Substructure3DSearch();
            this.subs.setMolecules(this.getFragMol().getOriginalMolCopy(), this.getFragMol().getOriginalMolCopy());
            this.subs.setIgnoreExactMatching(false);
        }
        this.subs.setIgnoreGeometryMatching(false, tolerance);
        this.subs.setQueryCoordinates(c1);
        this.subs.setTargetCoordinates(c2);
        return this.subs.findFirst();
    }

    private Substructure3DSearch getGSSS() {
        if (this.gSSS == null) {
            this.gSSS = new Substructure3DSearch();
            Molecule m = this.getFragMol().getOriginalMolCopy();
            this.gSSS.setMolecules(m, m);
            this.gSSS.setIgnoreExactMatching(false);
            this.gSSS.setIgnoreGeometryConstraints(false);
            BitSet b = new BitSet();
            if (this.stereo != null) {
                int s = this.stereo.getSize();
                for (int i = 0; i < s; ++i) {
                    StereoCriteriaItem it = this.stereo.get(i);
                    int[] ia = it.getInvolvedAtoms();
                    for (int j = 0; j < ia.length; ++j) {
                        b.set(ia[j]);
                    }
                }
            }
            this.gSSS.setHighPriorityQueryAtoms(U.collectSets(b));
        }
        return this.gSSS;
    }

    public static String stereoResultsToString(int s) {
        String res = null;
        if ((s & 1) != 0) {
            String string = res = res == null ? "OK" : res + " OK";
        }
        if ((s & 2) != 0) {
            String string = res = res == null ? "CTERROR" : res + " CTERROR";
        }
        if ((s & 4) != 0) {
            String string = res = res == null ? "PERROR" : res + " PERROR";
        }
        if ((s & 8) != 0) {
            res = res == null ? "PERMUTATED" : res + " PERMUTATED";
        }
        return res;
    }

    public boolean isStereoSpecified() {
        return this.stereo != null && this.stereo.getSize() != 0;
    }

    public int checkStereo(final double[][] c, boolean allowPermutation, double tolerance, debugPrintout debug) {
        boolean lasterr;
        if (!this.isStereoSpecified()) {
            return 1;
        }
        if (!allowPermutation) {
            boolean stereoOK = this.stereo.checkStereo(c);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("checkStereo: no permutation, ok=" + stereoOK);
            }
            return stereoOK ? 1 : 6;
        }
        final int[] permv = new int[this.getFragMol().a];
        permv[0] = -1;
        StereoCriteriaList.coordinateQuery q = new StereoCriteriaList.coordinateQuery(){

            @Override
            public double[] get(int i) {
                int j = i;
                if (permv[0] != -1) {
                    j = permv[i];
                }
                return c[j];
            }

            @Override
            public boolean isPlaced(int i) {
                return true;
            }
        };
        Substructure3DSearch gSSSearch = null;
        do {
            boolean invalidPermutation = false;
            if (permv[0] != -1) {
                myMolecule m = this.getFragMol();
                if (debug != null) {
                    debug.printB("Check permutation:");
                    debug.printVector(permv);
                    double[][] cp = new double[c.length][];
                    for (int j = 0; j < c.length; ++j) {
                        cp[j] = c[permv[j]];
                    }
                    m.place3DApplet("Permutated coordinates", cp);
                }
                if (debug != null) {
                    debug.println("Check bonds");
                }
                for (int j = 0; j < m.b; ++j) {
                    double bl2;
                    int b1 = m.bat[0][j];
                    int b2 = m.bat[1][j];
                    double bl1 = V.vectLen(c[b1], c[b2]);
                    double err = Math.abs(bl1 - (bl2 = V.vectLen(c[permv[b1]], c[permv[b2]])));
                    if (!(err > 0.5)) continue;
                    invalidPermutation = true;
                    if (!CleanArgs.doVerbose()) continue;
                    CleanArgs.verbose("Invalid for bond " + j + " (" + b1 + "-" + b2 + ") " + "error=" + err + " bl1=" + bl1 + " bl2=" + bl2);
                }
                if (debug != null) {
                    debug.println("Check done");
                }
            }
            boolean stereoOK = this.stereo.checkStereo(q, debug);
            if (!allowPermutation && !stereoOK) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Permutations not allowed, stereo check failed, return with error");
                }
                return 6;
            }
            boolean bl = lasterr = invalidPermutation || !stereoOK;
            if (!lasterr) continue;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Try to permutate");
            }
            if (permv[0] == -1) {
                gSSSearch = this.getGSSS();
                gSSSearch.setQueryCoordinates(c);
                if (!gSSSearch.findFirst()) {
                    System.err.println("ERROR in stereo check! No auto map found.");
                    throw new UnsupportedOperationException();
                }
                if (CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Set first permutation");
                }
                if (debug != null) {
                    debug.printB("Set first permutation");
                }
                U.copyTo(permv, U.genInverse(gSSSearch.getResult()));
                continue;
            }
            if (gSSSearch.findNext()) {
                U.copyTo(permv, U.genInverse(gSSSearch.getResult()));
                if (CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Set next permutation");
                    ErrPrint.errPrint("permutation", permv);
                }
                if (debug == null) continue;
                debug.printB("Set next permutation");
                continue;
            }
            permv[0] = -1;
            if (debug != null) {
                debug.printB("No next permutation");
            }
            if (CleanArgs.verboseLevel <= 0) continue;
            CleanArgs.verbose("No next permutation");
        } while (lasterr && permv[0] != -1);
        if (lasterr) {
            return 6;
        }
        if (!lasterr && permv[0] != -1) {
            int j;
            double[][] permc = new double[c.length][];
            for (j = 0; j < permc.length; ++j) {
                permc[j] = c[permv[j]];
            }
            for (j = 0; j < permc.length; ++j) {
                c[j] = permc[j];
            }
            return 9;
        }
        return 1;
    }

    private void reportFlawed(CleanSettings settings) {
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Warning! Steric check invoked on flawed structure");
        }
        if (settings.getInst() != null) {
            settings.getInst().addFlag(new Instrumentation.StereocheckOnFlawed());
        }
    }

    public int checkSteric(double[][] c, boolean optimized, debugPrintout debug) {
        int a1;
        int ret = 0;
        BitSet[] atom13 = this.getAtom13position();
        BitSet[] atom13r4 = this.getAtom13positionInRing4();
        BitSet[] atom13r5 = this.getAtom13positionInRing5();
        IntVector selSoft = null;
        IntVector selHard = null;
        IntVector selDefSP3 = null;
        myMolecule mol = this.getFragMol();
        if (debug != null) {
            if (selHard != null) {
                selHard.clear();
            }
            if (selSoft != null) {
                selSoft.clear();
            }
            if (selDefSP3 != null) {
                selDefSP3.clear();
            }
        }
        for (a1 = 0; a1 < mol.a; ++a1) {
            int a1n;
            if (!mol.isHybSP3(a1) || mol.ctab[a1].length != 4 || (a1n = mol.anum[a1]) > 18) continue;
            boolean deformed = false;
            deformed = V.isSP3Deformed(c[a1], c[mol.ctab[a1][0]], c[mol.ctab[a1][1]], c[mol.ctab[a1][2]], c[mol.ctab[a1][3]], 0.5, 3.0543261909900763, 0.4363323129985824);
            if (!deformed) continue;
            ret |= 0x40;
            if (debug == null) continue;
            debug.println("SP3 neighborhood deformed on " + a1);
            if (selDefSP3 == null) {
                selDefSP3 = new IntVector(mol.a);
            }
            selDefSP3.add(a1);
        }
        for (a1 = 0; a1 < mol.a; ++a1) {
            boolean a1FCCand = mol.ctab[a1].length > 6;
            for (int i = 0; i < 3; ++i) {
                if (U.isDoubleOK(c[a1][i])) continue;
                if (debug != null) {
                    debug.println("Atom coordinate = NaN/Inf");
                }
                this.reportFlawed(this.cleanSettings);
                return 32;
            }
            for (int a2 = a1 + 1; a2 < mol.a; ++a2) {
                boolean a2FCCand = mol.ctab[a2].length > 6;
                boolean bonded = mol.bonds[a1][a2] != -1;
                int s1hard = -1;
                int s2hard = -1;
                int s1soft = -1;
                int s2soft = -1;
                double dsq = V.dot(V.minus(c[a1], c[a2]));
                double d = Math.sqrt(dsq);
                if (!U.isDoubleOK(d)) {
                    if (debug != null) {
                        debug.println("Atom-Atom distance = NaN/Inf");
                    }
                    this.reportFlawed(this.cleanSettings);
                    return 32;
                }
                if (!bonded) {
                    if (d < 0.2) {
                        ret |= 2;
                        s1hard = a1;
                        s2hard = a2;
                        if (debug != null) {
                            debug.println("Hard px: (" + a1 + "-" + a2 + ") d=" + d + " < 0.2");
                        }
                    }
                    double mlimit = 2.0;
                    if (mol.anum[a1] == 1 && mol.anum[a2] == 1) {
                        mlimit = 1.05;
                    }
                    if (mlimit > 1.8 && (mol.anum[a1] == 1 || mol.anum[a2] == 1)) {
                        mlimit = 1.8;
                    }
                    if (mlimit > 1.8 && atom13[a1].get(a2)) {
                        mlimit = 1.8;
                    }
                    if (mlimit > 1.5 && this.atom13positionInRing4[a1].get(a2)) {
                        mlimit = 1.5;
                    }
                    if (mlimit > 1.5 && this.atom13positionInRing5[a1].get(a2)) {
                        mlimit = 1.5;
                    }
                    if (mlimit > 1.35 && atom13[a1].get(a2) && (mol.anum[a1] == 1 || mol.anum[a2] == 1)) {
                        mlimit = 1.35;
                    }
                    if (d < mlimit) {
                        boolean anglesOK = false;
                        if (atom13[a1].get(a2)) {
                            int[] centrals = U.and(mol.ctab[a1], mol.ctab[a2]);
                            if (centrals == null || centrals.length == 0) {
                                throw new UnsupportedOperationException("Fragment consistency error");
                            }
                            anglesOK = true;
                            for (int i = 0; i < centrals.length; ++i) {
                                double angle = V.angle(c[a1], c[centrals[i]], c[a2], c[centrals[i]]);
                                if (!(angle <= 1.0471975511965976)) continue;
                                anglesOK = false;
                            }
                            if (anglesOK && debug != null) {
                                debug.println("ANGLES OK in 1,3: (" + a1 + "-" + a2 + ") d=" + d + " < " + mlimit);
                            }
                        }
                        if (!anglesOK) {
                            ret |= 1;
                            s1soft = a1;
                            s2soft = a2;
                            if (debug != null) {
                                debug.println("Soft px: (" + a1 + "-" + a2 + ") d=" + d + " < " + mlimit);
                            }
                        }
                    }
                } else {
                    boolean blenerr = false;
                    double deslen = mol.getBlen(a1, a2);
                    double deserr = (d - deslen) / deslen;
                    if (deserr > 4.0 || deserr < -0.75 || d < 0.25) {
                        ret |= 8;
                        s1hard = a1;
                        s2hard = a2;
                        blenerr = true;
                        if (debug != null) {
                            debug.println("Hard bl: (" + a1 + "-" + a2 + ") d=" + d + " des=" + deslen + " deserr=" + deserr);
                        }
                    }
                    if (deserr > 0.35 || deserr < -0.2) {
                        ret |= 4;
                        s1soft = a1;
                        s2soft = a2;
                        if (debug != null) {
                            double drlen = this.getEquilibriumBondLength(a1, a2);
                            debug.println("Soft bl: (" + a1 + "-" + a2 + ") d=" + d + " des=" + deslen + " deserr=" + deserr + " drlen=" + drlen);
                        }
                        blenerr = true;
                    }
                }
                if (debug == null) continue;
                if (s1soft != -1) {
                    if (selSoft == null) {
                        selSoft = new IntVector(mol.a);
                    }
                    selSoft.add(s1soft);
                    if (s2soft != -1) {
                        selSoft.add(s2soft);
                    }
                }
                if (s1hard == -1) continue;
                if (selHard == null) {
                    selHard = new IntVector(mol.a);
                }
                selHard.add(s1hard);
                if (s2hard == -1) continue;
                selHard.add(s2soft);
            }
        }
        double rcl = 0.0;
        StringBuffer rcverb = null;
        if (debug != null) {
            rcverb = new StringBuffer();
        }
        if (mol.SSSR != null && mol.SSSR.length > 0) {
            double[][] rcp = new double[mol.SSSR.length][];
            double[] ramr = new double[mol.SSSR.length];
            double[] rbmr = new double[mol.SSSR.length];
            double[] raar = new double[mol.SSSR.length];
            double[] rbar = new double[mol.SSSR.length];
            for (int i = 0; i < mol.SSSR.length; ++i) {
                if (mol.SSSR[i].length > 7) {
                    rcp[i] = null;
                    continue;
                }
                boolean nonstretched = false;
                if (optimized) {
                    nonstretched = true;
                    for (int j = 0; j < mol.SSSR[i].length; ++j) {
                        int ra1 = mol.SSSR[i][j];
                        int ra2 = mol.SSSR[i][(j + 1) % mol.SSSR[i].length];
                        double ebl = this.getEquilibriumBondLength(ra1, ra2);
                        double abl = V.vectLen(c[ra1], c[ra2]);
                        if (!(abl / ebl >= 1.05)) continue;
                        nonstretched = false;
                        break;
                    }
                }
                if (nonstretched) {
                    rcp[i] = null;
                    continue;
                }
                rcp[i] = V.avg(c, mol.SSSR[i]);
                ramr[i] = V.calcRadius(rcp[i], c, mol.SSSR[i], false, false);
                rbmr[i] = V.calcRadius(rcp[i], c, mol.SSSR[i], false, true);
                raar[i] = V.calcRadius(rcp[i], c, mol.SSSR[i], true, false);
                rbar[i] = V.calcRadius(rcp[i], c, mol.SSSR[i], true, true);
            }
            double[][] bcp = new double[mol.b][];
            for (int i = 0; i < mol.b; ++i) {
                bcp[i] = V.avg(c, mol.bat[0][i], mol.bat[1][i]);
            }
            for (int ri = 0; ri < rcp.length; ++ri) {
                if (rcp[ri] == null) continue;
                double ril = M.min(ramr[ri], rbmr[ri], raar[ri], rbar[ri]) * 0.72;
                for (int ai = 0; ai < mol.a; ++ai) {
                    double d;
                    if (U.contains(mol.SSSR[ri], ai) || mol.anum[ai] == 1 && mol.ctab[ai].length == 1 || !((d = V.vectLen(rcp[ri], c[ai])) < ril)) continue;
                    rcl = d;
                    ret |= 0x10;
                    if (rcverb != null) {
                        rcverb.append(" d=" + TextUtils.formatNumber(d) + "<" + TextUtils.formatNumber(ril) + "R: " + U.sel(mol.SSSR[ri]) + " A " + ai + " raar: " + TextUtils.formatNumber(raar[ri]) + " rbar: " + TextUtils.formatNumber(rbar[ri]) + " ramr: " + TextUtils.formatNumber(ramr[ri]) + " rbmr: " + TextUtils.formatNumber(rbmr[ri]) + "\n");
                    }
                    if (debug == null) continue;
                    debug.println("Ring critical error: d=" + d + "<" + ril + " ring: " + U.sel(mol.SSSR[ri]) + " atom: " + ai);
                    if (selSoft == null) {
                        selSoft = new IntVector(mol.a);
                    }
                    selSoft.add(ai);
                }
                for (int bi = 0; bi < bcp.length; ++bi) {
                    double d;
                    if (U.contains(mol.bondToRing[bi], ri)) continue;
                    int bia1 = mol.bat[0][bi];
                    int bia2 = mol.bat[1][bi];
                    if (U.contains(mol.SSSR[ri], bia1) || U.contains(mol.SSSR[ri], bia2) || mol.anum[bia1] == 1 && mol.ctab[bia1].length == 1 || mol.anum[bia2] == 1 && mol.ctab[bia2].length == 1 || !((d = V.vectLen(rcp[ri], bcp[bi])) < ril)) continue;
                    ret |= 0x10;
                    rcl = d;
                    if (rcverb != null) {
                        rcverb.append(" d=" + TextUtils.formatNumber(d) + "<" + TextUtils.formatNumber(ril) + "R: " + U.sel(mol.SSSR[ri]) + " B: " + bia1 + "-" + bia2 + " raar: " + TextUtils.formatNumber(raar[ri]) + " rbar: " + TextUtils.formatNumber(rbar[ri]) + " ramr: " + TextUtils.formatNumber(ramr[ri]) + " rbmr: " + TextUtils.formatNumber(rbmr[ri]) + "\n");
                    }
                    if (debug == null) continue;
                    debug.println("Ring critical error: d=" + d + "<" + ril + " ring: " + U.sel(mol.SSSR[ri]) + " bond: " + mol.bat[0][bi] + "-" + mol.bat[1][bi]);
                    if (selSoft == null) {
                        selSoft = new IntVector(mol.a);
                    }
                    selSoft.add(mol.bat[0][bi]);
                    selSoft.add(mol.bat[1][bi]);
                }
            }
        }
        if (CleanArgs.doVerbose() && (ret & 0x10) != 0 && rcverb != null) {
            CleanArgs.verbose(rcverb.toString());
        }
        Object origsmi = null;
        if ((ret & 0x10) != 0) {
            // empty if block
        }
        if (ret == 16) {
            // empty if block
        }
        if (debug != null) {
            debug.Tstart();
            debug.Trow();
            debug.TprintBC("Structure");
            debug.TprintBC("Soft errors");
            debug.TprintBC("Hard errors");
            debug.Trow();
            debug.print("<TD>");
            if (ret == 0) {
                mol.place3DApplet("Structure", c);
            } else {
                mol.place3DApplets("Structure (soft/hard)", new double[][][]{c, c}, new String[]{U.sel(selSoft == null ? null : selSoft.toArray()), selHard == null ? null : U.sel(selHard.toArray())});
            }
            debug.print("</TD>");
            String s = (ret & 4) != 0 ? "BLEN " : "";
            s = s + ((ret & 1) != 0 ? "PROXIMITY" : "-");
            if ((ret & 0x40) != 0) {
                s = s + " (+Deformed SP3)";
            }
            debug.Tprint(s);
            s = (ret & 8) != 0 ? "BLEN " : "";
            s = s + ((ret & 2) != 0 ? "PROXIMITY" : "-");
            s = s + ((ret & 0x10) != 0 ? "RINGCRITICAL" : "-");
            debug.Tprint(s);
            debug.Tstop();
        }
        return ret;
    }
}

