/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.calculations.clean.Optimization;
import chemaxon.marvin.modelling.struc.Multiconformer;
import chemaxon.marvin.modelling.util.U;
import java.util.Vector;

public class MultiConformerImpl
implements Multiconformer {
    private double[][][] coordinates = null;
    private double[] energies = null;

    @Override
    public double[][] getCoordinates(int confid) {
        return this.coordinates[confid];
    }

    @Override
    public double[][][] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public double[] getEnergies() {
        return this.energies;
    }

    @Override
    public void removeConformer(int confid) {
        if (this.getConfCount() == 1) {
            this.coordinates = null;
            this.energies = null;
            return;
        }
        double[][][] newc = new double[this.getConfCount() - 1][][];
        double[] newe = null;
        if (this.energies != null) {
            newe = new double[newc.length];
        }
        int j = 0;
        for (int i = 0; i < this.getConfCount(); ++i) {
            if (i == confid) {
                ++i;
            }
            newc[j] = this.getCoordinates(i);
            if (this.energies != null) {
                newe[j] = this.energies[i];
            }
            ++j;
        }
        this.coordinates = newc;
        this.energies = newe;
    }

    @Override
    public void applyConfPerm(int[] confperm) {
        if (confperm == null) {
            this.coordinates = null;
            this.energies = null;
            return;
        }
        double[][][] newc = new double[confperm.length][][];
        for (int i = 0; i < confperm.length; ++i) {
            newc[i] = this.coordinates[confperm[i]];
        }
        this.coordinates = newc;
        if (this.energies != null) {
            double[] newe = new double[confperm.length];
            for (int i = 0; i < confperm.length; ++i) {
                newe[i] = this.energies[confperm[i]];
            }
            this.energies = newe;
        }
    }

    public void sortByEnergy() {
        if (this.coordinates == null) {
            return;
        }
        if (this.energies == null || this.coordinates.length != this.energies.length) {
            String s = null;
            s = this.energies == null ? "Energies==null" : "Coordinate (" + this.coordinates.length + ") and energies (" + this.energies.length + ") count mismatch.";
            throw new IndexOutOfBoundsException(s);
        }
        final int[] perm = U.gen(this.getConfCount());
        final double[] e = this.getEnergies();
        Optimization.quickSort(0, perm.length - 1, new Optimization.Sortable(){

            @Override
            public boolean isGreater(int i, int j) {
                return e[perm[i]] > e[perm[j]];
            }

            @Override
            public void swap(int i, int j) {
                int tmp = perm[i];
                perm[i] = perm[j];
                perm[j] = tmp;
            }
        });
        this.applyConfPerm(perm);
    }

    public void concatConformers(Vector v) {
        int i;
        if (v == null) {
            return;
        }
        int newconfct = v.size();
        if (this.coordinates != null) {
            newconfct += this.coordinates.length;
        }
        double[][][] newc = new double[newconfct][][];
        int j = 0;
        if (this.coordinates != null) {
            for (i = 0; i < this.coordinates.length; ++i) {
                newc[j++] = this.coordinates[i];
            }
        }
        for (i = 0; i < v.size(); ++i) {
            newc[j++] = (double[][])v.get(i);
        }
        this.coordinates = newc;
        this.energies = null;
    }

    @Override
    public void setCoordinates(double[][][] coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public void setEnergies(double[] energies) {
        this.energies = energies;
    }

    @Override
    public int getAtomCount() {
        return this.coordinates[0].length;
    }

    @Override
    public int getConfCount() {
        if (this.coordinates == null) {
            return 0;
        }
        return this.coordinates.length;
    }
}

