/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.build.fafuse.WishListItem;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.util.U;
import java.util.Vector;

public class StereoCriteriaItem {
    public static final int T_CT_CIS = 1;
    public static final int T_CT_TRANS = 2;
    public static final int T_P_EVEN = 3;
    public static final int T_P_ODD = 4;
    int type = -1;
    int[] atoms = null;

    public StereoCriteriaItem cloneWithPermutation(int[] pt, int[] newGrinv, int[][] newCtab, debugPrintout debug) {
        StereoCriteriaItem ret = new StereoCriteriaItem();
        ret.type = this.type;
        ret.atoms = new int[this.atoms.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            int a = this.atoms[i];
            ret.atoms[i] = a >= pt.length || a < 0 ? -1 : pt[a];
        }
        boolean canC = ret.canCheck(new StereoCriteriaList.coordinateQuery(){

            @Override
            public double[] get(int i) {
                return null;
            }

            @Override
            public boolean isPlaced(int i) {
                return true;
            }
        }, null);
        if (debug != null) {
            debug.printB("Clone item with permutation");
            debug.println("Atom projection: " + U.sel(pt));
            debug.println("New grinv: " + U.sel(newGrinv));
            debug.println("This:");
            this.printout(debug);
            debug.println("Return candidate:");
            ret.printout(debug);
            debug.println("Can be checked: " + canC);
        }
        if (canC && newGrinv != null) {
            canC = ret.canCheck(newGrinv, newCtab, debug);
        }
        if (!canC) {
            return null;
        }
        return ret;
    }

    public StereoCriteriaItem() {
    }

    public int getCenterAtom() {
        if (this.type != 3 && this.type != 4) {
            return -1;
        }
        return this.atoms[0];
    }

    public boolean isTypeParity() {
        return this.type == 3 || this.type == 4;
    }

    public int[] getInvolvedAtoms() {
        int n = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i] < 0) continue;
            ++n;
        }
        int[] ret = new int[n];
        n = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i] < 0) continue;
            ret[n++] = this.atoms[i];
        }
        return ret;
    }

    public StereoCriteriaItem(int a0, int a1, int a2, int a3, int t) {
        this.atoms = new int[4];
        this.atoms[0] = a0;
        this.atoms[1] = a1;
        this.atoms[2] = a2;
        this.atoms[3] = a3;
        this.type = t;
    }

    public StereoCriteriaItem(int a0, int[] nlis, boolean[] isH, int t) {
        this.atoms = new int[5];
        this.atoms[0] = a0;
        this.atoms[1] = nlis.length > 0 ? nlis[0] : -1;
        this.atoms[2] = nlis.length > 1 ? nlis[1] : -1;
        this.atoms[3] = nlis.length > 2 ? nlis[2] : -1;
        this.atoms[4] = nlis.length > 3 ? nlis[3] : -1;
        boolean[] isH2 = new boolean[5];
        for (int i = 0; i < 4 && i < isH.length; ++i) {
            isH2[i + 1] = isH[i];
        }
        int e = 4;
        boolean swap = true;
        while (swap) {
            swap = false;
            for (int i = 1; i < e; ++i) {
                if (!(isH2[i] && !isH2[i + 1] || isH2[i] == isH2[i + 1] && this.atoms[i] != -1 && this.atoms[i + 1] != -1 && this.atoms[i] > this.atoms[i + 1]) && (isH2[i] != isH2[i + 1] || this.atoms[i] != -1 || this.atoms[i + 1] == -1)) continue;
                swap = true;
                int j = this.atoms[i];
                this.atoms[i] = this.atoms[i + 1];
                this.atoms[i + 1] = j;
                boolean b = isH2[i];
                isH2[i] = isH2[i + 1];
                isH2[i + 1] = b;
            }
            --e;
        }
        this.type = t;
    }

    public boolean isInvolved(int n) {
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean canCheck(int[] grinv, int[][] ctab, debugPrintout debug) {
        switch (this.type) {
            case 1: 
            case 2: {
                if (grinv == null && ctab == null) break;
                if (ctab[this.atoms[1]].length > 3 || ctab[this.atoms[2]].length > 3) {
                    throw new UnsupportedOperationException("Inconsystent CT criteria error. A0=" + this.atoms[0] + " A3=" + this.atoms[3] + " L(" + this.atoms[1] + ")=" + ctab[this.atoms[1]].length + " L(" + this.atoms[2] + ")=" + ctab[this.atoms[2]].length);
                }
                for (int i = 1; i <= 2; ++i) {
                    int j = 3 - i;
                    int ng = -1;
                    boolean cf = false;
                    for (int k = 0; k < ctab[this.atoms[i]].length; ++k) {
                        if (ctab[this.atoms[i]][k] == this.atoms[j]) {
                            if (cf) {
                                throw new UnsupportedOperationException("Inconsystent CT criteria error.");
                            }
                            cf = true;
                            continue;
                        }
                        int g = grinv[ctab[this.atoms[i]][k]];
                        if (ng == -1) {
                            ng = g;
                            continue;
                        }
                        if (ng != g) continue;
                        return false;
                    }
                }
                break;
            }
            case 3: 
            case 4: {
                if (debug != null) {
                    debug.println("can check?: Parity grinv: " + U.sel(grinv));
                }
                for (int i = 0; i < 4; ++i) {
                    if (this.atoms[i + 1] == -1 || this.atoms[i] == -1) continue;
                    int gri = grinv[this.atoms[i]];
                    int ct = 0;
                    for (int j = 1; j < 5; ++j) {
                        if (this.atoms[j] == -1 || grinv[this.atoms[j]] != gri) continue;
                        ++ct;
                    }
                    if (ct <= true) continue;
                    if (debug != null) {
                        debug.println("ct=" + ct + " gri=" + gri + " ca not check.");
                    }
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public boolean canCheck(StereoCriteriaList.coordinateQuery q, debugPrintout debug) {
        switch (this.type) {
            case 1: 
            case 2: {
                if (debug != null) {
                    debug.println("can check?: Cis/Trans");
                }
                for (int i = 0; i < 4; ++i) {
                    if (this.atoms[i] != -1 && q.isPlaced(this.atoms[i])) continue;
                    return false;
                }
                return true;
            }
            case 3: 
            case 4: {
                if (debug != null) {
                    debug.println("can check?: Parity");
                }
                int n = 0;
                for (int i = 0; i < 5; ++i) {
                    if (this.atoms[i] == -1 || !q.isPlaced(this.atoms[i])) continue;
                    ++n;
                }
                return n >= 4;
            }
        }
        return false;
    }

    public int addPhantomAtomDescriptors(StereoCriteriaList.coordinateQuery q, Vector pal, debugPrintout debug) {
        if (debug != null) {
            debug.println("Add phantom atom for this criterion", false, this.toString());
        }
        switch (this.type) {
            case 1: 
            case 2: {
                if (debug != null) {
                    debug.println("Cis/Trans criterion, no phantom");
                }
                return 0;
            }
            case 3: 
            case 4: {
                if (debug != null) {
                    debug.println("Parity");
                }
                if (this.atoms[0] == -1 || !q.isPlaced(this.atoms[0])) {
                    if (debug != null) {
                        debug.println("Central atom implicit or nonplaced");
                    }
                    return 0;
                }
                int n = 0;
                int m = -1;
                for (int i = 1; i < 5; ++i) {
                    if (this.atoms[i] != -1 && q.isPlaced(this.atoms[i])) {
                        ++n;
                        continue;
                    }
                    m = i;
                }
                if (debug != null) {
                    debug.println("Nonplaced: n=" + n + " index: m=" + m);
                }
                if (n != 3) {
                    if (debug != null) {
                        debug.println("No 3 missing");
                    }
                    return 0;
                }
                StereoCriteriaList.PhantomAtomDescriptor pad = new StereoCriteriaList.PhantomAtomDescriptor(new double[3], this.atoms[0]);
                pad.type = this.type;
                pad.il = new int[3];
                switch (m) {
                    case 1: {
                        pad.il[0] = this.atoms[2];
                        pad.il[1] = this.atoms[4];
                        pad.il[2] = this.atoms[3];
                        break;
                    }
                    case 2: {
                        pad.il[0] = this.atoms[1];
                        pad.il[1] = this.atoms[3];
                        pad.il[2] = this.atoms[4];
                        break;
                    }
                    case 3: {
                        pad.il[0] = this.atoms[1];
                        pad.il[1] = this.atoms[4];
                        pad.il[2] = this.atoms[2];
                        break;
                    }
                    case 4: {
                        pad.il[0] = this.atoms[1];
                        pad.il[1] = this.atoms[2];
                        pad.il[2] = this.atoms[3];
                    }
                }
                if (this.type == 3) {
                    int tmp = pad.il[1];
                    pad.il[1] = pad.il[2];
                    pad.il[2] = tmp;
                }
                pal.add(pad);
                if (debug == null) break;
                debug.println("Added item:");
                pad.printout(debug);
                debug.println("Bonded atom: " + this.atoms[0]);
            }
        }
        return -1;
    }

    public static void refreshPhantomAtom(StereoCriteriaList.coordinateQuery q, StereoCriteriaList.PhantomAtomDescriptor pad, debugPrintout debug) {
        if (debug != null) {
            debug.println("Update phantom atom coordinates");
        }
        switch (pad.type) {
            case 1: 
            case 2: {
                if (debug != null) {
                    debug.println("Cis/Trans criterion, no phantom");
                }
                return;
            }
            case 3: 
            case 4: {
                if (debug != null) {
                    debug.println("Parity");
                }
                double[] cc = q.get(pad.ba);
                double[] c1 = q.get(pad.il[0]);
                double[] c2 = q.get(pad.il[1]);
                double[] c3 = q.get(pad.il[2]);
                double[] l4v = V.vectProd(V.minus(c2, c1), V.minus(c3, c1));
                double l = V.dot(l4v);
                if (l < 1.0E-4) {
                    System.err.println("Error in phantom atoms: 0 l4v ");
                    l = 1.0;
                }
                pad.coord = V.plus(cc, V.dot(1.09 / Math.sqrt(l), l4v));
                return;
            }
        }
    }

    public boolean check(StereoCriteriaList.coordinateQuery getc, debugPrintout debug) {
        switch (this.type) {
            case 1: 
            case 2: {
                double[][] coord = new double[][]{getc.get(this.atoms[0]), getc.get(this.atoms[1]), getc.get(this.atoms[2]), getc.get(this.atoms[3])};
                return this.check(coord, false, debug);
            }
            case 3: 
            case 4: {
                double[][] coord = new double[5][];
                for (int i = 0; i < 5; ++i) {
                    coord[i] = (double[])(this.atoms[i] == -1 ? null : getc.get(this.atoms[i]));
                }
                return this.check(coord, false, debug);
            }
        }
        throw new UnsupportedOperationException("Unknown stereo type");
    }

    public boolean check(double[][] coord, boolean doProject, debugPrintout debug) {
        if (debug != null) {
            debug.println("Check criteria:");
            this.printout(debug);
        }
        switch (this.type) {
            case 1: 
            case 2: {
                if (debug != null) {
                    debug.println("Cis/Trans");
                }
                double[] c0 = doProject ? coord[this.atoms[0]] : coord[0];
                double[] c1 = doProject ? coord[this.atoms[1]] : coord[1];
                double[] c2 = doProject ? coord[this.atoms[2]] : coord[2];
                double[] c3 = doProject ? coord[this.atoms[3]] : coord[3];
                double f = WishListItem.calcDihedralAngle(c0, c1, c2, c3);
                if (debug != null) {
                    debug.println("Angle: " + f);
                }
                if (this.type == 1) {
                    return Math.abs(f) < 90.0;
                }
                if (this.type != 2) break;
                return Math.abs(180.0 - Math.abs(f)) < 90.0;
            }
            case 3: 
            case 4: {
                int j;
                int i;
                int m = -1;
                double[][] c = new double[5][];
                for (i = 0; i < 5; ++i) {
                    c[i] = doProject ? (this.atoms[i] == -1 ? null : coord[this.atoms[i]]) : coord[i];
                    if (c[i] != null) continue;
                    if (m != -1) {
                        System.err.println("Parity check consystency error!");
                    }
                    m = i;
                }
                if (m == 0) {
                    c[0] = new double[3];
                    i = 0;
                    while (i < 3) {
                        for (j = 1; j < 5; ++j) {
                            double[] dArray = c[0];
                            int n = i;
                            dArray[n] = dArray[n] + c[j][i];
                        }
                        double[] dArray = c[0];
                        int n = i++;
                        dArray[n] = dArray[n] / 4.0;
                    }
                }
                if (m > 0) {
                    c[m] = new double[3];
                    for (i = 0; i < 3; ++i) {
                        for (j = 1; j < 5; ++j) {
                            if (j == m) continue;
                            double[] dArray = c[m];
                            int n = i;
                            dArray[n] = dArray[n] + c[j][i];
                        }
                    }
                    V.dotWriteBackToA(0.3333333333333333, c[m]);
                    double[] bv = V.minus(c[0], c[m]);
                    V.normalizeSafe(bv);
                    V.dotWriteBackToA(1.5, bv);
                    V.copyV(c[m], V.plus(c[0], bv));
                }
                if (V.isSP3Deformed(c[0], c[1], c[2], c[3], c[4])) {
                    if (CleanArgs.doVerbose()) {
                        CleanArgs.verbose("SP3Deformed!");
                    }
                    return false;
                }
                double[] v12 = V.minus(c[2], c[1]);
                double[] v13 = V.minus(c[3], c[1]);
                double[] v04 = V.minus(c[4], c[0]);
                double s = V.dot(v04, V.vectProd(v12, v13));
                if (debug != null) {
                    debug.println("Actual parity: " + (s > 0.0 ? "ODD" : (s < 0.0 ? "EVEN" : "zero!")));
                }
                if (this.type == 4) {
                    return s > 0.0;
                }
                if (this.type != 3) break;
                return s < 0.0;
            }
        }
        throw new UnsupportedOperationException("Unknown stereo type");
    }

    private String getTypeString() {
        String typestring = "?";
        switch (this.type) {
            case 1: {
                typestring = "CIS";
                break;
            }
            case 2: {
                typestring = "TRANS";
                break;
            }
            case 3: {
                typestring = "EVEN";
                break;
            }
            case 4: {
                typestring = "ODD";
            }
        }
        return typestring;
    }

    public void printout(debugPrintout debug) {
        debug.Tstart();
        debug.Trow();
        debug.TprintBC("Type:");
        debug.Tprint(this.atoms.length, this.getTypeString());
        debug.Trow();
        debug.TprintBC("Atoms:");
        for (int i = 0; i < this.atoms.length; ++i) {
            debug.Tprint("" + this.atoms[i]);
        }
        debug.Tstop();
    }

    public String toString() {
        String ret = this.getTypeString() + " (";
        for (int i = 0; i < this.atoms.length; ++i) {
            ret = ret + (i != 0 ? "," : "") + this.atoms[i];
        }
        ret = ret + ")";
        return ret;
    }
}

