/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.calculations.clean.Opt3D;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.build.fafuse.WishListItem;
import chemaxon.marvin.modelling.debug.CleanDebug;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.Tracer;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintHTML;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.WishGroup;
import chemaxon.marvin.modelling.struc.myMoleculeConstants;
import chemaxon.marvin.modelling.util.Stopper;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.modelling.util.myList;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Vector;

public class myMolecule
implements Opt3D.MolCT {
    public SelectionMolecule originalM = null;
    Stopper aromaTimer = null;
    Molecule originalM_2Dcleaned_copy = null;
    Molecule originalM_copy = null;
    String saved2Dmolfilename = null;
    transient CallbackIface get2Dcb = null;
    transient CallbackIface get2DcbFname = null;
    public int a = 0;
    public int[] anum = null;
    public int[] atomFlag = null;
    public double[][] coord = null;
    public int[] grinv = null;
    public int chainCenterCandidate = -1;
    public int b = 0;
    public int[] bdesc = null;
    public int[][] bat = null;
    public double[] blen = null;
    public int[][] ctab = null;
    public int[][] blist = null;
    public int[][] bonds = null;
    public double[][] forcedAngleValue = null;
    public int[][] forcedAngleA0 = null;
    public int[][] forcedAngleA2 = null;
    public int[][] ligandPermutation = null;
    private int[][] cssr = null;
    public int[][] SSSR = null;
    public int[] ringflags = null;
    public int[][] ringSet = null;
    public int[] rings = null;
    public int[][] atomToRing = null;
    public int[][] atomToRingNextP = null;
    public int[][] atomToRingPrevP = null;
    public int[][] bondToRing = null;
    int[] atomProjection = null;
    double[][] atomLocalCoordinateScratch = null;
    double[] atomCoordinateScratch = null;
    int[] atomNumberScratch = null;
    double[][] localDerivateScratch = null;
    int[] D_anum = null;
    int[] D_batom1 = null;
    int[] D_batom2 = null;
    public int[] D_bondOrders = null;
    public int[][] D_CTAB = null;
    public int[][] D_Blist = null;
    public int[][] D_BOlist = null;
    public static final int BONDORDER_SINGLE = 2;
    public static final int BONDORDER_DOUBLE = 4;
    public static final int BONDORDER_TRIPLE = 6;
    public static final int BONDORDER_AROMATIC = 3;
    private WishGroup wg = null;
    private ForceField ff = null;
    double[][] coordinatesFromOrig = null;

    @Override
    public int[] getAtomNumberScratch() {
        if (this.atomNumberScratch == null) {
            this.atomNumberScratch = new int[4];
        }
        return this.atomNumberScratch;
    }

    double[] getCoordinates(int i) {
        return this.coord[i];
    }

    void invalidateDreiding() {
        this.D_anum = null;
        this.D_batom1 = null;
        this.D_batom2 = null;
        this.D_bondOrders = null;
        this.D_CTAB = null;
        this.D_Blist = null;
        this.D_BOlist = null;
    }

    public void fillDreidingDescriptors() {
        int i;
        this.D_anum = this.anum;
        this.D_batom1 = this.bat[0];
        this.D_batom2 = this.bat[1];
        this.D_bondOrders = new int[this.b];
        for (i = 0; i < this.b; ++i) {
            this.D_bondOrders[i] = this.getBondOrder(i);
        }
        this.D_CTAB = this.ctab;
        this.D_Blist = this.blist;
        this.D_BOlist = new int[this.ctab.length][];
        for (i = 0; i < this.ctab.length; ++i) {
            this.D_BOlist[i] = new int[this.ctab[i].length];
            for (int j = 0; j < this.ctab[i].length; ++j) {
                this.D_BOlist[i][j] = this.D_bondOrders[this.D_Blist[i][j]];
            }
        }
    }

    @Override
    public void askLocalCoordinates(int n) {
        if (this.atomNumberScratch != null && this.atomLocalCoordinateScratch != null) {
            for (int i = 0; i < n && i < this.atomNumberScratch.length && i < this.atomLocalCoordinateScratch.length; ++i) {
                double[] v = this.getCoordinates(this.atomNumberScratch[i]);
                for (int j = 0; j < 3; ++j) {
                    this.atomLocalCoordinateScratch[i][j] = v[j];
                }
            }
        }
    }

    @Override
    public void askCoordinates(int i) {
        if (this.atomNumberScratch != null && this.atomLocalCoordinateScratch != null) {
            double[] v = this.getCoordinates(i);
            for (int j = 0; j < 3; ++j) {
                this.atomCoordinateScratch[j] = v[j];
            }
        }
    }

    @Override
    public void setCoordinates(int i) {
        if (this.atomNumberScratch != null && this.atomLocalCoordinateScratch != null) {
            double[] v = this.getCoordinates(i);
            for (int j = 0; j < 3; ++j) {
                v[j] = this.atomCoordinateScratch[j];
            }
        }
    }

    @Override
    public void derivateUpdatedNotification() {
    }

    @Override
    public double[][] getAtomLocalCoordinateScratch() {
        if (this.atomLocalCoordinateScratch == null) {
            this.atomLocalCoordinateScratch = new double[4][3];
        }
        return this.atomLocalCoordinateScratch;
    }

    @Override
    public double[] getAtomCoordinateScratch() {
        if (this.atomCoordinateScratch == null) {
            this.atomCoordinateScratch = new double[3];
        }
        return this.atomCoordinateScratch;
    }

    @Override
    public int[] getAtomNumbers() {
        if (this.D_anum == null) {
            this.fillDreidingDescriptors();
        }
        return this.D_anum;
    }

    @Override
    public int[] getBAtom1() {
        if (this.D_batom1 == null) {
            this.fillDreidingDescriptors();
        }
        return this.D_batom1;
    }

    @Override
    public int[] getBAtom2() {
        if (this.D_batom2 == null) {
            this.fillDreidingDescriptors();
        }
        return this.D_batom2;
    }

    public int getBondOrder(int b) {
        if (b < this.b) {
            if (myMolecule.isSet(this.bdesc[b], 8)) {
                return 3;
            }
            if (myMolecule.isSet(this.bdesc[b], 2)) {
                return 4;
            }
            if (myMolecule.isSet(this.bdesc[b], 4)) {
                return 6;
            }
            return 2;
        }
        return 2;
    }

    @Override
    public int[] getBondOrders() {
        if (this.D_bondOrders == null) {
            this.fillDreidingDescriptors();
        }
        return this.D_bondOrders;
    }

    @Override
    public int getBond(int a1, int a2) {
        if (this.D_CTAB == null) {
            this.fillDreidingDescriptors();
        }
        for (int i = 0; i < this.D_CTAB[a1].length; ++i) {
            if (this.D_CTAB[a1][i] != a2) continue;
            return this.D_Blist[a1][i];
        }
        return -1;
    }

    @Override
    public int[][] getCtab() {
        if (this.D_CTAB == null) {
            this.fillDreidingDescriptors();
        }
        return this.D_CTAB;
    }

    @Override
    public int[][] getBList() {
        if (this.D_Blist == null) {
            this.fillDreidingDescriptors();
        }
        return this.D_Blist;
    }

    @Override
    public int[][] getBOlist() {
        if (this.D_BOlist == null) {
            this.fillDreidingDescriptors();
        }
        return this.D_BOlist;
    }

    @Override
    public double[][] getLocalDerivateScratch() {
        if (this.localDerivateScratch == null) {
            this.localDerivateScratch = new double[4][3];
        }
        return this.localDerivateScratch;
    }

    public double getBlen(int a0, int a1) {
        if (this.bonds[a0][a1] == -1) {
            return -1.0;
        }
        return this.blen[this.bonds[a0][a1]];
    }

    public int getLigands(int a0) {
        return this.blist[a0].length;
    }

    public int getLigandNumber(int a0, int a1) {
        int ret = -1;
        if (this.ligandPermutation != null && this.ligandPermutation[a0] != null) {
            for (int i = 0; i < this.ctab[a0].length; ++i) {
                if (this.ctab[a0][this.ligandPermutation[a0][i]] != a1) continue;
                ret = i;
                break;
            }
        } else {
            for (int i = 0; i < this.ctab[a0].length; ++i) {
                if (this.ctab[a0][i] != a1) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    public int getSSpUnusedBase() {
        return 65536;
    }

    public int getSSp2DMask() {
        return 65280;
    }

    public int getSSp2DBase() {
        return 256;
    }

    public int getSSp1DMask() {
        return 255;
    }

    public int calculateOverlap(int i1, int i2, int mask) {
        int ret = 0;
        for (i1 = i1 & i2 & mask; i1 != 0; i1 >>>= 1) {
            if ((i1 & 1) == 0) continue;
            ++ret;
        }
        return ret;
    }

    public int[][] getHOPPermutations(int c) {
        switch (c) {
            case 256: {
                return new int[][]{{0, 1, 2, 3, 4}, {0, 2, 1, 3, 4}, {0, 3, 1, 2, 4}, {0, 4, 1, 2, 3}, {1, 2, 0, 3, 4}, {1, 3, 0, 2, 4}, {1, 4, 0, 2, 3}, {2, 3, 0, 1, 4}, {2, 4, 0, 1, 3}, {3, 4, 0, 1, 2}};
            }
            case 512: {
                return new int[][]{{0, 1, 2, 3, 4, 5}, {0, 1, 2, 4, 3, 5}, {0, 1, 2, 5, 3, 4}, {0, 2, 1, 3, 4, 5}, {0, 2, 1, 4, 3, 5}, {0, 2, 1, 5, 3, 4}, {0, 3, 1, 2, 4, 5}, {0, 3, 1, 4, 2, 5}, {0, 3, 1, 5, 2, 4}, {0, 4, 1, 2, 3, 5}, {0, 4, 1, 3, 2, 5}, {0, 4, 1, 5, 2, 3}, {0, 5, 1, 2, 3, 4}, {0, 5, 1, 3, 2, 4}, {0, 5, 1, 4, 2, 3}};
            }
            case 1024: {
                return null;
            }
        }
        return null;
    }

    public int getSSpInfo(int a0, int a1) {
        int a1n = this.getLigandNumber(a0, a1);
        int ligCfg = this.atomFlag[a0] & 0xF80;
        int base2D = this.getSSp2DBase();
        switch (ligCfg) {
            case 128: {
                return base2D * (1 << a1n);
            }
            case 256: {
                return base2D * (a1n <= 1 ? 0 : 1) + (a1n <= 1 ? 1 : 0);
            }
            case 512: {
                return 1 << (a1n >>> 1);
            }
            case 1024: {
                return 1 << (a1n & 3 ^ ((a1n & 4) == 0 ? 0 : 3));
            }
            case 2048: {
                int info1D = 1 << (a1n <= 5 ? a1n : 11 - a1n);
                int r0 = base2D * 1;
                int r1 = base2D * 2;
                int r2 = base2D * 4;
                int r3 = base2D * 8;
                switch (a1n) {
                    case 0: {
                        return r0 + r2 + info1D;
                    }
                    case 1: {
                        return r0 + r1 + info1D;
                    }
                    case 2: {
                        return r1 + r2 + info1D;
                    }
                    case 3: {
                        return r2 + r3 + info1D;
                    }
                    case 4: {
                        return r1 + r3 + info1D;
                    }
                    case 5: {
                        return r0 + r3 + info1D;
                    }
                    case 6: {
                        return r0 + r3 + info1D;
                    }
                    case 7: {
                        return r1 + r3 + info1D;
                    }
                    case 8: {
                        return r2 + r3 + info1D;
                    }
                    case 9: {
                        return r1 + r2 + info1D;
                    }
                    case 10: {
                        return r0 + r1 + info1D;
                    }
                    case 11: {
                        return r0 + r2 + info1D;
                    }
                }
            }
        }
        return 0;
    }

    public double getBangl(int a0, int a1, int a2) {
        return this.getBangl(a0, a1, a2, null);
    }

    public double getBangl(int a0, int a1, int a2, StereoCriteriaList.coordinateQuery q) {
        int i;
        debugPrintout debug = null;
        if (CleanArgs.cltracer != null && CleanArgs.cltracer.getExtensiveDebug()) {
            debug = CleanArgs.cltracer.getDebug();
        }
        if (debug != null) {
            debug.printB("Bond angle");
            debug.println("a0-a1-a2: " + a0 + " " + a1 + " " + a2);
        }
        if (this.forcedAngleValue != null && this.forcedAngleValue[a1] != null) {
            int t_a0 = a0;
            int t_a2 = a2;
            if (a0 > a2) {
                t_a0 = a2;
                t_a2 = a0;
            }
            for (int i2 = 0; i2 < this.forcedAngleValue[a1].length; ++i2) {
                if (this.forcedAngleA0[a1][i2] != t_a0 || this.forcedAngleA2[a1][i2] != t_a2) continue;
                if (debug != null) {
                    debug.println("Forced angle=" + this.forcedAngleValue[a1][i2]);
                }
                return this.forcedAngleValue[a1][i2];
            }
        }
        if (this.bonds == null || this.rings == null || this.SSSR == null) {
            return -1.0;
        }
        boolean ar_0_1 = myMolecule.isSet(this.bdesc[this.bonds[a0][a1]], 8);
        boolean ar_1_2 = myMolecule.isSet(this.bdesc[this.bonds[a1][a2]], 8);
        boolean rrr1 = (this.atomFlag[a1] & 0x3000) == 8192;
        ar_0_1 = rrr1 && ar_0_1 && (this.atomFlag[a0] & 0x3000) == 8192;
        boolean bl = ar_1_2 = rrr1 && ar_1_2 && (this.atomFlag[a2] & 0x3000) == 8192;
        if (ar_0_1 && ar_1_2) {
            int r2size;
            int ra2;
            int ra1;
            int r1size;
            int ra12;
            int r1;
            int ra0;
            if (debug != null) {
                debug.println("Aromatic rings");
            }
            int scr = -1;
            int scrsize = 0;
            for (int ra02 = 0; ra02 < this.rings[a0]; ++ra02) {
                int r0 = this.atomToRing[a0][ra02];
                if ((this.ringflags[r0] & myMoleculeConstants.R_AROMATIC) == 0) continue;
                for (int ra13 = 0; ra13 < this.rings[a1]; ++ra13) {
                    int r12 = this.atomToRing[a1][ra13];
                    if (r12 != r0) continue;
                    for (int ra22 = 0; ra22 < this.rings[a2]; ++ra22) {
                        int r2 = this.atomToRing[a2][ra22];
                        if (r2 != r0) continue;
                        int r0size = this.SSSR[r0].length;
                        if (scr != -1 && r0size >= scrsize) continue;
                        scr = r0;
                        scrsize = r0size;
                    }
                }
            }
            if (debug != null) {
                debug.println("Smallest common ring ID=" + scr + " size=" + scrsize);
            }
            if (scr != -1) {
                return 180 - 360 / scrsize;
            }
            int sr1 = -1;
            int sr1size = 0;
            int sr2 = -1;
            int sr2size = 0;
            for (ra0 = 0; ra0 < this.rings[a0]; ++ra0) {
                r1 = this.atomToRing[a0][ra0];
                if ((this.ringflags[r1] & myMoleculeConstants.R_AROMATIC) == 0) continue;
                for (ra12 = 0; ra12 < this.rings[a1]; ++ra12) {
                    if (r1 != this.atomToRing[a1][ra12]) continue;
                    r1size = this.SSSR[r1].length;
                    if (sr1 != -1 && sr1size <= r1size) continue;
                    sr1 = r1;
                    sr1size = r1size;
                }
            }
            if (sr1size == 0) {
                for (ra0 = 0; ra0 < this.rings[a0]; ++ra0) {
                    r1 = this.atomToRing[a0][ra0];
                    for (ra12 = 0; ra12 < this.rings[a1]; ++ra12) {
                        if (r1 != this.atomToRing[a1][ra12]) continue;
                        r1size = this.SSSR[r1].length;
                        if (sr1 != -1 && sr1size <= r1size) continue;
                        sr1 = r1;
                        sr1size = r1size;
                    }
                }
            }
            for (ra1 = 0; ra1 < this.rings[a1]; ++ra1) {
                r1 = this.atomToRing[a1][ra1];
                if ((this.ringflags[r1] & myMoleculeConstants.R_AROMATIC) == 0) continue;
                for (ra2 = 0; ra2 < this.rings[a2]; ++ra2) {
                    if (r1 != this.atomToRing[a2][ra2]) continue;
                    r2size = this.SSSR[r1].length;
                    if (sr2 != -1 && sr2size <= r2size) continue;
                    sr2 = r1;
                    sr2size = r2size;
                }
            }
            if (sr2size == 0) {
                for (ra1 = 0; ra1 < this.rings[a1]; ++ra1) {
                    r1 = this.atomToRing[a1][ra1];
                    for (ra2 = 0; ra2 < this.rings[a2]; ++ra2) {
                        if (r1 != this.atomToRing[a2][ra2]) continue;
                        r2size = this.SSSR[r1].length;
                        if (sr2 != -1 && sr2size <= r2size) continue;
                        sr2 = r1;
                        sr2size = r2size;
                    }
                }
            }
            if (sr1size == 0) {
                sr1size = 6;
            }
            if (sr2size == 0) {
                sr2size = 6;
            }
            return 360 / sr1size + 360 / sr2size;
        }
        int ligCfg = this.atomFlag[a1] & 0xF80;
        int ligands = this.getLigands(a1);
        int l0 = -1;
        int l2 = -1;
        if (ligands > 4) {
            l0 = this.getLigandNumber(a1, a0);
            l2 = this.getLigandNumber(a1, a2);
            if (l2 < l0) {
                i = l0;
                l0 = l2;
                l2 = i;
            }
        }
        if (debug != null) {
            debug.println("Angle based on ligCfg=" + ligCfg);
        }
        switch (ligCfg) {
            case 128: {
                if ((this.atomFlag[a1] & 0x10) != 0 || ligands == 4) {
                    return 109.47122;
                }
                if ((this.atomFlag[a1] & 8) != 0 || ligands == 3) {
                    for (i = 0; i < this.ctab[a0].length; ++i) {
                        for (int j = 0; j < this.ctab[a1].length; ++j) {
                            for (int k = 0; k < this.ctab[a2].length; ++k) {
                                if (this.ctab[a0][i] != this.ctab[a1][j] || this.ctab[a0][i] != this.ctab[a2][k]) continue;
                                return 120.0;
                            }
                        }
                    }
                    if (q != null && q.isPlaced(a1)) {
                        int x1 = -1;
                        if (q.isPlaced(a0)) {
                            x1 = a0;
                        }
                        if (q.isPlaced(a2)) {
                            x1 = a2;
                        }
                        if (x1 != -1) {
                            int x2 = -1;
                            for (int i3 = 0; i3 < this.ctab[a1].length; ++i3) {
                                int ai = this.ctab[a1][i3];
                                if (ai == a0 || ai == a2 || !q.isPlaced(ai)) continue;
                                x2 = ai;
                            }
                            if (x2 != -1) {
                                double fi = WishListItem.calcBondAngle(q.get(x1), q.get(a1), q.get(x2));
                                return (360.0 - fi) / 2.0;
                            }
                        }
                    }
                    return 120.0;
                }
                if ((this.atomFlag[a1] & 4) != 0 || ligands == 2) {
                    return 180.0;
                }
                return 109.47122;
            }
            case 256: {
                if (l0 == 0 && l2 == 1) {
                    return 180.0;
                }
                if (l0 == 0 || l2 == 0 || l0 == 1 || l2 == 1) {
                    return 90.0;
                }
                return 120.0;
            }
            case 512: {
                if ((l0 & 6) == (l2 & 6)) {
                    return 180.0;
                }
                return 90.0;
            }
            case 1024: {
                int neighindex = l0 ^ l2;
                int neighweight = ((neighindex & 1) == 0 ? 0 : 1) + ((neighindex & 2) == 0 ? 0 : 1) + ((neighindex & 4) == 0 ? 0 : 1);
                if (neighweight == 1) {
                    return 70.52878;
                }
                if (neighweight == 2) {
                    return 109.47122;
                }
                return 180.0;
            }
            case 2048: {
                int j;
                if (l0 + l2 == 11) {
                    return 180.0;
                }
                int[][] r = new int[2][4];
                block44: for (int i4 = 0; i4 < 2; ++i4) {
                    for (j = 0; j < 4; ++j) {
                        r[i4][j] = -1;
                    }
                    j = i4 == 0 ? l0 : l2;
                    switch (j) {
                        case 0: {
                            r[i4][0] = 0;
                            r[i4][2] = 1;
                            continue block44;
                        }
                        case 1: {
                            r[i4][0] = 1;
                            r[i4][1] = 0;
                            continue block44;
                        }
                        case 2: {
                            r[i4][1] = 5;
                            r[i4][2] = 0;
                            continue block44;
                        }
                        case 3: {
                            r[i4][2] = 2;
                            r[i4][3] = 0;
                            continue block44;
                        }
                        case 4: {
                            r[i4][1] = 1;
                            r[i4][3] = 1;
                            continue block44;
                        }
                        case 5: {
                            r[i4][0] = 2;
                            r[i4][3] = 2;
                            continue block44;
                        }
                        case 6: {
                            r[i4][0] = 5;
                            r[i4][3] = 5;
                            continue block44;
                        }
                        case 7: {
                            r[i4][1] = 4;
                            r[i4][3] = 4;
                            continue block44;
                        }
                        case 8: {
                            r[i4][2] = 5;
                            r[i4][3] = 3;
                            continue block44;
                        }
                        case 9: {
                            r[i4][1] = 2;
                            r[i4][2] = 3;
                            continue block44;
                        }
                        case 10: {
                            r[i4][0] = 4;
                            r[i4][1] = 3;
                            continue block44;
                        }
                        case 11: {
                            r[i4][0] = 3;
                            r[i4][2] = 4;
                        }
                    }
                }
                int vcn = -1;
                for (j = 0; j < 4; ++j) {
                    if (r[0][j] < 0 || r[1][j] < 0) continue;
                    vcn = j;
                    break;
                }
                if (vcn >= 0) {
                    switch (Math.abs(r[0][vcn] - r[1][vcn])) {
                        case 1: {
                            return 60.0;
                        }
                        case 2: {
                            return 120.0;
                        }
                        case 3: {
                            return 180.0;
                        }
                        case 4: {
                            return 120.0;
                        }
                        case 5: {
                            return 60.0;
                        }
                    }
                }
                return 90.0;
            }
        }
        return 109.47122;
    }

    public myMolecule(int[] atomlist, int[] atomToFragatom, myMolecule origmol, debugPrintout debug) {
        int i;
        int j;
        int i2;
        this.originalM = null;
        if (atomToFragatom == null) {
            atomToFragatom = new int[origmol.a];
            for (i2 = 0; i2 < origmol.a; ++i2) {
                atomToFragatom[i2] = -1;
            }
            for (i2 = 0; i2 < atomlist.length; ++i2) {
                atomToFragatom[atomlist[i2]] = i2;
            }
        }
        this.atomProjection = atomToFragatom;
        if (debug != null) {
            debug.incLevel("Construct molecule fragment");
            debug.printBC("Construct molecule");
        }
        this.a = atomlist.length;
        this.anum = new int[this.a];
        this.atomFlag = new int[this.a];
        this.coord = new double[this.a][3];
        this.grinv = new int[this.a];
        for (i2 = 0; i2 < this.a; ++i2) {
            this.grinv[i2] = origmol.grinv[atomlist[i2]];
            this.anum[i2] = origmol.anum[atomlist[i2]];
            this.atomFlag[i2] = origmol.atomFlag[atomlist[i2]];
            for (int j2 = 0; j2 < 3; ++j2) {
                this.coord[i2][j2] = origmol.coord[atomlist[i2]][j2];
            }
        }
        this.b = 0;
        this.ctab = new int[this.a][];
        for (i2 = 0; i2 < this.a; ++i2) {
            int neighs = 0;
            for (j = 0; j < origmol.ctab[atomlist[i2]].length; ++j) {
                if (atomToFragatom[origmol.ctab[atomlist[i2]][j]] < 0) continue;
                ++neighs;
                ++this.b;
            }
            this.ctab[i2] = new int[neighs];
            neighs = 0;
            for (j = 0; j < origmol.ctab[atomlist[i2]].length; ++j) {
                if (atomToFragatom[origmol.ctab[atomlist[i2]][j]] < 0) continue;
                this.ctab[i2][neighs++] = atomToFragatom[origmol.ctab[atomlist[i2]][j]];
            }
        }
        this.b /= 2;
        this.bdesc = new int[this.b];
        this.bat = new int[2][this.b];
        int bindex = 0;
        for (i = 0; i < origmol.b; ++i) {
            int fa0 = atomToFragatom[origmol.bat[0][i]];
            int fa1 = atomToFragatom[origmol.bat[1][i]];
            if (fa0 < 0 || fa1 < 0) continue;
            this.bdesc[bindex] = origmol.bdesc[i];
            this.bat[0][bindex] = fa0;
            this.bat[1][bindex] = fa1;
            ++bindex;
        }
        this.blist = new int[this.ctab.length][];
        for (i = 0; i < this.blist.length; ++i) {
            this.blist[i] = new int[this.ctab[i].length];
        }
        for (i = 0; i < this.b; ++i) {
            for (int perm = 0; perm < 2; ++perm) {
                int j3;
                int at1 = this.bat[1 - perm][i];
                int at2 = this.bat[perm][i];
                for (j3 = 0; j3 < this.blist[at1].length && this.ctab[at1][j3] != at2; ++j3) {
                }
                if (j3 == this.blist[at1].length) {
                    System.err.println("CRITICAL ERROR IN MOLECULE CONSISTENCE");
                    System.err.println("bat[ 0 ]: " + U.sel(this.bat[0]));
                    System.err.println("bat[ 1 ]: " + U.sel(this.bat[1]));
                    System.err.println("ctab: " + U.toString(this.ctab));
                    throw new UnsupportedOperationException();
                }
                this.blist[at1][j3] = i;
            }
        }
        this.bonds = new int[this.a][this.a];
        for (i = 0; i < this.a; ++i) {
            for (j = 0; j < this.a; ++j) {
                this.bonds[i][j] = -1;
            }
        }
        for (i = 0; i < this.b; ++i) {
            this.bonds[this.bat[0][i]][this.bat[1][i]] = i;
            this.bonds[this.bat[1][i]][this.bat[0][i]] = i;
        }
        if (debug != null) {
            debug.decLevel();
        }
    }

    public int[][] getHackedSSSR(SelectionMolecule m, debugPrintout debug) {
        int[][] lSSSR = m.getSSSR();
        BitSet edges = new BitSet(this.b);
        if (debug != null) {
            debug.printBC("Entering SSSR expansion");
            debug.printBC("SSSR edge sum calculation");
        }
        for (int i = 0; i < lSSSR.length; ++i) {
            for (int j = 0; j < lSSSR[i].length; ++j) {
                int a2;
                int a1 = j == 0 ? lSSSR[i][lSSSR[i].length - 1] : lSSSR[i][j - 1];
                int bi = this.bonds[a1][a2 = lSSSR[i][j]];
                if (edges.get(bi)) {
                    edges.clear(bi);
                    continue;
                }
                edges.set(bi);
            }
        }
        if (debug != null) {
            debug.printBC("New rings atoms calculation");
        }
        int[] atoms = new int[this.a];
        for (int i = 0; i < this.b; ++i) {
            if (!edges.get(i)) continue;
            int ba_i_0 = this.bat[0][i];
            int ba_i_1 = this.bat[1][i];
            int n = ba_i_0;
            atoms[n] = atoms[n] + 1;
            int n2 = ba_i_1;
            atoms[n2] = atoms[n2] + 1;
            if (debug == null) continue;
            debug.println("New edge#" + i + " " + ba_i_0 + "-" + ba_i_1);
        }
        if (debug != null) {
            debug.print("Atom edge connections");
            debug.printVector(atoms);
        }
        myList newringlist = new myList(lSSSR.length);
        if (debug != null) {
            debug.printBC("Look for new rings");
        }
        for (int i = 0; i < this.a; ++i) {
            while (atoms[i] > 0) {
                int j;
                if (debug != null) {
                    debug.printB("New ring candidate. Base atom: " + i);
                }
                BitSet ringa = new BitSet(this.a);
                int[] nextringa = new int[this.a];
                int rsize = 0;
                int ano = i;
                boolean completed = false;
                boolean invalid = false;
                while (!completed) {
                    ringa.set(ano);
                    ++rsize;
                    int btr = 0;
                    boolean btf = false;
                    int newano = -1;
                    for (int j2 = 0; j2 < this.ctab[ano].length; ++j2) {
                        int ac = this.ctab[ano][j2];
                        if (atoms[ac] <= 0 || !edges.get(this.blist[ano][j2])) continue;
                        if (ringa.get(ac)) {
                            ++btr;
                            if (ac != i) continue;
                            btf = true;
                            continue;
                        }
                        newano = ac;
                    }
                    if (debug != null) {
                        debug.println("btr=" + btr + " newano=" + newano + " btf=" + btf);
                    }
                    if (btr > 1 || newano == -1) {
                        completed = true;
                        if (btr == 2 && btf) continue;
                        invalid = true;
                        continue;
                    }
                    nextringa[ano] = newano;
                    ano = newano;
                }
                if (!invalid && rsize >= 8) {
                    if (debug != null) {
                        debug.println("Ring size >= 8, invalidate");
                    }
                    invalid = true;
                }
                if (debug != null) {
                    debug.println("Walk completed.");
                    debug.println("Ring size: " + rsize);
                    debug.println("Is invalid: " + invalid);
                }
                if (!invalid) {
                    if (debug != null) {
                        debug.println("Check for previous ring match");
                    }
                    for (j = 0; j < lSSSR.length + newringlist.size(); ++j) {
                        int[] ringj;
                        int[] nArray = ringj = j < lSSSR.length ? lSSSR[j] : (int[])newringlist.get(j - lSSSR.length);
                        if (ringj.length != rsize) continue;
                        int matchatoms = 0;
                        for (int k = 0; k < ringj.length; ++k) {
                            if (!ringa.get(ringj[k])) continue;
                            ++matchatoms;
                        }
                        if (matchatoms != rsize) continue;
                        if (debug != null) {
                            debug.println("Match. Invalidate");
                        }
                        invalid = true;
                        break;
                    }
                    if (!invalid && debug != null) {
                        debug.println("No match.");
                    }
                }
                if (!invalid) {
                    if (debug != null) {
                        debug.println("Add ring.");
                    }
                    int[] newring = new int[rsize];
                    int aa = i;
                    for (int j3 = 0; j3 < rsize; ++j3) {
                        newring[j3] = aa;
                        aa = nextringa[aa];
                    }
                    if (debug != null) {
                        debug.printVector(newring);
                    }
                    newringlist.add(newring);
                }
                for (j = 0; j < this.a; ++j) {
                    if (!ringa.get(j)) continue;
                    int n = j;
                    atoms[n] = atoms[n] - 2;
                }
            }
        }
        if (newringlist.size() != 0) {
            Object newSSSR = null;
            newSSSR = new int[lSSSR.length + newringlist.size()][];
            for (int j = 0; j < lSSSR.length + newringlist.size(); ++j) {
                newSSSR[j] = j < lSSSR.length ? lSSSR[j] : (int[])newringlist.get(j - lSSSR.length);
            }
            return newSSSR;
        }
        return lSSSR;
    }

    public static boolean hasOverlap(double[][] d) {
        for (int i = 0; i < d.length; ++i) {
            for (int j = i + 1; j < d.length; ++j) {
                boolean match = true;
                for (int k = 0; k < d[i].length; ++k) {
                    if (d[i][k] == d[j][k]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStrainedCT(int a1, int a2, int[][] bat, int[][] ctab, int[][] btab) {
        for (int i = 0; i < ctab[a1].length; ++i) {
            int a = ctab[a1][i];
            if (a == a2 || btab[a][a2] < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isInSmallRing(int a1, int a2, int[][] bat, int[][] ctab, int[][] btab) {
        for (int i = 0; i < ctab[a1].length; ++i) {
            int a0 = ctab[a1][i];
            if (a0 == a2) continue;
            for (int j = 0; j < ctab[a2].length; ++j) {
                int a3 = ctab[a2][j];
                if (a3 == a1 || !myMolecule.isInSmallRing(a0, a1, a2, a3, bat, ctab, btab)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInSmallRing(int a1, int a2, int a3, int a4, int[][] bat, int[][] ctab, int[][] btab) {
        int i;
        if (btab[a1][a2] < 0) {
            return false;
        }
        if (btab[a2][a3] < 0) {
            return false;
        }
        if (btab[a3][a4] < 0) {
            return false;
        }
        if (a1 == a4) {
            return true;
        }
        if (btab[a1][a4] >= 0) {
            return true;
        }
        for (i = 0; i < ctab.length; ++i) {
            if (btab[i][a1] < 0 || btab[i][a4] < 0) continue;
            return true;
        }
        for (i = 0; i < bat[0].length; ++i) {
            int bia1 = bat[0][i];
            int bia2 = bat[1][i];
            if (bia1 == a2 && bia2 == a3 || bia2 == a2 && bia1 == a3) continue;
            if (btab[a1][bia1] >= 0 && btab[a4][bia2] >= 0) {
                return true;
            }
            if (btab[a4][bia1] < 0 || btab[a1][bia2] < 0) continue;
            return true;
        }
        for (int a6 = 0; a6 < ctab.length; ++a6) {
            if (a6 == a1 || a6 == a2 || a6 == a3 || a6 == a4) continue;
            for (int i2 = 1; i2 < ctab[a6].length; ++i2) {
                int a5 = ctab[a6][i2];
                if (a5 == a1 || a5 == a2 || a5 == a3 || a5 == a4) continue;
                for (int j = 0; j < i2; ++j) {
                    int a7 = ctab[a6][j];
                    if (a7 == a1 || a7 == a2 || a7 == a3 || a7 == a4) continue;
                    if (btab[a1][a7] >= 0 && btab[a4][a5] >= 0) {
                        return true;
                    }
                    if (btab[a1][a5] < 0 || btab[a4][a7] < 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void fillAtomInfo(SelectionMolecule m) {
        this.a = m.getAtomCount();
        this.anum = new int[this.a];
        this.atomFlag = new int[this.a];
        this.coord = new double[this.a][3];
        this.grinv = new int[this.a];
        m.getGrinv(this.grinv, 0);
        for (int i = 0; i < this.a; ++i) {
            this.anum[i] = m.getAtom(i).getAtno();
            this.atomFlag[i] = m.getAtom(i).getHybridizationState() == 1 ? 2 : (m.getAtom(i).getHybridizationState() == 2 ? 4 : (m.getAtom(i).getHybridizationState() == 3 ? 8 : (m.getAtom(i).getHybridizationState() == 4 ? 16 : 1)));
            this.coord[i][0] = m.getAtom(i).getX();
            this.coord[i][1] = m.getAtom(i).getY();
            this.coord[i][2] = m.getAtom(i).getZ();
        }
    }

    public static int[][] constuctBat(SelectionMolecule m) {
        int[][] ret = new int[2][m.getBondCount()];
        for (int i = 0; i < ret[0].length; ++i) {
            ret[0][i] = m.indexOf(m.getBond(i).getAtom1());
            ret[1][i] = m.indexOf(m.getBond(i).getAtom2());
            if (ret[0][i] >= 0 && ret[1][i] >= 0) continue;
            throw new UnsupportedOperationException("Atom missing");
        }
        return ret;
    }

    public static int[][] constructBonds(int act, int[][] bat) {
        int i;
        if (bat[0].length != bat[1].length) {
            throw new UnsupportedOperationException();
        }
        int bct = bat[0].length;
        int[][] bonds = new int[act][act];
        for (i = 0; i < act; ++i) {
            for (int j = 0; j < act; ++j) {
                bonds[i][j] = -1;
            }
        }
        for (i = 0; i < bct; ++i) {
            bonds[bat[0][i]][bat[1][i]] = i;
            bonds[bat[1][i]][bat[0][i]] = i;
        }
        return bonds;
    }

    private void fillBondInfo(SelectionMolecule m) {
        int i;
        this.b = m.getBondCount();
        this.bdesc = new int[this.b];
        this.bat = myMolecule.constuctBat(m);
        this.ctab = m.getCtab();
        for (i = 0; i < this.a; ++i) {
            int l = this.ctab[i].length;
            if (l <= 4) {
                int n = i;
                this.atomFlag[n] = this.atomFlag[n] | 0x80;
                continue;
            }
            if (l == 5) {
                int n = i;
                this.atomFlag[n] = this.atomFlag[n] | 0x100;
                continue;
            }
            if (l == 6) {
                int n = i;
                this.atomFlag[n] = this.atomFlag[n] | 0x200;
                continue;
            }
            if (l <= 8) {
                int n = i;
                this.atomFlag[n] = this.atomFlag[n] | 0x400;
                continue;
            }
            int n = i;
            this.atomFlag[n] = this.atomFlag[n] | 0x800;
        }
        for (i = 0; i < this.b; ++i) {
            this.bdesc[i] = m.getBond(i).getType() == 1 ? 1 : (m.getBond(i).getType() == 2 ? 2 : (m.getBond(i).getType() == 3 ? 4 : (m.getBond(i).getType() == 4 ? 8 : 16)));
        }
        this.blist = new int[this.ctab.length][];
        for (i = 0; i < this.blist.length; ++i) {
            this.blist[i] = new int[this.ctab[i].length];
        }
        for (i = 0; i < this.b; ++i) {
            for (int perm = 0; perm < 2; ++perm) {
                int j;
                int at1 = this.bat[1 - perm][i];
                int at2 = this.bat[perm][i];
                for (j = 0; j < this.blist[at1].length && this.ctab[at1][j] != at2; ++j) {
                }
                if (j == this.blist[at1].length) {
                    System.err.println("CRITICAL ERROR IN MOLECULE CONSISTENCE");
                    System.err.println("bat[ 0 ]: " + U.sel(this.bat[0]));
                    System.err.println("bat[ 1 ]: " + U.sel(this.bat[1]));
                    System.err.println("ctab: " + U.toString(this.ctab));
                    throw new UnsupportedOperationException();
                }
                this.blist[at1][j] = i;
            }
        }
        this.bonds = myMolecule.constructBonds(this.a, this.bat);
    }

    private void fillRingInfo(SelectionMolecule m, debugPrintout debug) {
        int j;
        int i;
        if (debug != null) {
            debug.incLevel("Entering SSSR hack");
        }
        this.SSSR = this.getHackedSSSR(m, debug);
        if (debug != null) {
            debug.decLevel();
        }
        this.cssr = m.getCSSR();
        this.ringflags = new int[this.SSSR.length];
        for (i = 0; i < this.SSSR.length; ++i) {
            int flag = myMoleculeConstants.B_R_INRING;
            if (this.SSSR[i].length <= 6) {
                flag |= myMoleculeConstants.B_R_INSMALLRING;
                int n = i;
                this.ringflags[n] = this.ringflags[n] | 2;
            } else if (this.SSSR[i].length <= 9) {
                flag |= myMoleculeConstants.B_R_INMEDIUMRING;
            }
            for (j = 0; j < this.SSSR[i].length; ++j) {
                int bi = this.bonds[this.SSSR[i][j]][this.SSSR[i][(j + 1) % this.SSSR[i].length]];
                if (bi < 0) continue;
                this.bdesc[bi] = this.bdesc[bi] | flag;
            }
        }
        for (i = 0; i < this.SSSR.length; ++i) {
            boolean aromatic = true;
            for (j = 0; j < this.SSSR[i].length; ++j) {
                if (myMolecule.isSet(this.bdesc[this.bonds[this.SSSR[i][j == 0 ? this.SSSR[i].length - 1 : j - 1]][this.SSSR[i][j]]], 8)) continue;
                aromatic = false;
                break;
            }
            if (!aromatic) continue;
            this.ringflags[i] = this.ringflags[i] | myMoleculeConstants.R_AROMATIC;
        }
    }

    public myMolecule(Molecule mol, CleanSettings settings) {
        this(mol.findFrags()[0], CleanArgs.getDebug(), settings);
    }

    public myMolecule(SelectionMolecule mol, debugPrintout debug, CleanSettings settings) {
        int j;
        int i;
        int i2;
        if (CleanArgs.OPT_DEBUG_USEORIGCOORDINATES) {
            this.coordinatesFromOrig = new double[mol.getAtomCount()][3];
            for (i2 = 0; i2 < this.coordinatesFromOrig.length; ++i2) {
                MolAtom ma = mol.getAtom(i2);
                this.coordinatesFromOrig[i2][0] = ma.getX();
                this.coordinatesFromOrig[i2][1] = ma.getY();
                this.coordinatesFromOrig[i2][2] = ma.getZ();
            }
            if (myMolecule.hasOverlap(this.coordinatesFromOrig)) {
                this.coordinatesFromOrig = null;
            }
        }
        if (debug != null) {
            debug.incLevel("myMolecule constructor");
        }
        this.originalM = mol;
        for (i2 = 0; i2 < mol.getBondCount(); ++i2) {
            MolBond bond = mol.getBond(i2);
            int bType = bond.getType();
            if (bType == 0 || bType == 6 || bType == 5) {
                bType = 1;
            }
            bond.setType(bType);
        }
        this.aromaTimer = new Stopper();
        mol.aromatize(true);
        this.aromaTimer.stop();
        myMolecule.assignHybridizationStates(mol);
        this.fillAtomInfo(mol);
        this.fillBondInfo(mol);
        this.fillRingInfo(mol, debug);
        this.assignRingDerivedInfos();
        this.assignDreidingLengths(debug, settings);
        this.assignForcedAngles(debug, settings);
        int[] proj = new int[this.a];
        for (int i3 = 0; i3 < proj.length; ++i3) {
            proj[i3] = -1;
        }
        boolean[] ringFlag = new boolean[this.SSSR.length];
        for (int i4 = 0; i4 < ringFlag.length; ++i4) {
            ringFlag[i4] = false;
        }
        int nextID = 0;
        for (i = 0; i < this.SSSR.length; ++i) {
            if (ringFlag[i]) continue;
            ringFlag[i] = true;
            for (int j2 = 0; j2 < this.SSSR[i].length; ++j2) {
                proj[this.SSSR[i][j2]] = nextID;
            }
            boolean go = true;
            while (go) {
                go = false;
                for (j = 0; j < this.SSSR.length; ++j) {
                    int k;
                    if (ringFlag[j]) continue;
                    boolean ok = false;
                    for (k = 0; k < this.SSSR[j].length; ++k) {
                        if (proj[this.SSSR[j][k]] == -1) continue;
                        ok = true;
                        go = true;
                    }
                    if (!ok) continue;
                    ringFlag[j] = true;
                    for (k = 0; k < this.SSSR[j].length; ++k) {
                        proj[this.SSSR[j][k]] = nextID;
                    }
                }
            }
            ++nextID;
        }
        this.ringSet = new int[nextID][];
        for (i = 0; i < nextID; ++i) {
            int c = 0;
            for (j = 0; j < this.SSSR.length; ++j) {
                if (proj[this.SSSR[j][0]] != i) continue;
                ++c;
            }
            this.ringSet[i] = new int[c];
            c = 0;
            for (j = 0; j < this.SSSR.length; ++j) {
                if (proj[this.SSSR[j][0]] != i) continue;
                this.ringSet[i][c] = j;
                ++c;
            }
        }
        this.assignOrphanAromaRings();
        this.assignAtomClassification();
        this.assignHOPLigandPermutations(debug);
        if (debug != null) {
            debug.decLevel();
        }
    }

    private void assignOldDreidingLengths(debugPrintout debug) {
        if (debug != null) {
            debug.incLevel("Invoke Dreiding constructor");
        }
        this.fillDreidingDescriptors();
        Opt3D.Dreiding ffield = new Opt3D.Dreiding(this, debug);
        if (debug != null) {
            debug.decLevel();
        }
        this.blen = new double[this.b];
        for (int i = 0; i < this.b; ++i) {
            double dlen;
            int a1 = this.bat[0][i];
            int a2 = this.bat[1][i];
            this.blen[i] = dlen = ffield.getEquilibriumBondLength(a1, a2);
        }
    }

    public WishGroup getWishGroup(CleanSettings settings) {
        if (this.wg == null) {
            VerbosePrinter vp = null;
            if (settings != null) {
                vp = settings.getVerbosePrinter("Construct wg");
            }
            this.wg = new WishGroup(this.bat, this.ctab, this.bonds, this.cssr, this.getForceField(settings), vp);
            if (vp != null) {
                vp.close();
            }
        }
        return this.wg;
    }

    public ForceField getForceField(CleanSettings settings) {
        if (this.ff == null) {
            if (settings == null) {
                settings = new CleanSettings(null, null);
            }
            Dreiding dd = new Dreiding(settings.getMMDiagnosticObserver());
            this.ff = dd;
            int angleterm = 0;
            if (settings.getForcefieldNonLinAngleMethod() == 2) {
                angleterm |= 2;
            } else if (settings.getForcefieldNonLinAngleMethod() == 3) {
                angleterm |= 4;
            } else if (settings.getForcefieldNonLinAngleMethod() == 1) {
                angleterm |= 1;
            }
            if (settings.getForcefieldLinAngleMethod() == 1) {
                angleterm |= 8;
            }
            dd.setAngleTreatment(angleterm);
            dd.setAngleScaleUpperInterval(settings.getForceFieldAngleDf() * Math.PI / 180.0);
            dd.setAngleScaleLowerInterval(settings.getForceFieldAngleLowerInterval() * Math.PI / 180.0);
            switch (settings.getForceFieldDihedralDSMethod()) {
                case 1: {
                    this.ff.setAngleScaleAtDihedralsLimit(-1.0);
                    break;
                }
                case 2: {
                    this.ff.setAngleScaleAtDihedralsLimit(settings.getForceFieldDihedralDSAngle() * Math.PI / 180.0);
                }
            }
            boolean invmqt = settings.getForceFieldInversionMethod() == 2;
            dd.setUseCorrectedInversionForm(invmqt);
            dd.setCutOffForVDW(1.4);
            switch (settings.getForceFieldInversionDSMethod()) {
                case 1: {
                    this.ff.setAngleScaleAtInversionLimit(-1.0);
                    break;
                }
                case 2: {
                    this.ff.setAngleScaleAtInversionLimit(settings.getForceFieldInversionDSAngle() * Math.PI / 180.0);
                }
            }
            if (settings.getForceFieldDisableComponent() != null) {
                this.ff.disableEnergyComponent(settings.getForceFieldDisableComponent());
            }
            dd.init(this.getOriginalMolCopy());
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Constructing FF angleterm=" + angleterm + " invmqt=" + invmqt, ((Object)this.ff).toString());
            }
        }
        return this.ff;
    }

    public ForceField getMMFF() throws MMFF94Exception {
        MMFF94 mmff = new MMFF94();
        mmff.init(this.getOriginalMolCopy());
        this.ff = mmff;
        return this.ff;
    }

    private void assignDreidingLengths(debugPrintout debug, CleanSettings settings) {
        WishGroup wgr = this.getWishGroup(settings);
        this.blen = wgr.getBlen();
    }

    void assignOrphanAromaRings() {
        int j;
        int i;
        boolean[] orphan = new boolean[this.b];
        for (i = 0; i < this.b; ++i) {
            if (!myMolecule.isSet(this.bdesc[i], 8)) continue;
            orphan[i] = true;
        }
        for (i = 0; i < this.SSSR.length; ++i) {
            if ((this.ringflags[i] & myMoleculeConstants.R_AROMATIC) == 0) continue;
            for (j = 0; j < this.SSSR[i].length; ++j) {
                int at1 = this.SSSR[i][j];
                int at2 = this.SSSR[i][(j + 1) % this.SSSR[i].length];
                orphan[this.bonds[at1][at2]] = false;
            }
        }
        for (i = 0; i < this.b; ++i) {
        }
        for (i = 0; i < this.b; ++i) {
            if (!orphan[i]) continue;
            for (j = 0; j < this.bondToRing[i].length; ++j) {
                boolean allSP2 = true;
                int ri = this.bondToRing[i][j];
                for (int k = 0; k < this.SSSR[ri].length; ++k) {
                    if (this.isHybSP2(this.SSSR[ri][k])) continue;
                    allSP2 = false;
                }
                if (!allSP2) continue;
                int n = ri;
                this.ringflags[n] = this.ringflags[n] | myMoleculeConstants.R_AROMATIC;
            }
        }
    }

    public static void assignHybridizationStates(SelectionMolecule m) {
        int i;
        MolAtom a1;
        int i2;
        int me = m.getBondCount();
        int mn = m.getAtomCount();
        for (i2 = 0; i2 < me; ++i2) {
            MolAtom a2;
            MolBond b = m.getBond(i2);
            if (b.getType() == 4) {
                a1 = b.getAtom1();
                a2 = b.getAtom2();
                if (a1.getHybridizationState() == 0) {
                    a1.setHybridizationState(3);
                }
                if (a2.getHybridizationState() == 0) {
                    a2.setHybridizationState(3);
                }
            }
            if (b.getType() == 3) {
                a1 = b.getAtom1();
                a2 = b.getAtom2();
                if (a1.getHybridizationState() == 0) {
                    a1.setHybridizationState(2);
                }
                if (a2.getHybridizationState() == 0) {
                    a2.setHybridizationState(2);
                }
            }
            if (b.getType() != 2) continue;
            a1 = b.getAtom1();
            a2 = b.getAtom2();
            if (a1.getHybridizationState() == 0) {
                if (myMolecule.has2doubleBond(a1)) {
                    a1.setHybridizationState(2);
                } else {
                    a1.setHybridizationState(3);
                }
            }
            if (a2.getHybridizationState() != 0) continue;
            if (myMolecule.has2doubleBond(a2)) {
                a2.setHybridizationState(2);
                continue;
            }
            a2.setHybridizationState(3);
        }
        for (i2 = 0; i2 < mn; ++i2) {
            MolAtom a = m.getAtom(i2);
            if (a.getHybridizationState() != 0) continue;
            a.setHybridizationState(4);
        }
        int[][] ctab = m.getCtab();
        for (i = 0; i < mn; ++i) {
            a1 = m.getAtom(i);
            int an1 = a1.getAtno();
            if (a1.getHybridizationState() != 4 || an1 != 7 && an1 != 8) continue;
            for (int j = 0; j < ctab[i].length; ++j) {
                int a2i = ctab[i][j];
                MolAtom a2 = m.getAtom(a2i);
                int an2 = a2.getAtno();
                if (a2.getHybridizationState() != 3 || an2 != 6) continue;
                int a2bondcount = a2.getBondCount();
                for (int k = 0; k < a2bondcount; ++k) {
                    MolBond a2a3b = a2.getBond(k);
                    if (a2a3b.getType() != 2) continue;
                    MolAtom a3 = null;
                    if (a2a3b.getAtom1() == a2) {
                        a3 = a2a3b.getAtom2();
                    } else if (a2a3b.getAtom2() == a2) {
                        a3 = a2a3b.getAtom1();
                    } else {
                        System.err.println("Consystency error in SelectionMolecule");
                    }
                    if (a3 == null) continue;
                    int an3 = a3.getAtno();
                    if (a3.getHybridizationState() != 3 || an3 != 8) continue;
                    a1.setHybridizationState(3);
                }
            }
        }
        for (i = 0; i < mn; ++i) {
            a1 = m.getAtom(i);
            int an1 = a1.getAtno();
            if (a1.getHybridizationState() == 4 || an1 != 16 || ctab[i].length != 3) continue;
            int dbnc = 0;
            int sbnc = 0;
            int obnc = 0;
            for (int j = 0; j < 3; ++j) {
                MolBond bj = a1.getBond(j);
                int bjt = bj.getType();
                if (bjt == 1) {
                    ++sbnc;
                    continue;
                }
                if (bjt == 2) {
                    ++dbnc;
                    continue;
                }
                ++obnc;
            }
            if (dbnc != true || sbnc != 2 || obnc != 0) continue;
            a1.setHybridizationState(4);
        }
    }

    int countOpposites(int at, int[][] shrlp) {
        if (shrlp == null) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < shrlp.length; ++i) {
            double angl = this.getBangl(shrlp[i][0], at, shrlp[i][1]);
            if (!(angl > 130.0)) continue;
            ++ret;
        }
        return ret;
    }

    void assignHOPLigandPermutations(debugPrintout debug) {
        if (debug != null) {
            debug.printBC("Assign ligand permutations for HOP ligands");
        }
        block0: for (int at = 0; at < this.a; ++at) {
            int i;
            Object shrlp = null;
            int lct = this.getLigands(at);
            if (lct <= 4) continue;
            if (debug != null) {
                debug.printB("Atom " + at + " has " + lct + " ligands");
            }
            if (this.atomToRing == null || this.atomToRing[at] == null || this.atomToRing[at].length <= 0) continue;
            int srct = 0;
            for (i = 0; i < this.atomToRing[at].length; ++i) {
                if (this.SSSR[this.atomToRing[at][i]].length >= 7) continue;
                ++srct;
            }
            if (srct <= 0) continue;
            if (debug != null) {
                debug.print("Small held ring count: " + srct);
            }
            shrlp = new int[srct][];
            srct = 0;
            for (i = 0; i < this.atomToRing[at].length; ++i) {
                if (this.SSSR[this.atomToRing[at][i]].length >= 7) continue;
                shrlp[srct] = new int[2];
                shrlp[srct][0] = this.atomToRingNextP[at][i];
                shrlp[srct][1] = this.atomToRingPrevP[at][i];
                ++srct;
            }
            if (debug != null) {
                debug.println("Small held ring ligand pairs:");
                for (i = 0; i < ((int[][])shrlp).length; ++i) {
                    debug.println(shrlp[i][0] + "-" + shrlp[i][1]);
                }
            }
            if (this.ligandPermutation == null) {
                this.ligandPermutation = new int[this.a][];
            }
            if (this.ligandPermutation[at] == null || this.ligandPermutation[at].length == 0) {
                this.ligandPermutation[at] = new int[lct];
                for (i = 0; i < this.ligandPermutation[at].length; ++i) {
                    this.ligandPermutation[at][i] = i;
                }
            }
            int bestops = this.countOpposites(at, (int[][])shrlp);
            int[] bestprm = new int[this.ligandPermutation[at].length];
            System.arraycopy(this.ligandPermutation[at], 0, bestprm, 0, bestprm.length);
            if (debug != null) {
                debug.println("Default permutation, ops=" + bestops);
                debug.printVector(bestprm);
            }
            boolean go = true;
            while (go) {
                go = false;
                if (bestops == 0) continue block0;
                if (debug != null) {
                    debug.println("ops=" + bestops + ", look for better");
                }
                for (int i2 = 0; i2 < bestprm.length - 1; ++i2) {
                    for (int j = i2 + 1; j < bestprm.length; ++j) {
                        System.arraycopy(bestprm, 0, this.ligandPermutation[at], 0, bestprm.length);
                        int k = this.ligandPermutation[at][i2];
                        this.ligandPermutation[at][i2] = this.ligandPermutation[at][j];
                        this.ligandPermutation[at][j] = k;
                        int ops = this.countOpposites(at, (int[][])shrlp);
                        if (debug != null) {
                            debug.println("ops=" + ops);
                            debug.printVector(this.ligandPermutation[at]);
                        }
                        if (ops >= bestops) continue;
                        bestops = ops;
                        System.arraycopy(this.ligandPermutation[at], 0, bestprm, 0, bestprm.length);
                        go = true;
                        break;
                    }
                    if (go) break;
                }
                if (debug == null || !go) continue;
                debug.println("New, better permutation, ops=" + bestops);
                debug.printVector(this.ligandPermutation[at]);
            }
        }
    }

    void assignForcedAngles(debugPrintout debug, CleanSettings settings) {
        WishGroup wgr = this.getWishGroup(settings);
        if (debug != null) {
            debug.printBC("Assign forced angles");
        }
        Vector<int[]> a012 = new Vector<int[]>();
        Vector<Double> angl = new Vector<Double>();
        boolean hasforced = false;
        if (this.SSSR != null) {
            int i;
            if (debug != null) {
                debug.printB("Look for ring triangles");
            }
            for (int i2 = 0; i2 < this.SSSR.length; ++i2) {
                if (this.SSSR[i2].length != 3) continue;
                for (int j = 0; j < 3; ++j) {
                    double cosval;
                    int a0 = this.SSSR[i2][j];
                    int a1 = this.SSSR[i2][(j + 1) % 3];
                    int a2 = this.SSSR[i2][(j + 2) % 3];
                    double l01 = this.blen[this.bonds[a0][a1]];
                    double l12 = this.blen[this.bonds[a1][a2]];
                    double l20 = this.blen[this.bonds[a2][a0]];
                    double cos_num = -M.sqr(l20) + M.sqr(l01) + M.sqr(l12);
                    double cos_den = 2.0 * l01 * l12;
                    double val = 60.0;
                    if (cos_den != 0.0 && (cosval = cos_num / cos_den) >= -1.0 && cosval <= 1.0) {
                        val = Math.acos(cosval) * 180.0 / Math.PI;
                    }
                    if (a0 < a2) {
                        a012.add(new int[]{a0, a1, a2});
                    } else {
                        a012.add(new int[]{a2, a1, a0});
                    }
                    angl.add(new Double(val));
                    hasforced = true;
                }
            }
            if (debug != null) {
                debug.printB("Look for ferrocene like substructures");
            }
            Vector<Integer> ferrorings = new Vector<Integer>();
            Vector<int[]> ferroringa = new Vector<int[]>();
            for (i = 0; i < this.SSSR.length; ++i) {
                int j;
                if (this.SSSR[i].length >= 7) continue;
                int ra0 = this.SSSR[i][0];
                int[] ns = new int[this.ctab[ra0].length];
                for (j = 0; j < this.ctab[ra0].length; ++j) {
                    ns[j] = this.ctab[ra0][j];
                }
                for (j = 1; j < this.SSSR[i].length; ++j) {
                    int ra = this.SSSR[i][j];
                    for (int k = 0; k < ns.length; ++k) {
                        if (ns[k] == -1) continue;
                        boolean found = false;
                        for (int l = 0; l < this.ctab[ra].length; ++l) {
                            if (ns[k] != this.ctab[ra][l]) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ns[k] = -1;
                    }
                }
                int commons = 0;
                for (int j2 = 0; j2 < ns.length; ++j2) {
                    if (ns[j2] == -1) continue;
                    ++commons;
                }
                if (commons == 0) continue;
                ferrorings.add(new Integer(i));
                int[] fra = new int[commons];
                int frai = 0;
                for (int k = 0; k < ns.length; ++k) {
                    if (ns[k] == -1) continue;
                    fra[frai++] = ns[k];
                }
                ferroringa.add(fra);
                if (debug != null) {
                    debug.println("Found " + commons + " common ligand");
                }
                double rba = 180.0 - (double)(360 / this.SSSR[i].length);
                if (debug != null) {
                    debug.println("New bond angle in ring=" + rba);
                }
                for (int j3 = 0; j3 < this.SSSR[i].length; ++j3) {
                    int a0 = this.SSSR[i][j3];
                    int a1 = this.SSSR[i][(j3 + 1) % this.SSSR[i].length];
                    int a2 = this.SSSR[i][(j3 + 2) % this.SSSR[i].length];
                    int[] ni = null;
                    ni = a0 < a2 ? new int[]{a0, a1, a2} : new int[]{a2, a1, a0};
                    boolean doNotAdd = false;
                    for (int k = 0; k < a012.size(); ++k) {
                        int[] ia = (int[])a012.get(k);
                        if (ia[0] != ni[0] || ia[1] != ni[1] || ia[2] != ni[2]) continue;
                        doNotAdd = true;
                    }
                    if (doNotAdd) continue;
                    a012.add(ni);
                    angl.add(new Double(rba));
                    hasforced = true;
                }
            }
            for (i = 0; i < ferrorings.size() - 1; ++i) {
                int r1 = (Integer)ferrorings.get(i);
                int[] r1f = (int[])ferroringa.get(i);
                for (int j = i + 1; j < ferrorings.size(); ++j) {
                    int l;
                    int k;
                    int r2 = (Integer)ferrorings.get(j);
                    int[] r2f = (int[])ferroringa.get(j);
                    boolean hascommon = false;
                    int commona = -1;
                    for (k = 0; k < r1f.length; ++k) {
                        for (l = 0; l < r2f.length; ++l) {
                            if (r1f[k] != r2f[l]) continue;
                            hascommon = true;
                            commona = r1f[k];
                        }
                    }
                    if (!hascommon) continue;
                    for (k = 0; k < this.SSSR[r1].length; ++k) {
                        for (l = 0; l < this.SSSR[r2].length; ++l) {
                            int a0 = this.SSSR[r1][k];
                            int a1 = commona;
                            int a2 = this.SSSR[r2][l];
                            int[] ni = null;
                            ni = a0 < a2 ? new int[]{a0, a1, a2} : new int[]{a2, a1, a0};
                            boolean doNotAdd = false;
                            for (int m = 0; m < a012.size(); ++m) {
                                int[] ia = (int[])a012.get(m);
                                if (ia[0] != ni[0] || ia[1] != ni[1] || ia[2] != ni[2]) continue;
                                doNotAdd = true;
                            }
                            if (doNotAdd) continue;
                            a012.add(ni);
                            angl.add(new Double(109.0));
                            hasforced = true;
                        }
                    }
                }
            }
        }
        if (hasforced) {
            int i;
            this.forcedAngleValue = new double[this.a][];
            this.forcedAngleA0 = new int[this.a][];
            this.forcedAngleA2 = new int[this.a][];
            int[] ct = new int[this.a];
            for (i = 0; i < a012.size(); ++i) {
                int[] atoms = (int[])a012.get(i);
                int n = atoms[1];
                ct[n] = ct[n] + 1;
            }
            for (i = 0; i < this.a; ++i) {
                if (ct[i] == 0) continue;
                this.forcedAngleValue[i] = new double[ct[i]];
                this.forcedAngleA0[i] = new int[ct[i]];
                this.forcedAngleA2[i] = new int[ct[i]];
                ct[i] = 0;
            }
            for (i = 0; i < a012.size(); ++i) {
                double val;
                int[] atoms = (int[])a012.get(i);
                this.forcedAngleValue[atoms[1]][ct[atoms[1]]] = val = ((Double)angl.get(i)).doubleValue();
                this.forcedAngleA0[atoms[1]][ct[atoms[1]]] = atoms[0];
                this.forcedAngleA2[atoms[1]][ct[atoms[1]]] = atoms[2];
                int n = atoms[1];
                ct[n] = ct[n] + 1;
            }
        }
    }

    void assignRingDerivedInfos() {
        int a2;
        int a1;
        int j;
        int i;
        int i2;
        this.rings = new int[this.a];
        this.atomToRing = new int[this.a][];
        this.atomToRingNextP = new int[this.a][];
        this.atomToRingPrevP = new int[this.a][];
        for (i2 = 0; i2 < this.SSSR.length; ++i2) {
            for (int j2 = 0; j2 < this.SSSR[i2].length; ++j2) {
                int n = this.SSSR[i2][j2];
                this.rings[n] = this.rings[n] + 1;
            }
        }
        for (i2 = 0; i2 < this.a; ++i2) {
            this.atomToRing[i2] = new int[this.rings[i2]];
            this.atomToRingNextP[i2] = new int[this.rings[i2]];
            this.atomToRingPrevP[i2] = new int[this.rings[i2]];
        }
        int[] tmppoi = new int[this.a];
        for (i = 0; i < this.SSSR.length; ++i) {
            for (j = 0; j < this.SSSR[i].length; ++j) {
                int ai = this.SSSR[i][j];
                int aP = this.SSSR[i][j - 1 < 0 ? this.SSSR[i].length - 1 : j - 1];
                int aN = this.SSSR[i][j + 1 == this.SSSR[i].length ? 0 : j + 1];
                this.atomToRing[ai][tmppoi[ai]] = i;
                this.atomToRingNextP[ai][tmppoi[ai]] = aN;
                this.atomToRingPrevP[ai][tmppoi[ai]] = aP;
                int n = ai;
                tmppoi[n] = tmppoi[n] + 1;
            }
        }
        tmppoi = new int[this.b];
        for (i = 0; i < this.SSSR.length; ++i) {
            for (j = 0; j < this.SSSR[i].length; ++j) {
                a1 = this.SSSR[i][j];
                a2 = this.SSSR[i][(j + 1) % this.SSSR[i].length];
                int n = this.bonds[a1][a2];
                tmppoi[n] = tmppoi[n] + 1;
            }
        }
        this.bondToRing = new int[this.b][];
        for (int k = 0; k < this.b; ++k) {
            this.bondToRing[k] = new int[tmppoi[k]];
            tmppoi[k] = 0;
        }
        for (i = 0; i < this.SSSR.length; ++i) {
            for (j = 0; j < this.SSSR[i].length; ++j) {
                a1 = this.SSSR[i][j];
                a2 = this.SSSR[i][(j + 1) % this.SSSR[i].length];
                int bi = this.bonds[a1][a2];
                this.bondToRing[bi][tmppoi[bi]] = i;
                int n = bi;
                tmppoi[n] = tmppoi[n] + 1;
            }
        }
    }

    void assignAtomClassification(debugPrintout debug) {
        int i;
        if (debug != null && !debug.getWillPrint()) {
            debug = null;
        }
        if (debug != null) {
            debug.println("Entering assignAtomClassification()");
        }
        int[] atomflag = new int[this.a];
        int[] atomparam = new int[this.a];
        for (int i2 = 0; i2 < this.SSSR.length; ++i2) {
            for (int j = 0; j < this.SSSR[i2].length; ++j) {
                atomflag[this.SSSR[i2][j]] = 2;
            }
        }
        boolean go = true;
        int catomparam = 0;
        while (go) {
            go = false;
            for (i = 0; i < this.a; ++i) {
                if (atomflag[i] != 0) continue;
                int nonchainneighbor = 0;
                int maxatomparam = 0;
                for (int j = 0; j < this.ctab[i].length; ++j) {
                    int a0 = this.ctab[i][j];
                    if (atomflag[a0] != 1) {
                        ++nonchainneighbor;
                        continue;
                    }
                    maxatomparam = Math.max(maxatomparam, atomparam[a0]);
                }
                if (nonchainneighbor > true || maxatomparam != catomparam) continue;
                atomflag[i] = 1;
                atomparam[i] = maxatomparam + 1;
                this.chainCenterCandidate = i;
                go = true;
            }
            ++catomparam;
        }
        for (i = 0; i < this.a; ++i) {
            if (atomflag[i] != 0) continue;
            atomflag[i] = 3;
        }
        for (i = 0; i < this.a; ++i) {
            int j = 0;
            switch (atomflag[i]) {
                case 1: {
                    j = 4096;
                    break;
                }
                case 2: {
                    j = 8192;
                    break;
                }
                case 3: {
                    j = 12288;
                }
            }
            this.atomFlag[i] = this.atomFlag[i] & 0xFFFFCFFF | j;
        }
        if (debug != null) {
            debug.println("Atom classification done");
            debug.Tstart();
            debug.Trow();
            debug.TprintBC("No");
            debug.TprintBC("Flag");
            debug.TprintBC("Type");
            for (i = 0; i < this.a; ++i) {
                debug.Trow();
                debug.TprintBC("" + i);
                int flag = this.atomFlag[i] & 0x3000;
                debug.TprintC("" + flag);
                switch (flag) {
                    case 4096: {
                        debug.TprintC("Chain atom");
                    }
                    case 8192: {
                        debug.TprintC("Ring atom");
                    }
                    case 12288: {
                        debug.TprintC("Inter-ring backbone atom");
                    }
                }
            }
        }
    }

    void assignAtomClassification() {
        this.assignAtomClassification(null);
    }

    public static boolean isSet(int var, int flag) {
        return (var & flag) == flag;
    }

    static boolean has2doubleBond(MolAtom a) {
        int doublebonds = 0;
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            if (b.getType() != 2) continue;
            ++doublebonds;
        }
        return doublebonds == 2;
    }

    public boolean isHybS(int n) {
        return myMolecule.isSet(this.atomFlag[n], 2);
    }

    public boolean isHybSP(int n) {
        return myMolecule.isSet(this.atomFlag[n], 4);
    }

    public boolean isHybSP2(int n) {
        return myMolecule.isSet(this.atomFlag[n], 8);
    }

    public boolean isHybSP3(int n) {
        return myMolecule.isSet(this.atomFlag[n], 16);
    }

    public boolean isSingle(int n) {
        return (this.bdesc[n] & 1) != 0;
    }

    public boolean isSingle(int a0, int a1) {
        return this.isSingle(this.getBond(a0, a1));
    }

    public boolean isDouble(int n) {
        return (this.bdesc[n] & 2) != 0;
    }

    public boolean isDouble(int a0, int a1) {
        return this.isDouble(this.getBond(a0, a1));
    }

    public boolean isTriple(int n) {
        return (this.bdesc[n] & 4) != 0;
    }

    public boolean isTriple(int a0, int a1) {
        return this.isTriple(this.getBond(a0, a1));
    }

    public boolean isAromatic(int n) {
        return (this.bdesc[n] & 8) != 0;
    }

    public boolean isAromatic(int a0, int a1) {
        return this.isAromatic(this.getBond(a0, a1));
    }

    public static void fillMoleculeCoordinates(Opt3D.MolCT mol, Molecule m) {
        double[] mc = mol.getAtomCoordinateScratch();
        int[] anums = mol.getAtomNumbers();
        for (int i = 0; i < anums.length; ++i) {
            MolAtom a = m.getAtom(i);
            mol.askCoordinates(i);
            a.setXYZ(mc[0], mc[1], mc[2]);
        }
    }

    public static Molecule constructMolecule(Opt3D.MolCT mol) {
        Molecule m = new Molecule();
        int[] anums = mol.getAtomNumbers();
        double[] mc = mol.getAtomCoordinateScratch();
        for (int i = 0; i < anums.length; ++i) {
            MolAtom a = new MolAtom(anums[i]);
            mol.askCoordinates(i);
            a.setXYZ(mc[0], mc[1], mc[2]);
            m.add(a);
        }
        m.setDim(3);
        int[] bat1 = mol.getBAtom1();
        int[] bat2 = mol.getBAtom2();
        int[] bor = mol.getBondOrders();
        for (int i = 0; i < bat1.length; ++i) {
            MolBond b = new MolBond(m.getAtom(bat1[i]), m.getAtom(bat2[i]));
            switch (bor[i]) {
                case 2: {
                    b.setFlags(1);
                    break;
                }
                case 3: {
                    b.setFlags(4);
                    break;
                }
                case 4: {
                    b.setFlags(2);
                    break;
                }
                case 6: {
                    b.setFlags(3);
                }
            }
            m.add(b);
        }
        return m;
    }

    public static boolean isMolecule2D(Molecule m) {
        if (m.getDim() != 2) {
            return false;
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a1 = m.getAtom(i);
            for (int j = i + 1; j < m.getAtomCount(); ++j) {
                MolAtom a2 = m.getAtom(j);
                if (a1.getX() != a2.getX() || a1.getY() != a2.getY()) continue;
                return false;
            }
        }
        return true;
    }

    public Molecule getOriginalMolCopy() {
        if (this.originalM_copy == null) {
            Molecule m = new Molecule();
            if (this.originalM != null) {
                this.originalM.clonecopy(m);
            } else {
                m = myMolecule.constructMolecule(this);
            }
            this.originalM_copy = m;
        }
        return this.originalM_copy;
    }

    public Molecule get2DCleanedCopy() {
        if (this.originalM_2Dcleaned_copy == null) {
            this.originalM_2Dcleaned_copy = new Molecule();
            this.originalM = null;
            if (this.originalM != null) {
                this.originalM.clonecopy(this.originalM_2Dcleaned_copy);
            } else {
                this.originalM_2Dcleaned_copy = myMolecule.constructMolecule(this);
            }
            if (this.coordinatesFromOrig != null) {
                for (int i = 0; i < this.coordinatesFromOrig.length; ++i) {
                    MolAtom ma = this.originalM_2Dcleaned_copy.getAtom(i);
                    ma.setX(this.coordinatesFromOrig[i][0]);
                    ma.setY(this.coordinatesFromOrig[i][1]);
                    ma.setZ(this.coordinatesFromOrig[i][2]);
                }
            } else if (!myMolecule.isMolecule2D(this.originalM_2Dcleaned_copy)) {
                this.originalM_2Dcleaned_copy.clean(2, null);
            }
        }
        return this.originalM_2Dcleaned_copy;
    }

    public String get2DCleanedMolfileName() {
        if (this.saved2Dmolfilename == null) {
            Molecule m = this.get2DCleanedCopy();
            this.saved2Dmolfilename = Tracer.getNewID() + ".sdf";
            this.writeMolecule(m, this.saved2Dmolfilename);
        }
        return this.saved2Dmolfilename;
    }

    public CallbackIface get2DgetterCb() {
        if (this.get2Dcb == null) {
            this.get2Dcb = new CallbackIface(){

                @Override
                public Object callback(String method, Object arg) {
                    return myMolecule.this.get2DCleanedCopy();
                }
            };
        }
        return this.get2Dcb;
    }

    CallbackIface get2DfngetterCB() {
        if (this.get2DcbFname == null) {
            this.get2DcbFname = new CallbackIface(){

                @Override
                public Object callback(String method, Object arg) {
                    return myMolecule.this.get2DCleanedMolfileName();
                }
            };
        }
        return this.get2DcbFname;
    }

    public void placeJpeg() {
        Printouts.placeJpegs(this.get2DgetterCb(), null, null);
    }

    public void placeJpeg(String sel) {
        Printouts.placeJpegs(this.get2DgetterCb(), new String[]{sel}, null);
    }

    public void placeJpegs(String[] sel) {
        Printouts.placeJpegs(this.get2DgetterCb(), sel, null);
    }

    public void placeJpegs(String[] sel, String[] desc) {
        Printouts.placeJpegs(this.get2DgetterCb(), sel, desc);
    }

    public void placeApplet(String btnlabel) {
        Printouts.placeApplet(this.get2DfngetterCB(), btnlabel, null, null, 1, btnlabel);
    }

    public void placeApplet(String btnlabel, String sel) {
        Printouts.placeApplet(this.get2DfngetterCB(), btnlabel, null, new String[]{sel}, 1, btnlabel);
    }

    public void placeApplets(String btnlabel, String[] sel) {
        Printouts.placeApplet(this.get2DfngetterCB(), btnlabel, null, sel, sel.length, btnlabel);
    }

    public void placeApplets(String btnlabel, String[] sel, String[] desc) {
        Printouts.placeApplet(this.get2DfngetterCB(), btnlabel, desc, sel, sel.length, btnlabel);
    }

    public void place3DApplet(String btnlabel, double[][] coords) {
        this.place3DApplet(btnlabel, coords, null);
    }

    public void place3DApplet(String btnlabel, double[][] coords, String sel) {
        this.place3DApplets(btnlabel, new double[][][]{coords}, new String[]{sel});
    }

    public void place3DApplets(String btnlabel, final double[][] coord, String[] sel, final myMolecule othermol, final double[][] othercoord) {
        CallbackIface getter = new CallbackIface(){

            @Override
            public Object callback(String method, Object arg) {
                MolAtom a;
                int i;
                Molecule mthis = new Molecule();
                myMolecule.this.getOriginalMolCopy().clonecopy(mthis);
                Molecule moth = new Molecule();
                othermol.getOriginalMolCopy().clonecopy(moth);
                String[] s = new String[1];
                if (coord.length != mthis.getAtomCount()) {
                    System.err.println("Warning! Atom count != coordinate count");
                }
                if (othercoord.length != moth.getAtomCount()) {
                    System.err.println("Warning! Atom count != coordinate count");
                }
                for (i = 0; i < coord.length; ++i) {
                    a = mthis.getAtom(i);
                    a.setXYZ(coord[i][0], coord[i][1], coord[i][2]);
                }
                for (i = 0; i < othercoord.length; ++i) {
                    a = moth.getAtom(i);
                    a.setXYZ(othercoord[i][0], othercoord[i][1], othercoord[i][2]);
                    mthis.add(a);
                }
                for (i = 0; i < moth.getBondCount(); ++i) {
                    mthis.add(moth.getBond(i));
                }
                s[0] = Tracer.getNewID() + ".sdf";
                mthis.setDim(3);
                myMolecule.this.writeMolecule(mthis, s[0]);
                return s;
            }
        };
        Printouts.placeApplets(getter, null, null, sel, 1, btnlabel);
    }

    public void place3DApplets(String btnlabel, double[][][] coords, String[] sel) {
        this.place3DApplets(btnlabel, coords, sel, null);
    }

    public void place3DApplets(String btnlabel, final double[][][] coords, String[] sel, String[] desc) {
        CallbackIface getter = new CallbackIface(){

            @Override
            public Object callback(String method, Object arg) {
                Molecule m = new Molecule();
                myMolecule.this.getOriginalMolCopy().clonecopy(m);
                String[] s = new String[coords.length];
                for (int conf = 0; conf < coords.length; ++conf) {
                    double[][] coord = coords[conf];
                    if (coord.length != m.getAtomCount()) {
                        System.err.println("Warning! Atom count != coordinate count");
                    }
                    for (int i = 0; i < coord.length; ++i) {
                        MolAtom a = m.getAtom(i);
                        a.setXYZ(coord[i][0], coord[i][1], coord[i][2]);
                    }
                    s[conf] = Tracer.getNewID() + ".mrv";
                    m.setDim(3);
                    myMolecule.this.writeMolecule(m, "mrv", s[conf]);
                }
                return s;
            }
        };
        Printouts.placeApplets(getter, null, desc, sel, coords.length, btnlabel);
    }

    public void writeMolecule(Molecule m, String fmt, String fname) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("DEBUG/struc/" + fname, true));
            ps.print(m.toFormat(fmt));
            ps.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void writeMolecule(Molecule m, String fname) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("DEBUG/struc/" + fname, true));
            ps.print(m.toFormat("sdf"));
            ps.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String writeMoleculeApplet(Molecule m, debugPrintout debug, String sel, String btnl, String msg, CleanDebug.MolAppletRecorder rec) {
        boolean confCount = true;
        int rows = 1;
        int vrows = 1;
        int cols = 1;
        String prefix = CleanDebug.getNewStringID();
        debug.print("<script type=\"text/javascript\">\n");
        debug.print("<!--\n");
        debug.print("function NewWindow_" + prefix + "( ){\n");
        debug.print("    MyExample=window.open(\"../popup/" + prefix + ".html\",\"xname\",\"directories=no,location=no,menubar=no,resizable=yes,status=no,toolbar=no,scrollbars=yes,width=" + (300 * cols + 50) + ",height=" + (300 * vrows + 120) + "\");\n");
        debug.print("}\n");
        debug.print("// -->\n");
        debug.print("</script>\n");
        debug.print("<FORM>");
        debug.print("<input type=\"button\" value=\"" + btnl + "\" OnClick=\"NewWindow_" + prefix + "()\")\">");
        debug.print("</FORM>");
        debugPrintHTML ap = new debugPrintHTML("DEBUG/popup/" + prefix + ".html");
        String fname = prefix + "_conf.mol";
        msg = msg + " " + fname;
        ap.print("<CENTER>" + msg + "</CENTER><BR>");
        ap.print("<CENTER><applet CODEBASE=\"marvin\" ARCHIVE=\"marvin.jar\" CODE=\"MView\" WIDTH=" + (cols * 300 + 22) + " HEIGHT=" + (vrows * 300 + 42) + ">\n");
        ap.print("<param NAME=\"rows\" VALUE=\"" + rows + "\">\n");
        ap.print("<param NAME=\"border\" VALUE=\"1\">\n");
        ap.print("<param NAME=\"molbg\" VALUE=\"#000000\">\n");
        ap.print("<param NAME=\"cols\" VALUE=\"" + cols + "\">\n");
        ap.print("<param NAME=\"visibleRows\" VALUE=\"" + vrows + "\">\n");
        ap.print("<param NAME=\"implicitH\" VALUE=\"off\">\n");
        ap.print("<param NAME=\"navmode\" VALUE=\"rot3d\">\n");
        ap.print("<param NAME=\"atomNumbersVisible\" VALUE=\"true\">\n");
        ap.print("<param NAME=\"layout\" VALUE=\":2:1:M:1:0:1:1:L:0:0\">\n");
        ap.print("<param NAME=\"param\" VALUE=\":M:300:300:L:10\">\n");
        this.writeMolecule(m, fname);
        String desc = "descriptor string";
        if (rec != null) {
            rec.add(fname, sel, desc);
        }
        ap.print("<param NAME=\"cell0\" VALUE=\"|../struc/" + fname + "|" + desc + "\">\n");
        if (sel != null) {
            ap.print("<param NAME=\"selection0\" VALUE=\"" + sel + "\">\n");
        }
        ap.print("<strong>(YOU CANNOT SEE A JAVA APPLET HERE)</strong>\n");
        ap.print("</applet></CENTER>\n");
        ap.print("<CENTER><A HREF=\"javascript:self.close()\">Close this window</A></CENTER>");
        ap.close();
        return fname;
    }

    public static void printout(debugPrintout debug, Opt3D.MolCT mol) {
        debug.printBC("Molecule for force field");
        debug.printBC("Atoms");
        int[] anums = mol.getAtomNumbers();
        double[] mc = mol.getAtomCoordinateScratch();
        debug.printB("Atoms: " + anums.length);
        debug.Tstart();
        debug.Trow();
        debug.TprintBC(3, "Atoms");
        debug.Trow();
        debug.TprintBC("#");
        debug.TprintBC("Atomic number");
        debug.TprintBC(3, "Minkowski coordinates");
        for (int i = 0; i < anums.length; ++i) {
            debug.Trow();
            debug.TprintBC("" + i);
            debug.Tprint("" + anums[i]);
            mol.askCoordinates(i);
            for (int j = 0; j < mc.length; ++j) {
                debug.Tprint(debugPrintout.formatNumber(mc[j]));
            }
        }
        debug.Tstop();
        debug.printBC("Bonds");
        int[] bat1 = mol.getBAtom1();
        int[] bat2 = mol.getBAtom2();
        int[] bor = mol.getBondOrders();
        debug.printB("Bonds: " + bat1.length);
        debug.Tstart();
        debug.Trow();
        debug.TprintBC(4, "Bonds");
        debug.Trow();
        debug.TprintBC("#");
        debug.TprintBC("A1");
        debug.TprintBC("A2");
        debug.TprintBC("order");
        for (int i = 0; i < bat1.length; ++i) {
            debug.Trow();
            debug.TprintBC("" + i);
            debug.Tprint("" + bat1[i]);
            debug.Tprint("" + bat2[i]);
            debug.Tprint("" + bor[i]);
        }
        debug.Tstop();
    }

    public void printInnerCoordinates(debugPrintout debug, double[][] coord) {
        int i;
        if (debug == null || !debug.getWillPrint()) {
            return;
        }
        debug.printBC("Coordinates");
        debug.Tstart();
        debug.TprintBC("a");
        debug.TprintBC(3, "coordinates");
        for (i = 0; i < coord.length; ++i) {
            debug.Trow();
            debug.TprintBC("" + i);
            debug.TprintBC("" + TextUtils.formatNumber(coord[i][0]));
            debug.TprintBC("" + TextUtils.formatNumber(coord[i][1]));
            debug.TprintBC("" + TextUtils.formatNumber(coord[i][2]));
        }
        debug.Tstop();
        debug.printBC("Bond lengths");
        debug.Tstart();
        debug.Trow();
        debug.TprintBC("#");
        debug.TprintBC("a1");
        debug.TprintBC("a2");
        debug.TprintBC("length");
        debug.TprintBC("eqlength");
        for (i = 0; i < this.bat[0].length; ++i) {
            debug.Trow();
            debug.TprintBC("" + i);
            debug.TprintBC("" + this.bat[0][i]);
            debug.TprintBC("" + this.bat[1][i]);
            double l = V.vectLen(coord[this.bat[0][i]], coord[this.bat[1][i]]);
            debug.TprintC("" + TextUtils.formatNumber(l));
            debug.TprintC("" + TextUtils.formatNumber(this.blen[i]));
        }
        debug.Tstop();
        debug.printBC("Bond angles");
        debug.Tstart();
        debug.Trow();
        debug.TprintBC("#");
        debug.TprintBC("a1");
        debug.TprintBC("a2");
        debug.TprintBC("a3");
        debug.TprintBC("angle");
        debug.TprintBC("a2hyb");
        for (int a2 = 0; a2 < this.a; ++a2) {
            for (int i2 = 0; i2 < this.ctab[a2].length; ++i2) {
                int a1 = this.ctab[a2][i2];
                for (int j = i2 + 1; j < this.ctab[a2].length; ++j) {
                    int a3 = this.ctab[a2][j];
                    debug.Trow();
                    debug.TprintBC("" + i2);
                    debug.TprintBC("" + a1);
                    debug.TprintBC("" + a2);
                    debug.TprintBC("" + a3);
                    double an = V.angle(coord[a1], coord[a2], coord[a3], coord[a2]) * 180.0 / Math.PI;
                    debug.TprintC("" + TextUtils.formatNumber(an));
                    debug.TprintC(this.getHybridizationString(a2));
                }
            }
        }
        debug.Tstop();
    }

    public static void printInnerCoordinates(debugPrintout debug, Opt3D.MolCT mol) {
        debug.printBC("Molecule for force field inner coordinates");
        debug.printBC("Bond lengths");
        int[] bat1 = mol.getBAtom1();
        int[] bat2 = mol.getBAtom2();
        double[][] cs = mol.getAtomLocalCoordinateScratch();
        int[] ans = mol.getAtomNumberScratch();
        debug.Tstart();
        debug.Trow();
        debug.TprintBC("#");
        debug.TprintBC("a0");
        debug.TprintBC("a1");
        debug.TprintBC("length");
        for (int i = 0; i < bat1.length; ++i) {
            debug.Trow();
            debug.TprintBC("" + i);
            debug.TprintBC("" + bat1[i]);
            debug.TprintBC("" + bat2[i]);
            ans[0] = bat1[i];
            ans[1] = bat2[i];
            mol.askLocalCoordinates(2);
            double l = Math.sqrt(V.dot(V.minus(cs[0], cs[1])));
            debug.Tprint(debugPrintout.formatNumber(l));
        }
        debug.Tstop();
    }

    public String getHybridizationString(int i) {
        String hybr = (myMolecule.isSet(this.atomFlag[i], 2) ? "S" : "") + (myMolecule.isSet(this.atomFlag[i], 4) ? "SP" : "") + (myMolecule.isSet(this.atomFlag[i], 8) ? "SP2" : "") + (myMolecule.isSet(this.atomFlag[i], 16) ? "SP3" : "") + (myMolecule.isSet(this.atomFlag[i], 1) ? "UNKNOWN" : "???");
        return hybr;
    }

    public void printout(debugPrintout debug) {
        int a1;
        int i;
        debug.print("<CENTER><B>Atoms</B></CENTER>");
        debug.print("Atoms: " + this.a + "");
        debug.Tstart();
        debug.Trow();
        debug.TprintBC("No");
        debug.TprintBC("Grinv");
        debug.TprintBC("Coord");
        debug.TprintBC("At.Num");
        debug.TprintBC("ligcfg");
        debug.TprintBC("Hybr");
        debug.TprintBC("Lig.permutation");
        debug.TprintBC("Req.par.");
        debug.TprintBC("Classification");
        debug.TprintBC("Rings");
        debug.TprintBC("Ring projection");
        debug.TprintBC("Next/Prev ring a.");
        for (i = 0; i < this.a; ++i) {
            debug.Trow();
            debug.TprintBC("" + i);
            debug.TprintC("" + this.grinv[i]);
            String coords = "" + debugPrintout.formatNumber(this.coord[i][0]) + " " + debugPrintout.formatNumber(this.coord[i][1]) + " " + debugPrintout.formatNumber(this.coord[i][2]);
            debug.Tprint(coords);
            debug.Tprint("" + this.anum[i]);
            String ligcfg = "";
            switch (this.atomFlag[i] & 0xF80) {
                case 128: {
                    ligcfg = "L0";
                    break;
                }
                case 256: {
                    ligcfg = "L5";
                    break;
                }
                case 512: {
                    ligcfg = "L6";
                    break;
                }
                case 1024: {
                    ligcfg = "L8";
                    break;
                }
                case 2048: {
                    ligcfg = "L12";
                }
            }
            debug.TprintC(ligcfg);
            debug.TprintC(this.getHybridizationString(i));
            String lp = "-";
            if (this.ligandPermutation != null && this.ligandPermutation[i] != null) {
                lp = "";
                for (int j = 0; j < this.ligandPermutation[i].length; ++j) {
                    lp = lp + this.ligandPermutation[i][j] + " ";
                }
            }
            debug.TprintC(lp);
            debug.TprintC("-");
            String classif = "";
            switch (this.atomFlag[i] & 0x3000) {
                case 12288: {
                    classif = "inter-ring backbone";
                    break;
                }
                case 4096: {
                    classif = "chain atom";
                    break;
                }
                case 8192: {
                    classif = "ring atom";
                }
            }
            debug.TprintC(classif);
            debug.TprintC(this.rings == null ? "" : "" + this.rings[i]);
            String ringproj = "";
            String npra = "";
            if (this.atomToRing != null) {
                for (int j = 0; j < this.atomToRing[i].length; ++j) {
                    ringproj = ringproj + this.atomToRing[i][j] + " ";
                    npra = npra + "(" + this.atomToRingNextP[i][j] + "/" + this.atomToRingPrevP[i][j] + ") ";
                }
            }
            debug.TprintC(ringproj);
            debug.TprintC(npra);
        }
        debug.Tstop();
        debug.printBC("Forced bond angles");
        if (this.forcedAngleValue == null) {
            debug.printB("No forced value");
        } else {
            debug.Tstart();
            debug.Trow();
            debug.TprintBC(4, "All forced bond angles");
            debug.Trow();
            debug.TprintBC("a0");
            debug.TprintBC("a1");
            debug.TprintBC("a2");
            debug.TprintBC("a0-a1-a2");
            for (a1 = 0; a1 < this.forcedAngleValue.length; ++a1) {
                if (this.forcedAngleValue[a1] == null) continue;
                for (int i2 = 0; i2 < this.forcedAngleValue[a1].length; ++i2) {
                    debug.Trow();
                    debug.TprintBC("" + this.forcedAngleA0[a1][i2]);
                    debug.TprintBC("" + a1);
                    debug.TprintBC("" + this.forcedAngleA2[a1][i2]);
                    debug.TprintBC("" + this.forcedAngleValue[a1][i2]);
                }
            }
            debug.Tstop();
        }
        debug.Tstart();
        debug.Trow();
        debug.TprintBC(4, "All desired bond angles");
        debug.Trow();
        debug.TprintBC("a0");
        debug.TprintBC("a1");
        debug.TprintBC("a2");
        debug.TprintBC("a0-a1-a2");
        for (a1 = 0; a1 < this.a; ++a1) {
            for (int a0n = 0; a0n < this.ctab[a1].length; ++a0n) {
                int a0 = this.ctab[a1][a0n];
                for (int a2n = a0n + 1; a2n < this.ctab[a1].length; ++a2n) {
                    int a2 = this.ctab[a1][a2n];
                    debug.Trow();
                    debug.TprintBC("" + a0);
                    debug.TprintBC("" + a1);
                    debug.TprintBC("" + a2);
                    debug.TprintBC("" + this.getBangl(a0, a1, a2));
                }
            }
        }
        debug.Tstop();
        debug.print("<CENTER><B>BONDS</B></CENTER>");
        debug.print("Bonds: " + this.b + "");
        debug.print("<TABLE BORDER=1><TR><TD></TD><TD><B>A1</B></TD><TD><B>A2</B></TD><TD><B>Len</B></TD><TD><B>Type</B></TD><TD><B>Ring info</B></TD><TD><B>BondToRing</B></TD></TR>");
        for (i = 0; i < this.b; ++i) {
            String btr = "";
            if (this.bondToRing != null) {
                for (int j = 0; j < this.bondToRing[i].length; ++j) {
                    btr = btr + " " + this.bondToRing[i][j];
                }
            }
            debug.print("<TR><TD><B>" + i + "</B></TD><TD>" + this.bat[0][i] + "</TD><TD>" + this.bat[1][i] + "</TD><TD>" + (this.blen == null ? "N/A" : "" + this.blen[i]) + "</TD><TD>" + (myMolecule.isSet(this.bdesc[i], 1) ? "1x" : "") + (myMolecule.isSet(this.bdesc[i], 2) ? "2x" : "") + (myMolecule.isSet(this.bdesc[i], 4) ? "3x" : "") + (myMolecule.isSet(this.bdesc[i], 8) ? "Ar" : "") + (myMolecule.isSet(this.bdesc[i], 16) ? "?" : "") + "</TD><TD>" + (myMolecule.isSet(this.bdesc[i], myMoleculeConstants.B_R_INRING) ? "InRing " : "") + (myMolecule.isSet(this.bdesc[i], myMoleculeConstants.B_R_INSMALLRING) ? "InSmallRing " : "") + (myMolecule.isSet(this.bdesc[i], myMoleculeConstants.B_R_INMEDIUMRING) ? "InMediumRing " : "") + "</TD><TD>" + btr + "</TD></TR>");
        }
        debug.print("</TABLE>");
        debug.print("<CENTER><B>CTAB and BLIST</B></CENTER>");
        debug.print("<TABLE BORDER=1><TR><TD><B>Atom</B></TD><TD><B>Connected atoms</B></TD><TD><B>Connected bonds</B></TD></TR>");
        for (i = 0; i < this.ctab.length; ++i) {
            int j;
            debug.print("<TR><TD><B>" + i + "</B></TD><TD>");
            for (j = 0; j < this.ctab[i].length; ++j) {
                debug.print(this.ctab[i][j] + (j < this.ctab[i].length - 1 ? ", " : ""));
            }
            debug.print("</TD><TD>");
            for (j = 0; j < this.blist[i].length; ++j) {
                debug.print(this.blist[i][j] + (j < this.blist[i].length - 1 ? ", " : ""));
            }
            debug.print("</TD></TR>");
        }
        debug.print("</TABLE>");
        debug.print("<CENTER><B>RINGS</B></CENTER>");
        if (this.SSSR == null) {
            debug.println("N/A");
        } else {
            debug.print("Rings: " + this.SSSR.length + "");
            debug.print("<TABLE BORDER=1><TR><TD></TD><TD><B>Atoms</B></TD><TD><B>Flags</B></TD></TR>");
            for (i = 0; i < this.SSSR.length; ++i) {
                String rflags = "";
                if (this.ringflags != null) {
                    if ((this.ringflags[i] & myMoleculeConstants.R_AROMATIC) != 0) {
                        rflags = "AROMATIC";
                    }
                    if ((this.ringflags[i] & 2) != 0) {
                        rflags = rflags + "SMALL";
                    }
                }
                debug.print("<TR><TD><B>" + i + "</B></TD><TD>");
                for (int j = 0; j < this.SSSR[i].length; ++j) {
                    debug.print(this.SSSR[i][j] + (j < this.SSSR[i].length - 1 ? ", " : ""));
                }
                debug.print("</TD><TD>" + rflags + "</TD></TR>");
            }
            debug.print("</TABLE>");
        }
        debug.printB("Atom projection table:");
        debug.printVector(this.atomProjection);
        debug.print("<CENTER><B>Fused ring sets:</B></CENTER>");
        if (this.ringSet == null) {
            debug.println("N/A");
        } else {
            debug.print("Ring sets: " + this.ringSet.length + "");
            debug.print("<TABLE BORDER=1><TR><TD></TD><TD><B>Rings</B></TD></TR>");
            for (i = 0; i < this.ringSet.length; ++i) {
                debug.print("<TR><TD><B>" + i + "</B></TD><TD>");
                for (int j = 0; j < this.ringSet[i].length; ++j) {
                    debug.print(this.ringSet[i][j] + (j < this.ringSet[i].length - 1 ? ", " : ""));
                }
                debug.print("</TD></TR>");
            }
            debug.print("</TABLE>");
        }
        debug.print("<CENTER><B>Atom-Atom to bond association</B></CENTER>");
        debug.print("<TABLE BORDER=1>");
        debug.print("<TR><TD></TD><TD>");
        for (i = 0; i < this.a; ++i) {
            debug.print("<TD><B>" + i + "</B></TD>");
        }
        debug.print("</TR>");
        for (i = 0; i < this.a; ++i) {
            debug.print("<TR><TD><B>" + i + "</B></TD><TD>");
            for (int j = 0; j < this.a; ++j) {
                debug.print("<TD>" + (this.bonds[i][j] == -1 ? (i % 10 == 0 || j % 10 == 0 ? "&nbsp;" : "") : this.bonds[i][j] + "") + "</TD>");
            }
            debug.print("</TD></TR>");
        }
        debug.print("</TABLE>");
    }
}

