/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.util.U;

public class IntSetArray {
    int[] storage;
    public static final int ALLOCATEDSIZE = 0;
    public static final int SETCOUNT = 1;
    public static final int STOREDELEMENTSCOUNT = 2;
    public static final int ELEMENTSRANGE = 3;
    public static final int SETALLOCATEDSIZEINDEXSTART = 4;
    public static final int SETUSEDSIZEINDEXSTART = 5;
    public static final int SETSTOREINDEXSTART = 6;
    public static final int SETREVERSEINDEXARRAYSTART = 7;
    public static final int SETSTORESIZE = 8;
    public static final int SETSTORESTART = 9;
    public static final int DESCRIPTORCOUNT = 10;

    public IntSetArray(int setCount, int sizeSum, int elementsRange) {
        this.storage = IntSetArray.init(setCount, sizeSum, elementsRange);
    }

    public IntSetArray(int[] setSizes, int elementsRange) {
        int setCount = setSizes.length;
        int sizeSum = U.sum(setSizes);
        this.storage = IntSetArray.init(setCount, sizeSum, elementsRange);
        IntSetArray.format(this.storage, setSizes);
    }

    public IntSetArray(int[][] sets) {
        int setCount = sets.length;
        int sizeSum = U.countLengths(sets);
        int elementsRange = U.max(sets) + 1;
        this.storage = IntSetArray.init(setCount, sizeSum, elementsRange);
        IntSetArray.format(this.storage, sets);
    }

    static void format(int[] storage, int[][] setElements) {
        int reverseindex;
        int i;
        if (setElements.length != storage[1]) {
            throw new IndexOutOfBoundsException("SetCount mismatch");
        }
        if (U.countLengths(setElements) < storage[8]) {
            throw new IndexOutOfBoundsException("Set store size mismatch");
        }
        int setallocatedsize = storage[4];
        int setusedsizeindex = storage[5];
        int setstoreindex = storage[6];
        int store = storage[9];
        for (i = reverseindex = storage[7]; i < storage.length; ++i) {
            storage[i] = -1;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Init here", IntSetArray.toHTMLString(storage));
        }
        for (i = 0; i < setElements.length; ++i) {
            storage[setallocatedsize++] = setElements[i].length;
            storage[setusedsizeindex++] = setElements[i].length;
            storage[setstoreindex++] = store;
            for (int j = 0; j < setElements[i].length; ++j) {
                storage[store++] = setElements[i][j];
                storage[reverseindex + 2 * setElements[i][j]] = i;
                storage[reverseindex + 2 * setElements[i][j] + 1] = j;
            }
        }
    }

    static void format(int[] storage, int[] setSizes) {
        int reverseindex;
        if (setSizes.length != storage[1]) {
            throw new IndexOutOfBoundsException("SetCount mismatch");
        }
        if (U.sum(setSizes) < storage[8]) {
            throw new IndexOutOfBoundsException("Set store size mismatch");
        }
        for (int i = reverseindex = storage[7]; i < storage.length; ++i) {
            storage[i] = -1;
        }
        int setallocatedsize = storage[4];
        int setusedsizeindex = storage[5];
        int setstoreindex = storage[6];
        int store = storage[9];
        for (int i = 0; i < setSizes.length; ++i) {
            storage[setallocatedsize++] = setSizes[i];
            storage[setusedsizeindex++] = 0;
            storage[setstoreindex++] = store;
            store += setSizes[i];
        }
    }

    static int[] init(int setCount, int sizeSum, int elementsRange) {
        int ff;
        int siz = 10 + 3 * setCount + sizeSum + 2 * elementsRange;
        int[] news = new int[siz];
        news[0] = news.length;
        news[2] = 0;
        news[1] = setCount;
        news[3] = elementsRange;
        news[8] = sizeSum;
        news[4] = ff = 10;
        news[5] = ff += setCount;
        news[6] = ff += setCount;
        news[9] = ff += setCount;
        news[7] = ff += sizeSum;
        return news;
    }

    public static int getSetCount(int[] storage) {
        return storage[1];
    }

    public static int getSize(int[] storage) {
        return storage[2];
    }

    public int getSetCount() {
        return this.storage[1];
    }

    public int getSize() {
        return this.storage[2];
    }

    public int getSetSize(int setNo) {
        if (setNo < 0 || setNo >= this.getSetCount()) {
            throw new IndexOutOfBoundsException("Invalid setNo " + setNo);
        }
        return this.storage[this.storage[5] + setNo];
    }

    public static int getSetSize(int[] storage, int setNo) {
        if (setNo < 0 || setNo >= IntSetArray.getSetCount(storage)) {
            throw new IndexOutOfBoundsException("Invalid setNo " + setNo);
        }
        return storage[storage[5] + setNo];
    }

    public int getSet(int item) {
        if (item < 0 || item >= this.storage[3]) {
            return -1;
        }
        return this.storage[this.storage[7] + (item << 1)];
    }

    public boolean contains(int item) {
        if (item < 0 || item >= this.storage[3]) {
            return false;
        }
        return this.storage[this.storage[7] + (item << 1)] >= 0;
    }

    public boolean contains(int setNo, int item) {
        if (item < 0 || item >= this.storage[3]) {
            return false;
        }
        return this.storage[this.storage[7] + (item << 1)] == setNo;
    }

    public boolean containsInOneSet(int[] a) {
        int s = this.getSet(a[0]);
        if (s < 0) {
            return false;
        }
        for (int i = 1; i < a.length; ++i) {
            if (s == this.getSet(a[i])) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!this.contains(a[i])) continue;
            return true;
        }
        return false;
    }

    public void add(int setNo, int[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.add(setNo, items[i]);
        }
    }

    public void add(int[][] items) {
        for (int i = 0; i < items.length; ++i) {
            this.add(i, items[i]);
        }
    }

    public void add(int setNo, int item) {
        if (this.contains(item)) {
            throw new IndexOutOfBoundsException("Item already stored " + item);
        }
        if (setNo < 0 || setNo > this.getSetCount()) {
            throw new IndexOutOfBoundsException("Invalid setNo " + setNo);
        }
        int ai = this.storage[4] + setNo;
        int ui = this.storage[5] + setNo;
        int fi = this.storage[this.storage[6] + setNo];
        if (this.storage[ai] == this.storage[ui]) {
            throw new IndexOutOfBoundsException("Set full.");
        }
        if (this.storage[ai] < this.storage[ui]) {
            throw new IndexOutOfBoundsException("Consystency error in set store");
        }
        if (item >= this.storage[3]) {
            throw new IndexOutOfBoundsException("Item range " + item);
        }
        int ri = this.storage[7] + (item << 1);
        this.storage[ri] = setNo;
        this.storage[ri + 1] = this.storage[ui];
        this.storage[fi + this.storage[ui]] = item;
        int n = ui;
        this.storage[n] = this.storage[n] + 1;
        this.storage[2] = this.storage[2] + 1;
    }

    public int getMaxSetSize() {
        int ret = 0;
        for (int i = 0; i < this.getSetCount(); ++i) {
            if (this.getSetSize(i) <= ret) continue;
            ret = this.getMaxSetSize();
        }
        return ret;
    }

    public int[][] get() {
        int[][] ret = new int[this.getSetCount()][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.get(i);
        }
        return ret;
    }

    public int[] get(int setNo) {
        int[] ret = new int[this.getSetSize(setNo)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.get(setNo, i);
        }
        return ret;
    }

    public int get(int setNo, int itemNo) {
        int ss = this.getSetSize(setNo);
        if (itemNo < 0 || itemNo >= ss) {
            throw new IndexOutOfBoundsException("Invalid itemNo " + itemNo);
        }
        return this.storage[this.storage[this.storage[6] + setNo] + itemNo];
    }

    public static int get(int[] storage, int setNo, int itemNo) {
        int ss = IntSetArray.getSetSize(storage, setNo);
        if (itemNo < 0 || itemNo >= ss) {
            throw new IndexOutOfBoundsException("Invalid itemNo " + itemNo);
        }
        return storage[storage[storage[6] + setNo] + itemNo];
    }

    public String toSimpleString() {
        int siz = Math.max(30, this.storage[2] * 5);
        StringBuffer ret = new StringBuffer(siz);
        for (int i = 0; i < this.getSetCount(); ++i) {
            if (i != 0) {
                ret.append(" ");
            }
            ret.append(i);
            ret.append(": { ");
            for (int j = 0; j < this.getSetSize(i); ++j) {
                if (j != 0) {
                    ret.append(", ");
                }
                ret.append(this.get(i, j));
                ret.append(" ");
            }
            ret.append("}");
        }
        return ret.toString();
    }

    static String toHTMLString(int[] storage) {
        int i;
        int siz = Math.max(50, storage[2] * 15);
        StringBuffer ret = new StringBuffer(siz);
        ret.append("<TABLE><TR><TD><CENTER><B>Set</B></CENTER></TD><TD><B>Items</B></TD></TR>");
        for (i = 0; i < IntSetArray.getSetCount(storage); ++i) {
            ret.append("<TR><TD><CENER><B>");
            ret.append(i);
            ret.append("</B></CENTER></TD>");
            int ss = IntSetArray.getSetSize(storage, i);
            if (ss == 0) {
                ret.append("<TD>EMPTY</TD>");
            } else {
                ret.append("<TD>");
                for (int j = 0; j < ss; ++j) {
                    if (j > 0) {
                        ret.append(",");
                    }
                    ret.append(IntSetArray.get(storage, i, j));
                }
                ret.append("</TD>");
            }
            ret.append("</TR>");
        }
        ret.append("</TABLE><BR>");
        ret.append("Allocated: " + storage[0] + "<BR>");
        ret.append("Set count: " + storage[1] + "<BR>");
        ret.append("Elements range: " + storage[3] + "<BR>");
        ret.append("StoredElementsCount: " + storage[2] + "<BR>");
        ret.append("SetStoreSize: " + storage[8] + "<BR>");
        ret.append("SetAllocatedSizeIndexStart: " + storage[4] + "<BR>");
        ret.append("SetUsedSizeIndexStart: " + storage[5] + "<BR>");
        ret.append("SetStoreIndexStart: " + storage[6] + "<BR>");
        ret.append("SetStoreStart: " + storage[9] + "<BR>");
        ret.append("Set reverse index start: " + storage[7] + "<BR>");
        ret.append("<TABLE border=1 cols=11><TR><TD></TD>");
        for (i = 0; i < 10; ++i) {
            ret.append("<TD><B><CENTER>" + i + "</CENTER></B></TD>");
        }
        ret.append("</TR>");
        int c = 0;
        while (c < storage.length) {
            ret.append("<TR><TD><B><CENTER>+" + c + "</CENTER></B></TD>");
            for (int i2 = 0; i2 < 10; ++i2) {
                if (c < storage.length) {
                    ret.append("<TD>" + storage[c++] + "</TD>");
                    continue;
                }
                ret.append("<TD>---</TD>");
            }
            ret.append("</TR>");
        }
        ret.append("</TABLE>");
        return ret.toString();
    }

    public String toHTMLString() {
        return IntSetArray.toHTMLString(this.storage);
    }

    public boolean equals(IntSetArray a) {
        if (a.getSize() != this.getSize()) {
            return false;
        }
        if (a.getSetCount() != this.getSetCount()) {
            return false;
        }
        for (int i = 0; i < this.getSetCount(); ++i) {
            if (a.getSetSize(i) != this.getSetSize(i)) {
                return false;
            }
            for (int j = 0; j < this.getSetSize(i); ++j) {
                if (a.contains(i, this.get(i, j))) continue;
                return false;
            }
        }
        return true;
    }
}

