/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.modelling.util.Canceller;
import chemaxon.marvin.modelling.util.IntegerBuffer;
import chemaxon.marvin.modelling.util.ProgressMonitor;

public class ProgressTools {
    public static ProgressMonitor[] forkPM(ProgressMonitor root, double[] weights, double[] initialPart) {
        int i;
        double[] w_norm = new double[weights.length];
        double min = weights[0];
        for (i = 0; i < weights.length; ++i) {
            if (!(weights[i] < min)) continue;
            min = weights[i];
        }
        if (min == 0.0) {
            min = 1.0;
        }
        for (i = 0; i < weights.length; ++i) {
            w_norm[i] = weights[i] / min;
        }
        final ForkProgressMonitorRoot froot = new ForkProgressMonitorRoot(root, w_norm.length, weights, initialPart);
        final IntegerBuffer ibuf = new IntegerBuffer();
        ProgressMonitor[] ret = new ProgressMonitor[froot.forks];
        ibuf.v = 0;
        while (ibuf.v < ret.length) {
            ret[ibuf.v] = new ProgressMonitor(){
                int selfIndex;
                {
                    this.selfIndex = ibuf.v;
                }

                @Override
                public void init(int maxValue) {
                    froot.initCallback(this.selfIndex, maxValue);
                }

                @Override
                public void set(int value) {
                    froot.setCallback(this.selfIndex, value);
                }

                @Override
                public void close() {
                    froot.closeCallback(this.selfIndex);
                }
            };
            ++ibuf.v;
        }
        return ret;
    }

    public static ProgressMonitor encapsulateResetablePM(ProgressMonitor pm) {
        return ProgressTools.forkPM(pm, new double[]{1.0}, new double[]{0.5})[0];
    }

    static class ForkProgressMonitorRoot {
        public static final int MAXFORROOT = 10000000;
        int forks = 0;
        ProgressMonitor rootm = null;
        double[] weights;
        double[] allocPart;
        int rootstate = 0;
        int rootinitvalue = 0;
        int[] state;
        int[] maxInit;
        int[] lastZero;
        int[] lastMax;
        int[] lastCalc;
        int[] lastInit;
        int[] lastSet;
        boolean rootinited = false;
        boolean printDebug = false;

        void printoutState(int index) {
            System.err.println("          index=" + index + "   state=" + this.state[index] + " wights=" + this.weights[index] + " allocPart=" + this.allocPart[index]);
            System.err.println("              last0=" + this.lastZero[index] + " lastC=" + this.lastCalc[index] + " lastMax=" + this.lastMax[index]);
            System.err.println("              lastSet=" + this.lastSet[index] + " lastInit=" + this.lastInit[index]);
        }

        public ForkProgressMonitorRoot(ProgressMonitor root, int forks, double[] weights, double[] initialPart) {
            this.forks = forks;
            this.rootm = root;
            if (initialPart == null) {
                initialPart = new double[forks];
                for (int i = 0; i < forks; ++i) {
                    if (weights[i] <= 0.0) {
                        weights[i] = 1.0;
                    }
                    if (!(initialPart[i] <= 0.0) && !(initialPart[i] > 1.0)) continue;
                    initialPart[i] = 0.5;
                }
            }
            this.weights = weights == null ? new double[forks] : weights;
            this.allocPart = initialPart == null ? new double[forks] : initialPart;
            this.state = new int[forks];
            this.maxInit = new int[forks];
            this.lastInit = new int[forks];
            this.lastSet = new int[forks];
            this.lastZero = new int[forks];
            this.lastMax = new int[forks];
            this.lastCalc = new int[forks];
        }

        void initCallback(int index, int max) {
            if (this.printDebug) {
                System.err.println("Init[" + index + "] with max=" + max);
                this.printoutState(index);
            }
            block0 : switch (this.rootstate) {
                case 0: {
                    switch (this.state[index]) {
                        case 0: {
                            this.lastInit[index] = max;
                            this.state[index] = 1;
                            double wsum = 0.0;
                            for (int i = 0; i < this.forks; ++i) {
                                wsum += this.weights[i];
                            }
                            int maxInitsSum = 0;
                            for (int i = 0; i < this.forks; ++i) {
                                this.maxInit[i] = (int)(1.0E7 * this.weights[i] / wsum);
                                maxInitsSum += this.maxInit[i];
                            }
                            this.lastZero[index] = 0;
                            this.lastSet[index] = 0;
                            this.lastCalc[index] = 0;
                            this.lastMax[index] = (int)(((double)this.maxInit[index] - (double)this.lastZero[index]) * this.allocPart[index] + (double)this.lastZero[index]);
                            this.rootinitvalue = maxInitsSum;
                            this.rootm.init(this.rootinitvalue);
                            this.rootstate = 1;
                            break;
                        }
                        case 1: {
                            this.lastInit[index] = max;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.state[index]) {
                        case 1: {
                            this.lastZero[index] = this.lastCalc[index];
                            this.lastSet[index] = 0;
                            this.lastMax[index] = (int)(((double)this.maxInit[index] - (double)this.lastZero[index]) * this.allocPart[index] + (double)this.lastZero[index]);
                            this.lastInit[index] = max;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        void closeCallback(int index) {
            if (this.printDebug) {
                System.err.println("Close[" + index + "]");
                this.printoutState(index);
            }
            this.setCallback(index, this.lastInit[index]);
        }

        void setCallback(int index, int value) {
            if (this.printDebug) {
                System.err.println("Set[" + index + "] to=" + value);
                this.printoutState(index);
            }
            switch (this.rootstate) {
                case 0: {
                    if (this.printDebug) {
                        System.err.println("    root not inited");
                    }
                    return;
                }
                case 1: {
                    int i;
                    if (this.state[index] == 2) {
                        if (this.printDebug) {
                            System.err.println("    item reached max");
                        }
                        return;
                    }
                    if (value < this.lastSet[index]) {
                        if (this.printDebug) {
                            System.err.println("    try to set smaller");
                        }
                        return;
                    }
                    if (value >= this.lastInit[index]) {
                        this.state[index] = 2;
                        this.lastCalc[index] = this.maxInit[index];
                        boolean allmax = true;
                        for (i = 0; i < this.forks; ++i) {
                            if (this.state[i] == 2) continue;
                            allmax = false;
                            break;
                        }
                        if (allmax) {
                            this.rootstate = 2;
                        }
                    } else {
                        int newlc;
                        double li = this.lastInit[index];
                        if (li == 0.0) {
                            li = 1.0;
                        }
                        if ((newlc = this.lastZero[index] + (int)(((double)this.lastMax[index] - (double)this.lastZero[index]) * (double)value / li)) >= this.lastCalc[index] && newlc <= this.lastMax[index]) {
                            this.lastCalc[index] = newlc;
                        }
                    }
                    int newset = 0;
                    for (i = 0; i < this.forks; ++i) {
                        newset += this.lastCalc[i];
                    }
                    this.rootm.set(newset);
                    break;
                }
                case 2: {
                    if (this.printDebug) {
                        System.err.println("    root reached max");
                    }
                    return;
                }
            }
        }
    }

    public static class MProgressMonitorHolder
    implements ProgressMonitor {
        private MProgressMonitor pmon;
        private String initString;
        private int initvalue;
        private boolean inited = false;
        private int lastSetValue;
        private Canceller canceller;
        private boolean printDebugs = false;

        public MProgressMonitorHolder(MProgressMonitor pmon, String s, Canceller c) {
            this.pmon = pmon;
            this.initString = s;
            this.canceller = c;
        }

        public void printDebugs() {
            this.printDebugs = true;
        }

        @Override
        public void close() {
            if (this.inited) {
                this.set(this.initvalue);
            }
        }

        @Override
        public void init(int maxValue) {
            if (!this.inited) {
                if (this.printDebugs) {
                    System.err.println("MProgressMonitor inited with max=" + maxValue);
                }
                this.inited = true;
                this.initvalue = maxValue;
                this.pmon.initProgressMonitor(this.initString, 0, maxValue);
            } else if (this.printDebugs) {
                System.err.println("MProgressMonitor reinit atempted.");
            }
        }

        @Override
        public void set(int value) {
            if (value >= this.lastSetValue) {
                if (value > this.initvalue) {
                    value = this.initvalue;
                }
                boolean b = this.pmon.setProgressValue(value);
                this.lastSetValue = value;
                if (this.printDebugs) {
                    System.err.println("MProgressMonitor set to " + value);
                }
                if (!b && this.canceller != null) {
                    this.canceller.set();
                    if (this.printDebugs) {
                        System.err.println("MProgressMonitor cancel signed");
                    }
                }
            } else if (this.printDebugs) {
                System.err.println("MProgressMonitor invalid set attempted.");
            }
        }
    }
}

