/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

public class Stopper {
    private long startTime = -1L;
    private int startedMultiplicity = 0;
    private long elapsedTime = 0L;
    private String label = null;

    private synchronized void adjust(int dmult) {
        long tnow = System.currentTimeMillis();
        if (this.startedMultiplicity > 0) {
            this.elapsedTime += (long)this.startedMultiplicity * (tnow - this.startTime);
        }
        this.startedMultiplicity += dmult;
        if (this.startedMultiplicity > 0) {
            this.startTime = tnow;
        } else if (this.startedMultiplicity < 0) {
            throw new UnsupportedOperationException("Multiple stop request");
        }
        if (this.startedMultiplicity > 1) {
            throw new UnsupportedOperationException("Multiple start request");
        }
    }

    public boolean isStartInvoked() {
        return this.startTime >= 0L;
    }

    public void start() {
        this.adjust(1);
    }

    public Stopper() {
        this.start();
    }

    public Stopper(boolean start, String label) {
        if (start) {
            this.start();
        }
        this.label = label;
    }

    public long stop() {
        this.adjust(-1);
        return this.elapsedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String toString() {
        return Long.toString(this.getElapsedTime());
    }

    public String getLabel() {
        return this.label;
    }
}

