/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import chemaxon.marvin.modelling.util.MoleculeWithExtraProperties;
import chemaxon.struc.Molecule;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.GuardedObject;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class StringConversionUtility {
    public static final String ENCAPSULATOR = "MoleculeEncapsulator";

    public static String toString(GuardedObject go) {
        Object o = go.getObject();
        StringBuffer output = new StringBuffer();
        Class<?> c = o.getClass();
        String[] fieldNames = new String[c.getDeclaredFields().length];
        for (int i = 0; i < fieldNames.length; ++i) {
            Field f = c.getDeclaredFields()[i];
            if (f.getName().equals("this$0")) continue;
            fieldNames[i] = f.getName();
            output.append(">F " + fieldNames[i] + "\n");
            try {
                f.setAccessible(true);
                if (f.isAccessible()) {
                    Object po = f.get(o);
                    output.append(StringConversionUtility.itemToString(po) + "\n");
                    continue;
                }
                System.err.println(c.getName() + "." + fieldNames[i] + " is not accessible.");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return output.toString();
    }

    public static String itemToString(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuffer output = new StringBuffer();
        Class<?> c = o.getClass();
        if (c.isArray()) {
            output.append(c.getName());
            output.append("\n{\n");
            int length = Array.getLength(o);
            Class<?> itemType = c.getComponentType();
            if (itemType.isPrimitive()) {
                for (int i = 0; i < length; ++i) {
                    output.append(" " + Array.get(o, i).toString());
                }
                output.append("\n");
            } else {
                for (int i = 0; i < length; ++i) {
                    output.append(StringConversionUtility.itemToString(Array.get(o, i)));
                }
            }
            output.append("}\n");
        } else {
            String className = c.getName();
            output.append(className);
            output.append("\n{\n");
            if (className.equals(Molecule.class.getName())) {
                output.append(new MoleculeWithExtraProperties((Molecule)o).toString());
                output.append("\n");
            } else if (className.equals(BitSet.class.getName())) {
                output.append(StringConversionUtility.bitSetToString((BitSet)o));
                output.append("\n");
            } else {
                output.append(o.toString());
                output.append("\n");
            }
            output.append("}\n");
        }
        return output.toString();
    }

    public static String getStringBlock(StringTokenizer st) {
        int iDepth = 0;
        StringBuffer objectString = new StringBuffer();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (iDepth == 0 && !line.equals("{")) {
                objectString.append(line);
                while (st.hasMoreTokens()) {
                    line = st.nextToken();
                    if (line.length() == 0) continue;
                    objectString.append("\n" + line);
                }
                return objectString.toString();
            }
            if (line.length() == 0) continue;
            if (line.equals("}")) {
                --iDepth;
            }
            if (iDepth > 0) {
                if (objectString.length() == 0) {
                    objectString.append(line);
                } else {
                    objectString.append("\n" + line);
                }
            }
            if (line.equals("{")) {
                ++iDepth;
            }
            if (iDepth != 0) continue;
            return objectString.toString();
        }
        return objectString.toString();
    }

    private static Object arrayFromString(Class arrayClass, String s) {
        Class<?> componentType = arrayClass.getComponentType();
        Object o = null;
        if (componentType.isPrimitive()) {
            StringTokenizer st = null;
            st = s.length() > 1 ? new StringTokenizer(s.substring(1), " \n") : new StringTokenizer("", " \n");
            int length = st.countTokens();
            o = Array.newInstance(componentType, length);
            if (length > 1) {
                try {
                    Class<?> parserType = Array.get(o, 0).getClass();
                    Constructor<?> co = parserType.getConstructor(String.class);
                    for (int i = 0; i < length; ++i) {
                        Array.set(o, i, co.newInstance(st.nextToken()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return o;
        }
        StringTokenizer st = new StringTokenizer(s, "\n");
        Vector<Object> v = new Vector<Object>();
        Class<?> c = null;
        while (st.hasMoreTokens()) {
            String className = st.nextToken();
            c = null;
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            String data = StringConversionUtility.getStringBlock(st);
            if (c == null) continue;
            Object oItem = null;
            oItem = c.isArray() ? StringConversionUtility.arrayFromString(c, data) : StringConversionUtility.fromString(className, data);
            v.addElement(oItem);
        }
        o = Array.newInstance(componentType, v.size());
        for (int i = 0; i < v.size(); ++i) {
            Array.set(o, i, v.elementAt(i));
        }
        return o;
    }

    public static Object fromString(GuardedObject go, String s) {
        Object o = go.getObject();
        Class<?> c = o.getClass();
        if (c.isArray()) {
            return StringConversionUtility.arrayFromString(c, s);
        }
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            Object oField;
            String fieldName;
            block10: {
                String data;
                fieldName = StringConversionUtility.getFieldNameFromString(st.nextToken());
                String className = st.nextToken();
                oField = null;
                if (!className.equals("null") && !(data = StringConversionUtility.getStringBlock(st)).equals("null")) {
                    try {
                        Class<?> fClass = Class.forName(className);
                        if (fClass.isArray()) {
                            oField = StringConversionUtility.arrayFromString(fClass, data);
                            break block10;
                        }
                        if (className.equals(Molecule.class.getName())) {
                            MoleculeWithExtraProperties m = new MoleculeWithExtraProperties(data);
                            oField = m;
                            break block10;
                        }
                        if (className.equals(BitSet.class.getName())) {
                            oField = StringConversionUtility.bitSetFromString(data);
                            break block10;
                        }
                        Class[] parameterTypes = new Class[]{String.class};
                        Constructor<?> co = fClass.getConstructor(parameterTypes);
                        if (co == null) break block10;
                        Object[] initargs = new Object[]{data};
                        oField = co.newInstance(initargs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Data:\n" + data);
                        continue;
                    }
                }
            }
            Field f = null;
            try {
                f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                if (!f.isAccessible()) continue;
                f.set(o, oField);
            }
            catch (Exception e) {}
        }
        return o;
    }

    public static Object fromString(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        String className = st.nextToken();
        String data = StringConversionUtility.getStringBlock(st);
        return StringConversionUtility.fromString(className, data);
    }

    public static Object fromString(String className, String s) {
        if (className.equals("null")) {
            return null;
        }
        if (className.equals(Molecule.class.getName())) {
            return new MoleculeWithExtraProperties(s);
        }
        if (className.equals(BitSet.class.getName())) {
            return StringConversionUtility.bitSetFromString(s);
        }
        StringTokenizer st = new StringTokenizer(s, "\n");
        Object o = null;
        String data = StringConversionUtility.getStringBlock(st);
        try {
            Class<?> c = Class.forName(className);
            if (c.isArray()) {
                o = StringConversionUtility.arrayFromString(c, data);
            } else {
                Class[] parameterTypes = new Class[]{String.class};
                Constructor<?> co = c.getDeclaredConstructor(parameterTypes);
                if (co != null) {
                    Object[] initargs = new Object[]{data};
                    o = co.newInstance(initargs);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }

    private static String getFieldNameFromString(String fieldNameString) {
        if (fieldNameString.indexOf(">F ") == 0) {
            return fieldNameString.substring(3);
        }
        return null;
    }

    public static String bitSetToString(BitSet b) {
        String res = new String();
        for (int i = 0; i < b.length(); ++i) {
            res = b.get(i) ? res + "1" : res + "0";
        }
        return res;
    }

    public static BitSet bitSetFromString(String data) {
        BitSet b = new BitSet(data.length());
        for (int i = 0; i < data.length(); ++i) {
            if (!data.substring(i, i + 1).equals("1")) continue;
            b.set(i);
        }
        return b;
    }
}

