/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.util;

import chemaxon.marvin.util.CallbackIface;
import java.util.LinkedList;

public class WorkQueue {
    private LinkedList q = new LinkedList();
    private int wtc = 0;
    private int state = 0;

    public WorkQueue(int workerThreadCount) {
        this.wtc = workerThreadCount;
    }

    public WorkQueue() {
    }

    synchronized CallbackIface getNextWork() {
        if (this.q.isEmpty()) {
            return null;
        }
        return (CallbackIface)this.q.removeFirst();
    }

    public void addWork(CallbackIface work) {
        if (this.state == 1) {
            System.err.println("ERROR: Work cannot be added while worker threads running");
            return;
        }
        this.q.addLast(work);
    }

    public void invokeWorks(int workerThreadCount) {
        if (this.state == 1) {
            System.err.println("ERROR: Worker threads already running.");
        } else if (workerThreadCount <= 0) {
            this.state = 1;
            while (!this.q.isEmpty()) {
                CallbackIface work = (CallbackIface)this.q.removeFirst();
                work.callback(null, null);
            }
            this.state = 0;
        } else {
            int i;
            this.state = 1;
            Thread[] threads = new Thread[workerThreadCount];
            for (i = 0; i < workerThreadCount; ++i) {
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        CallbackIface work = null;
                        while ((work = WorkQueue.this.getNextWork()) != null) {
                            work.callback(null, null);
                        }
                    }
                };
                threads[i].start();
            }
            for (i = 0; i < workerThreadCount; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    System.err.println("InterruptedException caught.");
                    i = 0;
                }
            }
            this.state = 0;
        }
    }
}

