/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MEFlow;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class LonePairPainter
extends MarvinModule {
    private List<DPoint3> lonePairCoords = null;
    private List<DPoint3> radicalCoords = null;
    private static final char NEGATIVE_CHARGE_CHAR;
    private static double treshold;

    @Override
    public Object modfunc(Object arg) {
        Object[] args = (Object[])arg;
        Graphics g = (Graphics)args[0];
        CTransform3D t = (CTransform3D)args[1];
        CTransform3D tscr = (CTransform3D)args[2];
        MolAtom a = (MolAtom)args[3];
        DPoint3 p0 = a.getLocation();
        tscr.transform(p0);
        double r = Math.floor((Double)args[4] * 100.0) / 100.0;
        int lpc = (Integer)args[5];
        boolean implh = (Boolean)args[6];
        Font font = (Font)args[7];
        double[] atomCoordsOff = (double[])args[8];
        this.paint(g, t, tscr, a, p0, r, lpc, implh, font, atomCoordsOff);
        return null;
    }

    public void paint(Graphics g, CTransform3D t, CTransform3D tscr, MolAtom a, DPoint3 p0, double r, int lpc, boolean implh, Font font, double[] atomCoordsOff) {
        this.lonePairCoords = new ArrayList<DPoint3>();
        this.radicalCoords = new ArrayList<DPoint3>();
        a.storeTemporaryObject("lonePairCoords", null);
        a.storeTemporaryObject("radicalCoords", null);
        DPoint3[][] dots = this.calcDotCoords(t, tscr, a, p0, r, lpc, implh);
        if (atomCoordsOff == null) {
            atomCoordsOff = new double[2];
        }
        if (dots.length != 0) {
            DPoint3 p;
            int i;
            CTransform3D invtscr = new CTransform3D(tscr);
            invtscr.invert();
            if (LonePairPainter.getEFlowFrom(a) != null && LonePairPainter.getEFlowFrom(a).getNumElectrons() == 1 && this.radicalCoords.size() > 0) {
                DPoint3[] radcoords = new DPoint3[this.radicalCoords.size()];
                this.radicalCoords.toArray(radcoords);
                for (i = 0; i < radcoords.length; ++i) {
                    p = new DPoint3(radcoords[i]);
                    p.x += atomCoordsOff[0];
                    p.y += atomCoordsOff[1];
                    invtscr.transform(p);
                    radcoords[i] = p;
                }
                a.storeTemporaryObject("radicalCoords", radcoords);
            }
            if (this.lonePairCoords.size() > 0) {
                DPoint3[] lonepaircoords = new DPoint3[this.lonePairCoords.size()];
                this.lonePairCoords.toArray(lonepaircoords);
                for (i = 0; i < lonepaircoords.length; ++i) {
                    p = new DPoint3(lonepaircoords[i]);
                    p.x += atomCoordsOff[0];
                    p.y += atomCoordsOff[1];
                    invtscr.transform(p);
                    lonepaircoords[i] = p;
                }
                a.storeTemporaryObject("lonePairCoords", lonepaircoords);
            }
        }
        LonePairPainter.paintDots(g, dots, r, atomCoordsOff);
        if (a.getCharge() != 0 && LonePairPainter.isChargeVisible(a)) {
            LonePairPainter.paintPlusSign(g, a, p0.x, p0.y, r, t, font, true, atomCoordsOff);
            if (a.getCharge() < 0 && LonePairPainter.getEFlowFrom(a) != null && LonePairPainter.getEFlowFrom(a).getNumElectrons() == 2) {
                int[] plusSignCoords = LonePairPainter.getPlusSignLocation(a, p0.x, p0.y, r, t);
                DPoint3 negativeChargeCoords = new DPoint3((double)plusSignCoords[0] + atomCoordsOff[0], (double)plusSignCoords[1] + atomCoordsOff[1], a.getLocation().z);
                CTransform3D invtscr = new CTransform3D(tscr);
                invtscr.invert();
                invtscr.transform(negativeChargeCoords);
                a.storeTemporaryObject("negativeChargeCoords", negativeChargeCoords);
            }
        } else if (a.getAtno() == 0 && (a.getElectronProp() == -1 || a.getElectronProp() == -2 || a.getElectronProp() == -4)) {
            LonePairPainter.paintPlusSign(g, a, p0.x, p0.y, r, t, font, false, atomCoordsOff);
        }
    }

    public static void paintCharge(Graphics g, MolAtom a, double r, CTransform3D t, Font f, double[] atomCoordsOff) {
        MEFlow eflow;
        DPoint3 p = a.getLocation();
        t.transform(p);
        if (atomCoordsOff == null) {
            atomCoordsOff = new double[2];
        }
        LonePairPainter.paintPlusSign(g, a, p.x, p.y, r, t, f, true, atomCoordsOff);
        if (a.getCharge() < 0 && (eflow = LonePairPainter.getEFlowFrom(a)) != null && eflow.getNumElectrons() == 2) {
            int[] plusSignCoords = LonePairPainter.getPlusSignLocation(a, p.x, p.y, r, t);
            DPoint3 negativeChargeCoords = new DPoint3((double)plusSignCoords[0] + atomCoordsOff[0], (double)plusSignCoords[1] + atomCoordsOff[1], a.getLocation().z);
            CTransform3D invtscr = new CTransform3D(t);
            invtscr.invert();
            invtscr.transform(negativeChargeCoords);
            a.storeTemporaryObject("negativeChargeCoords", negativeChargeCoords);
        }
    }

    private DPoint3[][] calcDotCoords(CTransform3D t, CTransform3D tscr, MolAtom a, DPoint3 p0, double r, int lpc, boolean implh) {
        boolean lonepairNeededFirst = LonePairPainter.getEFlowFrom(a) != null && LonePairPainter.getEFlowFrom(a).getNumElectrons() == 2 && lpc > 0;
        boolean changeLonePairToRad = false;
        int nb = a.getBondCount();
        ArrayList<Integer> bi = new ArrayList<Integer>();
        for (int i = 0; i < nb; ++i) {
            bi.add(i);
        }
        if (implh) {
            bi.add(nb);
            ++nb;
        }
        ArrayList<Double> angles = LonePairPainter.bondAngles(a, bi, nb, t, implh);
        GeomUtil.sortAngles(angles, bi);
        int rad = a.getRadical();
        int radcount = a.getRadicalCount();
        if (rad == 10 || rad == 2) {
            lpc += 2;
        } else if (rad == 1 || rad == 6) {
            ++lpc;
        } else if (rad == 3 || rad == 7) {
            lpc += 2;
        } else if (rad == 11) {
            lpc += 3;
        } else if (rad == 4) {
            lpc += 4;
        }
        DPoint3[][] dotpoints = new DPoint3[lpc][];
        boolean rad2first = false;
        for (int i = 0; i < lpc; ++i) {
            double phi = LonePairPainter.getBestAngle(a, t, bi, angles, i, lpc, rad, p0, tscr, r);
            boolean raddot = false;
            if ((rad == 1 || radcount == 3) && i == 0) {
                raddot = true;
            } else if (rad == 11 && i < 3 || rad == 4 && i < 4) {
                raddot = true;
            } else if (rad == 10 || rad == 2) {
                if (i == 0) {
                    double[] largest = GeomUtil.getLargestBondAngle2D(bi, angles);
                    if (largest[1] - Math.PI >= treshold && largest[1] - 4.1887902047863905 <= treshold || lpc == 2) {
                        raddot = true;
                        rad2first = true;
                    }
                } else if (rad2first) {
                    raddot = i == 1 && lpc == 2 || i == 2;
                } else if (i == lpc - 2 || i == lpc - 1) {
                    raddot = true;
                }
            }
            if (raddot && !lonepairNeededFirst || !raddot && changeLonePairToRad) {
                changeLonePairToRad = false;
                DPoint3[] dc = new DPoint3[]{LonePairPainter.calcRadicalDot(p0, r, phi)};
                dotpoints[i] = dc;
                this.radicalCoords.add(dc[0]);
            } else {
                if (lonepairNeededFirst) {
                    lonepairNeededFirst = false;
                    if (raddot) {
                        changeLonePairToRad = true;
                    }
                }
                dotpoints[i] = LonePairPainter.calcLonePair(p0, r, phi);
                this.lonePairCoords.add(new DPoint3((dotpoints[i][0].x + dotpoints[i][1].x) / 2.0, (dotpoints[i][0].y + dotpoints[i][1].y) / 2.0, (dotpoints[i][0].z + dotpoints[i][1].z) / 2.0));
            }
            angles.add(phi);
            bi.add(bi.size());
        }
        return dotpoints;
    }

    private static void paintDots(Graphics g, DPoint3[][] dots, double r, double[] atomCoordsOff) {
        double d = 0.1 * r;
        int w = (int)Math.round(Math.max(2.0 * d, 1.0));
        for (int i = 0; i < dots.length; ++i) {
            DPoint3[] points = dots[i];
            for (int j = 0; j < points.length; ++j) {
                DPoint3 p = points[j];
                g.fillOval((int)Math.round(p.x + atomCoordsOff[0] - d), (int)Math.round(p.y + atomCoordsOff[1] - d), w, w);
            }
        }
    }

    private static double getBestAngle(MolAtom a0, CTransform3D t, ArrayList<Integer> bi, ArrayList<Double> angles, int i, int lpc, int radical, DPoint3 p0, CTransform3D tscr, double r) {
        MEFlow eflow = LonePairPainter.getEFlowFrom(a0);
        if (eflow != null && i == 0) {
            double phi = LonePairPainter.getEFlowAngle(a0, eflow, t, lpc, r);
            ArrayList<Integer> bitemp = new ArrayList<Integer>(bi);
            bi = bitemp;
            bi.add(bi.size());
            ArrayList<Double> anglestemp = new ArrayList<Double>(angles);
            angles = anglestemp;
            angles.add(phi);
        }
        double[] largest = GeomUtil.getLargestBondAngle2D(bi, angles);
        int nb = a0.getBondCount();
        double ang4_3 = 4.1887902047863905;
        double ang3_2 = 4.71238898038469;
        double phi = lpc == 2 && i == 0 && largest[1] >= 3.7699111843077517 ? largest[0] + largest[1] / 3.0 : (lpc > 2 && i == 0 && radical != 4 && (largest[1] >= Math.PI && largest[1] < 4.1887902047863905 || radical == 11 && nb == 2 && largest[1] < 4.71238898038469) ? largest[0] + largest[1] / 3.0 : (i == 0 && radical == 4 && nb == 1 ? largest[0] + largest[1] / 5.0 : largest[0] + largest[1] / 2.0));
        if (phi - Math.PI > treshold) {
            phi -= Math.PI * 2;
        }
        return phi;
    }

    private static DPoint3[] calcLonePair(DPoint3 p0, double r, double phi) {
        DPoint3[] p = new DPoint3[2];
        double dphi = 0.2617993877991494;
        p[0] = new DPoint3(p0.x + r * Math.cos(phi - dphi), p0.y - r * Math.sin(phi - dphi), p0.z);
        p[1] = new DPoint3(p0.x + r * Math.cos(phi + dphi), p0.y - r * Math.sin(phi + dphi), p0.z);
        return p;
    }

    private static DPoint3 calcRadicalDot(DPoint3 p0, double r, double phi) {
        double x = p0.x + r * Math.cos(phi);
        double y = p0.y - r * Math.sin(phi);
        double z = p0.z;
        return new DPoint3(x, y, z);
    }

    private static int[] getPlusSignLocation(MolAtom a, double x0, double y0, double r0, CTransform3D t) {
        double phi = 0.7853981633974483;
        MEFlow eflow = LonePairPainter.getEFlowFrom(a);
        if (eflow != null) {
            DPoint3 source;
            if (eflow.getArcAngle() < 0.0) {
                source = eflow.getPointRef(0, null).getLocation();
                DPoint3 sink = eflow.getPointRef(1, null).getLocation();
                t.transform(source);
                t.transform(sink);
                if (source.y > sink.y) {
                    phi = 2.356194490192345;
                }
            } else {
                source = eflow.getPointRef(0, null).getLocation();
                DPoint3 sink = eflow.getPointRef(1, null).getLocation();
                t.transform(source);
                t.transform(sink);
                if (source.x > sink.x) {
                    phi = 2.356194490192345;
                }
            }
        }
        double deg = Math.PI / 180;
        double dphi = LonePairPainter.closestAngleDiff(a, t, phi);
        double dphilo = -25.0 * deg;
        double dphihi = 25.0 * deg;
        if (dphi > dphilo && dphi < dphihi) {
            phi = dphi <= 0.0 ? (phi += dphilo) : (phi += dphihi);
            phi -= dphi;
        }
        double r = 1.1 * r0;
        double fx = x0 + r * Math.cos(phi);
        double fy = y0 - r * Math.sin(phi);
        int x = (int)Math.round(fx);
        int y = (int)Math.round(fy);
        int[] ret = new int[]{x, y};
        return ret;
    }

    private static void paintPlusSign(Graphics g, MolAtom a, double x0, double y0, double r0, CTransform3D t, Font font, boolean isCharge, double[] atomCoordsOff) {
        if (font == null) {
            return;
        }
        int[] plusSignCoords = LonePairPainter.getPlusSignLocation(a, x0, y0, r0, t);
        Font oldf = g.getFont();
        g.setFont(font);
        if (isCharge) {
            if (a.getCharge() < 0) {
                // empty if block
            }
            g.drawString(LonePairPainter.getChargeString(a.getCharge()), plusSignCoords[0] + (int)Math.round(atomCoordsOff[0]), plusSignCoords[1] + (int)Math.round(atomCoordsOff[1]));
        } else {
            g.drawString("+", plusSignCoords[0] + (int)Math.round(atomCoordsOff[0]), plusSignCoords[1] + (int)Math.round(atomCoordsOff[1]));
        }
        g.setFont(oldf);
    }

    private static double[] bondAngles(MolAtom a0, int[] bi, int nb, CTransform3D t, boolean implh) {
        double[] angles = new double[nb];
        DPoint3 p0 = a0.getLocation();
        t.transform(p0);
        for (int i = 0; i < nb; ++i) {
            double phi;
            if (implh && i == nb - 1) {
                phi = LonePairPainter.getPreferredHLabelAngle(a0, t);
            } else {
                MolAtom a = a0.getLigand(bi[i]);
                DPoint3 p = a.getLocation();
                t.transform(p);
                phi = p0.angle2D(p.x, p.y);
            }
            angles[i] = phi;
        }
        return angles;
    }

    private static ArrayList<Double> bondAngles(MolAtom a0, ArrayList<Integer> bi, int nb, CTransform3D t, boolean implh) {
        ArrayList<Double> angles = new ArrayList<Double>();
        DPoint3 p0 = a0.getLocation();
        t.transform(p0);
        for (int i = 0; i < nb; ++i) {
            double phi;
            if (implh && i == nb - 1) {
                phi = LonePairPainter.getPreferredHLabelAngle(a0, t);
            } else {
                MolAtom a = a0.getLigand(bi.get(i));
                DPoint3 p = a.getLocation();
                t.transform(p);
                phi = p0.angle2D(p.x, p.y);
            }
            angles.add(phi);
        }
        return angles;
    }

    public static MEFlow getEFlowFrom(MolAtom a) {
        MDocument doc;
        MoleculeGraph m = a.getParent();
        if (m != null && (doc = m.getDocument()) != null) {
            for (int i = 0; i < doc.getObjectCount(); ++i) {
                MEFlow ef;
                MPoint p;
                MObject o = doc.getObject(i);
                if (!(o instanceof MEFlow) || !(p = (ef = (MEFlow)o).getPointRef(0, null)).containsAtom(a)) continue;
                return ef;
            }
        }
        return null;
    }

    private static double getEFlowAngle(MolAtom a, MEFlow ef, CTransform3D t, int lpc, double r) {
        int sign;
        DPoint3 p0 = a.getLocation();
        DPoint3 p2 = ef.getPointRef(1, null).getLocation();
        DPoint3 p1 = ef.getPointRef(0, null).getLocation();
        t.transform(p1);
        t.transform(p2);
        double phi = ef.getArcAngle();
        int n = sign = phi < 0.0 ? -1 : 1;
        if (Math.abs(p2.x - p0.x) < 0.01 && Math.abs(p2.y - p0.y) < 0.01) {
            sign *= -1;
        } else if (lpc > 2) {
            sign = 0;
        }
        double theta = Math.atan2(p1.y - p2.y, p1.x - p2.x) + (double)sign * Math.PI / 2.0;
        theta = theta - -Math.PI < treshold ? theta + Math.PI * 2 : theta;
        theta = theta - Math.PI > treshold ? theta - Math.PI * 2 : theta;
        return theta;
    }

    private static double getPreferredHLabelAngle(MolAtom a0, CTransform3D t) {
        int h = a0.getImplicitHcount();
        int dir = a0.getPreferredLabelDir(t, h);
        double phi = dir == 0 ? 0.0 : (dir == 2 ? 1.5707963267948966 : (dir == 1 ? Math.PI : 4.71238898038469));
        return phi;
    }

    public static String getChargeString(int charge) {
        boolean pos;
        if (charge == 0) {
            return "";
        }
        boolean bl = pos = charge > 0;
        char sign = pos ? (char)'+' : (charge == -1 ? (char)NEGATIVE_CHARGE_CHAR : (char)'-');
        int abscharge = pos ? charge : -charge;
        StringBuffer sb = new StringBuffer();
        if (abscharge <= 1) {
            sb.append(sign);
        } else {
            sb.append(abscharge);
            sb.append(sign);
        }
        return sb.toString();
    }

    private static double closestAngleDiff(MolAtom a, CTransform3D t, double phi) {
        int nb = a.getBondCount();
        int[] bi = new int[nb];
        for (int i = 0; i < nb; ++i) {
            bi[i] = i;
        }
        double[] angles = LonePairPainter.bondAngles(a, bi, nb, t, false);
        return LonePairPainter.closestAngleDiff(angles, phi);
    }

    private static double closestAngleDiff(double[] angles, double phi) {
        double min = Math.PI * 2;
        for (int i = 0; i < angles.length; ++i) {
            double dphi = phi - angles[i];
            if (dphi - -Math.PI <= treshold) {
                dphi += Math.PI * 2;
            } else if (dphi - Math.PI > treshold) {
                dphi -= Math.PI * 2;
            }
            if (!(Math.abs(dphi) - Math.abs(min) < treshold)) continue;
            min = dphi;
        }
        return min;
    }

    public static boolean isChargeVisible(MolAtom a) {
        Molecule mol;
        Sgroup sg;
        return !(a.getParent() instanceof Molecule) || (sg = (mol = (Molecule)a.getParent()).findSmallestSgroupContaining(a)) == null || sg.getChargeLocation() != 2;
    }

    static {
        treshold = 0.1;
        String jver = System.getProperty("java.version");
        String os = System.getProperty("os.name");
        NEGATIVE_CHARGE_CHAR = os.startsWith("Windows") && jver.startsWith("1.3.1") ? (char)45 : (char)8211;
    }
}

