/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.Molecule;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.LineChart;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;

public class MChart
extends MarvinModule {
    private static Color[] SERIES_COLORS = new Color[]{new Color(255, 102, 0), new Color(80, 160, 124), new Color(80, 100, 155), new Color(168, 24, 42), new Color(135, 42, 130), new Color(248, 28, 244), new Color(144, 118, 200), new Color(168, 86, 26), new Color(72, 214, 184), new Color(100, 100, 100)};
    private Color[] colors = SERIES_COLORS;
    private static double EPSILON = 0.01;
    private static Font LEGEND_FONT = new Font("Arial", 1, 24);
    private static Font SMALL_LEGEND_FONT = new Font("Arial", 1, 14);
    private static Color BG_COLOR = new Color(164, 174, 204);
    private static int IMG_SIZE = 100;
    private LineChart chart = new LineChart();
    private int precision = 2;
    private Molecule[] legendMols = null;
    private String[] legendTexts = null;

    private static int calcImageSize(int count) {
        if (count <= 5) {
            return IMG_SIZE;
        }
        if (count <= 50) {
            return 500 / count - 3;
        }
        return 10;
    }

    public MChart() {
        this.chart.setValueLabelStyle(3);
        this.chart.setSampleDecimalCount(2);
        this.chart.setRangeDecimalCount(1);
        this.chart.setSampleLabelsOn(true);
        this.chart.setSampleLabelStyle(4);
        this.chart.setAutomaticRepaintOn(true);
        this.chart.setAutoLabelSpacingOn(true);
        this.chart.setBackground(BG_COLOR);
        this.chart.setTitleOn(true);
        this.chart.setFont("legendFont", LEGEND_FONT);
        this.chart.setSeriesLabelStyle(3);
        this.chart.setLegendPosition(0);
        this.chart.setFloatingOnLegendOn(true);
        this.chart.setSampleHighlightOn(true);
    }

    @Override
    public Object modfunc(Object arg) {
        Object param;
        Object[] args = (Object[])arg;
        String method = (String)args[0];
        Object object = param = args.length > 1 ? args[1] : null;
        if (method.equalsIgnoreCase("setTitle")) {
            this.chart.setTitle((String)param);
        } else if (method.equalsIgnoreCase("setSampleLabels")) {
            String[] labels = (String[])param;
            int n = labels.length;
            this.chart.setSampleCount(n);
            this.chart.setVisibleSamples(0, n);
            for (int i = 0; i < n; ++i) {
                this.chart.appendSampleLabel(this.stripEndingZeros(labels[i]), true);
            }
            this.chart.setLabel("SampleAxisLabel", "pH");
            this.precision = this.getDecimalCount(labels);
            this.chart.setRangeDecimalCount(this.precision);
        } else if (method.equalsIgnoreCase("setSampleValues")) {
            double[][] v = (double[][])param;
            int count = v.length;
            this.chart.setSeriesCount(count);
            this.chart.setSampleColors(this.colors);
            for (int index = 0; index < count; ++index) {
                double[] values = v[index];
                this.chart.setSampleDecimalCount(index, this.precision);
                this.chart.setSeriesLabelColor(index, this.colors[index % this.colors.length]);
                this.chart.setLineWidth(index, 2);
                for (int i = 0; i < values.length; ++i) {
                    this.chart.appendSampleValue(index, values[i], true);
                }
                this.chart.setSampleHighlightStyle(index, 7, 8);
                this.chart.setValueLabelsOn(index, true);
            }
        } else if (method.equalsIgnoreCase("setLegendImages")) {
            this.legendMols = (Molecule[])param;
            int count = this.legendMols.length;
            int imgsize = MChart.calcImageSize(count);
            for (int index = 0; index < count; ++index) {
                Molecule mol = this.legendMols[index];
                if (mol != null) {
                    byte[] bytes = mol.toBinFormat("jpeg:w" + imgsize);
                    ImageIcon icon = new ImageIcon(bytes);
                    this.chart.addImage("" + index, icon.getImage());
                    this.chart.setLegendImage(index, "" + index);
                }
                this.chart.setSeriesLabel(index, "" + (index + 1));
                this.chart.setSeriesLabelColor(index, this.colors[index % this.colors.length]);
            }
            this.chart.setLegendOn(true);
            this.chart.setSeriesLabelsOn(true);
        } else if (method.equalsIgnoreCase("setLegendTexts")) {
            this.legendTexts = (String[])param;
        } else if (method.equalsIgnoreCase("setLegendLabels")) {
            String[] labels = (String[])param;
            this.chart.setSeriesLabels(labels);
            this.chart.setFont("legendFont", SMALL_LEGEND_FONT);
            this.chart.setLegendPosition(3);
            this.chart.setLegendOn(true);
            this.chart.setSeriesLabelsOn(true);
        } else if (method.equalsIgnoreCase("setSampleHighlightOn")) {
            Boolean b = (Boolean)param;
            this.chart.setSampleHighlightOn(b.booleanValue());
        } else if (method.equalsIgnoreCase("setSeriesColors")) {
            this.colors = (Color[])param;
        } else if (method.equalsIgnoreCase("setRange")) {
            double min = Math.min(this.chart.getMinValue(-1), ((double[])param)[0]);
            double max = Math.max(this.chart.getMaxValue(-1), ((double[])param)[1]);
            if (max - min < EPSILON) {
                min = Math.floor(min);
                if ((max = Math.ceil(max)) - min < EPSILON) {
                    min -= 1.0;
                    max += 1.0;
                }
            }
            this.chart.setLowerRange(0, min);
            this.chart.setRange(0, max);
            this.chart.setCurrentLowerRange(0, min);
            this.chart.setCurrentRange(0, max);
        } else if (method.equalsIgnoreCase("setRangeDecimalCount")) {
            this.chart.setRangeDecimalCount(((Integer)param).intValue());
        } else if (method.equalsIgnoreCase("addItemListener")) {
            this.chart.addItemListener((ItemListener)param);
        } else if (method.equalsIgnoreCase("removeItemListener")) {
            this.chart.removeItemListener((ItemListener)param);
        } else {
            if (method.equalsIgnoreCase("getSeries")) {
                return new Integer(((ChartSample)param).getSeries());
            }
            if (method.equalsIgnoreCase("getLegendMols")) {
                return this.legendMols;
            }
            if (method.equalsIgnoreCase("getLegendTexts")) {
                return this.legendTexts;
            }
            if (method.equalsIgnoreCase("getChartComponent")) {
                return this.chart;
            }
            if (method.equalsIgnoreCase("getChartImage")) {
                int width = (Integer)args[1];
                int height = (Integer)args[2];
                return this.chart.getImage(width, height);
            }
        }
        return null;
    }

    private int getDecimalCount(String[] labels) {
        int count = 0;
        if (labels.length > 0) {
            String str = labels[0];
            try {
                Double.parseDouble(str);
                for (int i = 0; i < labels.length; ++i) {
                    int k = labels[i].lastIndexOf(".");
                    if (k < 0) continue;
                    count = Math.max(labels[i].length() - 1 - k, count);
                }
                return count;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return 2;
    }

    private String stripEndingZeros(String str) {
        try {
            double d = Double.parseDouble(str);
            return String.valueOf(d);
        }
        catch (NumberFormatException e) {
            return str;
        }
    }
}

