/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

class MaxClique {
    int restartLimit = 1000;
    int selectionLimit = -1;
    long timeLimit = -1L;
    int sizeLimit = -1;
    boolean deltaBasedRestart = true;
    float fullRestartProb = 0.0f;
    int minDelta = 4;
    long rndSeed = 308051301241514L;
    int[] penalty = null;
    final boolean[][] gr;
    boolean[] clique;
    int size;
    boolean[] bestClique;
    int bestSize;
    int[] delta;
    boolean[] tabu;
    Random rnd;

    void setRestartCountLimit(int limit) {
        this.restartLimit = limit;
    }

    void setStepCountLimit(int limit) {
        this.selectionLimit = limit;
    }

    void setTimeLimit(long limit) {
        this.timeLimit = limit;
    }

    void setSizeLimit(int limit) {
        this.sizeLimit = limit;
    }

    void setDeltaBasedRestart(boolean deltaBased) {
        this.deltaBasedRestart = deltaBased;
    }

    void setMinDelta(int delta) {
        this.minDelta = delta;
    }

    void setFullRestartProb(float fullRestartProb) {
        this.fullRestartProb = fullRestartProb;
    }

    void setPenalties(int[] penalty) {
        this.penalty = penalty;
    }

    void setPenalties(ArrayList<Integer> penalty) {
        this.penalty = new int[penalty.size()];
        for (int i = 0; i != penalty.size(); ++i) {
            this.penalty[i] = penalty.get(i);
        }
    }

    void setRandomSeed(long seed) {
        this.rndSeed = seed;
    }

    MaxClique(boolean[][] gr) {
        this.gr = gr;
    }

    private int nextFeasibleAddNode() {
        int i;
        int startNode = this.rnd.nextInt(this.delta.length);
        int node = -1;
        int min = Integer.MAX_VALUE;
        for (i = startNode; i < this.delta.length; ++i) {
            if (this.delta[i] != 0 || this.tabu[i] || this.penalty[i] >= min) continue;
            node = i;
            min = this.penalty[i];
        }
        for (i = 0; i < startNode; ++i) {
            if (this.delta[i] != 0 || this.tabu[i] || this.penalty[i] >= min) continue;
            node = i;
            min = this.penalty[i];
        }
        return node;
    }

    private int nextFeasibleSwapNode() {
        int i;
        int startNode = this.rnd.nextInt(this.delta.length);
        int node = -1;
        int min = Integer.MAX_VALUE;
        for (i = startNode; i < this.delta.length; ++i) {
            if (this.clique[i] || this.delta[i] != 1 || this.tabu[i] || this.penalty[i] >= min) continue;
            node = i;
            min = this.penalty[i];
        }
        for (i = 0; i < startNode; ++i) {
            if (this.clique[i] || this.delta[i] != 1 || this.tabu[i] || this.penalty[i] >= min) continue;
            node = i;
            min = this.penalty[i];
        }
        return node;
    }

    private int nextAddNode() {
        int i;
        int startNode = this.rnd.nextInt(this.delta.length);
        int node = -1;
        int min = Integer.MAX_VALUE;
        for (i = startNode; i < this.delta.length; ++i) {
            if (this.delta[i] != 0 || this.penalty[i] >= min) continue;
            node = i;
            min = this.penalty[i];
        }
        for (i = 0; i < startNode; ++i) {
            if (this.delta[i] != 0 || this.penalty[i] >= min) continue;
            node = i;
            min = this.penalty[i];
        }
        return node;
    }

    private void updatePenalties() {
        for (int i = 0; i != this.clique.length; ++i) {
            if (!this.clique[i]) continue;
            int n = i;
            this.penalty[n] = this.penalty[n] + 1;
        }
    }

    private void addCliqueNode(int u) {
        if (this.clique[u]) {
            return;
        }
        this.clique[u] = true;
        ++this.size;
        boolean[] row = this.gr[u];
        for (int i = 0; i != this.gr.length; ++i) {
            if (row[i]) continue;
            int n = i;
            this.delta[n] = this.delta[n] + 1;
        }
    }

    private void delCliqueNode(int u) {
        if (!this.clique[u]) {
            return;
        }
        this.clique[u] = false;
        --this.size;
        boolean[] row = this.gr[u];
        for (int i = 0; i != this.gr.length; ++i) {
            if (row[i]) continue;
            int n = i;
            this.delta[n] = this.delta[n] - 1;
        }
    }

    public boolean[] getClique() {
        return this.bestClique;
    }

    TerminationCause search() {
        int n = this.gr.length;
        this.clique = new boolean[n];
        Arrays.fill(this.clique, false);
        this.size = 0;
        this.delta = new int[n];
        Arrays.fill(this.delta, 0);
        this.bestClique = new boolean[n];
        Arrays.fill(this.bestClique, false);
        this.bestSize = 0;
        this.tabu = new boolean[n];
        Arrays.fill(this.tabu, false);
        if (this.penalty == null) {
            this.penalty = new int[this.gr.length];
            Arrays.fill(this.penalty, 0);
        }
        if (n == 0) {
            return TerminationCause.SIZE_LIMIT;
        }
        if (n == 1) {
            this.bestClique[0] = true;
            this.bestSize = 1;
            return TerminationCause.SIZE_LIMIT;
        }
        this.rnd = this.rndSeed != 0L ? new Random(this.rndSeed) : new Random();
        int maxSize = this.sizeLimit >= 0 ? this.sizeLimit : n;
        int maxRestartCount = this.restartLimit >= 0 ? this.restartLimit : Integer.MAX_VALUE;
        int maxSelCount = this.selectionLimit >= 0 ? this.selectionLimit : Integer.MAX_VALUE;
        long maxTime = this.timeLimit >= 0L ? System.currentTimeMillis() + this.timeLimit : Long.MAX_VALUE;
        int select = 0;
        int restart = 0;
        boolean[] row = null;
        int[] restartNodes = null;
        if (this.deltaBasedRestart) {
            restartNodes = new int[n];
        }
        while (select < maxSelCount && restart < maxRestartCount && System.currentTimeMillis() < maxTime) {
            ++restart;
            int restartNodeCount = 0;
            if (this.deltaBasedRestart) {
                for (int i = 0; i != n; ++i) {
                    if (this.delta[i] < this.minDelta) continue;
                    restartNodes[restartNodeCount++] = i;
                }
            }
            int rsNode = -1;
            rsNode = restartNodeCount > 0 ? restartNodes[this.rnd.nextInt(restartNodeCount)] : this.rnd.nextInt(n);
            if (this.deltaBasedRestart && this.rnd.nextFloat() < this.fullRestartProb) {
                Arrays.fill(this.clique, false);
                this.size = 0;
                Arrays.fill(this.delta, 0);
                this.addCliqueNode(rsNode);
            } else {
                row = this.gr[rsNode];
                for (int i = 0; i != n; ++i) {
                    if (!this.clique[i] || row[i]) continue;
                    this.delCliqueNode(i);
                }
                this.addCliqueNode(rsNode);
            }
            Arrays.fill(this.tabu, false);
            boolean tabuEmpty = true;
            int maxSwap = this.size;
            while (select < maxSelCount && System.currentTimeMillis() < maxTime) {
                ++select;
                int u = this.nextFeasibleAddNode();
                if (u != -1) {
                    this.addCliqueNode(u);
                    if (!tabuEmpty) continue;
                    maxSwap = this.size;
                    continue;
                }
                u = this.nextFeasibleSwapNode();
                if (u != -1) {
                    int v = -1;
                    row = this.gr[u];
                    for (int i = 0; i != n; ++i) {
                        if (!this.clique[i] || row[i]) continue;
                        v = i;
                        break;
                    }
                    this.addCliqueNode(u);
                    this.delCliqueNode(v);
                    this.tabu[v] = true;
                    tabuEmpty = false;
                    if (--maxSwap > 0) continue;
                    break;
                }
                u = this.nextAddNode();
                if (u == -1) break;
                this.addCliqueNode(u);
            }
            if (this.size > this.bestSize) {
                System.arraycopy(this.clique, 0, this.bestClique, 0, n);
                this.bestSize = this.size;
                if (this.bestSize >= maxSize) break;
            }
            this.updatePenalties();
        }
        if (this.bestSize >= maxSize) {
            return TerminationCause.SIZE_LIMIT;
        }
        if (restart >= maxRestartCount) {
            return TerminationCause.RESTART_LIMIT;
        }
        if (select >= maxSelCount) {
            return TerminationCause.STEP_LIMIT;
        }
        return TerminationCause.TIME_LIMIT;
    }

    static enum TerminationCause {
        RESTART_LIMIT,
        STEP_LIMIT,
        TIME_LIMIT,
        SIZE_LIMIT;

    }
}

