/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.marvin.modules.win.UnsupportedPlatformException;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.InstallFromJar;
import chemaxon.util.FindCodeBase;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public abstract class NativeLibrary {
    protected boolean isInitFailed = false;
    private static final String arch;
    private File libraryDir;
    private String libName;
    private String jarFile;
    protected String dllPath;

    protected abstract boolean isPreferredOS();

    public NativeLibrary(String name, String jarname, File libdir) {
        if (!this.isPreferredOS()) {
            this.initializationFailed();
            return;
        }
        if (Environment.UNTRUSTED) {
            throw new SecurityException("Non secure context: " + name + " is not accessible.");
        }
        this.libName = name.contains("%arch%") ? name.replace("%arch%", arch) : name;
        this.libraryDir = libdir;
        this.jarFile = jarname.contains("%arch%") ? jarname.replace("%arch%", arch) : jarname;
        try {
            this.install();
            this.init();
        }
        catch (IOException e) {
            this.initializationFailed();
        }
    }

    protected abstract void initializationFailed();

    protected void init() throws IOException {
        if (this.isPreferredOS() && !Environment.UNTRUSTED) {
            try {
                System.load(this.dllPath);
            }
            catch (UnsatisfiedLinkError e) {
                throw new IOException("File " + this.dllPath + " cannot be loaded, file did not found.");
            }
            catch (SecurityException e) {
                throw new IOException("File " + this.dllPath + " cannot be loaded due to security problems.");
            }
            catch (NullPointerException e) {
                throw new IOException("Dll file name cannot be calculated for " + this.libName + ".");
            }
        } else {
            throw new UnsupportedPlatformException(this.libName + " are not supported in this platform.");
        }
    }

    protected void install() throws IOException {
        if (!this.libraryDir.exists() && !this.libraryDir.mkdirs()) {
            throw new IOException("Cannot create " + this.libraryDir.getAbsolutePath());
        }
        File dllfile = new File(this.libraryDir, this.libName);
        URL codebase = Environment.getCodeBase();
        File localjar = null;
        String natjarname = this.getNativeJarName(null, null);
        if (codebase != null) {
            URL remotejar = new URL(codebase, natjarname);
            localjar = new File(this.libraryDir, natjarname);
            Environment.downloadURL(remotejar, localjar);
        } else {
            String codebasedir = FindCodeBase.getCodeBaseDir();
            if (Environment.JAVAWEBSTART && !FindCodeBase.isURL(codebasedir)) {
                natjarname = this.getNativeJarName("RM", null);
            }
            if (!(localjar = new File(codebasedir, natjarname)).exists()) {
                localjar = new File(codebasedir + "/lib", natjarname);
            }
        }
        if (!dllfile.exists()) {
            InstallFromJar.extractFromJar(localjar, this.libName, this.libraryDir);
        }
        if (!dllfile.canRead()) {
            throw new IOException("Cannot find " + dllfile.getAbsolutePath());
        }
        this.dllPath = dllfile.getCanonicalPath();
    }

    private String getNativeJarName(String cachePrefix, String cachePostfix) {
        if (Environment.JAVAWEBSTART) {
            if (cachePrefix != null) {
                this.jarFile = cachePrefix + this.jarFile;
            }
            if (cachePostfix != null) {
                this.jarFile = this.jarFile + cachePostfix;
            }
        }
        return this.jarFile;
    }

    static {
        String s;
        String a = System.getenv("sun.arch.data.model");
        if (a != null && a.equalsIgnoreCase("unknown")) {
            a = null;
        }
        if (a == null && (s = System.getProperty("os.arch")) != null && s.contains("64")) {
            a = "64";
        }
        if (a == null) {
            a = "32";
        }
        arch = a.equals("32") ? "x86" : "x64";
    }
}

