/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import java.util.Hashtable;
import java.util.StringTokenizer;

public class ResidueInfo {
    public static final int PDB_RES_COUNT = 35;
    private static final String[][] PDB_ATOM_NAMES = new String[35][];
    private static final Hashtable[] PDB_ATOM_IDS = new Hashtable[35];
    private static final String PDB_RES_ATOMS_DATA = "UNK 0 A 37 O3* P 1H5* 1H6 C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N3 N6 N7 N9 O1P O2* O2P O3P O4* O5* 2HOP 3HOP 2H5* H1* H2 H2* H3* H4* 2H6 H8 H3T 2HO* +A 37 O3* P 1H5* 1H6 C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N3 N6 N7 N9 O1P O2* O2P O3P O4* O5* 2HOP 3HOP 2H5* H1* H2 H2* H3* H4* 2H6 H8 H3T 2HO* C 35 O3* P 1H4 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 N1 N3 N4 O1P O2 O2* O2P O3P O4* O5* 2HOP 3HOP 2H4 2H5* H1* H2* H3* H4* H5 H6 H3T 2HO* +C 35 O3* P 1H4 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 N1 N3 N4 O1P O2 O2* O2P O3P O4* O5* 2HOP 3HOP 2H4 2H5* H1* H2* H3* H4* H5 H6 H3T 2HO* G 38 O3* P 1H2 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N2 N3 N7 N9 O1P O2* O2P O3P O4* O5* O6 2HOP 3HOP 2H5* H1 H1* H2* H3* H4* H8 H3T 2HO* 2H2 +G 38 O3* P 1H2 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N2 N3 N7 N9 O1P O2* O2P O3P O4* O5* O6 2HOP 3HOP 2H5* H1 H1* H2* H3* H4* H8 H3T 2HO* 2H2 T 37 O3* P 1H2* 1H5* 1H5M 2H5M C1* C2 C2* C3* C4 C4* C5 C5* C6 C5M N1 N3 O1P O2 O2P O3P O4 O4* O5* 2HOP 3HOP 2H5* H1* H3 H3* H4* H6 H3T 2H2 2H2* 3H5M +T 37 O3* P 1H2* 1H5* 1H5M 2H5M C1* C2 C2* C3* C4 C4* C5 C5* C6 C5M N1 N3 O1P O2 O2P O3P O4 O4* O5* 2HOP 3HOP 2H5* H1* H3 H3* H4* H6 H3T 2H2 2H2* 3H5M I 36 O3* P 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N3 N7 N9 O1P O2* O2P O3P O4* O5* O6 2HOP 3HOP 2H5* H1 H1* H2 H2* H3* H4* H8 H3T 2HO* +I 36 O3* P 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N3 N7 N9 O1P O2* O2P O3P O4* O5* O6 2HOP 3HOP 2H5* H1 H1* H2 H2* H3* H4* H8 H3T 2HO* U 34 O3* P 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 N1 N3 O1P O2 O2* O2P O3P O4 O4* O5* 2HOP 3HOP 2H5* H1* H3 H3* H4* H5 H6 H3T H2* 2HO* +U 34 O3* P 1H5* C1* C2 C2* C3* C4 C4* C5 C5* C6 N1 N3 O1P O2 O2* O2P O3P O4 O4* O5* 2HOP 3HOP 2H5* H1* H3 H3* H4* H5 H6 H3T H2* 2HO* ALA 13 C N O OXT CA CB H HN2 HA 1HB 2HB 3HB HXT ARG 27 C N O OXT CA CB CG CD NE CZ NH1 NH2 H HN2 HA 1HB 2HB 1HG 2HG 1HD 2HD HE 1HH1 2HH1 1HH2 2HH2 HXT ASN 18 C N O OXT CA CB CG OD1 ND2 NH2 H HN2 HA 1HB 2HB 1HD2 2HD2 HXT ASP 17 C N O OXT CA CB CG OD1 OD2 NH2 H HN2 HA 1HB 2HB HD2 HXT CYS 15 C N O OXT CA CB SG NH2 H HN2 HA 1HB 2HB HG HXT GLN 20 C N O OXT CA CB CG CD OE1 NE2 H HN2 HA 1HB 2HB 1HG 2HG 1HE2 2HE2 HXT GLU 19 C N O OXT CA CB CG CD OE1 OE2 H HN2 HA 1HB 2HB 1HG 2HG HE2 HXT GLY 12 C N O CA OXT H HN2 HA 1HA 1HB 2HA HXT HIS 22 C N O OXT CA CB CG ND1 CE1 CD2 NE2 H HN2 HA 1HB 2HB HD1 HD2 HD2 HE1 HE2 HXT ILE 22 C N O OXT CA CB CG1 CG2 CD1 H HN2 HA HB 1HG1 2HG1 1HG2 2HG2 3HG2 1HD1 2HD1 3HD1 HXT LEU 22 C N O OXT CA CB CG CD1 CD2 H HN2 HA 1HB 2HB HG 1HD1 2HD1 3HD1 1HD2 2HD2 3HD2 HXT LYS 25 C N O OXT CA CB CG CD CE NZ H HN2 HA 1HB 2HB 1HG 2HG 1HD 2HD 1HE 2HE 1HZ 2HZ 3HZ HXT MET 20 C N O OXT CA CB CG SD CE H HN2 HA 1HB 2HB 1HG 2HG 1HE 2HE 3HE HXT PHE 25 C N O OXT CA CB CG CD1 CD2 CE1 CE2 CZ H HN2 HA 1HB 2HB HD1 HD2 HE1 HE2 CE1 CE2 HZ HXT PRO 19 C N O OXT CA CB CG CD OD1 HT1 HT2 HA 1HB 2HB 1HG 2HG 1HD 2HD HXT SER 15 C N O OXT CA CB CG OG H HN2 HA 1HB 2HB HG HXT THR 17 C N O OXT CA CB OG1 CG2 H HN2 HA HB HG1 1HG2 2HG2 3HG2 HXT TRP 27 C N O OXT CA CB CG CD1 CD2 NE1 CE2 CE3 CZ2 CZ3 CH2 H HN2 HA 1HB 2HB HD1 HE1 HE3 HZ2 HZ3 HH2 HXT TYR 24 C N O OXT CA CB CG CD1 CD2 CE1 CE2 CZ OH H HN2 HA 1HB 2HB HD1 HD2 HE1 HE2 HH HXT VAL 19 C N O OXT CA CB CG1 CG2 H HN2 HA HB 1HG1 2HG1 3HG1 1HG2 2HG2 3HG2 HXT ASX 9 C N O OXT CA CB CG OD1 AD2 GLX 10 C N O OXT CA CB CG CD OE1 AE2";

    public static String getAtomName(int resType, int id) {
        if (resType >= 0 && resType < PDB_ATOM_NAMES.length) {
            String[] names = PDB_ATOM_NAMES[resType];
            if (id > 0 && id <= names.length) {
                return names[id - 1];
            }
        }
        return null;
    }

    public static int getAtomId(int resType, String name) {
        Integer i = (Integer)PDB_ATOM_IDS[resType].get(name);
        return i != null ? i + 1 : 0;
    }

    static {
        StringTokenizer st = new StringTokenizer(PDB_RES_ATOMS_DATA);
        int i = 0;
        while (st.hasMoreTokens()) {
            String gname = st.nextToken();
            int na = 0;
            try {
                na = Integer.parseInt(st.nextToken());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ResidueInfo.PDB_ATOM_NAMES[i] = new String[na];
            ResidueInfo.PDB_ATOM_IDS[i] = new Hashtable();
            for (int j = 0; j < na; ++j) {
                String name;
                ResidueInfo.PDB_ATOM_NAMES[i][j] = name = st.nextToken();
                PDB_ATOM_IDS[i].put(name, new Integer(j));
            }
            ++i;
        }
    }
}

