/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.struc.Molecule;
import chemaxon.struc.Smolecule;
import chemaxon.struc.StaticMolecule;
import java.io.IOException;
import java.util.Vector;

public class SubstructureSearch {
    public static final int DEFAULT_MIN_COMMON_SIZE = 3;
    private Smolecule targetMol = null;
    private Smolecule queryMol = null;
    private boolean queryMolChanged = true;
    private int minCommonSize = 3;
    private boolean ignoreAtomType = false;
    private boolean ignoreBondType = false;
    private boolean ignoreCharge = true;
    private boolean ignoreHybridization = true;
    private boolean ignoreIsotopes = true;
    private boolean ignoreQueryProperties = true;
    private boolean ignoreRadicals = true;
    private boolean[] allowedQueryAtoms = null;
    private boolean[] allowedTargetAtoms = null;
    private boolean[] mustTargetAtoms = null;
    private int[] lastSSMap = null;
    private int[] startBFSFromAtom = null;
    private Vector allHits = new Vector();
    private int treeSize = 0;
    private int[] route = null;
    private boolean[] visited = null;
    private Queue visitQueue = new Queue();
    private boolean[] adequateAtoms = null;
    private int[] baseNumber = null;
    private int[] state = null;
    private boolean carry = false;
    private int pos = 0;
    private int[][] valueToTargetAtomIndex = null;
    private int[] parentQueryNode = null;
    private boolean[] targetAtomMapped = null;
    private boolean[] mappedAtPos = null;
    private int[] targetAtomInComponent = null;
    private int[] queryAtomInComponent = null;
    private int[] queryAtomIndexToPos = null;
    private int currentMapSize = 0;
    private int[] ringCountOfAtoms = null;
    private boolean isRingCountOfAtomsSet = false;
    private int[] elemAnal = new int[112];

    public void setMolecules(Molecule query, Molecule target) throws SearchException {
        this.checkCoordinationCompound(query);
        this.checkCoordinationCompound(target);
        this.queryMol = new StaticMolecule(query);
        this.queryMolChanged = true;
        this.targetMol = new StaticMolecule(target);
        this.allowedQueryAtoms = null;
        this.allowedTargetAtoms = null;
        this.mustTargetAtoms = null;
    }

    public void setMolecules(Smolecule query, Smolecule target) {
        this.queryMol = query;
        this.queryMolChanged = true;
        this.targetMol = target;
        this.allowedQueryAtoms = null;
        this.allowedTargetAtoms = null;
        this.mustTargetAtoms = null;
    }

    public void setQuery(Molecule query) throws SearchException {
        this.checkCoordinationCompound(query);
        this.setQuery(new StaticMolecule(query));
    }

    public void setQuery(Smolecule query) {
        this.queryMol = query;
        this.allowedQueryAtoms = null;
        this.queryMolChanged = true;
    }

    public void setTarget(Molecule target) throws SearchException {
        this.checkCoordinationCompound(target);
        this.targetMol = new StaticMolecule(target);
        this.allowedTargetAtoms = null;
        this.mustTargetAtoms = null;
    }

    private void checkCoordinationCompound(Molecule m) throws SearchException {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (m.getAtom(i).getAtno() != 137) continue;
            throw new SearchException("Coordinate bonds are not supported by this version of SubstructureSearch.");
        }
    }

    public void setIgnoreAtomType(boolean ignore) {
        this.ignoreAtomType = ignore;
    }

    public void setIgnoreHybridization(boolean ignore) {
        this.ignoreHybridization = ignore;
    }

    public void setIgnoreCharge(boolean ignore) {
        this.ignoreCharge = ignore;
    }

    public void setIgnoreIsotopes(boolean ignore) {
        this.ignoreIsotopes = ignore;
    }

    public void setIgnoreBondType(boolean ignore) {
        this.ignoreBondType = ignore;
    }

    public void setIgnoreQueryProperties(boolean ignore) {
        this.ignoreQueryProperties = ignore;
    }

    public void setIgnoreRadicals(boolean ignore) {
        this.ignoreRadicals = ignore;
    }

    public void restrictMatching(int[] targetAtoms) {
        this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
        for (int i = 0; i < targetAtoms.length; ++i) {
            this.allowedTargetAtoms[targetAtoms[i]] = true;
        }
    }

    public void excludeAtoms(int[] excludedQueryAtoms, int[] excludedTargetAtoms) {
        int i;
        if (this.allowedQueryAtoms == null) {
            this.allowedQueryAtoms = new boolean[this.queryMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        if (this.allowedTargetAtoms == null) {
            this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        for (i = 0; i < excludedQueryAtoms.length; ++i) {
            this.allowedQueryAtoms[excludedQueryAtoms[i]] = false;
        }
        for (i = 0; i < excludedTargetAtoms.length; ++i) {
            this.allowedTargetAtoms[excludedTargetAtoms[i]] = false;
        }
    }

    public void excludeQueryAtom(int excludedQueryAtom) {
        if (this.allowedQueryAtoms == null) {
            this.allowedQueryAtoms = new boolean[this.queryMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        this.allowedQueryAtoms[excludedQueryAtom] = false;
    }

    public void excludeTargetAtom(int excludedTargetAtom) {
        if (this.allowedTargetAtoms == null) {
            this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
            this.fill(this.allowedTargetAtoms, true);
        }
        this.allowedTargetAtoms[excludedTargetAtom] = false;
    }

    public void setMustMatchTargetAtoms(int[] atomIndices) {
        this.mustTargetAtoms = new boolean[this.targetMol.getAtomCount()];
        for (int i = 0; i < atomIndices.length; ++i) {
            this.mustTargetAtoms[atomIndices[i]] = true;
        }
    }

    public boolean search() {
        this.doElemAnal();
        if (!this.findFirst()) {
            return false;
        }
        while (this.findNext()) {
        }
        return true;
    }

    public boolean findFirst() {
        if (this.queryMol.getAtomCount() > this.targetMol.getAtomCount()) {
            return false;
        }
        this.init();
        this.createSpannigTree(this.startBFSFromAtom[0]);
        this.setupConstrainedBacktrack();
        this.findTargetComponents();
        this.carry = false;
        this.pos = 0;
        while (!this.carry) {
            if (this.find()) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public boolean findNext() {
        if (this.carry) {
            return false;
        }
        this.lastSSMap = null;
        this.next();
        while (!this.carry) {
            if (this.find()) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public int[] getResult() {
        return this.lastSSMap;
    }

    public int getResultCount() {
        return this.allHits.size();
    }

    public int[] getResult(int resultIndex) {
        return (int[])this.allHits.get(resultIndex);
    }

    private boolean find() {
        while (this.pos != this.treeSize) {
            if (!this.good()) {
                return false;
            }
            ++this.pos;
        }
        --this.pos;
        this.addCommonSubstructure();
        return true;
    }

    private boolean good() {
        int predecessorPos;
        int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        if (this.pos == 0) {
            if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
                return false;
            }
            if (!this.matchAtoms(this.route[this.pos], targetAtom)) {
                return false;
            }
            this.targetAtomMapped[targetAtom] = true;
            this.mappedAtPos[this.pos] = true;
            ++this.currentMapSize;
            return true;
        }
        if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
            return false;
        }
        if (targetAtom > -1 && this.targetAtomMapped[targetAtom]) {
            return false;
        }
        int n = predecessorPos = this.parentQueryNode[this.pos] == -1 ? this.pos - 1 : this.parentQueryNode[this.pos];
        if (this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1 && this.state[this.pos] != this.baseNumber[this.pos] - 1) {
            return false;
        }
        if (!this.match(predecessorPos)) {
            return false;
        }
        if (this.pos + 1 == this.treeSize && this.mustTargetAtoms != null) {
            for (int ta = 0; ta < this.mustTargetAtoms.length; ++ta) {
                if (ta == targetAtom || !this.mustTargetAtoms[ta] || this.targetAtomMapped[ta]) continue;
                return false;
            }
        }
        if (targetAtom > -1) {
            this.targetAtomMapped[targetAtom] = true;
        }
        this.mappedAtPos[this.pos] = true;
        ++this.currentMapSize;
        return true;
    }

    private boolean match(int predecessorPos) {
        int targetAtomMappedToAtomAtPos;
        int atomAtPos = this.route[this.pos];
        int predecessorAtom = this.route[predecessorPos];
        int targetAtomMappedToPredecessor = this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1 ? -1 : this.valueToTargetAtomIndex[predecessorPos][this.state[predecessorPos]];
        int n = targetAtomMappedToAtomAtPos = this.state[this.pos] == this.baseNumber[this.pos] - 1 ? -1 : this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        if (targetAtomMappedToAtomAtPos < -1) {
            return this.queryMol.getAtomType(atomAtPos) == 1 && -2 - targetAtomMappedToPredecessor == targetAtomMappedToAtomAtPos && this.isHMapCountOK(this.pos, this.route[predecessorPos], targetAtomMappedToPredecessor);
        }
        if (targetAtomMappedToPredecessor >= 0 && this.targetAtomInComponent[targetAtomMappedToPredecessor] != this.targetAtomInComponent[targetAtomMappedToAtomAtPos]) {
            return this.queryAtomInComponent[atomAtPos] != this.queryAtomInComponent[predecessorAtom];
        }
        int targetBond = -1;
        if (targetAtomMappedToAtomAtPos >= 0 && targetAtomMappedToPredecessor >= 0) {
            if (!this.targetMol.areNeighbors(targetAtomMappedToAtomAtPos, targetAtomMappedToPredecessor)) {
                return false;
            }
            targetBond = this.targetMol.getBondType(targetAtomMappedToAtomAtPos, targetAtomMappedToPredecessor);
        }
        if (targetAtomMappedToAtomAtPos != -1 && !this.matchAtoms(atomAtPos, targetAtomMappedToAtomAtPos)) {
            return false;
        }
        if (this.queryAtomInComponent[atomAtPos] != this.queryAtomInComponent[predecessorAtom]) {
            return true;
        }
        if (targetBond != -1 && !this.ignoreBondType) {
            if (!this.queryMol.areNeighbors(atomAtPos, predecessorAtom)) {
                return false;
            }
            int queryBond = this.queryMol.getBondType(atomAtPos, predecessorAtom);
            if (queryBond != targetBond) {
                return false;
            }
        }
        return targetAtomMappedToAtomAtPos == -1 || this.checkQueryTargetInducedEdges(predecessorAtom, atomAtPos, targetAtomMappedToAtomAtPos);
    }

    private boolean isHMapCountOK(int pos, int parentQueryAtom, int parentTargetAtom) {
        int ihc = 0;
        int max = this.targetMol.getImplicitHcount(parentTargetAtom);
        for (int i = 0; i < pos; ++i) {
            if ((ihc += this.valueToTargetAtomIndex[i][this.state[i]] == -2 - parentTargetAtom ? 1 : 0) <= max) continue;
            return false;
        }
        return true;
    }

    private boolean checkQueryTargetInducedEdges(int predecessorAtom, int atomAtPos, int targetAtomAtPos) {
        for (int i = 0; i < this.queryMol.getNeighborCount(atomAtPos); ++i) {
            int queryBond;
            int neighPos;
            int neigh = this.queryMol.getNeighbor(atomAtPos, i);
            if (neigh == predecessorAtom || (neighPos = this.queryAtomIndexToPos[neigh]) > this.pos) continue;
            int neighTargetAtom = this.valueToTargetAtomIndex[neighPos][this.state[neighPos]];
            if (neighTargetAtom < 0) {
                return true;
            }
            if (!this.targetMol.areNeighbors(targetAtomAtPos, neighTargetAtom)) {
                return false;
            }
            int targetBond = this.targetMol.getBondType(targetAtomAtPos, neighTargetAtom);
            if (this.ignoreBondType || (queryBond = this.queryMol.getBondType(atomAtPos, neigh)) == targetBond) continue;
            return false;
        }
        return true;
    }

    private boolean matchAtoms(int queryAtomIndex, int targetAtomIndex) {
        int qa = this.queryMol.getAtomType(queryAtomIndex);
        int ta = this.targetMol.getAtomType(targetAtomIndex);
        if (!this.ignoreAtomType && (qa == 128 ? !this.queryMol.inAtomList(queryAtomIndex, ta) : (qa == 129 ? this.queryMol.inAtomList(queryAtomIndex, ta) : (qa == 132 ? ta == 1 || ta == 6 : qa != 131 && qa != ta)))) {
            return false;
        }
        if (!this.ignoreRadicals && this.queryMol.getRadical(queryAtomIndex) != this.targetMol.getRadical(targetAtomIndex)) {
            return false;
        }
        if (!this.ignoreHybridization && this.queryMol.getHybridizationState(queryAtomIndex) != this.targetMol.getHybridizationState(targetAtomIndex)) {
            return false;
        }
        if (!this.ignoreCharge && this.queryMol.getCharge(queryAtomIndex) != this.targetMol.getCharge(targetAtomIndex)) {
            return false;
        }
        if (!this.ignoreIsotopes && this.queryMol.getMassno(queryAtomIndex) != this.targetMol.getMassno(targetAtomIndex)) {
            return false;
        }
        if (!this.ignoreQueryProperties) {
            return this.matchQueryProperties(queryAtomIndex, targetAtomIndex);
        }
        return true;
    }

    private boolean matchQueryProperties(int queryAtomIndex, int targetAtomIndex) {
        int qv = this.queryMol.getQPropAsInt(queryAtomIndex, "v");
        if (qv != -1 && qv != this.targetMol.getValence(targetAtomIndex)) {
            return false;
        }
        int hc = this.queryMol.getQPropAsInt(queryAtomIndex, "H");
        return hc == -1 || this.targetMol.getHcount(targetAtomIndex) == hc;
    }

    private void next() {
        while (true) {
            if (this.mappedAtPos[this.pos]) {
                int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
                if (targetAtom >= 0) {
                    this.targetAtomMapped[targetAtom] = false;
                }
                this.mappedAtPos[this.pos] = false;
                --this.currentMapSize;
            }
            if (this.state[this.pos] < this.baseNumber[this.pos] - 1) {
                int n = this.pos;
                this.state[n] = this.state[n] + 1;
                this.carry = false;
                return;
            }
            if (this.pos == 0) {
                this.carry = true;
                return;
            }
            this.state[this.pos--] = 0;
        }
    }

    private void createSpannigTree(int startingNode) {
        this.treeSize = 0;
        for (int i = 0; i < this.visited.length; ++i) {
            this.visited[i] = false;
        }
        if (!this.isAllowedQueryAtom(startingNode)) {
            return;
        }
        int componentCount = 0;
        while (this.treeSize < this.queryMol.getAtomCount()) {
            this.visitQueue.addLast(-(++componentCount));
            this.visitQueue.addLast(startingNode);
            this.visit(componentCount - 1);
            for (startingNode = 0; startingNode < this.queryMol.getAtomCount() && this.visited[startingNode]; ++startingNode) {
            }
        }
    }

    private void visit(int componentIndex) {
        while (!this.visitQueue.isEmpty()) {
            int parent = this.visitQueue.removeFirst();
            int nodeIndex = this.visitQueue.removeFirst();
            if (nodeIndex == -1 || this.visited[nodeIndex]) continue;
            this.visited[nodeIndex] = true;
            this.route[this.treeSize++] = nodeIndex;
            this.queryAtomInComponent[nodeIndex] = componentIndex;
            for (int ni = 0; ni < this.queryMol.getNeighborCount(nodeIndex); ++ni) {
                int neigh = this.queryMol.getNeighbor(nodeIndex, ni);
                if (neigh == parent || !this.isAllowedQueryAtom(neigh)) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neigh);
            }
        }
    }

    private void findTargetComponents() {
        for (int i = 0; i < this.targetAtomInComponent.length; ++i) {
            this.targetAtomInComponent[i] = -1;
        }
        int visitedCount = 0;
        int componentCount = 0;
        int startingNode = 0;
        while (visitedCount < this.targetMol.getAtomCount()) {
            this.visitQueue.addLast(-(++componentCount));
            this.visitQueue.addLast(startingNode);
            visitedCount += this.visitTargetMol(componentCount - 1, visitedCount);
            for (startingNode = 0; startingNode < this.targetMol.getAtomCount() && this.targetAtomInComponent[startingNode] != -1; ++startingNode) {
            }
        }
    }

    private int visitTargetMol(int componentIndex, int visitedCount) {
        while (!this.visitQueue.isEmpty()) {
            int parent = this.visitQueue.removeFirst();
            int nodeIndex = this.visitQueue.removeFirst();
            if (nodeIndex == -1 || this.targetAtomInComponent[nodeIndex] != -1) continue;
            this.targetAtomInComponent[nodeIndex] = componentIndex;
            ++visitedCount;
            for (int ni = 0; ni < this.targetMol.getNeighborCount(nodeIndex); ++ni) {
                int neigh = this.targetMol.getNeighbor(nodeIndex, ni);
                if (neigh == parent || !this.isAllowedTargetAtom(neigh)) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neigh);
            }
        }
        return visitedCount;
    }

    private boolean isAllowedQueryAtom(int atom) {
        return this.allowedQueryAtoms == null || this.allowedQueryAtoms[atom];
    }

    private boolean isAllowedTargetAtom(int atom) {
        return this.allowedTargetAtoms == null || this.allowedTargetAtoms[atom];
    }

    private void setupConstrainedBacktrack() {
        int i;
        int ts = this.targetMol.getAtomCount();
        for (i = 0; i < this.treeSize; ++i) {
            int qa = this.route[i];
            this.queryAtomIndexToPos[qa] = i;
            this.baseNumber[i] = 0;
            for (int j = 0; j < ts; ++j) {
                if (!this.isAllowedTargetAtom(j) || !this.adequateAtoms[qa * ts + j]) continue;
                int n = i;
                int n2 = this.baseNumber[n];
                this.baseNumber[n] = n2 + 1;
                this.valueToTargetAtomIndex[i][n2] = j;
            }
            if (this.queryMol.getAtomType(qa) == 1) {
                int qn = this.queryMol.getNeighbor(qa, 0);
                for (int j = 0; j < ts; ++j) {
                    if (!this.isAllowedTargetAtom(j) || !this.adequateAtoms[qn * ts + j] || this.targetMol.getImplicitHcount(j) <= 0) continue;
                    int n = i;
                    int n3 = this.baseNumber[n];
                    this.baseNumber[n] = n3 + 1;
                    this.valueToTargetAtomIndex[i][n3] = -2 - j;
                }
            }
            int n = i;
            int n4 = this.baseNumber[n];
            this.baseNumber[n] = n4 + 1;
            this.valueToTargetAtomIndex[i][n4] = -1;
        }
        for (i = 0; i < this.treeSize; ++i) {
            this.parentQueryNode[i] = -1;
        }
        for (i = 1; i < this.treeSize; ++i) {
            int j;
            if (this.queryMol.areNeighbors(this.route[i], this.route[i - 1])) continue;
            for (j = i - 2; j >= 0 && !this.queryMol.areNeighbors(this.route[i], this.route[j]); --j) {
            }
            if (j < 0) continue;
            this.parentQueryNode[i] = j;
        }
        for (i = 0; i < this.state.length; ++i) {
            this.state[i] = 0;
            this.mappedAtPos[i] = false;
        }
        for (i = 0; i < this.targetAtomMapped.length; ++i) {
            this.targetAtomMapped[i] = false;
        }
        this.currentMapSize = 0;
    }

    private boolean adequateAtoms(int queryAtom, int targetAtom) {
        int queryAtomType = this.queryMol.getAtomType(queryAtom);
        int targetAtomType = this.targetMol.getAtomType(targetAtom);
        if (!(this.ignoreAtomType || queryAtomType == 131 || queryAtomType == 132 && targetAtomType != 1 && targetAtomType != 6 || queryAtomType == 128 && this.queryMol.inAtomList(queryAtom, targetAtomType) || queryAtomType == 129 && !this.queryMol.inAtomList(queryAtom, targetAtomType) || targetAtomType == queryAtomType)) {
            return false;
        }
        if (!this.ignoreHybridization && this.queryMol.getHybridizationState(queryAtom) != this.targetMol.getHybridizationState(targetAtom)) {
            return false;
        }
        if (!this.ignoreCharge && this.queryMol.getCharge(queryAtom) != this.targetMol.getCharge(targetAtom)) {
            return false;
        }
        if (this.queryMol.getExplicitHcount(queryAtom) > this.targetMol.getImplicitHcount(targetAtom) + this.targetMol.getExplicitHcount(targetAtom)) {
            return false;
        }
        return this.queryMol.getNeighborCount(queryAtom) - this.queryMol.getHcount(queryAtom) <= this.targetMol.getNeighborCount(targetAtom);
    }

    private void addCommonSubstructure() {
        int i;
        if (this.currentMapSize < this.minCommonSize) {
            return;
        }
        int[] map = new int[this.queryMol.getAtomCount()];
        for (i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        for (i = 0; i <= this.pos; ++i) {
            map[this.route[i]] = this.valueToTargetAtomIndex[i][this.state[i]];
        }
        if (this.isNewSolution(map)) {
            this.lastSSMap = map;
            this.allHits.addElement(map);
        }
    }

    private boolean isNewSolution(int[] map) {
        for (int i = 0; i < this.allHits.size(); ++i) {
            int[] m = (int[])this.allHits.elementAt(i);
            boolean same = true;
            for (int j = 0; same && j < m.length; ++j) {
                same = m[j] == map[j];
            }
            if (!same) continue;
            return false;
        }
        return true;
    }

    private void doElemAnal() {
        int i;
        for (i = 0; i < this.elemAnal.length; ++i) {
            this.elemAnal[i] = 0;
        }
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            int n = this.queryMol.getAtomType(i);
            this.elemAnal[n] = this.elemAnal[n] + 1;
        }
    }

    private void init() {
        this.alloc();
        this.lastSSMap = null;
        this.allHits.removeAllElements();
        this.minCommonSize = this.queryMol.getAtomCount();
        this.clear(this.ringCountOfAtoms);
        this.isRingCountOfAtomsSet = false;
        if (this.queryMolChanged) {
            this.findStartingNode();
        }
        this.initAdequateAtoms();
        this.queryMolChanged = false;
    }

    private void findStartingNode() {
        int i;
        int qgSize = this.queryMol.getAtomCount();
        for (i = 0; i < qgSize; ++i) {
            this.startBFSFromAtom[i] = this.isAllowedQueryAtom(i) && this.queryMol.getAtomType(i) != 1 ? i : -1;
        }
        if (this.startBFSFromAtom[0] == -1) {
            for (i = 1; i < qgSize; ++i) {
                if (this.startBFSFromAtom[i] == -1) continue;
                this.startBFSFromAtom[0] = this.startBFSFromAtom[i];
                this.startBFSFromAtom[i] = -1;
            }
        }
        for (i = 0; i < qgSize - 1; ++i) {
            int ai = this.startBFSFromAtom[i];
            if (ai == -1) continue;
            int atnoi = this.queryMol.getAtomType(ai);
            int scorei = this.atomScore(ai, atnoi);
            for (int j = i + 1; j < qgSize; ++j) {
                int atnoj;
                int scorej;
                int aj = this.startBFSFromAtom[j];
                if (aj == -1 || (scorej = this.atomScore(aj, atnoj = this.queryMol.getAtomType(aj))) >= scorei) continue;
                int w = this.startBFSFromAtom[i];
                this.startBFSFromAtom[i] = this.startBFSFromAtom[j];
                this.startBFSFromAtom[j] = w;
                ai = this.startBFSFromAtom[i];
                scorei = scorej;
            }
        }
    }

    private int atomScore(int atomIndex, int atno) {
        return (atno >= this.elemAnal.length || atno == 6 || atno == 128 || atno == 131 || atno == 132 ? 6 : 2 * this.elemAnal[atno]) + this.queryMol.getNeighborCount(atomIndex);
    }

    private void initAdequateAtoms() {
        for (int i = 0; i < this.queryMol.getAtomCount(); ++i) {
            for (int j = 0; j < this.targetMol.getAtomCount(); ++j) {
                this.adequateAtoms[i * this.targetMol.getAtomCount() + j] = this.adequateAtoms(i, j);
            }
        }
    }

    private void fill(boolean[] a, boolean v) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = v;
        }
    }

    private void clear(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0;
        }
    }

    private void alloc() {
        int qgSize = this.queryMol.getAtomCount();
        int tgSize = this.targetMol.getAtomCount();
        int tgIHcount = this.targetMol.getImplicitHcount();
        this.visitQueue.setMaxSize(Math.max(4 * qgSize, 4 * tgSize));
        if (this.route == null || qgSize > this.route.length) {
            this.startBFSFromAtom = new int[qgSize];
            this.route = new int[qgSize];
            this.visited = new boolean[qgSize];
            this.baseNumber = new int[qgSize];
            this.state = new int[qgSize];
            this.parentQueryNode = new int[qgSize];
            this.mappedAtPos = new boolean[qgSize];
            this.valueToTargetAtomIndex = new int[qgSize][tgSize + tgIHcount + 1];
            this.queryAtomIndexToPos = new int[qgSize];
            this.queryAtomInComponent = new int[qgSize];
            this.targetAtomMapped = new boolean[tgSize];
            this.ringCountOfAtoms = new int[tgSize];
            this.targetAtomInComponent = new int[tgSize];
            if (this.adequateAtoms == null || qgSize * tgSize > this.adequateAtoms.length) {
                this.adequateAtoms = new boolean[qgSize * tgSize];
            }
            return;
        }
        int minLength = 0;
        if (this.valueToTargetAtomIndex != null) {
            minLength = this.valueToTargetAtomIndex[0].length;
            for (int i = 1; i < this.valueToTargetAtomIndex.length; ++i) {
                if (this.valueToTargetAtomIndex[i].length >= minLength) continue;
                minLength = this.valueToTargetAtomIndex[i].length;
            }
            if (this.targetAtomMapped.length < minLength) {
                minLength = this.targetAtomMapped.length;
            }
        }
        if (this.valueToTargetAtomIndex == null || tgSize > minLength) {
            this.valueToTargetAtomIndex = new int[this.route.length][tgSize + 1];
            this.targetAtomMapped = new boolean[tgSize];
            this.ringCountOfAtoms = new int[tgSize];
            this.targetAtomInComponent = new int[tgSize];
        }
        if (qgSize * tgSize > this.adequateAtoms.length) {
            this.adequateAtoms = new boolean[qgSize * tgSize];
        }
    }

    public void dump() {
        int j;
        int i;
        System.out.println("=== dump ===");
        for (i = 0; i < this.queryMol.getAtomCount(); ++i) {
            for (j = 0; j < this.targetMol.getAtomCount(); ++j) {
                System.out.println("adequateAtoms[ " + i + " , " + j + " ] = " + this.adequateAtoms[i * this.targetMol.getAtomCount() + j]);
            }
        }
        System.out.println("treeSize = " + this.treeSize);
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("route[ " + i + " ] = " + this.route[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("baseNumber[ " + i + " ] = " + this.baseNumber[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("state[ " + i + " ] = " + this.state[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.print("valueToTargetAtomIndex[ " + i + " ] = ");
            for (j = 0; j < this.valueToTargetAtomIndex[i].length; ++j) {
                System.out.print(this.valueToTargetAtomIndex[i][j] + " ");
            }
            System.out.println();
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("parentQueryNode[ " + i + " ]= " + this.parentQueryNode[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("queryAtomIndexToPos[ " + i + " ]= " + this.queryAtomIndexToPos[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.out.println("queryAtomInComponent[ " + i + " ]= " + this.queryAtomInComponent[i]);
        }
        if (this.lastSSMap != null) {
            for (i = 0; i < this.lastSSMap.length; ++i) {
                System.out.println("lastSSMap[" + i + "]=" + this.lastSSMap[i]);
            }
        }
        System.out.println("=== ---- ===");
    }

    public static void main(String[] args) throws IOException {
        int i;
        String[] targets = new String[]{"[H][CH:1]1[CH:2]([CH2:3][O:4][Si:5]([c:6]2[cH:7][cH:8][cH:9][cH:10][cH:11]2)([c:12]2[cH:13][cH:14][cH:15][cH:16][cH:17]2)[C:18]([CH3:19])([CH3:20])[CH3:21])[O:22][C:23](=[O:24])[C:25]1([CH3:26])N(C)C", "[CH3:26][C:25]1=[CH:1][CH:2]([CH2:3][O:4][Si:5]([c:12]2[cH:13][cH:14][cH:15][cH:16][cH:17]2)([c:6]2[cH:11][cH:10][cH:9][cH:8][cH:7]2)[C:18]([CH3:19])([CH3:20])[CH3:21])[O:22][C:23]1=[O:24]"};
        String[] queries = new String[]{"[#1,#6:2][C:1]([#1,#6:5])=[O:4]", "[#1,#6:2][O:3][C:1]([#1,#6:5])=[O:4]", "[H:2][C:1]([#6,#7,#15,#16:5])=[C:6].[C:3]=[N,O:4]", "[H:2][N,O:4][C:3][C:1]([#6,#7,#15,#16:5])=[C:6]", "[H:6][O:5][N:2]=[C:1](/[#6:4])[#6:3]", "[H:8][N:2]([#6:3])[C:1]([#6:4])=[O:7]", "[#6:1]-[Cl,Br,I:3].[H:10][C:2](=[C:7]/[C:8]([#1,#6:10])=[O:9])[N;v3:6]([#6:5])[#6:4]", "[#6:1][C:2]=[C:7][C:8]([#1,#6:10])=[O:9]", "[H:20][C:1]([#1,#6:14])=[O:4].[H:5][C:2]([H:7])([C:3]([#6:15])=[O:6])[C:16](=[O:17])[O:18][#6:19].[H:11][N;v3:8][C:12](=[O,S:13])[N;v3:9][H:10]", "[#6:19][O:18][C:16](=[O:17])[C:2]1=[C:3]([#6:15])[N:8][C:12](=[O,S:13])[N:9][C:1]1[#1,#6:14]", "[H:10][C:4]([#7,#8,Cl,Br,I:6])[C:5]([c:11])=[O:9].[H:8][N;v3:1][C:2]1=[C:3]([H:7])[C:12]=[C:13][C:14]=[C:15]1", "[c:11][C:5]1=[C:4][C:3]2=[C:2]([N:1]1)[C:15]=[C:14][C:13]=[C:12]2.[#7,#8,Cl,Br,I:6][H:7]", "[H:5][N;v3:3]([C:7][C:8][C:9]1=[C:13][C:12]=[C:11][C:10]=[C:1]1[H:4])[C:2]=[O:6]", "[C:7]1[C:8][C:9]2=[C:13][C:12]=[C:11][C:10]=[C:1]2[C:2]=[N:3]1", "[c:1][H:2]", "[H:5][C:4]([H:6])([c:1])[Cl:3]"};
        SubstructureSearch sss = SubstructureSearch.initSSS();
        for (i = 0; i < queries.length / 2; ++i) {
            SubstructureSearch.processMols(sss, queries[2 * i], targets[0]);
        }
        for (i = 0; i < queries.length / 2; ++i) {
            SubstructureSearch.processMols(sss, queries[2 * i + 1], targets[1]);
        }
    }

    static void processMols(SubstructureSearch sss, String q, String t) throws IOException {
        Molecule queryMol = new Molecule();
        new SmilesImport().readMol(q, queryMol);
        Molecule targetMol = new Molecule();
        new SmilesImport().readMol(t, targetMol);
        SubstructureSearch.search(sss, queryMol, targetMol);
    }

    static SubstructureSearch initSSS() {
        SubstructureSearch sss = new SubstructureSearch();
        sss.setIgnoreAtomType(false);
        sss.setIgnoreBondType(false);
        sss.setIgnoreHybridization(true);
        sss.setIgnoreCharge(true);
        return sss;
    }

    static void search(SubstructureSearch sss, Molecule query, Molecule target) {
        sss.setTarget(target);
        sss.setQuery(query);
        boolean found = sss.findFirst();
        while (found) {
            SubstructureSearch.printResult(sss);
            found = sss.findNext();
        }
    }

    static void printResult(SubstructureSearch sss) {
        System.out.print("Solution found: ");
        int[] r = sss.getResult();
        for (int i = 0; i < r.length; ++i) {
            System.out.print(r[i] + ", ");
        }
        System.out.println();
    }

    public class SearchException
    extends RuntimeException {
        public SearchException(String message) {
            super(message);
        }
    }

    private class Queue {
        private int[] values = null;
        private int head = -1;
        private int tail = -1;
        private boolean empty = true;

        public void setMaxSize(int maxSize) {
            if (this.values == null || maxSize > this.values.length) {
                this.values = new int[maxSize];
            }
            this.clear();
        }

        public void clear() {
            this.head = 0;
            this.tail = -1;
            this.empty = true;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void addLast(int value) throws RuntimeException {
            if (this.overflow()) {
                throw new RuntimeException("Queue overflow.");
            }
            this.tail = (this.tail + 1) % this.values.length;
            this.values[this.tail] = value;
            this.empty = false;
        }

        private int removeFirst() throws RuntimeException {
            if (this.empty) {
                throw new RuntimeException("Queue underflow.");
            }
            int r = this.values[this.head];
            this.empty = this.head == this.tail;
            this.head = (this.head + 1) % this.values.length;
            return r;
        }

        private boolean overflow() {
            return !this.empty && (this.tail + 1) % this.values.length == this.head;
        }
    }
}

