/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules;

import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;

public class Threedim
extends MarvinModule {
    private static final int INDEX_NBITS = 31;
    private static final long INDEX_MASK = Integer.MAX_VALUE;
    private static final long Z_MASK = Integer.MAX_VALUE;
    private static final double Z_MIN = -1.0737418245E9;
    private Object[] zobjtmp = null;
    private Object[] zobjclean = null;
    private long[] zranks = null;

    @Override
    public Object modfunc(Object arg) {
        if (arg instanceof Object[]) {
            Object[] args = (Object[])arg;
            MoleculeGraph mol = (MoleculeGraph)args[0];
            DPoint3[] screenCoords = (DPoint3[])args[1];
            int nobjs = (Integer)args[2];
            Object[] objs = (Object[])args[3];
            CTransform3D tscr = (CTransform3D)args[4];
            this.zsort(mol, screenCoords, nobjs, objs, tscr);
        }
        return null;
    }

    public synchronized void zsort(MoleculeGraph mol, DPoint3[] screenCoords, int nobjs, Object[] objs, CTransform3D tscr) {
        int i;
        if (this.zranks == null || this.zranks.length < nobjs) {
            this.zranks = new long[nobjs];
        }
        long[] ranks = this.zranks;
        DPoint3 pscr = new DPoint3();
        if (ranks != null) {
            for (i = 0; i < nobjs; ++i) {
                Object obj = objs[i];
                if (obj instanceof MolAtom) {
                    MolAtom a = (MolAtom)obj;
                    DPoint3 p = screenCoords[mol.indexOf(a)];
                    long iz = (long)(p.z - -1.0737418245E9) & Integer.MAX_VALUE;
                    ranks[i] = iz << 32 | (long)i;
                    continue;
                }
                if (obj instanceof MolBond || obj instanceof MolAtom[]) {
                    MolAtom a1 = null;
                    MolAtom a2 = null;
                    if (obj instanceof MolBond) {
                        MolBond b = (MolBond)obj;
                        a1 = b.getAtom1();
                        a2 = b.getAtom2();
                    } else {
                        MolAtom[] atoms = (MolAtom[])objs[i];
                        a1 = atoms[0];
                        a2 = atoms[1];
                    }
                    int nz = 0;
                    double z = 0.0;
                    if (a1 != null) {
                        DPoint3 p1 = screenCoords[mol.indexOf(a1)];
                        z += p1.z;
                        ++nz;
                    }
                    if (a2 != null) {
                        DPoint3 p2 = screenCoords[mol.indexOf(a2)];
                        z += p2.z;
                        ++nz;
                    }
                    if (nz != 0) {
                        z /= (double)nz;
                    }
                    long iz = (long)(z - -1.0737418245E9) & Integer.MAX_VALUE;
                    ranks[i] = (iz << 1 | 1L) << 31 | (long)i;
                    continue;
                }
                if (obj instanceof MObject) {
                    MObject mo = (MObject)obj;
                    mo.calcCenter(pscr, tscr);
                    long iz = (long)(pscr.z - -1.0737418245E9) & Integer.MAX_VALUE;
                    ranks[i] = (iz << 1 | 1L) << 31 | (long)i;
                    continue;
                }
                MoleculeGraph molg = (MoleculeGraph)obj;
                molg.calcCenter(pscr);
                tscr.transform(pscr);
                long iz = (long)(pscr.z - -1.0737418245E9) & Integer.MAX_VALUE;
                ranks[i] = iz << 32 | (long)i;
            }
        }
        Threedim.qsort(ranks, 0, nobjs - 1);
        if (this.zobjtmp == null || this.zobjtmp.length < nobjs) {
            this.zobjtmp = new Object[nobjs];
            this.zobjclean = new Object[nobjs];
        }
        for (i = 0; i < nobjs; ++i) {
            this.zobjtmp[i] = objs[(int)(ranks[i] & Integer.MAX_VALUE)];
        }
        System.arraycopy(this.zobjtmp, 0, objs, 0, nobjs);
        System.arraycopy(this.zobjclean, 0, this.zobjtmp, 0, nobjs);
    }

    private static final void qsort(long[] ranks, int lo0, int hi0) {
        int hi = hi0;
        int lo = lo0;
        if (hi - lo <= 3) {
            Threedim.brute(ranks, lo, hi);
            return;
        }
        long mid = ranks[(lo + hi) / 2];
        while (lo < hi) {
            while (lo < hi && ranks[lo] < mid) {
                ++lo;
            }
            while (lo < hi && ranks[hi] > mid) {
                --hi;
            }
            if (lo >= hi) continue;
            long r = ranks[lo];
            ranks[lo] = ranks[hi];
            ranks[hi] = r;
        }
        if (hi < lo) {
            int t = hi;
            hi = lo;
            lo = t;
        }
        Threedim.qsort(ranks, lo0, lo);
        Threedim.qsort(ranks, lo == lo0 ? lo + 1 : lo, hi0);
    }

    private static final void brute(long[] ranks, int lo, int hi) {
        int d = hi - lo;
        if (d == 1) {
            if (ranks[hi] < ranks[lo]) {
                long r = ranks[lo];
                ranks[lo] = ranks[hi];
                ranks[hi] = r;
            }
        } else if (d == 2) {
            int pmin;
            int n = pmin = ranks[lo] < ranks[lo + 1] ? lo : lo + 1;
            if (ranks[pmin] >= ranks[lo + 2]) {
                pmin = lo + 2;
            }
            if (pmin != lo) {
                long r = ranks[lo];
                ranks[lo] = ranks[pmin];
                ranks[pmin] = r;
            }
            Threedim.brute(ranks, lo + 1, hi);
        } else if (d == 3) {
            int pmax;
            int pmin;
            int n = pmin = ranks[lo] < ranks[lo + 1] ? lo : lo + 1;
            if (ranks[pmin] >= ranks[lo + 2]) {
                pmin = lo + 2;
            }
            if (ranks[pmin] >= ranks[lo + 3]) {
                pmin = lo + 3;
            }
            if (pmin != lo) {
                long r = ranks[lo];
                ranks[lo] = ranks[pmin];
                ranks[pmin] = r;
            }
            int n2 = pmax = ranks[hi] > ranks[hi - 1] ? hi : hi - 1;
            if (ranks[pmax] <= ranks[hi - 2]) {
                pmax = hi - 2;
            }
            if (pmax != hi) {
                long r = ranks[hi];
                ranks[hi] = ranks[pmax];
                ranks[pmax] = r;
            }
            Threedim.brute(ranks, lo + 1, hi - 1);
        }
    }
}

