/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.modules.win.Jacob;
import chemaxon.marvin.modules.win.ole.OLEDocument;
import chemaxon.marvin.modules.win.ole.OLELibInfo;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MolLoader;
import chemaxon.struc.Molecule;
import chemaxon.util.ImageExportUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Logger;

public class MarvinOLETransfer {
    private Molecule molecule = null;
    private Properties properties = null;
    private static boolean permanentOLESupported = true;
    private static OLELibInfo OLEReferenceHolder = null;
    private boolean newEMFStreamSupported = true;
    private static Logger log = ClipboardHandler.getLog();

    public MarvinOLETransfer() throws IOException {
        log.entering("MarvinOLETransfer", "MarvinOLETransfer()");
        this.init();
        log.exiting("MarvinOLETransfer", "MarvinOLETransfer()");
    }

    MarvinOLETransfer(Molecule mol, Properties props) throws IOException {
        log.entering("MarvinOLETransfer", "MarvinOLETransfer(mol,props)");
        this.init();
        this.molecule = mol;
        this.properties = props;
        log.exiting("MarvinOLETransfer", "MarvinOLETransfer");
    }

    public static void disablePermanentOLE() {
        log.entering("MarvinOLETransfer", "disablePermanentOLE");
        permanentOLESupported = false;
        MarvinOLETransfer.removeOLEReference();
        log.exiting("MarvinOLETransfer", "diablePermanentOLE");
    }

    public static void removeOLEReference() {
        log.entering("MarvinOLETransfer", "removeOLEReference");
        if (OLEReferenceHolder != null) {
            log.fine("OLEReferenceHolder is not null release resources.");
            OLEReferenceHolder.release();
            OLEReferenceHolder = null;
        }
    }

    private void init() throws IOException {
        log.entering("MarvinOLETransfer", "init");
        if (!Jacob.getInstance().isSupported()) {
            throw new IOException("Jacob is not suported on this platform.");
        }
        if (!Jacob.getInstance().getOLEDocument().isUsable()) {
            throw new MissingResourceException("Cannot create CmarvinOLEServerDoc: marvinOLEServer.exe may be not registered", "MarvinOLEServer", "");
        }
        this.ensureState();
        try {
            this.setNewEMFStreamUsage();
        }
        catch (Throwable t) {
            log.throwing("MarvinOLETransfer", "init", t);
        }
    }

    private void setNewEMFStreamUsage() {
        log.entering("MarvinOLETransfer", "setNewEMFStreamUsage");
        log.fine("Getting OLE version.");
        String ver = "0.0";
        if (permanentOLESupported) {
            ver = OLEReferenceHolder.getVersion();
        } else if (Jacob.getInstance().isSupported()) {
            OLELibInfo info = Jacob.getInstance().getOLELibInfo();
            ver = info.getVersion();
            info.release();
        }
        String[] v = ver.split("\\.");
        if (Integer.valueOf(v[0]) <= 2 && Integer.valueOf(v[1]) >= 3) {
            log.fine("New EMF stream not supported.");
            this.newEMFStreamSupported = false;
        }
        log.exiting("MarvinOLETransfer", "setNewEMFStreamUsage");
    }

    boolean getDataToClipboard() {
        try {
            this.ensureState();
            byte[] EMFData = this.createEMFData();
            OLEDocument serverDoc = null;
            boolean state = false;
            while (!state && Jacob.getInstance().getOLEDocument().isUsable()) {
                serverDoc = Jacob.getInstance().getOLEDocument();
                serverDoc.setMOLData(MolExporter.exportToFormat(this.molecule, "mol"));
                if (this.molecule.getDocument() != null) {
                    serverDoc.setMrvData(MolExporter.exportToFormat(this.molecule.getDocument(), "mrv"));
                } else {
                    serverDoc.setMrvData(MolExporter.exportToFormat(this.molecule, "MRV"));
                }
                if (this.newEMFStreamSupported) {
                    serverDoc.setEMFPictureStream(EMFData);
                } else {
                    String stringEMFData = this.convertEMFByteArrToString(EMFData);
                    serverDoc.setEMFDatas(stringEMFData);
                }
                serverDoc.oleToClipboard();
                state = true;
            }
        }
        catch (MolExportException e) {
            throw new IllegalArgumentException("The given Molecule cannot exported");
        }
        catch (IOException e) {
            throw new IllegalStateException("IO operation failed");
        }
        return true;
    }

    public Object getDataFromClipboard() {
        this.ensureState();
        String mrvData = null;
        OLEDocument serverDoc = Jacob.getInstance().getOLEDocument();
        mrvData = serverDoc.oleFromClipboard();
        if (mrvData != null) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(mrvData.getBytes());
                MolInputStream mis = new MolInputStream((InputStream)is, null);
                MRecordImporter mii = MolLoader.createImporter(mis, null);
                return mii.readMol(null);
            }
            catch (MolFormatException e) {
            }
            catch (IOException e) {
            }
            catch (MRecordParseException mRecordParseException) {
                // empty catch block
            }
        }
        return null;
    }

    private byte[] createEMFData() throws MolExportException, IOException, NullPointerException {
        this.properties.setProperty("transbg", "true");
        String params = ImageExportUtil.createImageExporterParameter(this.properties, "emf:ole,", this.molecule.getDocument());
        byte[] emfData = null;
        if (Environment.MSWINDOWS) {
            String mrvSource = MolExporter.exportToFormat(this.molecule, "mrv");
            emfData = ImageExportUtil.createEMF(mrvSource, params);
        }
        if (emfData == null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            MolExporter exporter = new MolExporter(outputStream, params);
            exporter.write(this.molecule);
            exporter.close();
            emfData = outputStream.toByteArray();
        }
        if (emfData == null) {
            throw new NullPointerException("emf array is empty");
        }
        return emfData;
    }

    private String convertEMFByteArrToString(byte[] ar) {
        byte[] data = new byte[ar.length * 2];
        for (int i = 0; i < ar.length; ++i) {
            if (ar[i] < 0) {
                data[2 * i] = (byte)(ar[i] + 128);
                data[2 * i + 1] = 1;
                continue;
            }
            data[2 * i] = ar[i];
            data[2 * i + 1] = 0;
        }
        return new String(data);
    }

    private void ensureState() {
        log.entering("MarvinOLETransfer", "ensureState");
        if (!permanentOLESupported) {
            log.fine("Permanent OLE not supported not storing a reference on it.");
            log.exiting("MarvinOLETransfer", "ensureState");
            return;
        }
        String version = null;
        if (OLEReferenceHolder == null) {
            log.fine("OLE reference holder is null.");
            this.createLibInfo();
            try {
                version = OLEReferenceHolder.getVersion();
                log.fine("Reference is stored.");
            }
            catch (Exception e) {
                log.throwing("MarvinOLETransfer", "ensureState", e);
                this.createLibInfo();
            }
        } else {
            log.fine("OLEReference is not null.");
            try {
                version = OLEReferenceHolder.getVersion();
                log.fine("Reference stores valid value.");
            }
            catch (Exception e) {
                log.throwing("MarvinOLETransfer", "ensureState", e);
                log.fine("Reference is invalid, recreating OLEServer.");
                this.createLibInfo();
            }
        }
        if (OLEReferenceHolder != null) {
            try {
                version = OLEReferenceHolder.getVersion();
            }
            catch (Exception e) {
                permanentOLESupported = false;
                OLEReferenceHolder = null;
            }
        }
        if (version == null) {
            log.fine("Permanent OLE cannot be started. Disabling for next time.");
            permanentOLESupported = false;
            OLEReferenceHolder = null;
        }
        log.exiting("MarvinOLETransfer", "ensureState");
    }

    private void createLibInfo() {
        log.entering("MarvinOLETransfer", "createLibInfo");
        if (permanentOLESupported) {
            log.fine("Permanent OLE supported creating and store reference.");
            OLEReferenceHolder = Jacob.getInstance().getOLELibInfo();
            if (!OLEReferenceHolder.isUsable()) {
                log.fine("Permanent OLE LibInfo object cannot be created. Disabling for next time.");
                permanentOLESupported = false;
                OLEReferenceHolder = null;
            }
        }
        log.exiting("MarvinOLETransfer", "createLibInfo");
    }
}

