/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CompositeTransferable<T extends Transferable>
implements Transferable {
    protected List<T> transferables = new ArrayList<T>();

    public void add(T t) {
        this.transferables.add(t);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        for (Transferable t : this.transferables) {
            if (!t.isDataFlavorSupported(flavor)) continue;
            return t.getTransferData(flavor);
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> ret = new ArrayList<DataFlavor>();
        DataFlavor[] temp = null;
        for (int i = 0; i < this.transferables.size(); ++i) {
            for (DataFlavor f : temp = ((Transferable)this.transferables.get(i)).getTransferDataFlavors()) {
                if (ret.contains(f)) continue;
                ret.add(f);
            }
        }
        temp = new DataFlavor[ret.size()];
        return ret.toArray(temp);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (Transferable t : this.transferables) {
            if (!t.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }
}

