/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.marvin.modules.datatransfer.MTransferable;
import chemaxon.marvin.modules.datatransfer.Transferables;
import chemaxon.marvin.modules.datatransfer.transferables.CompositeTransferable;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.Molecule;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class DefaultTransferable
extends CompositeTransferable<MTransferable>
implements MTransferable {
    public DefaultTransferable() {
        this.transferables = Transferables.getInstance().getDefaultTransferables();
    }

    @Override
    public boolean isInputAvailable() {
        return false;
    }

    @Override
    public void registerNativeNames() {
        for (MTransferable t : this.transferables) {
            t.registerNativeNames();
        }
    }

    @Override
    public void setMolecule(Molecule mol) {
        for (MTransferable t : this.transferables) {
            t.setMolecule(mol);
        }
    }

    @Override
    public void setProperties(Properties props) {
        for (MTransferable t : this.transferables) {
            t.setProperties(props);
        }
    }

    @Override
    public void setTransfer(Transferable transfer) {
        for (MTransferable t : this.transferables) {
            t.setTransfer(transfer);
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        for (MTransferable t : this.transferables) {
            if (!t.isDataFlavorSupported(flavor)) continue;
            return t.getTransferData(flavor);
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> ret = new ArrayList<DataFlavor>();
        DataFlavor[] temp = null;
        for (int i = 0; i < this.transferables.size(); ++i) {
            for (DataFlavor f : temp = ((MTransferable)this.transferables.get(i)).getTransferDataFlavors()) {
                if ((DataFlavor.stringFlavor.equals(f) || DataFlavor.imageFlavor.equals(f)) && (Environment.isOLESupported() || Environment.MACOS || ret.contains(f))) continue;
                ret.add(f);
            }
        }
        return (DataFlavor[])ret.toArray(temp);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (MTransferable t : this.transferables) {
            if (!t.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }
}

