/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.formats.MolExporter;
import chemaxon.marvin.modules.datatransfer.transferables.ImageTransferable;
import chemaxon.marvin.util.Environment;
import chemaxon.util.ImageExportUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class EMFTransferable
extends ImageTransferable {
    public EMFTransferable() {
        try {
            this.flavor = new DataFlavor("image/emf");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.format = "emf";
    }

    @Override
    public void registerNativeNames() {
        SystemFlavorMap map = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        map.addUnencodedNativeForFlavor(this.flavor, "ENHMETAFILE");
        map.addFlavorForUnencodedNative("ENHMETAFILE", this.flavor);
    }

    @Override
    public Object getDataToClipboard(DataFlavor flv) {
        ByteArrayInputStream retval = null;
        if (Environment.MSWINDOWS) {
            String mrvSource;
            String params = ImageExportUtil.createImageExporterParameter(this.properties, this.format, this.molecule.getDocument());
            try {
                mrvSource = MolExporter.exportToFormat(this.molecule, "mrv");
            }
            catch (IOException e) {
                mrvSource = "";
            }
            byte[] emfStream = ImageExportUtil.createEMF(mrvSource, params);
            retval = emfStream != null ? new ByteArrayInputStream(emfStream) : this.createGraphicsStream(this.format);
        }
        return retval;
    }

    @Override
    public boolean isInputAvailable() {
        return false;
    }
}

