/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.datatransfer.transferables;

import chemaxon.marvin.modules.datatransfer.transferables.StructureTransferable;
import chemaxon.marvin.util.Environment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MDLTransferable
extends StructureTransferable {
    private byte[] convertMolfileToMDLCT(String str) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int prev = 0;
        for (int i = 0; i < str.length(); ++i) {
            char cc;
            char c = str.charAt(i);
            if (c != '\n' && c != '\r') continue;
            os.write(i - prev);
            for (int j = prev; j < i; ++j) {
                os.write(str.charAt(j));
            }
            if (i < str.length() - 1 && ((cc = str.charAt(i + 1)) == '\n' || cc == '\r') && cc != c) {
                ++i;
            }
            prev = i + 1;
        }
        if (prev < str.length()) {
            os.write(str.length() - prev);
            for (int j = prev; j < str.length(); ++j) {
                os.write(str.charAt(j));
            }
        }
        return os.toByteArray();
    }

    private static byte[] convertMDLCTtoMolfile(InputStream is) throws IOException {
        int len;
        byte[] buf = new byte[256];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((len = is.read()) != -1) {
            is.read(buf, 0, len);
            os.write(buf, 0, len);
            os.write(10);
        }
        return os.toByteArray();
    }

    public void registerNativeNames(String defaultnative) {
        String mdlnativename = defaultnative;
        if (Environment.MSWINDOWS) {
            mdlnativename = "MDLCT";
        }
        if (Environment.MACOS) {
            mdlnativename = "swsC";
        }
        SystemFlavorMap map = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        map.addUnencodedNativeForFlavor(this.extraFlavor, mdlnativename);
        map.addFlavorForUnencodedNative(mdlnativename, this.extraFlavor);
    }

    @Override
    protected Object getDataToClipboard(DataFlavor flv) {
        if (!flv.equals(DataFlavor.stringFlavor)) {
            String ret = this.getMoleculeString();
            return new ByteArrayInputStream(this.convertMolfileToMDLCT(ret));
        }
        return super.getDataToClipboard(flv);
    }

    @Override
    protected InputStream getInputStreamFromClipboard() {
        InputStream is = super.getInputStreamFromClipboard();
        try {
            byte[] b = MDLTransferable.convertMDLCTtoMolfile(is);
            if (b != null) {
                return new ByteArrayInputStream(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

