/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.osx;

import chemaxon.marvin.modules.osx.OSXLibrary;

public class OSXPasteboardWrapper {
    private static boolean isAvailable = false;

    private static native byte[] getDataFromPasteBoard(String var0, int var1);

    private static native boolean setDataToPasteBoard(String var0, byte[] var1, int var2);

    private static native String[] getTypesFromPasteboard(int var0);

    private static native int clearContentsFromPasteboard(int var0);

    public static String[] getTypesFromPasteboard(OSXPasteboard pb) {
        if (pb == OSXPasteboard.GENERAL_PASTEBOARD) {
            return OSXPasteboardWrapper.getTypesFromPasteboard(1);
        }
        if (pb == OSXPasteboard.DND_PASTEBOARD) {
            return OSXPasteboardWrapper.getTypesFromPasteboard(2);
        }
        return null;
    }

    public static byte[] getDataFromPasteBoard(String type, OSXPasteboard pb) {
        if (pb == OSXPasteboard.GENERAL_PASTEBOARD) {
            return OSXPasteboardWrapper.getDataFromPasteBoard(type, 1);
        }
        if (pb == OSXPasteboard.DND_PASTEBOARD) {
            return OSXPasteboardWrapper.getDataFromPasteBoard(type, 2);
        }
        return null;
    }

    public static boolean setDataToPasteBoard(String type, byte[] data, OSXPasteboard pb) {
        if (pb == OSXPasteboard.GENERAL_PASTEBOARD) {
            return OSXPasteboardWrapper.setDataToPasteBoard(type, data, 1);
        }
        if (pb == OSXPasteboard.DND_PASTEBOARD) {
            return OSXPasteboardWrapper.setDataToPasteBoard(type, data, 2);
        }
        return false;
    }

    public static int clearContentsFromPasteboard(OSXPasteboard pb) {
        if (pb == OSXPasteboard.GENERAL_PASTEBOARD) {
            return OSXPasteboardWrapper.clearContentsFromPasteboard(1);
        }
        if (pb == OSXPasteboard.DND_PASTEBOARD) {
            return OSXPasteboardWrapper.clearContentsFromPasteboard(2);
        }
        return 0;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    static {
        try {
            OSXLibrary lib = new OSXLibrary("libOSXPasteboardWrapper.jnilib", "OSXPasteBoardWrapper.jar");
            isAvailable = lib.isInitSuccess();
        }
        catch (SecurityException e) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public static enum OSXPasteboard {
        GENERAL_PASTEBOARD,
        DND_PASTEBOARD;

    }
}

