/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.marvin.modules.print.PrintFactory;
import chemaxon.marvin.modules.print.PrintProvider;
import chemaxon.marvin.modules.print.TableSerializer;
import chemaxon.marvin.util.CancelPrintException;
import chemaxon.marvin.util.PrintControl;
import chemaxon.marvin.view.swing.ViewPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;

public class Print2Device
implements PrintControl {
    private ViewPanel viewPanel;
    private int type = 0;
    private PageFormat pageFormat = null;
    private PrintProviderBridge ppbridge = null;

    public Print2Device() {
    }

    public Print2Device(ViewPanel viewPanel) {
        this.setContent(viewPanel);
    }

    @Override
    public void setContent(Object content) throws ClassCastException {
        this.viewPanel = (ViewPanel)content;
    }

    @Override
    public void initSettings(int type) throws CancelPrintException {
        PrinterJob printerJob;
        this.type = type;
        try {
            printerJob = PrinterJob.getPrinterJob();
        }
        catch (SecurityException sex) {
            throw new CancelPrintException("Printing is not allowed:" + sex.getMessage());
        }
        PageFormat defaultFormat = printerJob.defaultPage();
        this.pageFormat = printerJob.pageDialog(defaultFormat);
    }

    @Override
    public void doPrint() {
        this.ppbridge = new PrintProviderBridge();
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.ppbridge, this.pageFormat);
            this.ppbridge.bindPrinterJob(printerJob);
            boolean commit = printerJob.printDialog();
            if (commit) {
                if (this.type == 2) {
                    TableSerializer ts = new TableSerializer(this.viewPanel);
                    SerializeEndListener selst = new SerializeEndListener();
                    ts.addListener(selst);
                    ts.saveViewPanelInBackground();
                } else {
                    this.performPrint(null, -1);
                }
            }
        }
        catch (InstantiationException instex) {
            this.viewPanel.getErrorDisplay().error(instex.getMessage(), instex);
        }
        catch (SecurityException sex) {
            this.viewPanel.getErrorDisplay().error("Printing is not allowed.", sex);
            return;
        }
        catch (PrinterException pex) {
            this.viewPanel.getErrorDisplay().error("Printing failed.", pex);
        }
    }

    private void performPrint(File tserFile, int tserMolcount) throws InstantiationException, SecurityException, PrinterException {
        if (this.ppbridge == null) {
            throw new PrinterException("PrintProviderBridge is null.");
        }
        PrintProvider printProvider = null;
        printProvider = this.type == 2 ? new PrintFactory(this.viewPanel, tserFile, tserMolcount).createPrintProvider(this.type) : new PrintFactory(this.viewPanel).createPrintProvider(this.type);
        this.ppbridge.setPrintProvider(printProvider);
        this.ppbridge.print();
        this.ppbridge.releasePrinterJob();
        this.ppbridge = null;
    }

    class PrintProviderBridge
    implements Printable {
        private PrintProvider printProvider = null;
        private int cachedPage = -1;
        private BufferedImage cachedImage = null;
        private PrinterJob currentPrinterJob = null;

        PrintProviderBridge() {
        }

        void setPrintProvider(PrintProvider pp) {
            this.printProvider = pp;
        }

        public void print() throws PrinterException {
            this.currentPrinterJob.print();
        }

        public void bindPrinterJob(PrinterJob pj) {
            this.releasePrinterJob();
            this.currentPrinterJob = pj;
        }

        public void releasePrinterJob() {
            this.currentPrinterJob = null;
        }

        private void createCachedImage(PageFormat pageFormat, int pageIndex) throws PrinterException {
            BufferedImage paperSizeImage = new BufferedImage((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight(), 5);
            Graphics g = paperSizeImage.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, paperSizeImage.getWidth(), paperSizeImage.getHeight());
            this.printProvider.print(g, pageFormat, pageIndex);
            this.cachedPage = pageIndex;
            this.cachedImage = paperSizeImage;
        }

        private boolean isUpdateCachedImage(int w, int h, int pageIndex) {
            if (this.cachedImage != null && this.cachedPage == pageIndex) {
                int ciw = this.cachedImage.getWidth();
                int cih = this.cachedImage.getHeight();
                if (ciw == w && cih == h) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex != this.cachedPage && !this.printProvider.hasMorePages()) {
                return 1;
            }
            int piw = (int)pageFormat.getImageableWidth();
            int pih = (int)pageFormat.getImageableHeight();
            int ix = (int)pageFormat.getImageableX();
            int iy = (int)pageFormat.getImageableY();
            int x = ix;
            int y = iy;
            graphics.translate(x, y);
            try {
                if (this.isUpdateCachedImage(piw, pih, pageIndex)) {
                    this.createCachedImage(pageFormat, pageIndex);
                }
                graphics.drawImage(this.cachedImage, 0, 0, null);
            }
            catch (PrinterException pex) {
                pex.printStackTrace();
            }
            graphics.translate(-x, -y);
            return 0;
        }
    }

    private class SerializeEndListener
    implements PropertyChangeListener {
        private SerializeEndListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            File tserialFile = null;
            int molcount = -1;
            String name = evt.getPropertyName();
            if (name != null && name.equals("fileSaveEnd")) {
                TableSerializer tableSerToClose = (TableSerializer)evt.getNewValue();
                tableSerToClose.removeListener(this);
                tserialFile = tableSerToClose.getFile();
                molcount = tableSerToClose.getMolCount();
                try {
                    Print2Device.this.performPrint(tserialFile, molcount);
                }
                catch (InstantiationException instex) {
                    Print2Device.this.viewPanel.getErrorDisplay().error(instex.getMessage(), instex);
                }
                catch (SecurityException sex) {
                    Print2Device.this.viewPanel.getErrorDisplay().error("Printing is not allowed.", sex);
                    return;
                }
                catch (PrinterException pex) {
                    Print2Device.this.viewPanel.getErrorDisplay().error("Printing failed.", pex);
                }
            }
        }
    }
}

