/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.marvin.modules.print.PrintFactory;
import chemaxon.marvin.modules.print.PrintProvider;
import chemaxon.marvin.modules.print.TableSerializer;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.CancelPrintException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.PrintControl;
import chemaxon.marvin.view.swing.ViewPanel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class Print2Pdf
implements PrintControl {
    private ViewPanel viewPanel;
    private int type = 0;
    private PageFormat pageFormat = null;
    private File outputPdf = null;

    public Print2Pdf() {
    }

    public Print2Pdf(ViewPanel viewPanel) {
        this.setContent(viewPanel);
    }

    @Override
    public void setContent(Object content) throws ClassCastException {
        this.viewPanel = (ViewPanel)content;
    }

    @Override
    public void initSettings(int t) throws CancelPrintException {
        this.type = t;
        PrinterJob pjob = PrinterJob.getPrinterJob();
        this.pageFormat = pjob.defaultPage();
        this.outputPdf = this.openFileChooser();
        if (this.outputPdf == null) {
            this.outputPdf = new File("output.pdf");
        }
    }

    private File openFileChooser() throws CancelPrintException {
        JFileChooser jfc = new JFileChooser();
        jfc.putClientProperty("FileChooser.readOnly", Boolean.TRUE);
        FileFilter pdff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".pdf");
            }

            @Override
            public String getDescription() {
                return "Adobe Acrobat Document (.pdf)";
            }
        };
        FileFilter ff = jfc.getAcceptAllFileFilter();
        jfc.addChoosableFileFilter(pdff);
        jfc.setFileFilter(ff);
        int res = jfc.showSaveDialog(this.viewPanel);
        if (res == 0) {
            File f = jfc.getSelectedFile();
            if (f.exists()) {
                String message = "Are you sure to overwrite\n" + f.getAbsolutePath();
                int confirm = JOptionPane.showConfirmDialog(this.viewPanel, message);
                if (confirm != 0) {
                    throw new CancelPrintException("The user denied to overwrite " + f.getAbsolutePath());
                }
                if (!f.delete()) {
                    throw new CancelPrintException("Cannot overwrite " + f.getAbsolutePath());
                }
            }
            return f;
        }
        throw new CancelPrintException("Print to PDF is canceled by selecting output file");
    }

    @Override
    public void doPrint() {
        if (this.type == 2) {
            TableSerializer ts = new TableSerializer(this.viewPanel);
            SerializeEndListener selst = new SerializeEndListener();
            ts.addListener(selst);
            ts.saveViewPanelInBackground();
        } else {
            try {
                this.createPdf(this.outputPdf, this.pageFormat, null, -1);
            }
            catch (IOException ioex) {
                this.viewPanel.getErrorDisplay().error("Print to PDF failed.", ioex);
            }
        }
    }

    private void createPdf(final File f, final PageFormat pageFormat, final File tserialFile, final int tserMolcount) throws IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Print2Pdf.this.createPdf0(f, pageFormat, tserialFile, tserMolcount);
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace();
                    }
                }
            };
            Thread th = new Thread(r);
            th.start();
        } else {
            this.createPdf0(f, pageFormat, tserialFile, tserMolcount);
        }
    }

    private void createPdf0(File f, PageFormat pageFormat, File tserialFile, int tserMolcount) throws IOException {
        Dimension d = new Dimension();
        d.setSize(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        PrintProvider pprovider = null;
        try {
            pprovider = this.type == 2 ? new PrintFactory(this.viewPanel, tserialFile, tserMolcount).createPrintProvider(this.type) : new PrintFactory(this.viewPanel).createPrintProvider(this.type);
        }
        catch (InstantiationException instex) {
            this.viewPanel.getErrorDisplay().error(instex.getMessage(), instex);
            return;
        }
        Graphics2D pg2d = null;
        CallbackIface pdfexporter = null;
        try {
            pdfexporter = (CallbackIface)MarvinModule.loadClass("chemaxon.marvin.io.formats.vectgraphics.PdfExport", this.viewPanel);
            if (pdfexporter == null) {
                throw new IOException("Cannot instantiate PDF exporter.");
            }
            pg2d = (Graphics2D)pdfexporter.callback("createPdfDocument", new Object[]{new FileOutputStream(f), d, new Boolean(pprovider.hasMorePages())});
            if (pg2d == null) {
                throw new IOException("Cannot create PDFGraphics2D.");
            }
        }
        catch (SecurityException sex) {
            sex.printStackTrace();
            throw new IOException(sex.getMessage());
        }
        int i = 0;
        while (pprovider.hasMorePages()) {
            Object res = pdfexporter.callback("openPage", new Object[]{pg2d, d, new Integer(i + 1).toString()});
            if (res != null) {
                throw (IOException)res;
            }
            try {
                pprovider.print(pg2d, pageFormat, i);
            }
            catch (PrinterException pex) {
                Object res1 = pdfexporter.callback("closePage", pg2d);
                if (res1 != null) {
                    throw (IOException)res1;
                }
                pdfexporter.callback("endExport", pg2d);
                return;
            }
            Object res1 = pdfexporter.callback("closePage", pg2d);
            if (res1 != null) {
                throw (IOException)res1;
            }
            ++i;
        }
        pdfexporter.callback("endExport", pg2d);
        String message = "Printing into PDF format was successful.\nThe output is saved into \n" + f.getAbsolutePath();
        JOptionPane.showMessageDialog(this.viewPanel, message);
    }

    private class SerializeEndListener
    implements PropertyChangeListener {
        private SerializeEndListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            File tserialFile = null;
            int molcount = -1;
            String name = evt.getPropertyName();
            if (name != null && name.equals("fileSaveEnd")) {
                TableSerializer tableSerToClose = (TableSerializer)evt.getNewValue();
                tableSerToClose.removeListener(this);
                tserialFile = tableSerToClose.getFile();
                molcount = tableSerToClose.getMolCount();
                try {
                    Print2Pdf.this.createPdf(Print2Pdf.this.outputPdf, Print2Pdf.this.pageFormat, tserialFile, molcount);
                }
                catch (IOException ioex) {
                    Print2Pdf.this.viewPanel.getErrorDisplay().error("Print to PDF failed.", ioex);
                }
            }
        }
    }
}

