/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.marvin.modules.print.MultiPageTable;
import chemaxon.marvin.modules.print.PrintFactory;
import chemaxon.marvin.modules.print.PrintProvider;
import chemaxon.marvin.modules.print.TableSerializer;
import chemaxon.marvin.util.CancelPrintException;
import chemaxon.marvin.util.PrintControl;
import chemaxon.marvin.view.swing.ViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PrintPreview
implements PrintControl {
    private ViewPanel viewPanel;
    private int type = 0;
    private PageFormat pageFormat = null;
    private PrintProvider printProvider = null;
    private int pageIndex = 0;

    public PrintPreview() {
    }

    public PrintPreview(ViewPanel viewPanel) {
        this.setContent(viewPanel);
    }

    @Override
    public void setContent(Object content) throws ClassCastException {
        this.viewPanel = (ViewPanel)content;
    }

    @Override
    public void initSettings(int t) throws CancelPrintException {
        this.type = t;
        PrinterJob pjob = PrinterJob.getPrinterJob();
        this.pageFormat = pjob.defaultPage();
    }

    @Override
    public void doPrint() {
        if (this.type == 2) {
            TableSerializer ts = new TableSerializer(this.viewPanel);
            SerializeEndListener selst = new SerializeEndListener();
            ts.addListener(selst);
            ts.saveViewPanelInBackground();
        } else {
            try {
                this.printProvider = new PrintFactory(this.viewPanel).createPrintProvider(this.type);
            }
            catch (InstantiationException instex) {
                this.viewPanel.getErrorDisplay().error(instex.getMessage(), instex);
                return;
            }
            PreviewPanel previewPanel = new PreviewPanel();
            previewPanel.showInDialog();
        }
    }

    private void next() {
        ++this.pageIndex;
    }

    private void previous() {
        --this.pageIndex;
    }

    private class PreviewPanel
    extends JPanel
    implements ActionListener,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        JDialog dialog = null;
        JButton nextButton = null;
        PaperPanel paperPanel = null;

        public PreviewPanel() {
            this.initGUI();
        }

        private Dimension calcMaxSize() {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle rect = ge.getMaximumWindowBounds();
            int w = Math.min(rect.width, (int)PrintPreview.this.pageFormat.getWidth());
            int h = Math.min(rect.height - 40, (int)PrintPreview.this.pageFormat.getHeight());
            return new Dimension(w, h);
        }

        private void updateControlButtons() {
            if (PrintPreview.this.printProvider instanceof MultiPageTable) {
                this.nextButton.setEnabled(((MultiPageTable)PrintPreview.this.printProvider).hasMorePages());
            } else {
                this.nextButton.setEnabled(false);
            }
        }

        private void initGUI() {
            this.setLayout(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setBackground(Color.gray);
            this.paperPanel = new PaperPanel();
            scrollPane.setViewportView(this.paperPanel);
            this.add((Component)scrollPane, "Center");
            this.setPreferredSize(this.calcMaxSize());
            JToolBar toolbar = new JToolBar();
            this.nextButton = new JButton();
            this.nextButton.setText("Next");
            this.nextButton.setActionCommand("next");
            this.nextButton.addActionListener(this);
            toolbar.add(this.nextButton);
            String labelTxt = "Paper size: " + Integer.toString((int)PrintPreview.this.pageFormat.getWidth()) + "x" + Integer.toString((int)PrintPreview.this.pageFormat.getHeight()) + " pixel";
            JLabel label = new JLabel(labelTxt);
            label.setBorder(new EmptyBorder(0, 5, 0, 5));
            toolbar.add(label);
            this.add((Component)toolbar, "First");
            if (!PrintPreview.this.printProvider.isMultiPageSupported()) {
                this.nextButton.setEnabled(false);
            }
            this.paperPanel.addPropertyChangeListener("firstPage", this);
            this.paperPanel.addPropertyChangeListener("lastPage", this);
        }

        public void showInDialog() {
            Dialog parentDialog = PrintPreview.this.viewPanel.getParentDialog();
            Frame parentFrame = PrintPreview.this.viewPanel.getParentFrame();
            this.dialog = parentDialog != null ? new JDialog(parentDialog, "Print Preview") : new JDialog(parentFrame, "Print Preview");
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().setLayout(new GridLayout(1, 1));
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("next")) {
                PrintPreview.this.next();
            } else if (cmd.equals("previous")) {
                PrintPreview.this.previous();
            }
            this.paperPanel.repaint();
            this.updateControlButtons();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name != null && (name.equals("firstPage") || name.equals("lastPage"))) {
                this.updateControlButtons();
            }
        }
    }

    private class PaperPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int emptyInset = 0;
        private int cachedPage = -1;
        private BufferedImage cachedImage = null;

        public PaperPanel() {
            this.setBackground(Color.white);
            LineBorder border = new LineBorder(Color.gray, 20);
            this.setBorder(border);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)PrintPreview.this.pageFormat.getWidth() + this.emptyInset * 2, (int)PrintPreview.this.pageFormat.getHeight() + this.emptyInset * 2);
        }

        private void createCachedImage() throws PrinterException {
            BufferedImage paperSizeImage = new BufferedImage((int)PrintPreview.this.pageFormat.getImageableWidth(), (int)PrintPreview.this.pageFormat.getImageableHeight(), 5);
            Graphics g = paperSizeImage.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, paperSizeImage.getWidth(), paperSizeImage.getHeight());
            PrintPreview.this.printProvider.print(g, PrintPreview.this.pageFormat, PrintPreview.this.pageIndex);
            this.cachedPage = PrintPreview.this.pageIndex;
            this.cachedImage = paperSizeImage;
        }

        private boolean isUpdateCachedImage(int w, int h) {
            if (this.cachedImage != null && this.cachedPage == PrintPreview.this.pageIndex) {
                int ciw = this.cachedImage.getWidth();
                int cih = this.cachedImage.getHeight();
                if (ciw == w && cih == h) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void paint(Graphics g) {
            int pw = (int)PrintPreview.this.pageFormat.getWidth();
            int ph = (int)PrintPreview.this.pageFormat.getHeight();
            int piw = (int)PrintPreview.this.pageFormat.getImageableWidth();
            int pih = (int)PrintPreview.this.pageFormat.getImageableHeight();
            g.setColor(Color.white);
            g.fillRect(0, 0, pw, ph);
            int w = this.getWidth();
            int h = this.getHeight();
            this.getBorder().paintBorder(this, g, 0, 0, w, h);
            int ix = (int)PrintPreview.this.pageFormat.getImageableX();
            int iy = (int)PrintPreview.this.pageFormat.getImageableY();
            int x = ix;
            int y = iy;
            g.translate(x, y);
            try {
                if (this.isUpdateCachedImage(piw, pih)) {
                    this.createCachedImage();
                }
                g.drawImage(this.cachedImage, 0, 0, null);
                if (PrintPreview.this.printProvider.isMultiPageSupported()) {
                    boolean lastPage;
                    boolean firstPage = ((MultiPageTable)PrintPreview.this.printProvider).isFirstPage();
                    boolean bl = lastPage = !((MultiPageTable)PrintPreview.this.printProvider).hasMorePages();
                    if (firstPage) {
                        this.firePropertyChange("firstPage", null, null);
                    }
                    if (lastPage) {
                        this.firePropertyChange("lastPage", null, null);
                    }
                }
            }
            catch (PrinterException pex) {
                pex.printStackTrace();
            }
            g.translate(-x, -y);
        }
    }

    private class SerializeEndListener
    implements PropertyChangeListener {
        private SerializeEndListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            File tserialFile = null;
            int molcount = -1;
            String name = evt.getPropertyName();
            if (name != null && name.equals("fileSaveEnd")) {
                TableSerializer tableSerToClose = (TableSerializer)evt.getNewValue();
                tableSerToClose.removeListener(this);
                tserialFile = tableSerToClose.getFile();
                molcount = tableSerToClose.getMolCount();
                try {
                    PrintPreview.this.printProvider = new PrintFactory(PrintPreview.this.viewPanel, tserialFile, molcount).createPrintProvider(PrintPreview.this.type);
                }
                catch (InstantiationException instex) {
                    PrintPreview.this.viewPanel.getErrorDisplay().error(instex.getMessage(), instex);
                    return;
                }
                PreviewPanel previewPanel = new PreviewPanel();
                previewPanel.showInDialog();
            }
        }
    }
}

