/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.marvin.modules.print.PrintProvider;
import chemaxon.marvin.view.swing.ViewCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

class SimpleCellPanel
implements PrintProvider {
    private ViewCanvas canvas = null;
    private Color background = null;
    private int previousPage = -1;

    public SimpleCellPanel(ViewCanvas c, Color bg) {
        this.canvas = c;
        this.background = bg;
    }

    @Override
    public boolean hasMorePages() {
        return this.previousPage == -1;
    }

    @Override
    public boolean isMultiPageSupported() {
        return false;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        if (pageIndex == this.previousPage) {
            return 1;
        }
        this.previousPage = pageIndex;
        Dimension d = new Dimension();
        int relScale = -1;
        d.setSize(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, d.width, d.height);
        this.canvas.paintGraphics(graphics, d, true, relScale, 0);
        return 0;
    }
}

