/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.MFieldAccessor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modules.print.MultiPageTable;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.TextCellRenderer;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MStringProp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

class SpreadsheetMPageTable
extends MultiPageTable {
    private static final int T_RECORD_NUMBER = 0;
    private static final int T_MOLECULE = 1;
    private static final int T_TEXT = 2;
    private PageTableModel tableModel = new PageTableModel();
    private JTable table;
    private JPanel tablePanel = null;

    public SpreadsheetMPageTable(ViewPanel viewPanel, File f, Integer molcount) {
        super(viewPanel, f, molcount);
        this.initDocStorage();
        String nameargs = viewPanel.getViewHandler().getNameAndArgs();
        String headerdef = null;
        if (nameargs.startsWith("SpreadsheetView:")) {
            headerdef = nameargs.substring("SpreadsheetView:".length());
        }
        this.tableModel.createHeader(headerdef);
    }

    @Override
    public int getMaxRecPerPage() {
        return this.rowPerPage;
    }

    @Override
    protected void initTablePanel(int paperWidth, int paperHeight) {
        this.tablePanel = new JPanel();
        this.table = new JTable(this.tableModel){

            @Override
            public int getRowCount() {
                return SpreadsheetMPageTable.this.getMaxRecPerPage();
            }
        };
        this.table.setDefaultRenderer(String.class, new TextCellRenderer(0, null, null));
        this.table.setDefaultRenderer(Integer.class, new TextCellRenderer(1, null, null));
        MViewCellRenderer cellRenderer = new MViewCellRenderer();
        this.table.setDefaultRenderer(MDocument.class, cellRenderer);
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.table.getTableHeader(), "First");
        this.tablePanel.add((Component)this.table, "Center");
        int defaultRowHeight = paperHeight / this.rowPerPage;
        this.tablePanel.setPreferredSize(new Dimension(paperWidth, paperHeight));
        this.table.setRowHeight(defaultRowHeight);
        this.tablePanel.validate();
    }

    private void displayTablePanel() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(this.tablePanel);
        frame.pack();
    }

    @Override
    public boolean isFirstPage() {
        return this.shift == 0;
    }

    @Override
    public void nextPage() {
        boolean visible = this.tablePanel.isVisible();
        if (visible) {
            this.tablePanel.setVisible(false);
        } else {
            this.tablePanel.invalidate();
        }
        this.hasMorePages();
        this.shift += this.getMaxRecPerPage();
        this.docStorage.setCacheCapacity(this.getMaxRecPerPage() * 2);
        this.docStorage.setDocSource(this.docStorage.getDocSource(), this.shift, this.getMaxRecPerPage());
        if (this.maxrec != -1 && this.shift > this.maxrec) {
            this.docStorage.setSize(this.shift - this.maxrec);
        }
        this.hasMorePages();
        if (visible) {
            this.tablePanel.setVisible(true);
        } else {
            this.tablePanel.validate();
        }
    }

    @Override
    public void previousPage() {
        this.shift -= this.getMaxRecPerPage();
        this.docStorage.setCacheCapacity(this.getMaxRecPerPage() * 2);
        this.docStorage.setDocSource(this.docStorage.getDocSource(), this.shift, this.getMaxRecPerPage());
    }

    @Override
    public boolean hasMorePages() {
        return (this.previousPage + 1) * this.getMaxRecPerPage() < this.maxrec;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D graphics = (Graphics2D)g;
        if (!this.hasMorePages()) {
            return 1;
        }
        if (pageIndex == this.previousPage) {
            return 1;
        }
        this.previousPage = pageIndex;
        Dimension d = new Dimension();
        d.setSize(pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        if (this.tablePanel == null) {
            this.initTablePanel(d.width, d.height);
            this.displayTablePanel();
        } else {
            this.nextPage();
        }
        this.tablePanel.print(graphics);
        return 0;
    }

    class MViewCellRenderer
    extends ViewPanel
    implements TableCellRenderer {
        public MViewCellRenderer() {
            super(null, 2, null);
            super.init();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object doc, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            if (doc == null) {
                return null;
            }
            int rh = table.getRowHeight(rowIndex);
            int cc = table.getColumnCount();
            int cellwidth = table.getWidth() / cc;
            this.setPreferredSize(new Dimension(cellwidth, rh));
            MDocument document = (MDocument)doc;
            Molecule m = (Molecule)document.getMainMoleculeGraph();
            if (m != null) {
                this.setM(0, m);
            }
            return this;
        }
    }

    class PageTableModel
    extends AbstractTableModel {
        private String[] cellOptions = null;
        private int[] cellTypes = null;

        private void createHeader(String args) {
            if (args == null) {
                this.cellOptions = new String[]{null, null, "$MolName"};
                this.cellTypes = new int[]{0, 1};
                return;
            }
            String args1 = args.replaceFirst(",\\|", "");
            String pat = "@#%";
            String nocommargs = args1.indexOf("\\,") != -1 ? args1.replaceAll("\\\\,", pat) : args1;
            StringTokenizer stk = new StringTokenizer(nocommargs, ",");
            this.cellOptions = new String[stk.countTokens()];
            this.cellTypes = new int[stk.countTokens()];
            for (int i = 0; i < this.cellTypes.length; ++i) {
                String s = stk.nextToken();
                if (!nocommargs.equals(args1)) {
                    s = s.replaceAll(pat, ",");
                }
                if (s.equals("#")) {
                    this.cellTypes[i] = 0;
                    this.cellOptions[i] = null;
                    continue;
                }
                if (s.equals("M")) {
                    this.cellTypes[i] = 1;
                    this.cellOptions[i] = null;
                    continue;
                }
                if (s.startsWith("T:")) {
                    this.cellTypes[i] = 2;
                    this.cellOptions[i] = s.substring("T:".length());
                    continue;
                }
                this.cellTypes[i] = 2;
                this.cellOptions[i] = null;
            }
        }

        @Override
        public String getColumnName(int i) {
            String name = this.cellOptions[i];
            if (name != null) {
                return name;
            }
            int t = this.cellTypes[i];
            if (t == 1) {
                return "structure";
            }
            if (t == 0) {
                return "#";
            }
            return "*";
        }

        public Class getColumnClass(int columnIndex) {
            int t = this.cellTypes[columnIndex];
            if (t == 0) {
                return Integer.class;
            }
            if (t == 1) {
                return MDocument.class;
            }
            if (t == 2) {
                return String.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getColumnCount() {
            int cc = this.cellTypes.length;
            return cc;
        }

        @Override
        public int getRowCount() {
            int rc = SpreadsheetMPageTable.this.docStorage.getSize();
            if (SpreadsheetMPageTable.this.maxrec != -1) {
                rc = Math.min(rc, SpreadsheetMPageTable.this.maxrec - SpreadsheetMPageTable.this.shift);
            }
            if (rc == 0) {
                rc = 1;
            }
            return rc;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object v;
            block16: {
                if (!this.isInRowIndexRange(SpreadsheetMPageTable.this.shift + rowIndex)) {
                    return null;
                }
                v = null;
                try {
                    MDocument doc = SpreadsheetMPageTable.this.docStorage.getDoc(rowIndex, null, null);
                    String colName = this.getColumnName(columnIndex);
                    if (colName.equals("structure")) {
                        v = doc;
                        break block16;
                    }
                    if (colName.equals("#")) {
                        v = new Integer(SpreadsheetMPageTable.this.shift + rowIndex + 1);
                        break block16;
                    }
                    if (colName.equals("$MolName")) {
                        Molecule m = doc.getPrimaryMolecule();
                        v = m.getName();
                        break block16;
                    }
                    if (colName.equals("$SMILES")) {
                        try {
                            v = doc.exportToFormat("smiles");
                        }
                        catch (MolExportException mex) {
                            v = null;
                        }
                        break block16;
                    }
                    if (colName.equals("$GenName")) {
                        String name = null;
                        if (LicenseHandler.getInstance().isLicensed("Structure to Name Plugin")) {
                            Molecule mol = doc.getPrimaryMolecule();
                            try {
                                name = mol.exportToFormat("name");
                            }
                            catch (MolExportException ex) {
                                for (Throwable t = ex; t != null; t = t.getCause()) {
                                    name = t.getMessage();
                                }
                            }
                        }
                        v = name;
                        break block16;
                    }
                    MFieldAccessor mfa = SpreadsheetMPageTable.this.docStorage.getFieldAccessor();
                    Molecule mol = (Molecule)doc.getMainMoleculeGraph();
                    String[] keys = mfa.getKeys(rowIndex, mol);
                    MProp[] values = new MProp[keys.length];
                    mfa.getFields(rowIndex, mol, keys, values);
                    for (int i = 0; i < values.length; ++i) {
                        if (!keys[i].equals(colName)) continue;
                        v = values[i];
                    }
                    if (v instanceof MStringProp) {
                        MStringProp msp = (MStringProp)v;
                        v = msp.getPropValue();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return v;
        }

        boolean isInRowIndexRange(int x) {
            if (x < 0) {
                return false;
            }
            if (SpreadsheetMPageTable.this.maxrec != -1) {
                return SpreadsheetMPageTable.this.maxrec > x;
            }
            return true;
        }
    }
}

