/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.print;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.SequentialScheduler;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMoleculeGraphIface;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class TableSerializer {
    public static final String TABLESERIALIZE_END_PROPNAME = "fileSaveEnd";
    private File file = null;
    private int rows;
    private int cols;
    private int molcount = 0;
    private boolean enableRgrps = false;
    private ViewPanel viewPanel;
    private PropertyChangeSupport changeListener = null;

    public TableSerializer(ViewPanel viewPanel) {
        this.viewPanel = viewPanel;
        this.rows = viewPanel.getVisibleRows();
        this.cols = viewPanel.getVisibleCols();
        this.enableRgrps = viewPanel.isEnableRgroups();
        File f = null;
        try {
            f = File.createTempFile("print", ".mrv");
            f.deleteOnExit();
            this.file = f;
        }
        catch (IOException ioex) {
            System.err.println("Cannot create temporary file.");
            return;
        }
    }

    private boolean saveMol(File f, MDocument d, MolExportModule cv) throws MolExportException, IOException {
        Molecule mol;
        Molecule molecule = mol = d != null ? d.getPrimaryMolecule() : null;
        if (mol != null && !mol.isEmpty() && !this.enableRgrps && mol instanceof RgMoleculeGraphIface) {
            mol = (Molecule)((RgMoleculeGraphIface)((Object)mol)).getRootG();
        }
        if (mol != null) {
            String molstr = (String)cv.convert(mol);
            this.append2File(molstr);
            ++this.molcount;
            return true;
        }
        return false;
    }

    private void endSave(File f, MolExportModule cv, final String format2) {
        try {
            String footer = (String)cv.close();
            this.append2File(footer);
        }
        catch (IOException ex) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableSerializer.this.displayError("Cannot convert molecule(s) to `" + format2 + "' format", ex);
                }
            });
        }
    }

    private void displayError(String msg, Throwable ex) {
        this.viewPanel.getErrorDisplay().error(msg, ex);
    }

    public void addListener(PropertyChangeListener listener) {
        if (this.changeListener == null) {
            this.changeListener = new PropertyChangeSupport(this);
        }
        this.changeListener.addPropertyChangeListener(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        if (this.changeListener != null) {
            this.changeListener.removePropertyChangeListener(listener);
        }
    }

    private void notifyAboutTableSerializeEnd() {
        this.changeListener.firePropertyChange(TABLESERIALIZE_END_PROPNAME, null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveViewPanelInBackground() {
        String format2 = "mrv";
        try {
            MolExportModule cv = MFileFormatUtil.createExportModule(format2);
            if (cv == null) {
                throw new Exception("Cannot load export module for '" + format2 + "'");
            }
            String header = (String)cv.open(format2);
            this.append2File(header);
            ViewHandler vhandler = this.viewPanel.getViewHandler();
            SequentialScheduler scheduler = vhandler.getScheduler();
            SaveThread r = new SaveThread(this.file, cv, format2, scheduler);
            scheduler.invokeLater(r, 0, "printAll");
        }
        catch (SecurityException sex) {
            this.viewPanel.getErrorDisplay().firewallError(sex, null);
        }
        catch (Throwable ex) {
            this.displayError("Cannot convert molecule(s) to `" + format2 + "' format", ex);
        }
        finally {
            this.viewPanel.endHourglass();
        }
    }

    private void append2File(String s) throws IOException {
        FileOutputStream fout = new FileOutputStream(this.file, true);
        fout.write(s.getBytes());
        fout.close();
    }

    public File getFile() {
        return this.file;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getMolCount() {
        return this.molcount;
    }

    private class SaveThread
    implements Runnable {
        private File f;
        private final MolExportModule cv;
        private final String format;
        private final SequentialScheduler scheduler;
        private int startpos = 0;
        private boolean isStartedHourglass = false;

        private SaveThread(File f, MolExportModule cv, String format2, SequentialScheduler scheduler) {
            this.f = f;
            this.cv = cv;
            this.format = format2;
            this.scheduler = scheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void end() {
            try {
                TableSerializer.this.endSave(this.f, this.cv, this.format);
            }
            finally {
                TableSerializer.this.viewPanel.endHourglass();
                TableSerializer.this.notifyAboutTableSerializeEnd();
            }
        }

        @Override
        public void run() {
            MDocStorage ds = TableSerializer.this.viewPanel.getViewHandler().getStorage();
            int n = ds.getSize();
            if (!this.isStartedHourglass) {
                TableSerializer.this.viewPanel.beginHourglass();
                this.isStartedHourglass = true;
            }
            try {
                int x = this.startpos;
                while (x < n) {
                    MDocument d = ds.getMainDoc(x++);
                    TableSerializer.this.saveMol(this.f, d, this.cv);
                }
                this.startpos = n;
            }
            catch (IOException ex) {
                this.end();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TableSerializer.this.displayError("Cannot convert molecule(s) to `" + SaveThread.this.format + "' format", ex);
                    }
                });
                return;
            }
            catch (MDocStorage.RecordUnavailableException ex) {
                this.end();
                return;
            }
            if (ds.getSize() == n) {
                this.end();
            } else {
                String name = "printSaveAll(" + n + "-";
                this.scheduler.invokeLater(this, n, name);
            }
        }
    }
}

