/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.smarts;

import chemaxon.marvin.modules.smarts.Node;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParser;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParserTreeConstants;
import chemaxon.marvin.modules.smarts.SmartsBondTreeParserTreeConstants;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected SmartsAtomTreeParser parser;
    protected String value = null;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(SmartsAtomTreeParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString(boolean isBondExpression) {
        String nodeName = isBondExpression ? SmartsBondTreeParserTreeConstants.jjtNodeName[this.id] : SmartsAtomTreeParserTreeConstants.jjtNodeName[this.id];
        return nodeName + " " + this.getValue();
    }

    public String toString(String prefix, boolean isBondExpression) {
        return prefix + this.toString(isBondExpression);
    }

    public void dump(String prefix, boolean isBondExpression) {
        System.out.println(this.toString(prefix, isBondExpression));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ", isBondExpression);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int newId) {
        this.id = newId;
    }

    public static boolean compareSMARTSBondTrees(SimpleNode t1, SimpleNode t2) {
        if (t1.getId() != t2.getId() || t1.getValue() != t2.getValue() || t1.jjtGetNumChildren() != t2.jjtGetNumChildren()) {
            return false;
        }
        for (int i = 0; i < t1.jjtGetNumChildren(); ++i) {
            if (SimpleNode.compareSMARTSBondTrees((SimpleNode)t1.jjtGetChild(i), (SimpleNode)t2.jjtGetChild(i))) continue;
            return false;
        }
        return true;
    }

    public String toSmartsAtom() {
        String s = this.toSmartsAtomRecursive(this.hasAndOr() ? 0 : 2);
        if (s != null) {
            return "[" + s + "]";
        }
        return null;
    }

    private String toSmartsAtomRecursive(int andLevel) {
        String retVal = null;
        switch (this.id) {
            case 9: {
                retVal = this.value == null ? null : ":" + this.value;
                break;
            }
            case 6: {
                if ("H".equals(this.value)) {
                    retVal = "#1A";
                    break;
                }
                retVal = this.value;
                break;
            }
            case 7: {
                retVal = this.value;
                break;
            }
            case 5: {
                if ("H".equals(this.value)) {
                    retVal = "H1";
                    break;
                }
                if ("h".equals(this.value)) {
                    retVal = "h1";
                    break;
                }
                retVal = this.value;
                break;
            }
            case 8: {
                retVal = "$(" + this.value + ")";
                break;
            }
            case 4: {
                retVal = this.toSmartsAtomProcessChildren("", "!", andLevel);
                break;
            }
            case 1: {
                String separator = andLevel == 0 ? ";" : "";
                retVal = this.toSmartsAtomProcessChildren(separator, "", andLevel + 1);
                break;
            }
            case 2: {
                String separator = ",";
                retVal = this.toSmartsAtomProcessChildren(separator, "", andLevel + 1);
                break;
            }
        }
        return retVal;
    }

    private String toSmartsAtomProcessChildren(String separator, String prefix, int andLevel) {
        StringBuffer buffer = new StringBuffer(prefix);
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            String childValue = ((SimpleNode)this.jjtGetChild(i)).toSmartsAtomRecursive(andLevel);
            if (childValue == null) continue;
            if (buffer.length() > 0) {
                buffer.append(separator);
            }
            buffer.append(childValue);
        }
        return buffer.length() == 0 ? null : buffer.toString();
    }

    private boolean hasAndOr() {
        if (this.getId() == 1) {
            for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
                SimpleNode child = (SimpleNode)this.jjtGetChild(i);
                if (child.getId() != 2) continue;
                return true;
            }
        }
        return false;
    }

    public SimpleNode getANDGrandChild(int i, int i1) {
        SimpleNode child = (SimpleNode)this.jjtGetChild(i);
        if (child.getId() != 1) {
            return child;
        }
        return (SimpleNode)child.jjtGetChild(i1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleNode) {
            String thisV;
            SimpleNode other = (SimpleNode)obj;
            String otherV = other.getValue();
            if (otherV == null) {
                otherV = "";
            }
            if ((thisV = this.getValue()) == null) {
                thisV = "";
            }
            if (other.getId() == this.getId() && otherV.equals(thisV) && other.jjtGetNumChildren() == this.jjtGetNumChildren()) {
                for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
                    if (this.jjtGetChild(i).equals(other.jjtGetChild(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

