/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.win;

import chemaxon.marvin.util.Environment;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class InstallMarvinBeans {
    static String arch = System.getProperty("os.arch").equals("x86") ? "i586" : "amd64";
    static String[] beansfiles = new String[]{"MarvinBeans.jar", "aloe-1.0.jar", "batik-core-1.0.jar", "chart-1.0.jar", "cxnregistry-native-x86-1.0.jar", "cxnregistry-native-x64-1.0.jar", "forms-1.1.0.jar", "freehep-graphics2d-2.1.1.jar", "freehep-graphicsio-2.1.1.jar", "freehep-graphicsio-emf-2.1.1.jar", "freehep-graphicsio-pdf-2.1.1.jar", "freehep-io-2.0.2.jar", "freehep-util-2.0.2.jar", "gluegen-rt-1.1.1a.jar", "inchi-native-windows-1.3.jar", "jacob-1.15.jar", "jacob-native-x86-1.15.jar", "jacob-native-x64-1.15.jar", "jextexp-1.0.jar", "jnbtools-1.0.jar", "jogl-1.1.1a.jar", "gluegen-rt-natives-windows-" + arch + "-1.1.1a.jar", "jogl-natives-windows-" + arch + "-1.1.1a.jar", "looks-2.1.4.jar", "marvinOLEServer.exe"};

    public InstallMarvinBeans(URL downloadurl, File targetdir) throws MalformedURLException, IOException {
        for (int i = 0; i < beansfiles.length; ++i) {
            URL remoteurl = new URL(downloadurl, beansfiles[i]);
            File localfile = new File(targetdir, beansfiles[i]);
            if (localfile.exists()) {
                URLConnection conn = remoteurl.openConnection();
                long clength = conn.getContentLength();
                long flength = localfile.length();
                if (flength == clength) continue;
                Environment.downloadURL(remoteurl, localfile);
                continue;
            }
            Environment.downloadURL(remoteurl, localfile);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Missing parameter.");
            System.exit(1);
        }
        URL downloadURL = new URL(args[0]);
        File targetdir = DotfileUtil.getDotFile("lib/marvinbeans");
        new InstallMarvinBeans(downloadURL, targetdir);
    }
}

