/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.win;

import chemaxon.marvin.modules.NativeLibrary;
import chemaxon.marvin.modules.win.emf.EMFExporter;
import chemaxon.marvin.modules.win.emf.NullEMFExporter;
import chemaxon.marvin.modules.win.emf.WinEMFExporter;
import chemaxon.marvin.modules.win.ole.NullOLEDocument;
import chemaxon.marvin.modules.win.ole.NullOLELibInfo;
import chemaxon.marvin.modules.win.ole.OLEDocument;
import chemaxon.marvin.modules.win.ole.OLELibInfo;
import chemaxon.marvin.modules.win.ole.WinOLEDocument;
import chemaxon.marvin.modules.win.ole.WinOLELibInfo;
import chemaxon.marvin.modules.win.registry.NullRegistryUtil;
import chemaxon.marvin.modules.win.registry.RegistryUtil;
import chemaxon.marvin.modules.win.registry.WinRegistryUtil;
import chemaxon.marvin.util.Environment;
import chemaxon.util.DotfileUtil;
import java.io.File;

public class Jacob
extends NativeLibrary {
    private static final String JACOB_VERSION = "1.15";
    private static final File DLLDIR = DotfileUtil.getDotFile("lib/jacob-1.15");
    private static final String LIBNAME = "jacob-1.15-M3-%arch%.dll";
    private static final String JARNAME = "jacob-native-%arch%-1.15.jar";
    private static boolean native_code_usable = true;
    private static Jacob instance = null;
    private static RegistryUtil regutil = null;
    private static OLEDocument oledoc = null;
    private static OLELibInfo libinfo = null;
    private static EMFExporter emf = null;

    private Jacob() {
        super(LIBNAME, JARNAME, DLLDIR);
        if (native_code_usable) {
            System.setProperty("jacob.dll.path", this.dllPath);
        }
    }

    public static synchronized Jacob getInstance() {
        if (instance == null) {
            instance = new Jacob();
            regutil = Jacob.createRegistryUtil();
            oledoc = Jacob.createOLEDocument();
            if (oledoc.isUsable()) {
                libinfo = Jacob.createOLELibInfo();
            }
            emf = Jacob.createEMFExporter();
        }
        return instance;
    }

    @Override
    protected boolean isPreferredOS() {
        return Environment.MSWINDOWS;
    }

    @Override
    protected void initializationFailed() {
        native_code_usable = false;
    }

    private static RegistryUtil createRegistryUtil() {
        if (!native_code_usable) {
            return new NullRegistryUtil();
        }
        WinRegistryUtil u = null;
        try {
            u = new WinRegistryUtil();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (u == null || !u.isUsable()) {
            return new NullRegistryUtil();
        }
        return u;
    }

    private static OLEDocument createOLEDocument() {
        if (!native_code_usable) {
            return new NullOLEDocument();
        }
        WinOLEDocument d = new WinOLEDocument();
        if (!d.isUsable()) {
            return new NullOLEDocument();
        }
        return d;
    }

    private static OLELibInfo createOLELibInfo() {
        if (!native_code_usable) {
            return new NullOLELibInfo();
        }
        WinOLELibInfo d = new WinOLELibInfo();
        if (!d.isUsable()) {
            return new NullOLELibInfo();
        }
        return d;
    }

    private static EMFExporter createEMFExporter() {
        if (!native_code_usable) {
            return new NullEMFExporter();
        }
        WinEMFExporter d = new WinEMFExporter();
        if (!d.isUsable()) {
            return new NullEMFExporter();
        }
        return d;
    }

    public RegistryUtil getRegistryUtil() {
        return regutil;
    }

    public OLEDocument getOLEDocument() {
        return oledoc;
    }

    public OLELibInfo getOLELibInfo() {
        return libinfo;
    }

    public EMFExporter getEMFExporter() {
        return emf;
    }

    public boolean isSupported() {
        return native_code_usable;
    }
}

