/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modules.win.registry;

import chemaxon.marvin.modules.NativeLibrary;
import chemaxon.marvin.modules.win.registry.RegistryUtil;
import chemaxon.marvin.util.Environment;
import chemaxon.util.DotfileUtil;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import java.io.IOException;

public class WinRegistryUtil
extends NativeLibrary
implements RegistryUtil {
    private static final File DLLDIR = DotfileUtil.getDotFile("lib/registry");
    private static final String LIBNAME = "registry_lib_%arch%.dll";
    private static final String JARNAME = "cxnregistry-native-%arch%-1.0.jar";
    private boolean usable = true;
    private Dispatch winObject;

    public WinRegistryUtil() {
        super(LIBNAME, JARNAME, DLLDIR);
        if (!this.isUsable()) {
            return;
        }
        try {
            this.winObject = new Dispatch("CXNRegistryLib.RegistryHelper");
        }
        catch (Throwable e) {
            ProcessBuilder builder = new ProcessBuilder("regsvr32", "/s", this.dllPath);
            try {
                Process p = builder.start();
                p.waitFor();
                this.winObject = new Dispatch("CXNRegistryLib.RegistryHelper");
            }
            catch (IOException e1) {
                this.usable = false;
            }
            catch (InterruptedException e1) {
                this.usable = false;
            }
            catch (Throwable e2) {
                this.usable = false;
            }
        }
    }

    @Override
    protected boolean isPreferredOS() {
        return Environment.MSWINDOWS;
    }

    @Override
    protected void initializationFailed() {
        this.usable = false;
    }

    @Override
    public boolean isUsable() {
        return this.usable;
    }

    @Override
    public void close() {
        if (!this.isUsable()) {
            return;
        }
        try {
            Dispatch.call((Dispatch)this.winObject, (String)"Close");
        }
        catch (Throwable e) {
            this.usable = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLongValue(String valueName, long defaultValue) {
        if (!this.isUsable()) {
            return 0L;
        }
        Variant v = null;
        long retval = defaultValue;
        try {
            v = Dispatch.call((Dispatch)this.winObject, (String)"GetLongValue", (Object)valueName, (Object)defaultValue);
            if (v != null && !v.isNull()) {
                if (v.getvt() == 20) {
                    retval = v.getLong();
                } else if (v.getvt() == 3) {
                    retval = v.getInt();
                }
            }
        }
        catch (Throwable ex) {
        }
        finally {
            if (v != null) {
                v.safeRelease();
                v = null;
            }
        }
        return retval;
    }

    @Override
    public long getLongValue(String valueName) {
        return this.getLongValue(valueName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringValue(String valueName, String defaultValue) {
        if (!this.isUsable()) {
            return "";
        }
        Variant v = null;
        String retval = defaultValue;
        try {
            v = Dispatch.call((Dispatch)this.winObject, (String)"GetStringValue", (Object)valueName, (Object)defaultValue);
            if (v != null && !v.isNull()) {
                retval = v.getString();
            }
        }
        catch (Throwable ex) {
        }
        finally {
            if (v != null) {
                v.safeRelease();
                v = null;
            }
        }
        return retval;
    }

    @Override
    public String getStringValue(String valueName) {
        return this.getStringValue(valueName, "");
    }

    @Override
    public void open(int keyParent, String key, boolean isForWrite) {
        if (!this.isUsable()) {
            return;
        }
        try {
            Dispatch.call((Dispatch)this.winObject, (String)"open", (Object)keyParent, (Object)key, (Object)isForWrite);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    @Override
    public void putLongValue(String valueName, long value) {
        if (!this.isUsable()) {
            return;
        }
        try {
            Dispatch.call((Dispatch)this.winObject, (String)"PutLongValue", (Object)valueName, (Object)value);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    @Override
    public void putStringValue(String valueName, String value) {
        if (!this.isUsable()) {
            return;
        }
        try {
            Dispatch.call((Dispatch)this.winObject, (String)"PutStringValue", (Object)valueName, (Object)value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isHKCRAccessible() {
        if (!this.isUsable()) {
            return false;
        }
        String key = "CLSID\\{726054A0-3C26-45D1-AB4C-E6E70F1E81DE}";
        this.deleteKey(Integer.MIN_VALUE, "CLSID\\{726054A0-3C26-45D1-AB4C-E6E70F1E81DE}");
        boolean retval = false;
        this.open(Integer.MIN_VALUE, "CLSID\\{726054A0-3C26-45D1-AB4C-E6E70F1E81DE}", true);
        this.putLongValue("test", 1L);
        this.close();
        this.open(Integer.MIN_VALUE, "CLSID\\{726054A0-3C26-45D1-AB4C-E6E70F1E81DE}", false);
        if (this.getLongValue("test") == 1L) {
            retval = true;
        }
        this.close();
        this.deleteKey(Integer.MIN_VALUE, "CLSID\\{726054A0-3C26-45D1-AB4C-E6E70F1E81DE}");
        return retval;
    }

    @Override
    public void deleteValue(String valueName) {
        try {
            Dispatch.call((Dispatch)this.winObject, (String)"deleteValue", (Object)valueName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void deleteKey(int keyParent, String key) {
        try {
            Dispatch.call((Dispatch)this.winObject, (String)"deleteKey", (Object)keyParent, (Object)key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

