/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AromatiCalc {
    private transient DPoint3[] screenCoords;
    private MoleculeGraph mol;
    private List<MolBond> visited = null;
    private int numatoms = 0;
    private List<DPoint3> vcoords = null;

    public AromatiCalc(DPoint3[] scrcrds, MoleculeGraph m) {
        this.screenCoords = scrcrds;
        this.mol = m;
        this.vcoords = new ArrayList<DPoint3>();
        this.visited = new ArrayList<MolBond>();
    }

    public double calcLineEnd(MolBond start, MolAtom a2, double dir) {
        MolAtom a1 = start.getOtherAtom(a2);
        int i1 = this.mol.indexOf(a1);
        int i2 = this.mol.indexOf(a2);
        if (i1 == -1 || i2 == -1) {
            return -1.0;
        }
        DPoint3 p1 = this.screenCoords[i1];
        DPoint3 p2 = this.screenCoords[i2];
        double deltax = p2.x - p1.x;
        double deltay = p2.y - p1.y;
        double r = Math.sqrt(deltax * deltax + deltay * deltay);
        if (r == 0.0) {
            return -1.0;
        }
        double ex12 = deltax / r;
        double ey12 = deltay / r;
        double sinthetaMin = -1.0;
        double costhetaMin = 1.0;
        for (int i = 0; i < a2.getBondCount(); ++i) {
            MolBond b23 = a2.getBond(i);
            MolAtom a3 = b23.getOtherAtom(a2);
            int i3 = this.mol.indexOf(a3);
            if (i3 == -1) {
                return 0.0;
            }
            DPoint3 p3 = this.screenCoords[i3];
            if (b23 == start || a2.getAtno() == 1) continue;
            deltax = p3.x - p2.x;
            deltay = p3.y - p2.y;
            r = Math.sqrt(deltax * deltax + deltay * deltay);
            if (r == 0.0) {
                return 0.0;
            }
            double ey23 = deltay / r;
            double ex23 = deltax / r;
            double sintheta = (ex12 * ey23 - ey12 * ex23) * dir;
            if (!(sintheta > sinthetaMin)) continue;
            sinthetaMin = sintheta;
            costhetaMin = ex12 * ex23 + ey12 * ey23;
        }
        double phi = Math.acos(costhetaMin);
        return phi < 1.5707963267948966 ? Math.tan(phi / 2.0) : 1.0;
    }

    public int getNumAtoms() {
        return this.numatoms;
    }

    public ArrayList<Integer> getRingsContainingBond(MolBond b, int[][] sssrIdx) {
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        ArrayList<Integer> ringIndexes = new ArrayList<Integer>();
        int ind1 = this.mol.indexOf(a1);
        int ind2 = this.mol.indexOf(a2);
        int n = sssrIdx[ind1].length;
        int k = sssrIdx[ind2].length;
        for (int i = 0; i < n; ++i) {
            boolean found = false;
            for (int j = 0; j < k && !found; ++j) {
                if (sssrIdx[ind1][i] != sssrIdx[ind2][j]) continue;
                ringIndexes.add(sssrIdx[ind1][i]);
                found = true;
            }
        }
        return ringIndexes;
    }

    public ArrayList<ArrayList<Integer>> getAromaticRings(ArrayList<Integer> rings, int[][] sssr) {
        ArrayList<ArrayList<Integer>> aromrings = new ArrayList<ArrayList<Integer>>();
        for (Integer ring : rings) {
            int n = sssr[ring].length;
            ArrayList<Integer> ringr = new ArrayList<Integer>();
            for (int j = 0; j < n; ++j) {
                ringr.add(sssr[ring][j]);
            }
            boolean arom = true;
            for (int j = 0; j < n && arom; ++j) {
                MolAtom a0 = this.mol.getAtom((Integer)ringr.get(j));
                int m = a0.getBondCount();
                for (int l = 0; l < m; ++l) {
                    MolBond b0 = a0.getBond(l);
                    MolAtom a1 = b0.getOtherAtom(a0);
                    int ia1 = this.mol.indexOf(a1);
                    if (!ringr.contains(ia1) || b0.getType() == 4) continue;
                    arom = false;
                }
            }
            if (!arom) continue;
            aromrings.add(ringr);
        }
        return aromrings;
    }

    public int calcDoubleBondSidedness(MolBond b, MolAtom a1, MolAtom a2, DPoint3 p1, DPoint3 p2, int[][] sssr, int[][] sssrIdx) {
        return this.calcDoubleBondSidedness(b, a1, a2, p1, p2, 0, 0, sssr, sssrIdx);
    }

    public int calcDoubleBondSidedness(MolBond b, MolAtom a1, MolAtom a2, DPoint3 p1, DPoint3 p2, int lab1, int lab2, int[][] sssr, int[][] sssrIdx) {
        int d = 1;
        if (p2.y < p1.y || Math.abs(p2.y - p1.y) == 0.0 && p2.x < p1.x) {
            DPoint3 tp = p1;
            p1 = p2;
            p2 = tp;
            MolAtom ta = a1;
            a1 = a2;
            a2 = ta;
            int tl = lab1;
            lab1 = lab2;
            lab2 = tl;
            d = -1;
        }
        int a1BondsNo = a1.getBondCount();
        int a2BondsNo = a2.getBondCount();
        int stereo1 = b.getFlags() & 0x30;
        if (!b.isBold() && stereo1 == 0 && this.isCentered(b, a1, a2, p1, p2, lab1, lab2, a1BondsNo, a2BondsNo)) {
            return 0;
        }
        ArrayList<Integer> ringIndexes = this.getRingsContainingBond(b, sssrIdx);
        if (this.mol.isRingBond(this.mol.indexOf(b)) && ringIndexes.size() != 0) {
            if (ringIndexes.size() == 1) {
                DPoint3 cp = this.calcCenter(sssr[ringIndexes.get(0)]);
                return d * DrawingUtil.getBondSideToPoint(p1, p2, cp);
            }
            return d * this.getBondSide_TwoRings(b, a1, a2, p1, p2, sssr, ringIndexes);
        }
        int side = this.getBondSideToMoreNeighbours(b, a1, a2, a1BondsNo, a2BondsNo, p1, p2);
        if (side == 0 && Math.abs(p2.y - p1.y) < 0.01) {
            return p2.x < p1.x ? d : -1 * d;
        }
        if (side == 0) {
            return d;
        }
        return d * side;
    }

    public int calcAromaticBondSidedness(MolBond b, MolAtom a1, MolAtom a2, DPoint3 p1, DPoint3 p2, int[][] sssr, int[][] sssrIdx) {
        int a2BondsNo;
        int a1BondsNo;
        int side;
        int d = 1;
        if (p2.y < p1.y || Math.abs(p2.y - p1.y) == 0.0 && p2.x < p1.x) {
            DPoint3 tp = p1;
            p1 = p2;
            p2 = tp;
            MolAtom ta = a1;
            a1 = a2;
            a2 = ta;
            d = -1;
        }
        if ((side = this.getBondSideToSameTypeNeighbours(b, a1, a2, a1BondsNo = a1.getBondCount(), a2BondsNo = a2.getBondCount(), p1, p2)) == 0) {
            if (this.mol.isRingBond(this.mol.indexOf(b))) {
                ArrayList<Integer> ringIndexes = this.getRingsContainingBond(b, sssrIdx);
                if (ringIndexes.size() == 1) {
                    DPoint3 cp = this.calcCenter(sssr[ringIndexes.get(0)]);
                    return d * DrawingUtil.getBondSideToPoint(p1, p2, cp);
                }
                if (ringIndexes.size() == 2) {
                    return d * this.getBondSide_TwoRings(b, a1, a2, p1, p2, sssr, ringIndexes);
                }
                return d;
            }
            if (Math.abs(p2.y - p1.y) < 0.01) {
                return p2.x < p1.x ? d : -1 * d;
            }
            return d;
        }
        return d * side;
    }

    public int calculateRingCoords(MolBond start, MolAtom a2, ArrayList<Integer> ratoms, double[] rcoords, boolean[] samecolors, Map<Integer, ArrayList<Integer>> ringBondIndexes, double scale, double d) {
        int ret;
        if (rcoords == null || rcoords.length < 6) {
            return -1;
        }
        this.numatoms = ratoms.size();
        MolAtom a1 = start.getOtherAtom(a2);
        Integer i1 = this.mol.indexOf(a1);
        Integer i2 = this.mol.indexOf(a2);
        if (i1 == -1 || i2 == -1) {
            return -1;
        }
        DPoint3 p1 = this.screenCoords[i1];
        DPoint3 p2 = this.screenCoords[i2];
        if (p2.y < p1.y - 0.01 || Math.abs(p2.y - p1.y) <= 0.01 && p2.x > p1.x + 0.01) {
            MolAtom ta = a1;
            a1 = a2;
            a2 = ta;
        }
        boolean found = false;
        MolBond neighbour = null;
        for (int j = 0; j < a2.getBondCount() && !found; ++j) {
            MolAtom a3;
            int i3;
            MolBond b1 = a2.getBond(j);
            if (b1 == start || !ratoms.contains(i3 = this.mol.indexOf(a3 = b1.getOtherAtom(a2)))) continue;
            neighbour = b1;
            found = true;
        }
        ArrayList<Integer> ringneigh = ringBondIndexes.get(this.mol.indexOf(start));
        if (ringneigh != null && neighbour != null && ringneigh.contains(this.mol.indexOf(neighbour))) {
            this.visited.clear();
            this.vcoords.clear();
            return 0;
        }
        this.setRingBondsAndPointsInOrder(start, a1, a2, ratoms);
        if (!this.isRingConvex()) {
            this.visited.clear();
            this.vcoords.clear();
            return -1;
        }
        ArrayList<Double> thetaL = new ArrayList<Double>();
        this.setRingDatas(thetaL, samecolors, ratoms);
        boolean symm = this.isSymmetric(thetaL);
        this.vcoords.remove(this.vcoords.size() - 1);
        if (!symm) {
            ret = (this.numatoms & 1) == 1 ? this.calcOddRingCoords(rcoords, d) : this.calcEvenRingCoords(rcoords, scale, d);
            if (ret < 0) {
                ret = this.calc_NotSymmetricRing_Coords(rcoords);
            }
        } else {
            ret = this.calc_SymmetricRing_Coords(rcoords, d);
        }
        this.setNeighbouringRingBonds(ringBondIndexes);
        this.visited.clear();
        this.vcoords.clear();
        return ret;
    }

    private boolean isCentered(MolBond b, MolAtom a1, MolAtom a2, DPoint3 p1, DPoint3 p2, int lab1, int lab2, int a1BondsNo, int a2BondsNo) {
        boolean center = false;
        if (a1BondsNo == 1 && a2BondsNo > 2 || a1BondsNo > 2 && a2BondsNo == 1 || a1BondsNo == 1 && a2BondsNo == 1 || a1BondsNo == 1 && lab2 > 0 || a2BondsNo == 1 && lab1 > 0 || lab1 > 0 && lab2 > 0) {
            center = true;
        } else {
            int t0;
            MolBond b0;
            int i;
            int t = b.getType();
            for (i = 0; i < a1BondsNo && !center; ++i) {
                b0 = a1.getBond(i);
                t0 = b0.getType();
                if (b0 == b || t0 != t) continue;
                center = true;
            }
            for (i = 0; i < a2BondsNo && !center; ++i) {
                b0 = a2.getBond(i);
                t0 = b0.getType();
                if (b0 == b || t0 != t) continue;
                center = true;
            }
            double alpha = p1.angle2D(p2.x, p2.y);
            if (!center && a1BondsNo == 2) {
                center = this.isOtherBondInLine(b, a1, a1BondsNo, p1, alpha);
            }
            if (!center && a2BondsNo == 2) {
                center = this.isOtherBondInLine(b, a2, a2BondsNo, p1, alpha);
            }
        }
        return center;
    }

    private boolean isOtherBondInLine(MolBond b, MolAtom a, int aBondsNo, DPoint3 p, double alpha) {
        for (int i = 0; i < aBondsNo; ++i) {
            MolAtom a3;
            int i3;
            MolBond b0 = a.getBond(i);
            if (b0 == null || b0 == b || (i3 = this.mol.indexOf(a3 = b0.getOtherAtom(a))) == -1) continue;
            DPoint3 p3 = this.screenCoords[i3];
            double beta = p.angle2D(p3.x, p3.y);
            if (!(Math.abs(alpha - beta - Math.PI) < 0.001)) continue;
            return true;
        }
        return false;
    }

    private int getBondSide_TwoRings(MolBond b, MolAtom a1, MolAtom a2, DPoint3 p1, DPoint3 p2, int[][] sssr, ArrayList<Integer> ringIndexes) {
        int n0 = sssr[ringIndexes.get(0)].length;
        int n1 = sssr[ringIndexes.get(1)].length;
        if (n0 == 6 && n1 != 6) {
            DPoint3 cp = this.calcCenter(sssr[ringIndexes.get(0)]);
            return DrawingUtil.getBondSideToPoint(p1, p2, cp);
        }
        if (n1 == 6 && n0 != 6) {
            DPoint3 cp = this.calcCenter(sssr[ringIndexes.get(1)]);
            return DrawingUtil.getBondSideToPoint(p1, p2, cp);
        }
        ArrayList<Integer> ringatoms0 = new ArrayList<Integer>();
        for (int i = 0; i < sssr[ringIndexes.get(0)].length; ++i) {
            ringatoms0.add(sssr[ringIndexes.get(0)][i]);
        }
        int nobs0 = this.countSameTypeBondsInRing(b, a1, a2, ringatoms0);
        ArrayList<Integer> ringatoms1 = new ArrayList<Integer>();
        for (int i = 0; i < sssr[ringIndexes.get(1)].length; ++i) {
            ringatoms1.add(sssr[ringIndexes.get(1)][i]);
        }
        int nobs1 = this.countSameTypeBondsInRing(b, a1, a2, ringatoms1);
        if (nobs0 < nobs1) {
            DPoint3 cp = this.calcCenter(sssr[ringIndexes.get(1)]);
            return DrawingUtil.getBondSideToPoint(p1, p2, cp);
        }
        if (nobs1 < nobs0) {
            DPoint3 cp = this.calcCenter(sssr[ringIndexes.get(0)]);
            return DrawingUtil.getBondSideToPoint(p1, p2, cp);
        }
        return 1;
    }

    private DPoint3 calcCenter(int[] aInds) {
        DPoint3 cent = new DPoint3(0.0, 0.0, 0.0);
        double x = 0.0;
        double y = 0.0;
        for (int i : aInds) {
            DPoint3 p1 = this.screenCoords[i];
            x += p1.x;
            y += p1.y;
        }
        cent.x = x / (double)aInds.length;
        cent.y = y / (double)aInds.length;
        return cent;
    }

    private int countSameTypeBondsInRing(MolBond b, MolAtom a1, MolAtom a2, ArrayList<Integer> aInds) {
        int nobs = 0;
        MolAtom a0 = a1;
        MolBond b0 = b;
        for (int i = 0; a0 != a2 && i < aInds.size() - 1; ++i) {
            boolean found = false;
            for (int j = 0; j < a0.getBondCount() && !found; ++j) {
                MolAtom a3;
                int i3;
                MolBond b1 = a0.getBond(j);
                if (b1 == b0 || !aInds.contains(i3 = this.mol.indexOf(a3 = b1.getOtherAtom(a0)))) continue;
                if (b1.getType() == b.getType()) {
                    ++nobs;
                }
                a0 = a3;
                b0 = b1;
                found = true;
            }
        }
        return nobs;
    }

    private int getBondSideToMoreNeighbours(MolBond b, MolAtom a1, MolAtom a2, int a1BondsNo, int a2BondsNo, DPoint3 p1, DPoint3 p2) {
        DPoint3 p3;
        MolAtom a3;
        int i3;
        MolBond b0;
        int i;
        int side = 0;
        for (i = 0; i < a1BondsNo; ++i) {
            b0 = a1.getBond(i);
            if (b0 == null || b0 == b || (i3 = this.mol.indexOf(a3 = b0.getOtherAtom(a1))) == -1) continue;
            p3 = this.screenCoords[i3];
            side += DrawingUtil.getBondSideToPoint(p1, p2, p3);
        }
        for (i = 0; i < a2BondsNo; ++i) {
            b0 = a2.getBond(i);
            if (b0 == null || b0 == b || (i3 = this.mol.indexOf(a3 = b0.getOtherAtom(a2))) == -1) continue;
            p3 = this.screenCoords[i3];
            side += DrawingUtil.getBondSideToPoint(p1, p2, p3);
        }
        if (side < 0) {
            return -1;
        }
        if (side > 0) {
            return 1;
        }
        return 0;
    }

    private int getBondSideToSameTypeNeighbours(MolBond b, MolAtom a1, MolAtom a2, int a1BondsNo, int a2BondsNo, DPoint3 p1, DPoint3 p2) {
        DPoint3 p3;
        MolAtom a3;
        int i3;
        MolBond b0;
        int i;
        int side = 0;
        for (i = 0; i < a1BondsNo; ++i) {
            b0 = a1.getBond(i);
            if (b0 == null || b0 == b || (i3 = this.mol.indexOf(a3 = b0.getOtherAtom(a1))) == -1 || b0.getType() != b.getType()) continue;
            p3 = this.screenCoords[i3];
            side += DrawingUtil.getBondSideToPoint(p1, p2, p3);
        }
        for (i = 0; i < a2BondsNo; ++i) {
            b0 = a2.getBond(i);
            if (b0 == null || b0 == b || (i3 = this.mol.indexOf(a3 = b0.getOtherAtom(a2))) == -1 || b0.getType() != b.getType()) continue;
            p3 = this.screenCoords[i3];
            side += DrawingUtil.getBondSideToPoint(p1, p2, p3);
        }
        if (side < 0) {
            return -1;
        }
        if (side > 0) {
            return 1;
        }
        return 0;
    }

    private void setRingBondsAndPointsInOrder(MolBond start, MolAtom a1, MolAtom a2, ArrayList<Integer> ralist) {
        MolAtom a0 = a2;
        this.vcoords.add(this.screenCoords[this.mol.indexOf(a1)]);
        this.vcoords.add(this.screenCoords[this.mol.indexOf(a2)]);
        MolBond b0 = start;
        this.visited.add(start);
        for (int i = 0; a0 != a1 && i < ralist.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < a0.getBondCount() && !found; ++j) {
                MolAtom a3;
                int i3;
                MolBond b1 = a0.getBond(j);
                if (b1 == b0 || !ralist.contains(i3 = this.mol.indexOf(a3 = b1.getOtherAtom(a0)))) continue;
                this.visited.add(b1);
                this.vcoords.add(this.screenCoords[i3]);
                a0 = a3;
                b0 = b1;
                found = true;
            }
        }
    }

    private boolean isRingConvex() {
        int n = this.vcoords.size();
        DPoint3 p1 = this.vcoords.get(0);
        DPoint3 p2 = this.vcoords.get(1);
        DPoint3 p3 = this.vcoords.get(2);
        boolean firstTurn = this.isRightTurn(p1, p2, p3);
        for (int i = 1; i < n - 2; ++i) {
            p1 = this.vcoords.get(i);
            if (firstTurn == this.isRightTurn(p1, p2 = this.vcoords.get(i + 1), p3 = this.vcoords.get(i + 2))) continue;
            return false;
        }
        p1 = this.vcoords.get(n - 2);
        return firstTurn == this.isRightTurn(p1, p2 = this.vcoords.get(0), p3 = this.vcoords.get(1));
    }

    private boolean isRightTurn(DPoint3 p1, DPoint3 p2, DPoint3 p3) {
        double alpha = p1.angle2D(p2.x, p2.y);
        double beta = p2.angle2D(p3.x, p3.y);
        if (alpha >= 0.0) {
            return alpha - Math.PI + 0.01 < beta && beta + 0.01 <= alpha;
        }
        return !(alpha + 0.01 <= beta) || !(beta + 0.01 < alpha + Math.PI);
    }

    private void setRingDatas(List<Double> thetaL, boolean[] samecolors, ArrayList<Integer> ralist) {
        MolBond b0 = this.visited.get(0);
        MolAtom a0 = this.mol.getAtom(ralist.get(0));
        boolean allselected = a0.isSelected();
        boolean allthesameatom = true;
        boolean sameatomset = true;
        boolean samebondset = true;
        int atno = a0.getAtno();
        int setno = a0.getSetSeq();
        int bondsetno = b0.getSetSeq();
        DPoint3 pn = this.vcoords.get(this.numatoms - 1);
        DPoint3 p0 = this.vcoords.get(0);
        double thetaSum = 0.0;
        for (int i = 0; i < this.numatoms; ++i) {
            MolAtom nextAtom = this.mol.getAtom(ralist.get(i));
            MolBond nextBond = this.visited.get(i);
            allselected &= nextAtom.isSelected();
            allthesameatom &= atno == nextAtom.getAtno();
            sameatomset &= setno == nextAtom.getSetSeq();
            samebondset &= bondsetno == nextBond.getSetSeq();
            DPoint3 p1 = this.vcoords.get(i + 1);
            double theta = DrawingUtil.calculateAngle2D(pn, p1, p0);
            thetaL.add(theta);
            thetaSum += theta;
            pn = p0;
            p0 = p1;
        }
        thetaL.add(thetaSum);
        samecolors[0] = allselected;
        samecolors[1] = allthesameatom;
        samecolors[2] = sameatomset;
        samecolors[3] = samebondset;
    }

    private boolean isSymmetric(List<Double> thetaL) {
        boolean symm = true;
        double thetaSum = thetaL.remove(thetaL.size() - 1);
        if (thetaL.size() == this.numatoms) {
            double thetaAvr = thetaSum / (double)this.numatoms;
            for (int j = 0; j < this.numatoms && symm; ++j) {
                if (!(Math.abs(thetaL.get(j) - thetaAvr) > 0.1)) continue;
                symm = false;
            }
            if (symm && this.numatoms == 4) {
                double d0 = this.vcoords.get(3).distance2D(this.vcoords.get(0));
                for (int j = 0; j < 3 && symm; ++j) {
                    double d = this.vcoords.get(j).distance2D(this.vcoords.get(j + 1));
                    if (!(Math.abs(d - d0) > 0.1)) continue;
                    symm = false;
                }
            }
        }
        return symm;
    }

    private void setNeighbouringRingBonds(Map<Integer, ArrayList<Integer>> ringBondIndexes) {
        for (int i = 0; i < this.numatoms; ++i) {
            ArrayList<Integer> neighbours = new ArrayList<Integer>();
            if (i == 0) {
                neighbours.add(this.mol.indexOf(this.visited.get(this.numatoms - 1)));
            } else {
                neighbours.add(this.mol.indexOf(this.visited.get(i - 1)));
            }
            if (i == this.numatoms - 1) {
                neighbours.add(this.mol.indexOf(this.visited.get(0)));
            } else {
                neighbours.add(this.mol.indexOf(this.visited.get(i + 1)));
            }
            Integer rb = this.mol.indexOf(this.visited.get(i));
            if (ringBondIndexes.containsKey(rb)) {
                ArrayList<Integer> oldbonds = ringBondIndexes.get(rb);
                oldbonds.addAll(neighbours);
                ringBondIndexes.put(rb, oldbonds);
                continue;
            }
            ringBondIndexes.put(rb, neighbours);
        }
    }

    private int calcOddRingCoords(double[] rcoords, double d) {
        int ret = -1;
        int s = this.numatoms / 2 + 1;
        DPoint3 pf0 = null;
        DPoint3[] p = new DPoint3[this.numatoms];
        int inax = 0;
        int inax0 = -1;
        Line2D[] axis = new Line2D[this.numatoms];
        axis[inax] = new Line2D.Double();
        double daxismin = 0.0;
        for (int j = 0; j < this.numatoms; ++j) {
            DPoint3[] pa = new DPoint3[this.numatoms];
            for (int inc = 0; inc < this.numatoms; ++inc) {
                pa[inc] = this.vcoords.get(AromatiCalc.getIndexByN(j + inc, this.numatoms));
            }
            DPoint3 pf = new DPoint3((pa[0].x + pa[1].x) / 2.0, (pa[0].y + pa[1].y) / 2.0, 0.0);
            axis[inax].setLine(pf.x, pf.y, pa[s].x, pa[s].y);
            boolean symm = this.isSymmetricToSide(pa, axis, inax);
            if (!symm) continue;
            double dx = pf.x - pa[s].x;
            double dy = pf.y - pa[s].y;
            double daxis = Math.sqrt(dx * dx + dy * dy);
            if (inax == 0 || daxis < daxismin) {
                daxismin = daxis;
                System.arraycopy(pa, 0, p, 0, p.length);
                pf0 = pf;
                inax0 = inax;
            }
            if (++inax >= this.numatoms) continue;
            axis[inax] = new Line2D.Double();
        }
        if (inax > this.numatoms / 2 - 1) {
            ret = this.calc_OrigoSymmetric_RingCoords(rcoords, p, pf0, axis, inax, inax0, d);
        } else if (inax >= 1) {
            ret = this.calc_AxisSymmetric_RingCoords(rcoords, p, axis, pf0);
        }
        return ret;
    }

    private int calc_TwoSideSymmetric_RingCoords(double[] rcoords, DPoint3[] p, Line2D[] axis, int inax, int inax0) {
        DPoint3 Origo = DrawingUtil.calcIntersectPointOf2Lines(axis[inax0], axis[AromatiCalc.getIndexByN(inax0 + 1, inax)]);
        Line2D.Double p01 = new Line2D.Double(p[0].x, p[0].y, p[1].x, p[1].y);
        double r = p01.ptLineDist(Origo.x, Origo.y);
        double dx = p[0].x - p[1].x;
        double dy = p[0].y - p[1].y;
        double a = Math.sqrt(dx * dx + dy * dy);
        dx = p[1].x - p[this.numatoms - 1].x;
        dy = p[1].y - p[this.numatoms - 1].y;
        double axdisth = Math.sqrt(dx * dx + dy * dy) / 2.0;
        double R = Math.sqrt(a * axdisth - a * a / 4.0);
        rcoords[0] = Origo.x;
        rcoords[1] = Origo.y;
        rcoords[2] = Origo.z;
        rcoords[3] = R * 0.75;
        Line2D.Double p12 = new Line2D.Double(p[1].x, p[1].y, p[2].x, p[2].y);
        double r12 = p12.ptLineDist(Origo.x, Origo.y);
        Line2D.Double p0n = new Line2D.Double(p[0].x, p[0].y, p[this.numatoms - 1].x, p[this.numatoms - 1].y);
        double r0n = p0n.ptLineDist(Origo.x, Origo.y);
        if (r12 < r) {
            rcoords[4] = r12 * 0.75;
            rcoords[5] = p[1].angle2D(p[2].x, p[2].y) + 1.5707963267948966;
        } else if (r0n < r) {
            rcoords[4] = r0n * 0.75;
            rcoords[5] = p[this.numatoms - 1].angle2D(p[0].x, p[0].y);
        } else {
            rcoords[4] = r * 0.75;
            rcoords[5] = p[0].angle2D(p[1].x, p[1].y);
        }
        return 1;
    }

    private int calc_OrigoSymmetric_RingCoords(double[] rcoords, DPoint3[] p, DPoint3 pf0, Line2D[] axis, int inax, int inax0, double d) {
        DPoint3 Origo = DrawingUtil.calcIntersectPointOf2Lines(axis[inax0], axis[AromatiCalc.getIndexByN(inax0 + 1, inax)]);
        Line2D.Double p01 = new Line2D.Double(p[0].x, p[0].y, p[1].x, p[1].y);
        double r = p01.ptLineDist(Origo.x, Origo.y);
        double dx = p[0].x - p[1].x;
        double dy = p[0].y - p[1].y;
        double R = Math.sqrt(dx * dx + dy * dy) / 2.0 * Math.tan((double)(this.numatoms - 2) * Math.PI / (double)(this.numatoms * 2));
        rcoords[3] = R * 0.75;
        rcoords[4] = r * 0.75;
        int nbu = 0;
        boolean biboldup = this.visited.get(this.numatoms - 1).isBold() || (this.visited.get(this.numatoms - 1).getFlags() & 0x30) == 16;
        boolean biboldup2 = false;
        int bi1 = -1;
        int bi2 = -1;
        int bi3 = -1;
        for (int i = 0; i < this.numatoms; ++i) {
            MolBond bi = this.visited.get(i);
            int bistereo = bi.getFlags() & 0x30;
            if (bi.isBold() || bistereo == 16) {
                ++nbu;
                if (biboldup2) {
                    bi3 = i;
                    continue;
                }
                if (biboldup) {
                    biboldup2 = true;
                    bi2 = i;
                    continue;
                }
                biboldup = true;
                bi1 = i;
                continue;
            }
            biboldup = false;
            biboldup2 = false;
        }
        if (nbu > 0) {
            rcoords[3] = rcoords[3] - d / 2.0;
            rcoords[4] = rcoords[4] - d / 2.0;
            if (nbu == 1 || nbu == 3 && bi3 > -1) {
                if (nbu == 3) {
                    bi1 = bi3 - 1;
                }
                DPoint3 f1 = this.vcoords.get(AromatiCalc.getIndexByN(bi1 + this.numatoms / 2 + 1, this.numatoms));
                DPoint3 f2 = new DPoint3((this.vcoords.get((int)bi1).x + this.vcoords.get((int)AromatiCalc.getIndexByN((int)(bi1 + 1), (int)this.numatoms)).x) / 2.0, (this.vcoords.get((int)bi1).y + this.vcoords.get((int)AromatiCalc.getIndexByN((int)(bi1 + 1), (int)this.numatoms)).y) / 2.0, 0.0);
                this.movePointByVector(Origo, f1, f2, d, true, false);
            } else if (nbu == 2 && bi2 > -1) {
                DPoint3 pi = this.vcoords.get(AromatiCalc.getIndexByN(bi2 + this.numatoms / 2, this.numatoms));
                DPoint3 pj = this.vcoords.get(AromatiCalc.getIndexByN(bi2 + this.numatoms / 2 + 1, this.numatoms));
                DPoint3 f1 = new DPoint3((pi.x + pj.x) / 2.0, (pi.y + pj.y) / 2.0, 0.0);
                DPoint3 f2 = this.vcoords.get(bi2);
                this.movePointByVector(Origo, f1, f2, d, true, false);
            }
        }
        rcoords[0] = Origo.x;
        rcoords[1] = Origo.y;
        rcoords[2] = Origo.z;
        rcoords[5] = pf0 != null ? pf0.angle2D(p[0].x, p[0].y) : 0.0;
        return 1;
    }

    private void calc_OrigoSymmetric_RingCoords(double[] rcoords, DPoint3[] po, double scale, double d) {
        double R;
        double x = 0.0;
        double y = 0.0;
        for (DPoint3 p : po) {
            x += p.x;
            y += p.y;
        }
        DPoint3 Origo = new DPoint3(x / (double)po.length, y / (double)po.length, 0.0);
        boolean vertical = false;
        DPoint3 p0 = this.vcoords.get(0);
        DPoint3 p1 = this.vcoords.get(1);
        Line2D.Double a = new Line2D.Double(p0.x, p0.y, p1.x, p1.y);
        int verti = 0;
        if (Math.abs(p0.x - p1.x) / scale < 0.035 && Math.abs(p0.y - this.vcoords.get((int)(this.numatoms / 2 + 1)).y) / scale < 0.35) {
            vertical = true;
        }
        double dmin = a.ptLineDist(Origo.x, Origo.y);
        int mini = 0;
        for (int j = 1; j < this.numatoms / 2; ++j) {
            p0 = this.vcoords.get(j);
            p1 = this.vcoords.get(j + 1);
            if (Math.abs(p0.x - p1.x) / scale < 0.035 && Math.abs(p0.y - this.vcoords.get((int)AromatiCalc.getIndexByN((int)(this.numatoms / 2 + j + 1), (int)this.numatoms)).y) / scale < 0.35) {
                vertical = true;
                verti = j;
            }
            ((Line2D)a).setLine(p0.x, p0.y, p1.x, p1.y);
            double d0 = a.ptLineDist(Origo.x, Origo.y);
            if (!(d0 < dmin)) continue;
            dmin = d0;
            mini = j;
        }
        double da = this.vcoords.get(mini).distance2D(this.vcoords.get(mini + 1));
        if (this.numatoms != 6) {
            R = da / 2.0 * Math.tan((double)(this.numatoms - 2) * Math.PI / (double)(this.numatoms * 2));
        } else {
            double axdisth = this.vcoords.get(AromatiCalc.getIndexByN(mini - 1, this.numatoms)).distance2D(this.vcoords.get(mini + 2));
            R = Math.sqrt(da * axdisth / 2.0 - da * da / 4.0);
        }
        rcoords[3] = R * 0.75;
        rcoords[4] = dmin * 0.75;
        if (vertical && verti != mini) {
            DPoint3 f2;
            DPoint3 f1;
            boolean l2;
            rcoords[5] = Origo.angle2D(this.vcoords.get((int)verti).x, (this.vcoords.get((int)verti).y + this.vcoords.get((int)(verti + 1)).y) / 2.0);
            MolBond b1 = this.visited.get(verti + 1);
            MolBond b2 = this.visited.get(verti + this.numatoms / 2 - 1);
            MolBond b3 = this.visited.get(AromatiCalc.getIndexByN(verti - 1, this.numatoms));
            MolBond b4 = this.visited.get(AromatiCalc.getIndexByN(verti + this.numatoms / 2 + 1, this.numatoms));
            int stereo11 = b1.getFlags() & 0x30;
            int stereo12 = b2.getFlags() & 0x30;
            int stereo13 = b3.getFlags() & 0x30;
            int stereo14 = b4.getFlags() & 0x30;
            boolean l1 = b1.isBold() || b2.isBold() || stereo11 == 16 || stereo12 == 16;
            boolean bl = l2 = b3.isBold() || b4.isBold() || stereo13 == 16 || stereo14 == 16;
            if (l1 || l2) {
                rcoords[4] = rcoords[4] - d / 2.0;
                f1 = this.vcoords.get(AromatiCalc.getIndexByN(verti - 1, this.numatoms));
                f2 = this.vcoords.get(verti + 2);
                this.movePointByVector(Origo, f1, f2, d, l1, l2);
            }
            b1 = this.visited.get(verti);
            b2 = this.visited.get(verti + this.numatoms / 2);
            l1 = b1.isBold();
            l2 = b2.isBold();
            if (l1 || l2) {
                rcoords[3] = rcoords[3] - d / 2.0;
                f1 = this.vcoords.get(verti + this.numatoms / 2);
                f2 = this.vcoords.get(verti + 1);
                this.movePointByVector(Origo, f1, f2, d, l1, l2);
            }
        } else {
            int s = mini + this.numatoms / 2 - 1;
            rcoords[5] = this.vcoords.get(AromatiCalc.getIndexByN(mini - (this.numatoms / 2 - 2), this.numatoms)).angle2D(this.vcoords.get((int)s).x, this.vcoords.get((int)s).y);
            int roti = -1;
            if (this.numatoms > 4) {
                double d23;
                p0 = this.vcoords.get(mini + 1);
                p1 = this.vcoords.get(mini + 2);
                DPoint3 p2 = this.vcoords.get(mini + this.numatoms / 2 - 1);
                DPoint3 p3 = this.vcoords.get(mini + this.numatoms / 2);
                double d01 = p0.distance2D(p1);
                if (Math.abs(d01 - (d23 = p2.distance2D(p3))) > 3.0 * d && d01 < d23) {
                    rcoords[5] = Origo.angle2D((p0.x + p1.x) / 2.0, (p0.y + p1.y) / 2.0);
                    roti = mini + 1;
                } else if (Math.abs(d01 - d23) > 3.0 * d && d23 < d01) {
                    rcoords[5] = Origo.angle2D((p2.x + p3.x) / 2.0, (p2.y + p3.y) / 2.0);
                    roti = mini + this.numatoms / 2 - 1;
                }
            }
            if (roti < 0) {
                boolean l2;
                int k = AromatiCalc.getIndexByN(mini + this.numatoms / 2, this.numatoms);
                MolBond b1 = this.visited.get(mini);
                MolBond b2 = this.visited.get(k);
                int stereo11 = b1.getFlags() & 0x30;
                int stereo12 = b2.getFlags() & 0x30;
                boolean l1 = b1.isBold() || stereo11 == 16;
                boolean bl = l2 = b2.isBold() || stereo12 == 16;
                if (l1 || l2) {
                    rcoords[3] = rcoords[3] - d / 2.0;
                    rcoords[4] = rcoords[4] - d / 2.0;
                    DPoint3 f2 = new DPoint3((this.vcoords.get((int)mini).x + this.vcoords.get((int)(mini + 1)).x) / 2.0, (this.vcoords.get((int)mini).y + this.vcoords.get((int)(mini + 1)).y) / 2.0, 0.0);
                    int k1 = AromatiCalc.getIndexByN(k + 1, this.numatoms);
                    DPoint3 f1 = new DPoint3((this.vcoords.get((int)k).x + this.vcoords.get((int)k1).x) / 2.0, (this.vcoords.get((int)k).y + this.vcoords.get((int)k1).y) / 2.0, 0.0);
                    this.movePointByVector(Origo, f1, f2, d, l1, l2);
                } else {
                    MolBond b0 = this.visited.get(AromatiCalc.getIndexByN(mini - 1, this.numatoms));
                    MolBond bn = this.visited.get(AromatiCalc.getIndexByN(mini - 2, this.numatoms));
                    MolBond bs0 = this.visited.get(s);
                    MolBond bsn = this.visited.get(s - 1);
                    if ((b0.getFlags() & 0x30) == 16 || b0.isBold() || (bn.getFlags() & 0x30) == 16 || bn.isBold() || (bs0.getFlags() & 0x30) == 16 || bs0.isBold() || (bsn.getFlags() & 0x30) == 16 || bsn.isBold()) {
                        rcoords[3] = rcoords[3] - d / 2.0;
                    }
                }
            } else {
                DPoint3 f2;
                DPoint3 f1;
                boolean l2;
                MolBond b1 = this.visited.get(roti + 1);
                MolBond b2 = this.visited.get(AromatiCalc.getIndexByN(roti + this.numatoms / 2 - 1, this.numatoms));
                MolBond b3 = this.visited.get(roti - 1);
                MolBond b4 = this.visited.get(AromatiCalc.getIndexByN(roti + this.numatoms / 2 + 1, this.numatoms));
                int stereo11 = b1.getFlags() & 0x30;
                int stereo12 = b2.getFlags() & 0x30;
                int stereo13 = b3.getFlags() & 0x30;
                int stereo14 = b4.getFlags() & 0x30;
                boolean l1 = b1.isBold() || b2.isBold() || stereo11 == 16 || stereo12 == 16;
                boolean bl = l2 = b3.isBold() || b4.isBold() || stereo13 == 16 || stereo14 == 16;
                if (l1 || l2) {
                    rcoords[4] = rcoords[4] - d / 2.0;
                    f1 = this.vcoords.get(roti - 1);
                    f2 = this.vcoords.get(AromatiCalc.getIndexByN(roti + 2, this.numatoms));
                    this.movePointByVector(Origo, f1, f2, d, l1, l2);
                }
                b1 = this.visited.get(roti);
                b2 = this.visited.get(AromatiCalc.getIndexByN(roti + this.numatoms / 2, this.numatoms));
                l1 = b1.isBold();
                l2 = b2.isBold();
                if (l1 || l2) {
                    rcoords[3] = rcoords[3] - d / 2.0;
                    f1 = this.vcoords.get(AromatiCalc.getIndexByN(roti + this.numatoms / 2, this.numatoms));
                    f2 = this.vcoords.get(roti + 1);
                    this.movePointByVector(Origo, f1, f2, d, l1, l2);
                }
            }
        }
        rcoords[0] = Origo.x;
        rcoords[1] = Origo.y;
        rcoords[2] = Origo.z;
    }

    private int calc_AxisSymmetric_RingCoords(double[] rcoords, DPoint3[] p, Line2D[] axis, DPoint3 pf0) {
        int s = this.numatoms / 2 + 1;
        double rmin = Double.MAX_VALUE;
        DPoint3 po = null;
        double[] abNext = null;
        Line2D lm2 = null;
        Line2D lm3 = null;
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < this.numatoms / 2 - 1; ++i) {
                double[] line1 = new double[4];
                double[] line2 = new double[4];
                double[] line3 = new double[4];
                for (int j = 0; j < 2; ++j) {
                    line2[2 * j] = p[AromatiCalc.getIndexByN((int)(j + 1 + i + k * s), (int)this.numatoms)].x;
                    line2[2 * j + 1] = p[AromatiCalc.getIndexByN((int)(j + 1 + i + k * s), (int)this.numatoms)].y;
                    line3[2 * j] = p[AromatiCalc.getIndexByN((int)(j + 2 + i + k * s), (int)this.numatoms)].x;
                    line3[2 * j + 1] = p[AromatiCalc.getIndexByN((int)(j + 2 + i + k * s), (int)this.numatoms)].y;
                }
                double[] ab0 = new double[4];
                if (abNext == null) {
                    for (int j = 0; j < 2; ++j) {
                        line1[2 * j] = p[AromatiCalc.getIndexByN((int)(j + i + k * s), (int)this.numatoms)].x;
                        line1[2 * j + 1] = p[AromatiCalc.getIndexByN((int)(j + i + k * s), (int)this.numatoms)].y;
                    }
                    ab0 = DrawingUtil.calcAngleBisectingOf2Lines(line1, line2);
                } else {
                    System.arraycopy(abNext, 0, ab0, 0, 4);
                }
                abNext = DrawingUtil.calcAngleBisectingOf2Lines(line2, line3);
                double[] ip = DrawingUtil.calcIntersectPointOf2Lines(ab0, abNext);
                DPoint3 o = new DPoint3(ip[0], ip[1], 0.0);
                Line2D.Double l2 = new Line2D.Double(line2[0], line2[1], line2[2], line2[3]);
                double r = l2.ptLineDist(ip[0], ip[1]);
                if (!(r < rmin)) continue;
                rmin = r;
                po = o;
                lm2 = l2;
                lm3 = k == 0 ? new Line2D.Double(line3[0], line3[1], line3[2], line3[3]) : new Line2D.Double(line1[0], line1[1], line1[2], line1[3]);
            }
            abNext = null;
        }
        DPoint3 Origo = new DPoint3(0.0, 0.0, 0.0);
        if ((int)(p[0].x - p[1].x) != 0) {
            if ((int)(p[0].y - p[1].y) != 0) {
                double hperp = (p[0].y - p[1].y) / (p[0].x - p[1].x);
                Line2D.Double perp = new Line2D.Double(po.x, po.y, po.x + 10.0, po.y + 10.0 * hperp);
                Origo = DrawingUtil.calcIntersectPointOf2Lines(axis[0], perp);
            } else {
                Origo.y = po.y;
                if (Math.abs(p[s].x - pf0.x) < 0.1) {
                    Origo.x = pf0.x;
                } else {
                    double hax = (p[s].y - pf0.y) / (p[s].x - pf0.x);
                    Origo.x = (po.y - pf0.y) / hax + pf0.x;
                }
            }
        } else {
            Origo.x = po.x;
            double hax = (p[s].y - pf0.y) / (p[s].x - pf0.x);
            Origo.y = (po.x - pf0.x) * hax + pf0.y;
        }
        double R = lm2 != null && lm3 != null && (lm2.ptLineDist(Origo.x, Origo.y) < lm2.ptLineDist(po.x, po.y) || lm3.ptLineDist(Origo.x, Origo.y) < lm3.ptLineDist(po.x, po.y)) ? rmin - axis[0].ptLineDist(po.x, po.y) : rmin + axis[0].ptLineDist(po.x, po.y);
        double angle = 2.0 * p[0].distance2D(p[1]) < pf0.distance2D(p[s]) ? (R > rmin ? pf0.angle2D(p[s].x, p[s].y) : pf0.angle2D(p[s].x, p[s].y) + 1.5707963267948966) : pf0.angle2D(p[0].x, p[0].y);
        rcoords[0] = Origo.x;
        rcoords[1] = Origo.y;
        rcoords[3] = 0.75 * R;
        rcoords[4] = 0.75 * rmin;
        rcoords[5] = angle;
        return 1;
    }

    private int calcEvenRingCoords(double[] rcoords, double scale, double d) {
        int ret = -1;
        DPoint3[] po = new DPoint3[this.numatoms / 2];
        boolean sym = this.isSymmetricToOrigo(po, scale);
        if (sym) {
            this.calc_OrigoSymmetric_RingCoords(rcoords, po, scale, d);
            return 1;
        }
        Line2D[] axis = new Line2D[this.numatoms];
        int[] inax = new int[3];
        inax[0] = 0;
        inax[2] = -1;
        inax[1] = -1;
        DPoint3[] p = new DPoint3[this.numatoms];
        DPoint3[] pp = new DPoint3[this.numatoms];
        DPoint3[] pf = new DPoint3[4];
        boolean symms0 = this.searchSymmetricAxises(axis, inax, p, pf, pp);
        if (inax[0] > 1 && pf[1] == null) {
            ret = this.calc_TwoSideSymmetric_RingCoords(rcoords, p, axis, inax[0], inax[1]);
        } else if (inax[0] > 1 && pf[1] != null) {
            ret = this.calc_TwoAxisSymmetric_RingCoords(rcoords, p, pp, axis, inax[0], inax[1], pf[1], pf[3]);
        } else if (inax[0] == 1) {
            DPoint3 Origo = new DPoint3((pf[0].x + pf[2].x) / 2.0, (pf[0].y + pf[2].y) / 2.0, 0.0);
            ret = symms0 ? this.calc_SymmetricForSide_RingCoords(rcoords, p, pf[0], pf[2], Origo) : this.calc_SymmetricForPoint_RingCoords(rcoords, p, pf[0], pf[2], Origo);
        }
        return ret;
    }

    private boolean isSymmetricToOrigo(DPoint3[] po, double scale) {
        boolean symm = true;
        int s = this.numatoms / 2;
        DPoint3 p0 = this.vcoords.get(0);
        DPoint3 ps = this.vcoords.get(s);
        DPoint3 op = po[0] = new DPoint3((p0.x + ps.x) / 2.0, (p0.y + ps.y) / 2.0, 0.0);
        for (int j = 1; j < s && symm; ++j) {
            p0 = this.vcoords.get(j);
            ps = this.vcoords.get(j + s);
            DPoint3 opj = new DPoint3((p0.x + ps.x) / 2.0, (p0.y + ps.y) / 2.0, 0.0);
            if (op.distance2D(opj) / scale > 0.12) {
                symm = false;
                continue;
            }
            po[j] = opj;
        }
        return symm;
    }

    private boolean searchSymmetricAxises(Line2D[] axis, int[] inax, DPoint3[] p, DPoint3[] pf, DPoint3[] pp) {
        axis[inax[0]] = new Line2D.Double();
        double daxismin = Double.MAX_VALUE;
        double damin = Double.MAX_VALUE;
        double daxisminp = Double.MAX_VALUE;
        boolean symms0 = false;
        int s = this.numatoms / 2;
        for (int j = 0; j < s && inax[0] < 2; ++j) {
            double alpha1;
            DPoint3[] pa = new DPoint3[this.numatoms];
            for (int inc = 0; inc < this.numatoms; ++inc) {
                pa[inc] = this.vcoords.get(AromatiCalc.getIndexByN(j + inc, this.numatoms));
            }
            double alpha0 = pa[1].angle2D(pa[0].x, pa[0].y);
            if (Math.abs(alpha0 - (alpha1 = pa[s].angle2D(pa[s + 1].x, pa[s + 1].y))) < 0.4 || Math.PI * 2 - Math.abs(alpha0) - Math.abs(alpha1) < 0.4) {
                DPoint3 pf0 = new DPoint3((pa[0].x + pa[1].x) / 2.0, (pa[0].y + pa[1].y) / 2.0, 0.0);
                DPoint3 pfh = new DPoint3((pa[s].x + pa[s + 1].x) / 2.0, (pa[s].y + pa[s + 1].y) / 2.0, 0.0);
                axis[inax[0]].setLine(pf0.x, pf0.y, pfh.x, pfh.y);
                boolean symms = this.isSymmetricToSide(pa, axis, inax[0]);
                if (symms) {
                    double dy0;
                    double dx0;
                    double da;
                    double dx = pf0.x - pfh.x;
                    double dy = pf0.y - pfh.y;
                    double daxis = Math.sqrt(dx * dx + dy * dy);
                    if (daxis < daxismin) {
                        daxismin = daxis;
                        System.arraycopy(pa, 0, p, 0, p.length);
                        pf[0] = pf0;
                        pf[2] = pfh;
                        inax[1] = inax[0];
                        symms0 = true;
                    }
                    if ((da = Math.sqrt((dx0 = pa[0].x - pa[1].x) * dx0 + (dy0 = pa[0].y - pa[1].y) * dy0)) < damin) {
                        damin = da;
                        inax[2] = inax[0];
                    }
                    int n = inax[0];
                    inax[0] = n + 1;
                    if (n > 1) continue;
                    axis[inax[0]] = new Line2D.Double();
                }
            }
            axis[inax[0]].setLine(pa[0].x, pa[0].y, pa[s].x, pa[s].y);
            boolean symmp = this.isSymmetricToPoints(pa, axis, inax[0]);
            if (!symmp) continue;
            double dx = pa[0].x - pa[s].x;
            double dy = pa[0].y - pa[s].y;
            double daxis = Math.sqrt(dx * dx + dy * dy);
            if (daxis < daxisminp) {
                daxisminp = daxis;
                if (!symms0) {
                    System.arraycopy(pa, 0, p, 0, p.length);
                    pf[0] = pf[1] = pa[0];
                    pf[2] = pf[3] = pa[s];
                    inax[1] = inax[0];
                } else {
                    pf[1] = pa[0];
                    pf[3] = pa[s];
                }
            }
            System.arraycopy(pa, 0, pp, 0, pp.length);
            int n = inax[0];
            inax[0] = n + 1;
            if (n >= 2) continue;
            axis[inax[0]] = new Line2D.Double();
        }
        return symms0;
    }

    private boolean isSymmetricToSide(DPoint3[] pa, Line2D[] axis, int inax) {
        boolean symms = true;
        int l = (this.numatoms - 3) / 2;
        double alpha0 = pa[1].angle2D(pa[0].x, pa[0].y);
        for (int i = 0; i < l && symms; ++i) {
            DPoint3 pai = pa[i + 2];
            DPoint3 pani = pa[this.numatoms - 1 - i];
            double alpha1 = pai.angle2D(pani.x, pani.y);
            if (Math.abs(alpha0 - alpha1) < 0.2 || Math.PI * 2 - Math.abs(alpha0) - Math.abs(alpha1) < 0.2) {
                double pdist;
                double axdist = axis[inax].ptLineDist((pai.x + pani.x) / 2.0, (pai.y + pani.y) / 2.0);
                if (!(axdist > (pdist = (axis[inax].ptLineDist(pani.x, pani.y) + axis[inax].ptLineDist(pai.x, pai.y)) / 2.0) / 10.0)) continue;
                symms = false;
                continue;
            }
            symms = false;
        }
        return symms;
    }

    private boolean isSymmetricToPoints(DPoint3[] pa, Line2D[] axis, int inax) {
        boolean symmp = true;
        int l = (this.numatoms - 2) / 2;
        double[] alpha = new double[l];
        for (int i = 0; i < l && symmp; ++i) {
            DPoint3 pai = pa[i + 1];
            DPoint3 pani = pa[this.numatoms - 1 - i];
            alpha[i] = pai.angle2D(pani.x, pani.y);
            if (Math.abs(alpha[i] - alpha[0]) < 0.2 || Math.PI * 2 - Math.abs(alpha[i]) - Math.abs(alpha[0]) < 0.2) {
                double pdist;
                double axdist = axis[inax].ptLineDist((pai.x + pani.x) / 2.0, (pai.y + pani.y) / 2.0);
                if (!(axdist > (pdist = (axis[inax].ptLineDist(pani.x, pani.y) + axis[inax].ptLineDist(pai.x, pai.y)) / 2.0) / 10.0)) continue;
                symmp = false;
                continue;
            }
            symmp = false;
        }
        return symmp;
    }

    private int calc_TwoAxisSymmetric_RingCoords(double[] rcoords, DPoint3[] p, DPoint3[] pp, Line2D[] axis, int inax, int inax0, DPoint3 pf0, DPoint3 pfs) {
        DPoint3 Origo = DrawingUtil.calcIntersectPointOf2Lines(axis[inax0], axis[AromatiCalc.getIndexByN(inax0 + 1, inax)]);
        int s = this.numatoms / 2;
        double r = this.searchMinForLinePtDist(pp, Origo, this.numatoms - 1);
        double dx = p[0].x - p[1].x;
        double dy = p[0].y - p[1].y;
        double a = Math.sqrt(dx * dx + dy * dy);
        dx = pf0.x - pfs.x;
        dy = pf0.y - pfs.y;
        double axdisth = Math.sqrt(dx * dx + dy * dy);
        double R = Math.sqrt(a * axdisth / 2.0 - a * a / 4.0);
        rcoords[0] = Origo.x;
        rcoords[1] = Origo.y;
        rcoords[2] = Origo.z;
        rcoords[3] = R * 0.75;
        rcoords[4] = r * 0.75;
        double[] d = new double[s - 1];
        boolean turn = false;
        for (int i = 1; i < s; ++i) {
            double d0 = pp[i].distance2D(pp[this.numatoms - i]);
            d[i - 1] = pp[i].distance2D(pp[this.numatoms - i]);
            if (!(d0 > axdisth)) continue;
            turn = true;
        }
        if (turn) {
            int mini = 1;
            double mind = d[0];
            for (int i = 1; i < s - 1; ++i) {
                if (!(d[i] < mind)) continue;
                mind = d[i];
                mini = i + 1;
            }
            rcoords[5] = pp[this.numatoms - mini].angle2D(pp[mini].x, pp[mini].y);
        } else {
            rcoords[5] = pf0.angle2D(pfs.x, pfs.y);
        }
        return 1;
    }

    private int calc_SymmetricForSide_RingCoords(double[] rcoords, DPoint3[] p, DPoint3 pf0, DPoint3 pfs, DPoint3 Origo) {
        int s = this.numatoms / 2;
        double angle = DrawingUtil.calculateAngle2D(p[0], pfs, pf0);
        if (Math.abs(1.5707963267948966 - angle) > 0.01 && angle < 1.5707963267948966) {
            for (int j = 0; j < s; ++j) {
                DPoint3 temp = p[j + 1];
                int ic = j == 0 ? 0 : this.numatoms - j;
                p[j + 1] = p[ic];
                p[ic] = temp;
            }
        }
        double[] ax = new double[4];
        double[] line0 = new double[4];
        double[] lines = new double[4];
        double[] linem = new double[4];
        ax[0] = lines[0] = pfs.x;
        ax[1] = lines[1] = pfs.y;
        ax[2] = pf0.x;
        ax[3] = pf0.y;
        lines[2] = p[s + 1].x;
        lines[3] = p[s + 1].y;
        double[] ab1 = DrawingUtil.calcAngleBisectingOf2Lines(ax, lines);
        line0[0] = pf0.x;
        line0[1] = pf0.y;
        line0[2] = p[0].x;
        line0[3] = p[0].y;
        double[] ab0 = DrawingUtil.calcAngleBisectingOf2Lines(line0, ax);
        double[] o1 = DrawingUtil.calcIntersectPointOf2Lines(ab0, ab1);
        linem[0] = o1[0];
        linem[1] = o1[1];
        linem[2] = Math.abs(pfs.y - pf0.y) > 0.001 ? o1[0] + 10.0 : o1[0];
        linem[3] = Math.abs(pfs.y - pf0.y) > 0.001 ? o1[1] + 10.0 * (pf0.x - pfs.x) / (pfs.y - pf0.y) : o1[1] + 10.0;
        double[] f1 = DrawingUtil.calcIntersectPointOf2Lines(ax, linem);
        linem[0] = f1[0];
        linem[1] = f1[1];
        linem[2] = Math.abs(p[0].y - p[1].y) > 0.001 ? linem[0] + 10.0 : linem[0];
        linem[3] = Math.abs(p[0].y - p[1].y) > 0.001 ? linem[1] + 10.0 * (p[1].x - p[0].x) / (p[0].y - p[1].y) : linem[0] + 10.0;
        double[] t = DrawingUtil.calcIntersectPointOf2Lines(line0, linem);
        DPoint3 T = new DPoint3(t[0], t[1], 0.0);
        double R = Origo.distance2D(T);
        double r = this.searchMinForLinePtDist(p, Origo, this.numatoms - 1, s - 1);
        rcoords[0] = Origo.x;
        rcoords[1] = Origo.y;
        rcoords[3] = 0.75 * R;
        rcoords[4] = 0.75 * r;
        double da = p[0].distance2D(p[1]);
        double ds = p[s].distance2D(p[s + 1]);
        double daxis = pf0.distance2D(pfs);
        if (daxis < da && daxis < ds) {
            double doc;
            Line2D.Double a = new Line2D.Double(p[0].x, p[0].y, p[1].x, p[1].y);
            Line2D.Double c = new Line2D.Double(p[s].x, p[s].y, p[s + 1].x, p[s + 1].y);
            double doa = a.ptLineDist(Origo.x, Origo.y);
            rcoords[5] = doa < (doc = c.ptLineDist(Origo.x, Origo.y)) ? p[0].angle2D(p[1].x, p[1].y) + 1.5707963267948966 : p[s].angle2D(p[s + 1].x, p[s + 1].y) + 1.5707963267948966;
        } else {
            rcoords[5] = Origo.angle2D(pfs.x, pfs.y);
        }
        return 1;
    }

    private int calc_SymmetricForPoint_RingCoords(double[] rcoords, DPoint3[] p, DPoint3 pf0, DPoint3 pfs, DPoint3 Origo) {
        double an2;
        int s = this.numatoms / 2;
        double an0 = DrawingUtil.calculateAngle2D(p[1], pfs, pf0);
        double an1 = DrawingUtil.calculateAngle2D(p[this.numatoms - 1], pfs, pf0);
        if (Math.abs(an1 - an0) > 0.01 && an1 < an0) {
            an0 = an1;
            for (int j = 0; j < s - 1; ++j) {
                DPoint3 temp = p[j + 1];
                p[j + 1] = p[this.numatoms - 1 - j];
                p[this.numatoms - 1 - j] = temp;
            }
        }
        if (Math.abs((an2 = DrawingUtil.calculateAngle2D(p[s + 1], pf0, pfs)) - an0) > 0.01 && an2 > an0) {
            DPoint3 temp = pf0;
            pf0 = pfs;
            pfs = temp;
            for (int j = 0; j < s; ++j) {
                temp = p[j];
                p[j] = p[s + j];
                p[s + j] = temp;
            }
        }
        double[] line01 = new double[4];
        double[] lines = new double[4];
        double[] linem = new double[4];
        double[] ax = new double[4];
        line01[0] = pf0.x;
        line01[1] = pf0.y;
        line01[2] = p[1].x;
        line01[3] = p[1].y;
        lines[0] = pfs.x;
        lines[1] = pfs.y;
        lines[2] = p[s + 1].x;
        lines[3] = p[s + 1].y;
        double[] ab0 = DrawingUtil.calcAngleBisectingOf2Lines(line01, lines);
        ax[0] = pfs.x;
        ax[1] = pfs.y;
        ax[2] = pf0.x;
        ax[3] = pf0.y;
        double[] ab1 = DrawingUtil.calcAngleBisectingOf2Lines(ax, lines);
        double[] o2 = DrawingUtil.calcIntersectPointOf2Lines(ab0, ab1);
        linem[0] = o2[0];
        linem[1] = o2[1];
        linem[2] = Math.abs(pfs.y - pf0.y) > 0.001 ? o2[0] + 10.0 : o2[0];
        linem[3] = Math.abs(pfs.y - pf0.y) > 0.001 ? o2[1] + 10.0 * (pf0.x - pfs.x) / (pfs.y - pf0.y) : o2[1] + 10.0;
        double[] f2 = DrawingUtil.calcIntersectPointOf2Lines(ax, linem);
        linem[0] = f2[0];
        linem[1] = f2[1];
        linem[2] = Math.abs(pf0.y - p[1].y) > 0.001 ? linem[0] + 10.0 : linem[0];
        linem[3] = Math.abs(pf0.y - p[1].y) > 0.001 ? linem[1] + 10.0 * (p[1].x - pf0.x) / (pf0.y - p[1].y) : linem[0] + 10.0;
        double[] t = DrawingUtil.calcIntersectPointOf2Lines(line01, linem);
        DPoint3 T = new DPoint3(t[0], t[1], 0.0);
        double R = Origo.distance(T);
        double r = this.searchMinForLinePtDist(p, Origo, this.numatoms - s - 1, this.numatoms - s - 2);
        for (DPoint3 q : this.vcoords) {
            rcoords[0] = rcoords[0] + q.x;
            rcoords[1] = rcoords[1] + q.y;
            rcoords[2] = rcoords[2] + q.z;
        }
        rcoords[0] = rcoords[0] / (double)this.numatoms;
        rcoords[1] = rcoords[1] / (double)this.numatoms;
        rcoords[2] = rcoords[2] / (double)this.numatoms;
        rcoords[0] = (rcoords[0] + Origo.x) / 2.0;
        rcoords[1] = (rcoords[1] + Origo.y) / 2.0;
        rcoords[3] = 0.6 * R;
        rcoords[4] = 0.6 * r;
        rcoords[5] = pf0.distance2D(pfs) > p[1].distance2D(p[this.numatoms - 1]) ? Origo.angle2D(pfs.x, pfs.y) : p[1].angle2D(p[this.numatoms - 1].x, p[this.numatoms - 1].y) + 1.5707963267948966;
        return 1;
    }

    private int calc_NotSymmetricRing_Coords(double[] rcoords) {
        for (DPoint3 q : this.vcoords) {
            rcoords[0] = rcoords[0] + q.x;
            rcoords[1] = rcoords[1] + q.y;
            rcoords[2] = rcoords[2] + q.z;
        }
        rcoords[0] = rcoords[0] / (double)this.numatoms;
        rcoords[1] = rcoords[1] / (double)this.numatoms;
        rcoords[2] = rcoords[2] / (double)this.numatoms;
        double r = Double.MAX_VALUE;
        for (int k = 0; k < this.numatoms; ++k) {
            Line2D.Double la = new Line2D.Double(this.vcoords.get((int)k).x, this.vcoords.get((int)k).y, this.vcoords.get((int)AromatiCalc.getIndexByN((int)(k + 1), (int)this.numatoms)).x, this.vcoords.get((int)AromatiCalc.getIndexByN((int)(k + 1), (int)this.numatoms)).y);
            double di = la.ptLineDist(rcoords[0], rcoords[1]);
            if (!(di < r)) continue;
            r = di;
        }
        rcoords[3] = r * 0.75;
        rcoords[4] = r * 0.75;
        return 1;
    }

    private int calc_SymmetricRing_Coords(double[] rcoords, double d) {
        double qx = 0.0;
        double qy = 0.0;
        int nbu = 0;
        boolean biboldup = this.visited.get(this.numatoms - 1).isBold() || (this.visited.get(this.numatoms - 1).getFlags() & 0x30) == 16;
        boolean biboldup2 = false;
        int bi1 = -1;
        int bi2 = -1;
        int bi3 = -1;
        for (int i = 0; i < this.numatoms; ++i) {
            rcoords[0] = rcoords[0] + this.vcoords.get((int)i).x;
            rcoords[1] = rcoords[1] + this.vcoords.get((int)i).y;
            rcoords[2] = rcoords[2] + this.vcoords.get((int)i).z;
            qx += this.vcoords.get((int)i).x * this.vcoords.get((int)i).x;
            qy += this.vcoords.get((int)i).y * this.vcoords.get((int)i).y;
            MolBond bi = this.visited.get(i);
            int bistereo = bi.getFlags() & 0x30;
            if (bi.isBold() || bistereo == 16) {
                ++nbu;
                if (biboldup2) {
                    bi3 = i;
                    continue;
                }
                if (biboldup) {
                    biboldup2 = true;
                    bi2 = i;
                    continue;
                }
                biboldup = true;
                bi1 = i;
                continue;
            }
            biboldup = false;
            biboldup2 = false;
        }
        rcoords[0] = rcoords[0] / (double)this.numatoms;
        rcoords[1] = rcoords[1] / (double)this.numatoms;
        rcoords[2] = rcoords[2] / (double)this.numatoms;
        double rsqx = (qx /= (double)this.numatoms) - rcoords[0] * rcoords[0];
        double rsqy = (qy /= (double)this.numatoms) - rcoords[1] * rcoords[1];
        double r = Math.cos(Math.PI / (double)this.numatoms) * Math.sqrt(rsqx + rsqy) * 0.75;
        if (nbu > 0) {
            r -= d / 2.0;
            if (nbu == 1 || nbu == 3 && bi3 > -1) {
                if (nbu == 3) {
                    bi1 = bi3 - 1;
                }
                DPoint3 Origo = new DPoint3(rcoords[0], rcoords[1], 0.0);
                DPoint3 f1 = this.vcoords.get(AromatiCalc.getIndexByN(bi1 + this.numatoms / 2 + 1, this.numatoms));
                DPoint3 f2 = this.vcoords.get(bi1);
                if ((this.numatoms & 1) == 1) {
                    f2 = new DPoint3((this.vcoords.get((int)bi1).x + this.vcoords.get((int)AromatiCalc.getIndexByN((int)(bi1 + 1), (int)this.numatoms)).x) / 2.0, (this.vcoords.get((int)bi1).y + this.vcoords.get((int)AromatiCalc.getIndexByN((int)(bi1 + 1), (int)this.numatoms)).y) / 2.0, 0.0);
                }
                this.movePointByVector(Origo, f1, f2, d, true, false);
                rcoords[0] = Origo.x;
                rcoords[1] = Origo.y;
            } else if (nbu == 2 && bi2 > -1) {
                DPoint3 Origo = new DPoint3(rcoords[0], rcoords[1], 0.0);
                DPoint3 f1 = this.vcoords.get(AromatiCalc.getIndexByN(bi2 + this.numatoms / 2, this.numatoms));
                if ((this.numatoms & 1) == 1) {
                    DPoint3 pi = this.vcoords.get(AromatiCalc.getIndexByN(bi2 + this.numatoms / 2, this.numatoms));
                    DPoint3 pj = this.vcoords.get(AromatiCalc.getIndexByN(bi2 + this.numatoms / 2 + 1, this.numatoms));
                    f1 = new DPoint3((pi.x + pj.x) / 2.0, (pi.y + pj.y) / 2.0, 0.0);
                }
                DPoint3 f2 = this.vcoords.get(bi2);
                this.movePointByVector(Origo, f1, f2, d, true, false);
                rcoords[0] = Origo.x;
                rcoords[1] = Origo.y;
            }
        }
        rcoords[3] = r;
        rcoords[4] = r;
        return 1;
    }

    public void movePointByVector(DPoint3 p, DPoint3 f1, DPoint3 f2, double d, boolean l1, boolean l2) {
        double dx = f1.x - f2.x;
        double dy = f1.y - f2.y;
        double m = d / (4.0 * Math.sqrt(dx * dx + dy * dy));
        if (l1 && !l2) {
            p.x += m * dx;
            p.y += m * dy;
        } else if (l2 && !l1) {
            p.x -= m * dx;
            p.y -= m * dy;
        }
    }

    private double searchMinForLinePtDist(DPoint3[] p, DPoint3 Origo, int n, int j) {
        double dm = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            Line2D.Double l;
            double d;
            if (i == j || !((d = (l = new Line2D.Double(p[1 + i].x, p[1 + i].y, p[AromatiCalc.getIndexByN((int)(2 + i), (int)(n + 1))].x, p[AromatiCalc.getIndexByN((int)(2 + i), (int)(n + 1))].y)).ptLineDist(Origo.x, Origo.y)) < dm)) continue;
            dm = d;
        }
        return dm;
    }

    private double searchMinForLinePtDist(DPoint3[] p, DPoint3 Origo, int n) {
        double dm = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            Line2D.Double l = new Line2D.Double(p[1 + i].x, p[1 + i].y, p[AromatiCalc.getIndexByN((int)(2 + i), (int)(n + 1))].x, p[AromatiCalc.getIndexByN((int)(2 + i), (int)(n + 1))].y);
            double d = l.ptLineDist(Origo.x, Origo.y);
            if (!(d < dm)) continue;
            dm = d;
        }
        return dm;
    }

    private static int getIndexByN(int j, int n) {
        return j < n && j >= 0 ? j : (j >= n ? j - n : j + n);
    }
}

