/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.marvin.modules.LonePairPainter;
import chemaxon.marvin.paint.internal.AtomLabelProp;
import chemaxon.marvin.paint.internal.AtomMapLabeller;
import chemaxon.marvin.paint.internal.AtomPropertyLabeller;
import chemaxon.marvin.paint.internal.AtomStereoGroupLabeller;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;

public class AtomLabeller {
    public static final int SYMBOL_VISIBLE = 1;
    public static final int LABEL_VISIBLE = 2;
    public static final int H_VISIBLE = 4;
    private int atomLabellerCount;
    private AtomLabelProp[] atomLabellers;
    private MolPainterCommon painterCommon;

    public AtomLabeller(MolPainterCommon common) {
        this.painterCommon = common;
        int dispoptsExt = common.getDispoptsExt();
        int dispopts = common.getDispopts();
        int n = 1;
        if ((dispoptsExt & 8) != 0) {
            ++n;
        }
        if ((dispopts & 0x800) != 0) {
            ++n;
        }
        if ((dispopts & 0x200) != 0) {
            ++n;
        }
        if (common.isAtomMappingVisible()) {
            ++n;
        }
        this.atomLabellers = new AtomLabelProp[n];
        if (common.isAtomPropertiesVisible()) {
            this.addLabeller(new AtomPropertyLabeller());
        }
        if ((dispopts & 0x800) != 0) {
            this.addLabeller("AtomIndexLabeller");
        }
        this.addLabeller(new AtomStereoGroupLabeller());
        if (common.isAtomMappingVisible()) {
            this.addLabeller(new AtomMapLabeller());
        }
        if ((dispopts & 0x200) != 0) {
            this.addLabeller("AtomGrinvLabeller");
        }
    }

    public void setMol(MoleculeGraph mol) {
        for (int i = 0; i < this.atomLabellerCount; ++i) {
            this.atomLabellers[i].setMol(mol);
        }
    }

    private void addLabeller(String modname) {
        AtomLabelProp l = (AtomLabelProp)MarvinModule.load(modname, null);
        if (l == null) {
            throw new RuntimeException("cannot load atom labeller module " + modname);
        }
        this.addLabeller(l);
    }

    private void addLabeller(AtomLabelProp l) {
        if (this.atomLabellerCount >= this.atomLabellers.length) {
            AtomLabelProp[] tmp = new AtomLabelProp[this.atomLabellerCount + 1];
            System.arraycopy(this.atomLabellers, 0, tmp, 0, this.atomLabellerCount);
            this.atomLabellers = tmp;
            System.err.println("WARNING: atom labeller array size increased to " + this.atomLabellerCount + " by " + l);
        }
        this.atomLabellers[this.atomLabellerCount++] = l;
    }

    public String getLabels(MolAtom atom, int atomIndex) {
        int length;
        StringBuffer labBuf = new StringBuffer();
        labBuf.append("_{");
        String qlab = atom.getQueryLabel();
        if (!this.painterCommon.isValencePropertyVisible()) {
            qlab = qlab.replaceAll("v[0-9]{1,2},{0,1}", "");
            qlab = qlab.replaceAll("\\(,", "\\(");
            qlab = qlab.replaceAll(",\\)", "\\)");
            qlab = qlab.replaceAll("\\(\\),{0,1}", "");
        }
        labBuf.append(qlab);
        if (labBuf.length() > 2) {
            labBuf.append(';');
        }
        for (int i = 0; i < this.atomLabellers.length; ++i) {
            this.atomLabellers[i].appendLabel(labBuf, atom, atomIndex);
        }
        if (atom.getMaxRepetitions() != 1) {
            labBuf.append("(L");
            labBuf.append(atom.getMinRepetitions());
            labBuf.append('-');
            labBuf.append(atom.getMaxRepetitions());
            labBuf.append("),");
        }
        if (atom.getExtraLabel() != null && !atom.getExtraLabel().equals("")) {
            labBuf.append(atom.getExtraLabel());
            labBuf.append(",");
        }
        if ((length = labBuf.length()) > 2) {
            if (labBuf.charAt(length - 1) == ',' || labBuf.charAt(length - 1) == ';') {
                labBuf = new StringBuffer(labBuf.toString().substring(0, length - 1));
            }
            labBuf.append("}");
            return labBuf.toString();
        }
        return "";
    }

    public int getLabelVisibility(MolAtom a, int nb, int dim) {
        boolean valenceerr;
        MolPainterCommon common = this.painterCommon;
        int ret = 0;
        int style = common.getRenderingStyle();
        int hcount = a.getImplicitHcount() + a.getExplicitHcount();
        boolean hydrit = false;
        if (style <= 262144) {
            boolean bl = hydrit = this.isHvisible(a) && hcount != 0;
            if (hydrit) {
                ret |= 4;
            }
        }
        int atno = a.getAtno();
        boolean bl = valenceerr = (common.isValenceErrorVisible() && common.isErrorVisible() || common.isValenceErrorVisibleInView()) && a.hasValenceError();
        if ((dim != 3 || common.isAtomSymbolsVisible3D()) && (atno != 6 && atno != 0 || nb == 0 || a.getCharge() != 0 && LonePairPainter.isChargeVisible(a) || hydrit && a.getImplicitHcount() != 0 || a.isSelected() || valenceerr || a.getAliasstr() != null || a.getMassno() != 0) || a.getRadical() != 0) {
            ret |= 1;
        }
        if (this.isLabelVisible(a)) {
            ret |= 2;
        }
        return ret;
    }

    private boolean isLabelVisible(MolAtom a) {
        for (int i = 0; i < this.atomLabellers.length; ++i) {
            if (!this.atomLabellers[i].isVisible(a)) continue;
            return true;
        }
        return !a.getQueryLabel().equals("") || a.getExtraLabel() != null || a.getMaxRepetitions() != 1;
    }

    private boolean isHvisible(MolAtom a) {
        int atno = a.getAtno();
        int n = a.getBondCount() - a.getExplicitHcount();
        int h = this.painterCommon.getDispopts() & 3;
        return h == 3 || h >= 1 && (atno != 6 || a.getCharge() != 0 || a.getRadical() != 0 || a.getMassno() != 0) || h == 2 && n <= 1;
    }
}

