/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.marvin.paint.internal.AtomLabelProp;
import chemaxon.struc.MolAtom;

class AtomMapLabeller
extends AtomLabelProp {
    AtomMapLabeller() {
    }

    @Override
    public boolean isVisible(MolAtom a) {
        return a.getAtomMap() != 0 && !this.isInQueryLabel(a) || a.getReactionStereo() != 0;
    }

    @Override
    public void appendLabel(StringBuffer sb, MolAtom a, int index) {
        int rxnstereo;
        int map = a.getAtomMap();
        if (map != 0 && !this.isInQueryLabel(a)) {
            sb.append(map);
            sb.append(",");
        }
        if ((rxnstereo = a.getReactionStereo()) != 0) {
            sb.append(rxnstereo == 1 ? "Inv" : "Ret");
            sb.append(",");
        }
    }

    private boolean isInQueryLabel(MolAtom a) {
        String qlab = a.getQueryLabel();
        return qlab != null && qlab.length() >= 2 && Character.isDigit(qlab.charAt(qlab.length() - 2)) && qlab.lastIndexOf(58) != -1;
    }
}

