/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.marvin.paint.internal.Shades;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ColorCollection {
    private static final Color[][] ALL_RESTYPE_COLORS;
    private static final Color[][] ALL_RESSEQ_COLORS;
    private static final Color[][] ALL_ELEM_COLORS;
    static final Color[][] ALL_ATOMSET_COLORS;
    static final Color[][] ALL_BONDSET_COLORS;
    static final Color LIGHT_GRAY;
    public static final Color DARK_SHADOW_BLUE;
    public static final Color LIGHT_SHADOW_BLUE;
    public static final Color PINK;
    public static final Color RED;
    private static final Color LIGHT_BLUE;
    private static final Color DARK_BLUE;
    public static final Color LIGHT_GREEN;
    public static final Color DARK_GREEN;
    Color bgColor;
    Color fgColor;
    private boolean bgIsLight;
    Color corruptedColor;
    Color highlightColor;
    Color atomHighlightColor;
    Color selectionColor;
    Color[] elemColors;
    transient Map<Color, Shades> shadeColorHash = null;
    Color[] residueTypeColors;
    Color[] residueSeqColors;
    private int numPainters;

    public ColorCollection(Color c) {
        this.bgColor = c;
        if (ColorCollection.isLight(c)) {
            this.bgIsLight = true;
            this.fgColor = Color.black;
            this.highlightColor = Color.magenta;
            this.atomHighlightColor = Color.blue;
            this.corruptedColor = Color.yellow;
            this.selectionColor = Color.green;
            this.elemColors = ALL_ELEM_COLORS[1];
            this.residueTypeColors = ALL_RESTYPE_COLORS[1];
            this.residueSeqColors = ALL_RESSEQ_COLORS[1];
        } else {
            this.bgIsLight = false;
            this.fgColor = Color.white;
            this.highlightColor = Color.orange;
            this.atomHighlightColor = Color.blue;
            this.corruptedColor = Color.darkGray;
            this.selectionColor = Color.blue;
            this.elemColors = ALL_ELEM_COLORS[0];
            this.residueTypeColors = ALL_RESTYPE_COLORS[0];
            this.residueSeqColors = ALL_RESSEQ_COLORS[0];
        }
        this.shadeColorHash = null;
        this.numPainters = 0;
    }

    public ColorCollection(ColorCollection c) {
        this.bgIsLight = c.bgIsLight;
        this.bgColor = c.bgColor;
        this.fgColor = c.fgColor;
        this.corruptedColor = c.corruptedColor;
        this.highlightColor = c.highlightColor;
        this.atomHighlightColor = c.atomHighlightColor;
        this.selectionColor = c.selectionColor;
        this.elemColors = new Color[c.elemColors.length];
        System.arraycopy(c.elemColors, 0, this.elemColors, 0, c.elemColors.length);
        this.residueTypeColors = new Color[c.residueTypeColors.length];
        System.arraycopy(c.residueTypeColors, 0, this.residueTypeColors, 0, c.residueTypeColors.length);
        this.residueSeqColors = new Color[c.residueSeqColors.length];
        System.arraycopy(c.residueSeqColors, 0, this.residueSeqColors, 0, c.residueSeqColors.length);
        if (c.shadeColorHash != null) {
            this.shadeColorHash = new HashMap<Color, Shades>();
            for (Color key : this.shadeColorHash.keySet()) {
                Shades shades = c.shadeColorHash.get(key);
                this.shadeColorHash.put(key, shades);
            }
        } else {
            this.shadeColorHash = null;
        }
        this.numPainters = 0;
    }

    public boolean isLight() {
        return this.bgIsLight;
    }

    public Object clone() {
        return new ColorCollection(this);
    }

    public Color getBackground() {
        return this.bgColor;
    }

    public Color getForeground() {
        return this.fgColor;
    }

    public Color getCorruptedColor() {
        return this.corruptedColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getAtomHighlightColor() {
        return this.atomHighlightColor;
    }

    public static Color getColor(int atno, boolean dark) {
        Color[] colors = ALL_ELEM_COLORS[dark ? 0 : 1];
        return colors[atno < colors.length ? atno : 0];
    }

    public Color getElemColor(int i) {
        return this.elemColors[i < this.elemColors.length ? i : 0];
    }

    public Color getResidueTypeColor(int i) {
        return this.residueTypeColors[i < this.residueTypeColors.length ? i : 0];
    }

    public Color getResidueSeqColor(int i) {
        return this.residueSeqColors[i % this.residueSeqColors.length];
    }

    public Color getExtraLabelColor() {
        if (ColorCollection.isLight(this.bgColor)) {
            return DARK_BLUE;
        }
        return LIGHT_BLUE;
    }

    public Color getTextBoxColor() {
        return LIGHT_BLUE;
    }

    public Shades getShades(Color color) {
        Shades shades;
        if (this.shadeColorHash == null) {
            this.shadeColorHash = new HashMap<Color, Shades>();
        }
        if ((shades = this.shadeColorHash.get(color)) == null) {
            shades = new Shades(color, this.bgColor, 64);
            this.shadeColorHash.put(color, shades);
        }
        return shades;
    }

    public static boolean isLight(Color c) {
        return c.getRed() + c.getGreen() + c.getBlue() >= 384;
    }

    void registerPainter() {
        ++this.numPainters;
    }

    void unregisterPainter() {
        --this.numPainters;
    }

    boolean isUsed() {
        return this.numPainters != 0;
    }

    static {
        int k;
        int i;
        ALL_RESTYPE_COLORS = new Color[2][35];
        ALL_RESSEQ_COLORS = new Color[2][64];
        ALL_ELEM_COLORS = new Color[2][110];
        ALL_ATOMSET_COLORS = new Color[2][64];
        ALL_BONDSET_COLORS = new Color[2][64];
        LIGHT_GRAY = new Color(230, 230, 230);
        DARK_SHADOW_BLUE = new Color(199, 227, 255);
        LIGHT_SHADOW_BLUE = new Color(199, 225, 225);
        PINK = new Color(255, 153, 153);
        RED = new Color(184, 28, 28);
        LIGHT_BLUE = new Color(160, 215, 255);
        DARK_BLUE = new Color(0, 0, 155);
        LIGHT_GREEN = new Color(160, 255, 215);
        DARK_GREEN = new Color(0, 155, 0);
        String colorstr = "fff000f00f000f009000f00f0ff099fc3660c3f609fff333f66933fa096099f339ccc000f93960ff66633930609996669cf369933633c33600fcc966f069039f96c6903903f33c3360060066f66c06006036336333c33cc93c93663663666666f63f63c30c30660660963963f9ff9ff0f9093f33f3";
        Color[] palette = new Color[78];
        for (i = 0; i < 78; ++i) {
            String s = colorstr.substring(3 * i, 3 * i + 3);
            int c = Integer.parseInt(s, 16);
            int r = (c & 0xF00) >> 8;
            int g = (c & 0xF0) >> 4;
            int b = c & 0xF;
            palette[i] = new Color(r << 20 | r << 16 | g << 12 | g << 8 | b << 4 | b);
        }
        colorstr = "b7jif2ba1c73efc95274fgfdff9ghhhggddh748ggggggddfggggd6749kkkkkk9d2kkkkkkkkkkkkkc7k7kk67kkkkkckkkkkkkkkkkkkkkkk";
        for (i = 0; i < colorstr.length(); ++i) {
            char c = colorstr.charAt(i);
            k = 2 * (c >= 'a' ? c - 97 + 10 : c - 48);
            ColorCollection.ALL_ELEM_COLORS[0][i] = palette[k];
            ColorCollection.ALL_ELEM_COLORS[1][i] = palette[k + 1];
        }
        for (i = 0; i < ALL_RESSEQ_COLORS[0].length; ++i) {
            int j = 2 * i % palette.length;
            ColorCollection.ALL_RESSEQ_COLORS[0][i] = palette[j];
            ColorCollection.ALL_RESSEQ_COLORS[1][i] = palette[j + 1];
        }
        for (i = 1; i < ALL_ATOMSET_COLORS[0].length; ++i) {
            int j = 2 * i % palette.length;
            ColorCollection.ALL_ATOMSET_COLORS[0][i] = palette[j];
            ColorCollection.ALL_ATOMSET_COLORS[1][i] = palette[j + 1];
        }
        for (i = 1; i < ALL_BONDSET_COLORS[0].length; ++i) {
            int j = 2 * i % palette.length;
            ColorCollection.ALL_BONDSET_COLORS[0][i] = palette[j];
            ColorCollection.ALL_BONDSET_COLORS[1][i] = palette[j + 1];
        }
        colorstr = "Baacc88CCBBBBl38mdno0pqrstuvwxyzABB";
        for (i = 0; i < colorstr.length(); ++i) {
            char c = colorstr.charAt(i);
            k = c >= 'a' && c <= 'z' ? c - 97 + 10 : (c >= 'A' && c <= 'Z' ? c - 65 + 36 : c - 48);
            ColorCollection.ALL_RESTYPE_COLORS[0][i] = palette[k *= 2];
            ColorCollection.ALL_RESTYPE_COLORS[1][i] = palette[k + 1];
        }
    }
}

