/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import java.awt.Font;

public class FontMaker {
    private static Object fontcacheLock = new Object();
    private static Font[][] fontcache = new Font[4][];

    public static void staticReset() {
        fontcache = new Font[4][0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font makeFont(int style, int size, Font base) {
        Object object = fontcacheLock;
        synchronized (object) {
            Font[] fonts = fontcache[style];
            if (fonts == null) {
                fonts = new Font[size + 1];
                FontMaker.fontcache[style] = fonts;
            } else if (size >= fonts.length) {
                fonts = new Font[size + 1];
                System.arraycopy(fontcache[style], 0, fonts, 0, fontcache[style].length);
                FontMaker.fontcache[style] = fonts;
            }
            Font f = fonts[size];
            if (f == null || f != null && !f.getFontName().equals(base.getFontName())) {
                fonts[size] = f = new Font(base.getName(), style, size);
            }
            return f;
        }
    }

    public static Font[] initFonts(Font[] fts0, double scale, double atomSize, Font base) {
        double[] scales = new double[4];
        int[] styles = new int[4];
        scales[0] = scale;
        scales[1] = scale;
        scales[2] = scale / 1.3;
        scales[3] = scale / 1.3;
        styles[3] = 0;
        styles[2] = 0;
        styles[0] = 0;
        styles[1] = 2;
        Font[] fts = new Font[6];
        System.arraycopy(fts0, 0, fts, 0, fts0.length);
        for (int i = 0; i <= 3; ++i) {
            int sz = (int)(atomSize * scales[i] + 0.5);
            if (sz > 1200) {
                sz = 1200;
            }
            if (scales[i] < 0.0 || sz < 1) {
                fts[i] = null;
                continue;
            }
            if (fts[i] != null && fts[i].getSize() == sz) continue;
            fts[i] = FontMaker.makeFont(styles[i], sz, base);
        }
        if (fts[1] == null || fts[2] == null || fts[3] == null) {
            fts[0] = null;
        }
        if (fts[0] != null) {
            fts[4] = FontMaker.makeFont(1, fts[0].getSize(), base);
            fts[5] = FontMaker.makeFont(1, fts[0].getSize() * 18 / 12, base);
        }
        return fts;
    }
}

