/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.paint.internal;

import chemaxon.marvin.paint.internal.GraphicsPainter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GraphicsPresentationChooser {
    private static final Map<String, String> presenters = Collections.unmodifiableMap(GraphicsPresentationChooser.createPresentersMap());
    private ConcurrentHashMap<Class<?>, GraphicsPainter> graphicsMap = new ConcurrentHashMap(10);

    private static Map<String, String> createPresentersMap() {
        HashMap<String, String> result = new HashMap<String, String>(10);
        result.put("chemaxon.struc.MPoint", "chemaxon.marvin.paint.internal.graphics.MPointPainter");
        result.put("chemaxon.struc.graphics.MAtomSetPoint", "chemaxon.marvin.paint.internal.graphics.MAtomSetPointPainter");
        result.put("chemaxon.struc.graphics.MPolyline", "chemaxon.marvin.paint.internal.graphics.MPolylinePainter");
        result.put("chemaxon.struc.graphics.MRArrow", "chemaxon.marvin.paint.internal.graphics.MRArrowPainter");
        result.put("chemaxon.struc.graphics.MRectangle", "chemaxon.marvin.paint.internal.graphics.MRectanglePainter");
        result.put("chemaxon.struc.graphics.MRoundedRectangle", "chemaxon.marvin.paint.internal.graphics.MRoundedRectanglePainter");
        result.put("chemaxon.struc.graphics.MEllipse", "chemaxon.marvin.paint.internal.graphics.MEllipsePainter");
        result.put("chemaxon.struc.graphics.MBracket", "chemaxon.marvin.paint.internal.graphics.MBracketPainter");
        result.put("chemaxon.struc.graphics.MTextBox", "chemaxon.marvin.paint.internal.graphics.MTextBoxPainter");
        result.put("chemaxon.struc.graphics.MAssigner", "chemaxon.marvin.paint.internal.graphics.MAssignerPainter");
        return result;
    }

    public GraphicsPainter getGraphicsPainter(Class<?> graphicsClass) {
        if (graphicsClass == null) {
            return null;
        }
        if (this.graphicsMap.containsKey(graphicsClass)) {
            return this.graphicsMap.get(graphicsClass);
        }
        GraphicsPainter result = this.createPainterFor(graphicsClass);
        if (result == null) {
            result = this.getGraphicsPainter(graphicsClass.getSuperclass());
        }
        this.graphicsMap.putIfAbsent(graphicsClass, result);
        return result;
    }

    private GraphicsPainter createPainterFor(Class<?> graphicsClass) {
        if (!presenters.containsKey(graphicsClass.getName())) {
            return null;
        }
        try {
            return (GraphicsPainter)Class.forName(presenters.get(graphicsClass.getName())).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

